/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.LDAPSession;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Repository {
    public static Logger logger = LoggerFactory.getLogger(Repository.class);
    protected CMSEngine engine;
    private BigInteger mSerialNo = null;
    protected String minSerialName;
    protected BigInteger mMinSerialNo;
    protected String maxSerialName;
    protected BigInteger mMaxSerialNo;
    protected String nextMinSerialName;
    protected BigInteger mNextMinSerialNo;
    protected String nextMaxSerialName;
    protected BigInteger mNextMaxSerialNo;
    protected BigInteger mCounter = null;
    protected BigInteger mIncrementNo;
    protected BigInteger mLowWaterMarkNo;
    protected DBSubsystem dbSubsystem;
    protected String mBaseDN;
    protected String rangeDN;
    protected int mRadix;
    protected Hashtable<String, String> repositoryConfig = new Hashtable();
    private BigInteger mLastSerialNo = null;
    protected IDGenerator idGenerator = IDGenerator.LEGACY;
    protected int idLength;
    protected SecureRandom secureRandom;

    public Repository(DBSubsystem dbSubsystem, int radix) {
        this.dbSubsystem = dbSubsystem;
        this.mRadix = radix;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() throws Exception {
    }

    public String getBaseDN() {
        return this.mBaseDN;
    }

    public int getRadix() {
        return this.mRadix;
    }

    public BigInteger getMaxSerial() {
        return this.mMaxSerialNo;
    }

    public synchronized void setMaxSerial(BigInteger serial) throws EBaseException {
        logger.debug("Repository: Setting max serial to " + serial);
        this.mMaxSerialNo = serial;
    }

    public BigInteger getNextMaxSerial() {
        return this.mNextMaxSerialNo;
    }

    public synchronized void setNextMaxSerial(BigInteger serial) throws EBaseException {
        logger.debug("Repository: Setting next max serial to " + serial);
        this.mNextMaxSerialNo = serial;
    }

    public BigInteger getMinSerial() {
        return this.mMinSerialNo;
    }

    protected void setLastSerialNo(BigInteger lastSN) {
        this.mLastSerialNo = lastSN;
    }

    public IDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    protected void setIDGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    protected void setIDGenerator(String idGenerator) {
        this.idGenerator = IDGenerator.fromString(idGenerator);
    }

    protected void initCache() throws EBaseException {
        if (this.idGenerator == IDGenerator.RANDOM) {
            return;
        }
        logger.debug("Repository: in InitCache");
        if (this.mLastSerialNo != null) {
            return;
        }
        logger.info("Repository: Getting last serial number in range " + this.mMinSerialNo + ".." + this.mMaxSerialNo);
        BigInteger theSerialNo = this.getLastSerialNumberInRange(this.mMinSerialNo, this.mMaxSerialNo);
        if (theSerialNo == null) {
            logger.warn("Repository: Range " + this.mMinSerialNo + ".." + this.mMaxSerialNo + " has been depleted");
            if (this.hasNextRange()) {
                logger.info("Repository: Switching to next range");
                this.switchToNextRange();
                logger.info("Repository: Getting last serial number in new range " + this.mMinSerialNo + ".." + this.mMaxSerialNo);
                theSerialNo = this.getLastSerialNumberInRange(this.mMinSerialNo, this.mMaxSerialNo);
            } else {
                logger.warn("Repository: Next range not available");
            }
        }
        if (theSerialNo == null) {
            throw new EBaseException("Error in obtaining the last serial number in the repository!");
        }
        this.mLastSerialNo = new BigInteger(theSerialNo.toString());
        logger.debug("Repository: Last serial number: " + this.mLastSerialNo);
    }

    public synchronized BigInteger peekNextSerialNumber() throws EBaseException {
        logger.debug("Repository:In getTheSerialNumber ");
        this.initCache();
        BigInteger serial = this.mLastSerialNo.add(BigInteger.ONE);
        if (this.mMaxSerialNo != null && serial.compareTo(this.mMaxSerialNo) > 0) {
            return this.hasNextRange() ? this.mNextMinSerialNo : null;
        }
        return serial;
    }

    public void setTheSerialNumber(BigInteger num) throws EBaseException {
        logger.debug("Repository:In setTheSerialNumber " + num);
        this.initCache();
        if (num.compareTo(this.mSerialNo) <= 0) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_SETBACK_SERIAL", this.mSerialNo.toString(16)));
        }
        this.dbSubsystem.setNextSerialConfig(num);
        this.mSerialNo = num.subtract(BigInteger.ONE);
    }

    public synchronized BigInteger getNextSerialNumber() throws EBaseException {
        if (this.idGenerator == IDGenerator.RANDOM) {
            logger.debug("Repository: Generating random serial number");
            BigInteger id = new BigInteger(this.idLength, this.secureRandom);
            logger.debug("Repository: - id: 0x" + id.toString(16));
            return id;
        }
        logger.debug("Repository: in getNextSerialNumber. ");
        this.initCache();
        if (this.mLastSerialNo == null) {
            logger.error("Repository::getNextSerialNumber() - mLastSerialNo is null!");
            throw new EBaseException("mLastSerialNo is null");
        }
        this.mLastSerialNo = this.mLastSerialNo.add(BigInteger.ONE);
        this.checkRange();
        logger.debug("Repository: getNextSerialNumber: returning " + this.mLastSerialNo);
        return this.mLastSerialNo;
    }

    public BigInteger getRangeLength() {
        return null;
    }

    public BigInteger getRandomLimit(BigInteger rangeLength) {
        return null;
    }

    protected void checkRange() throws EBaseException {
        BigInteger rangeLength = this.getRangeLength();
        logger.debug("Repository: range length: " + rangeLength);
        BigInteger randomLimit = this.getRandomLimit(rangeLength);
        logger.debug("Repository: random limit: " + randomLimit);
        logger.debug("Repository: checkRange  mLastSerialNo=" + this.mLastSerialNo);
        if (this.mLastSerialNo.compareTo(this.mMaxSerialNo) > 0 || !this.engine.isPreOpMode() && randomLimit != null && this.mCounter.compareTo(randomLimit) > 0) {
            if (this.dbSubsystem.getEnableSerialMgmt()) {
                logger.debug("Reached the end of the range.  Attempting to move to next range");
                if (!this.hasNextRange()) {
                    if (rangeLength == null || this.mCounter.compareTo(rangeLength) >= 0) {
                        throw new EDBException(CMS.getUserMessage("CMS_DBS_LIMIT_REACHED", this.mLastSerialNo.toString()));
                    }
                    return;
                }
                this.switchToNextRange();
            } else {
                throw new EDBException(CMS.getUserMessage("CMS_DBS_LIMIT_REACHED", this.mLastSerialNo.toString()));
            }
        }
    }

    private boolean hasNextRange() {
        return this.mNextMinSerialNo != null && this.mNextMaxSerialNo != null;
    }

    public void setMinSerialConfig() throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        String serial = this.mMinSerialNo.toString(this.mRadix);
        logger.debug("Repository: Setting min serial number: " + serial);
        dbConfig.putString(this.minSerialName, serial);
        cs.commit(false);
    }

    public void setMaxSerialConfig() throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        String serial = this.mMaxSerialNo.toString(this.mRadix);
        logger.debug("Repository: Setting max serial number: " + serial);
        dbConfig.putString(this.maxSerialName, serial);
        cs.commit(false);
    }

    public void setNextMinSerialConfig() throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        if (this.mNextMinSerialNo == null) {
            logger.debug("Repository: Removing next min number");
            dbConfig.remove(this.nextMinSerialName);
        } else {
            String serial = this.mNextMinSerialNo.toString(this.mRadix);
            logger.debug("Repository: Setting next min number: " + serial);
            dbConfig.putString(this.nextMinSerialName, serial);
        }
        cs.commit(false);
    }

    public void setNextMaxSerialConfig() throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        if (this.mNextMaxSerialNo == null) {
            logger.debug("Repository: Removing next max number");
            dbConfig.remove(this.nextMaxSerialName);
        } else {
            String serial = this.mNextMaxSerialNo.toString(this.mRadix);
            logger.debug("Repository: Setting next max number: " + serial);
            dbConfig.putString(this.nextMaxSerialName, serial);
        }
        cs.commit(false);
    }

    private void switchToNextRange() throws EBaseException {
        this.mMinSerialNo = this.mNextMinSerialNo;
        this.mMaxSerialNo = this.mNextMaxSerialNo;
        this.mLastSerialNo = this.mMinSerialNo;
        this.mNextMinSerialNo = null;
        this.mNextMaxSerialNo = null;
        this.mCounter = BigInteger.ZERO;
        this.setMinSerialConfig();
        this.setMaxSerialConfig();
        this.setNextMinSerialConfig();
        this.setNextMaxSerialConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextRange() throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        try (LDAPSession session = (LDAPSession)this.dbSubsystem.createSession();){
            LDAPConnection conn = session.getConnection();
            logger.info("Repository: Reading entry " + this.mBaseDN);
            LDAPEntry entry = conn.read(this.mBaseDN);
            LDAPAttribute attr = entry.getAttribute("nextRange");
            if (attr == null) {
                throw new Exception("Missing attributenextRange");
            }
            String nextRange = (String)attr.getStringValues().nextElement();
            BigInteger nextRangeNo = new BigInteger(nextRange);
            BigInteger newNextRangeNo = nextRangeNo.add(this.mIncrementNo);
            String newNextRange = newNextRangeNo.toString();
            String endRange = newNextRangeNo.subtract(BigInteger.ONE).toString();
            logger.info("Repository: Updating nextRange from " + nextRange + " to " + newNextRange);
            LDAPAttribute attrNextRange = new LDAPAttribute("nextRange", newNextRange);
            LDAPModification[] mods = new LDAPModification[]{new LDAPModification(1, attr), new LDAPModification(0, attrNextRange)};
            logger.info("Repository: Modifying entry " + this.mBaseDN);
            conn.modify(this.mBaseDN, mods);
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            attrs.add(new LDAPAttribute("objectClass", "top"));
            attrs.add(new LDAPAttribute("objectClass", "pkiRange"));
            attrs.add(new LDAPAttribute("beginRange", nextRange));
            attrs.add(new LDAPAttribute("endRange", endRange));
            attrs.add(new LDAPAttribute("cn", nextRange));
            attrs.add(new LDAPAttribute("host", cs.getHostname()));
            attrs.add(new LDAPAttribute("securePort", this.engine.getEESSLPort()));
            String dn2 = "cn=" + nextRange + "," + this.rangeDN;
            LDAPEntry rangeEntry = new LDAPEntry(dn2, attrs);
            logger.info("Repository: Adding entry " + dn2);
            conn.add(rangeEntry);
            String string = nextRange;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRangeConflict() throws EBaseException {
        if (this.mNextMinSerialNo == null) {
            return false;
        }
        EngineConfig cs = this.engine.getConfig();
        boolean conflict = false;
        try (LDAPSession session = (LDAPSession)this.dbSubsystem.createSession();){
            LDAPConnection conn = session.getConnection();
            logger.info("Repository: Searching for conflicting entries");
            String filter = "(&(nsds5ReplConflict=*)(objectClass=pkiRange)(host= " + cs.getHostname() + ")(SecurePort=" + this.engine.getEESSLPort() + ")(beginRange=" + this.mMinSerialNo.toString(this.mRadix) + "))";
            LDAPSearchResults results = conn.search(this.rangeDN, 2, filter, null, false);
            while (results.hasMoreElements()) {
                conflict = true;
                LDAPEntry entry = results.next();
                String dn = entry.getDN();
                logger.info("Repository: Deleting entry " + dn);
                conn.delete(dn);
            }
        }
        return conflict;
    }

    public BigInteger getNumbersInRange() {
        return this.mMaxSerialNo.subtract(this.mLastSerialNo);
    }

    public void checkRanges() throws EBaseException {
        if (this.idGenerator == IDGenerator.RANDOM) {
            return;
        }
        if (!this.dbSubsystem.getEnableSerialMgmt()) {
            logger.debug("Repository: serial management not enabled, ignore");
            return;
        }
        if (this.engine.getEESSLPort() == null) {
            logger.warn("Repository: Server not completely started.  Returning ..");
            return;
        }
        this.initCache();
        BigInteger numsInRange = this.getNumbersInRange();
        logger.debug("Repository: Serial numbers left in range: " + numsInRange);
        logger.debug("Repository: Last serial number: " + this.mLastSerialNo);
        BigInteger numsInNextRange = null;
        BigInteger numsAvail = null;
        if (this.mNextMaxSerialNo != null && this.mNextMinSerialNo != null) {
            numsInNextRange = this.mNextMaxSerialNo.subtract(this.mNextMinSerialNo).add(BigInteger.ONE);
            numsAvail = numsInRange.add(numsInNextRange);
            logger.debug("Repository: Serial numbers in next range: " + numsInNextRange);
        } else {
            numsAvail = numsInRange;
        }
        logger.debug("Repository: Serial numbers available: " + numsAvail);
        logger.debug("Repository: Low water mark: " + this.mLowWaterMarkNo);
        if (numsAvail.compareTo(this.mLowWaterMarkNo) < 0 && !this.engine.isPreOpMode()) {
            logger.debug("Repository: Requesting next range");
            String nextRange = this.getNextRange();
            logger.debug("Repository: next range: " + nextRange);
            this.mNextMinSerialNo = new BigInteger(nextRange, this.mRadix);
            if (this.mNextMinSerialNo == null) {
                logger.debug("Repository: Next range not available");
            } else {
                logger.debug("Repository: Next min serial number: " + this.mNextMinSerialNo.toString(this.mRadix));
                this.mNextMaxSerialNo = this.mNextMinSerialNo.add(this.mIncrementNo).subtract(BigInteger.ONE);
                numsAvail = numsAvail.add(this.mIncrementNo);
                this.setNextMinSerialConfig();
                this.setNextMaxSerialConfig();
            }
        }
        if (numsInRange.compareTo(this.mLowWaterMarkNo) < 0) {
            logger.debug("Checking for a range conflict");
            if (this.hasRangeConflict()) {
                logger.debug("Range Conflict found! Removing next range.");
                this.mNextMaxSerialNo = null;
                this.mNextMinSerialNo = null;
                this.setNextMinSerialConfig();
                this.setNextMaxSerialConfig();
            }
        }
    }

    public void setEnableSerialMgmt(boolean value) throws EBaseException {
        this.dbSubsystem.setEnableSerialMgmt(value);
    }

    public abstract BigInteger getLastSerialNumberInRange(BigInteger var1, BigInteger var2) throws EBaseException;

    public static enum IDGenerator {
        LEGACY("legacy"),
        RANDOM("random");

        private String name;

        private IDGenerator(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static IDGenerator fromString(String name) {
            for (IDGenerator idGenerator : IDGenerator.values()) {
                if (!idGenerator.name.equals(name)) continue;
                return idGenerator;
            }
            throw new IllegalArgumentException("Invalid ID generator: " + name);
        }
    }
}

