/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.extensions.CMSExtension;
import com.netscape.certsrv.extensions.EExtensionsException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUsage
extends CMSExtension {
    public static Logger logger = LoggerFactory.getLogger(KeyUsage.class);
    private static final String NAME = "KeyUsageExtension";
    private static final ObjectIdentifier OID = PKIXExtensions.KeyUsage_Id;
    private ConfigStore mConfig;
    private boolean mSetDefault = false;
    protected static final boolean[] DEF_BITS = new boolean[9];

    public KeyUsage(boolean setDefault) {
        this.mSetDefault = setDefault;
    }

    @Override
    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ObjectIdentifier getOID() {
        return OID;
    }

    private static boolean getBoolean(Object value) {
        String val = (String)value;
        return val != null && (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on"));
    }

    @Override
    public Extension getExtension(ArgBlock args) throws EBaseException {
        int i;
        boolean[] bits = new boolean[9];
        Object[] values = new Object[9];
        int bit = 0;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 1;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 2;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 3;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 4;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 5;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 6;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 7;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        bit = 8;
        values[bit] = args.get(KeyUsageExtension.names[bit]);
        for (i = 0; !(i >= 9 || values[i] != null && values[i] instanceof String); ++i) {
        }
        if (i == 9 && this.mSetDefault) {
            logger.debug("No Key usage bits requested. Setting default.");
            bits = DEF_BITS;
        } else {
            bit = 0;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 1;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 2;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 3;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 4;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 5;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 6;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 7;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
            bit = 8;
            bits[bit] = KeyUsage.getBoolean(values[bit]);
            logger.debug("Requested key usage bit " + bit + " " + bits[bit]);
        }
        try {
            int j = 0;
            for (j = 0; j < bits.length && !bits[j]; ++j) {
            }
            if (j == bits.length) {
                if (this.mSetDefault) {
                    bits = DEF_BITS;
                } else {
                    return null;
                }
            }
            return new KeyUsageExtension(bits);
        }
        catch (IOException e) {
            throw new EExtensionsException(CMS.getUserMessage("CMS_EXTENSION_CREATING_EXT_ERROR", NAME));
        }
    }

    @Override
    public ArgBlock getFormParams(Extension extension) throws EBaseException {
        KeyUsageExtension ext = null;
        if (!extension.getExtensionId().equals(PKIXExtensions.KeyUsage_Id)) {
            return null;
        }
        if (extension instanceof KeyUsageExtension) {
            ext = (KeyUsageExtension)extension;
        } else {
            try {
                byte[] value = extension.getExtensionValue();
                ext = new KeyUsageExtension(Boolean.valueOf(true), (Object)value);
            }
            catch (IOException e) {
                return null;
            }
        }
        ArgBlock params = new ArgBlock();
        boolean[] bits = ext.getBits();
        params.set("digital_signature", String.valueOf(bits[0]));
        params.set("non_repudiation", String.valueOf(bits[1]));
        params.set("key_encipherment", String.valueOf(bits[2]));
        params.set("data_encipherment", String.valueOf(bits[3]));
        params.set("key_agreement", String.valueOf(bits[4]));
        params.set("key_certsign", String.valueOf(bits[5]));
        params.set("crl_sign", String.valueOf(bits[6]));
        params.set("encipher_only", String.valueOf(bits[7]));
        params.set("decipher_only", String.valueOf(bits[8]));
        return params;
    }

    static {
        KeyUsage.DEF_BITS[0] = true;
        KeyUsage.DEF_BITS[1] = false;
        KeyUsage.DEF_BITS[2] = true;
        KeyUsage.DEF_BITS[3] = true;
        KeyUsage.DEF_BITS[4] = false;
        KeyUsage.DEF_BITS[5] = false;
        KeyUsage.DEF_BITS[6] = false;
        KeyUsage.DEF_BITS[7] = false;
        KeyUsage.DEF_BITS[8] = false;
    }
}

