/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapBoundConnFactory
extends LdapConnFactory {
    public static Logger logger = LoggerFactory.getLogger(LdapBoundConnFactory.class);
    protected String id;
    PKISocketConfig config;
    protected int mMinConns = 5;
    protected int mMaxConns = 1000;
    protected int mMaxResults = 0;
    protected LdapConnInfo mConnInfo = null;
    protected LdapAuthInfo mAuthInfo = null;
    PasswordStore passwordStore;
    public static final String PROP_MINCONNS = "minConns";
    public static final String PROP_MAXCONNS = "maxConns";
    public static final String PROP_MAXRESULTS = "maxResults";
    public static final String PROP_LDAPCONNINFO = "ldapconn";
    public static final String PROP_LDAPAUTHINFO = "ldapauth";
    public static final String PROP_ERROR_IF_DOWN = "errorIfDown";
    private int mNumConns = 0;
    private int mTotal = 0;
    private boolean doCloning = true;
    private LdapBoundConnection mMasterConn = null;
    private LdapBoundConnection[] mConns;
    private boolean mErrorIfDown;
    private boolean mDefErrorIfDown = false;

    public LdapBoundConnFactory(String id) {
        logger.debug("Creating LdapBoundConnFactor(" + id + ")");
        this.id = id;
    }

    public LdapBoundConnFactory(String id, boolean defErrorIfDown) {
        logger.debug("Creating LdapBoundConnFactor(" + id + ")");
        this.id = id;
        this.mDefErrorIfDown = defErrorIfDown;
    }

    public LdapBoundConnFactory(String id, int minConns, int maxConns, LdapConnInfo connInfo, LdapAuthInfo authInfo) throws ELdapException {
        logger.debug("Creating LdapBoundConnFactory(" + id + ")");
        this.id = id;
        this.mMinConns = minConns;
        this.mMaxConns = maxConns;
        this.mConnInfo = connInfo;
        this.mAuthInfo = authInfo;
    }

    public LdapBoundConnFactory(String id, int minConns, int maxConns, int maxResults, LdapConnInfo connInfo, LdapAuthInfo authInfo) throws ELdapException {
        logger.debug("Creating LdapBoundConnFactory(" + id + ")");
        this.id = id;
        this.mMinConns = minConns;
        this.mMaxConns = maxConns;
        this.mMaxResults = maxResults;
        this.mConnInfo = connInfo;
        this.mAuthInfo = authInfo;
    }

    @Override
    public int totalConn() {
        return this.mTotal;
    }

    @Override
    public synchronized int freeConn() {
        return this.mNumConns;
    }

    @Override
    public int maxConn() {
        return this.mMaxConns;
    }

    public void init(PKISocketConfig config, PasswordStore passwordStore) throws ELdapException {
        logger.debug("LdapBoundConnFactory: initialization");
        this.config = config;
        this.passwordStore = passwordStore;
        this.init();
    }

    public void init(PKISocketConfig config, LDAPConfig dbConfig, PasswordStore passwordStore) throws EBaseException, ELdapException {
        this.passwordStore = passwordStore;
        this.init(config, dbConfig);
    }

    public void init(PKISocketConfig config, LDAPConfig dbConfig) throws EBaseException, ELdapException {
        logger.debug("LdapBoundConnFactory: initialization");
        this.config = config;
        this.mMinConns = dbConfig.getInteger(PROP_MINCONNS, this.mMinConns);
        this.mMaxConns = dbConfig.getInteger(PROP_MAXCONNS, this.mMaxConns);
        this.mMaxResults = dbConfig.getInteger(PROP_MAXRESULTS, this.mMaxResults);
        LDAPConnectionConfig connConfig = dbConfig.getConnectionConfig();
        this.mConnInfo = new LdapConnInfo(connConfig);
        LDAPAuthenticationConfig authConfig = dbConfig.getAuthenticationConfig();
        this.mAuthInfo = new LdapAuthInfo();
        this.mAuthInfo.setPasswordStore(this.passwordStore);
        this.mAuthInfo.init(authConfig, this.mConnInfo.getHost(), this.mConnInfo.getPort(), this.mConnInfo.getSecure());
        this.mErrorIfDown = dbConfig.getBoolean(PROP_ERROR_IF_DOWN, this.mDefErrorIfDown);
        this.doCloning = dbConfig.getBoolean("doCloning", true);
        logger.debug("LdapBoundConnFactory: doCloning: " + this.doCloning);
        this.init();
    }

    private void init() throws ELdapException {
        if (this.mMinConns < 0) {
            throw new ELdapException("Invalid minimum number of connections: " + this.mMinConns);
        }
        if (this.mMaxConns <= 0) {
            throw new ELdapException("Invalid maximum number of connections: " + this.mMaxConns);
        }
        if (this.mMinConns > this.mMaxConns) {
            throw new ELdapException("Minimum number of connections is bigger than maximum: " + this.mMinConns + " > " + this.mMaxConns);
        }
        if (this.mMaxResults < 0) {
            throw new ELdapException("Invalid maximum number of results: " + this.mMaxResults);
        }
        if (this.mConnInfo == null) {
            throw new IllegalArgumentException("Missing connection info");
        }
        if (this.mAuthInfo == null) {
            throw new IllegalArgumentException("Missing authentication info");
        }
        logger.debug("LdapBoundConnFactory: mininum: " + this.mMinConns);
        logger.debug("LdapBoundConnFactory: maximum: " + this.mMaxConns);
        logger.debug("LdapBoundConnFactory: host: " + this.mConnInfo.getHost());
        logger.debug("LdapBoundConnFactory: port: " + this.mConnInfo.getPort());
        logger.debug("LdapBoundConnFactory: secure: " + this.mConnInfo.getSecure());
        logger.debug("LdapBoundConnFactory: authentication: " + this.mAuthInfo.getAuthType());
        this.mConns = new LdapBoundConnection[this.mMaxConns];
        if (this.mMinConns > 0) {
            this.makeConnection(this.mErrorIfDown);
            this.makeMinimum();
        }
    }

    protected void makeConnection(boolean errorIfDown) throws ELdapException {
        logger.debug("LdapBoundConnFactory: makeConnection(" + errorIfDown + ")");
        this.mMasterConn = this.makeNewConnection(errorIfDown);
        if (this.mMasterConn != null) {
            this.mMasterConn.connectionFactory = this;
        }
    }

    private LdapBoundConnection makeNewConnection(boolean errorIfDown) throws ELdapException {
        logger.debug("LdapBoundConnFactory: makeNewConnection(" + errorIfDown + ")");
        LdapBoundConnection conn = null;
        try {
            PKISocketFactory socketFactory = new PKISocketFactory();
            if (this.engine != null) {
                socketFactory.setAuditor(this.engine.getAuditor());
                socketFactory.addSocketListener(this.engine.getClientSocketListener());
            }
            socketFactory.setSecure(this.mConnInfo.getSecure());
            if (this.mAuthInfo.getAuthType() == 2) {
                socketFactory.setClientCertNickname(this.mAuthInfo.getClientCertNickname());
            }
            socketFactory.init(this.config);
            conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, this.mConnInfo, this.mAuthInfo);
            conn.connectionFactory = this;
        }
        catch (EBaseException e) {
            throw new ELdapException("Unable to create socket factory: " + e.getMessage(), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                String message = "LDAP server is unavailable: " + this.mConnInfo.getHost() + ":" + this.mConnInfo.getPort();
                logger.error("LdapBoundConnFactory: " + message, (Throwable)e);
                if (errorIfDown) {
                    throw new ELdapServerDownException(message, (Throwable)e);
                }
            }
            String message = "Unable to connect to LDAP server: " + e.getMessage();
            logger.error("LdapBoundConnFactory: " + message, (Throwable)e);
            throw new ELdapException(message, (Throwable)e);
        }
        return conn;
    }

    private void makeMinimum() throws ELdapException {
        String method = "LdapBoundConnFactory.makeMinimum: ";
        boolean cloning = false;
        int realMin = Math.max(this.mMinConns, 1);
        if (this.mMasterConn != null && this.mMasterConn.isConnected() && this.doCloning) {
            logger.debug(method + "connections will be cloned from the master");
            cloning = true;
        } else {
            logger.debug(method + "master conn not available.");
        }
        logger.debug(method + "begins: total connections: " + this.mTotal);
        logger.debug(method + "begins: available connections: " + this.mNumConns);
        if (this.mNumConns < realMin && this.mTotal <= this.mMaxConns) {
            int increment = Math.min(realMin - this.mNumConns, this.mMaxConns - this.mTotal);
            logger.debug(method + "increasing minimum connections by " + increment);
            for (int i = increment - 1; i >= 0; --i) {
                this.mConns[i] = cloning ? (LdapBoundConnection)((Object)this.mMasterConn.clone()) : this.makeNewConnection(true);
            }
            this.mTotal += increment;
            this.mNumConns += increment;
            logger.debug(method + "ends: total connections: " + this.mTotal);
            logger.debug(method + "ends: number of connections: " + this.mNumConns);
        }
    }

    @Override
    public LDAPConnection getConn() throws ELdapException {
        return this.getConn(true);
    }

    public synchronized LdapBoundConnection getConn(boolean waitForConn) throws ELdapException {
        LdapBoundConnection conn = null;
        String method = "LdapBoundConnFactory (" + this.id + ").getConn: ";
        logger.debug(method + "initial values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        if (this.mMasterConn != null) {
            logger.debug(method + "master connection is connected: " + this.mMasterConn.isConnected());
        } else {
            logger.debug(method + "master connection is null");
        }
        if (!(this.mMasterConn != null && this.mMasterConn.isConnected() || this.mMinConns <= 0)) {
            try {
                this.makeConnection(true);
            }
            catch (ELdapException e) {
                this.mMasterConn = null;
                throw new ELdapException("LdapBoundConnFactory: Unable to create master connection. " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.mNumConns == 0) {
            this.makeMinimum();
        }
        while (this.mNumConns == 0) {
            logger.warn("LdapBoundConnFactory: waiting connections for " + this.mConnInfo.getHost() + ":" + this.mConnInfo.getPort());
            if (!waitForConn) {
                logger.warn("LdapBoundConnFactory: out of LDAP connections");
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.warn("LdapBoundConnFactory: connection wait interrupted");
                return null;
            }
            if (this.mMinConns != 0) continue;
            this.makeMinimum();
        }
        --this.mNumConns;
        conn = this.mConns[this.mNumConns];
        this.mConns[this.mNumConns] = null;
        logger.debug("LdapBoundConnFactory: number of connections: " + this.mNumConns);
        if (conn == null || !conn.isConnected()) {
            logger.debug("LdapBoundConnFactory: reestablishing connection");
            try {
                conn = this.mMinConns > 0 && this.doCloning && this.mMasterConn != null ? (LdapBoundConnection)((Object)this.mMasterConn.clone()) : this.makeNewConnection(true);
            }
            catch (ELdapException e) {
                --this.mTotal;
                String message = "Unable to reestablish LDAP connection: " + e.getMessage();
                logger.error("LdapBoundConnFactory: " + message, (Throwable)e);
                throw new ELdapException(message, (Throwable)e);
            }
            logger.debug("LdapBoundConnFactory: connection reestablished");
        }
        try {
            conn.setOption(3, this.mMaxResults);
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to set LDAP size limit: " + e.getMessage(), (Throwable)e);
        }
        logger.debug(method + " final values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        return conn;
    }

    @Override
    public synchronized void returnConn(LDAPConnection conn) {
        String method = "LdapBoundConnFactory (" + this.id + ").returnConn: ";
        logger.debug(method + "initial values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        if (conn == null) {
            return;
        }
        LdapBoundConnection boundconn = null;
        if (!(conn instanceof LdapBoundConnection)) {
            logger.warn("LdapBoundConnFactory: Unable to return connection: not a bound connection");
            return;
        }
        boundconn = (LdapBoundConnection)conn;
        if (boundconn.connectionFactory != this) {
            logger.warn("LdapBoundConnFactory: Unknown connection");
            try {
                boundconn.disconnect();
            }
            catch (LDAPException e) {
                logger.warn("LdapBoundConnFactory: Unable to disconnect: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        for (int i = 0; i < this.mNumConns; ++i) {
            if (this.mConns[i] != conn) continue;
            logger.warn("LdapBoundConnFactory: Connection already returned");
            --this.mTotal;
            this.notifyAll();
            return;
        }
        if (this.mNumConns < this.mMinConns) {
            this.mConns[this.mNumConns++] = boundconn;
        } else {
            try {
                boundconn.disconnect();
            }
            catch (LDAPException e) {
                logger.warn("LdapBoundConnFactory: Unable to disconnect: " + e.getMessage(), (Throwable)e);
            }
            --this.mTotal;
        }
        this.notifyAll();
        logger.debug(method + " final values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
    }

    protected void finalize() throws Exception {
        this.reset();
    }

    @Override
    public synchronized void reset() throws ELdapException {
        logger.debug("Destroying LdapBoundConnFactory(" + this.id + ")");
        if (this.mNumConns == this.mTotal) {
            for (int i = 0; i < this.mNumConns; ++i) {
                try {
                    this.mConns[i].disconnect();
                }
                catch (LDAPException e) {
                    logger.warn("LdapBoundConnFactory: Unable to disconnect: " + e.getMessage(), (Throwable)e);
                }
                this.mConns[i] = null;
            }
            if (this.mMasterConn != null) {
                try {
                    logger.debug("LdapBoundConnFactory: disconnecting master connection");
                    this.mMasterConn.disconnect();
                }
                catch (LDAPException e) {
                    String message = "Unable to disconnect master connection: " + e.getMessage();
                    logger.warn("LdapBoundConnFactory: " + message, (Throwable)e);
                }
            }
        } else {
            String message = "Unable to reset LDAP connection factory due to outstanding connections";
            logger.error("LdapBoundConnFactory: " + message);
            throw new ELdapException(message);
        }
        this.mMasterConn = null;
        this.mTotal = 0;
        this.mNumConns = 0;
        this.mConns = new LdapBoundConnection[this.mMaxConns];
        if (this.mAuthInfo != null) {
            this.mAuthInfo.reset();
        }
    }

    public synchronized void shutdown() throws ELdapException {
        logger.debug("Destroying LdapBoundConnFactory(" + this.id + ")");
        for (int i = 0; i < this.mNumConns; ++i) {
            if (this.mConns[i] == null) continue;
            this.mConns[i].close();
            this.mConns[i] = null;
        }
        if (this.mMasterConn != null) {
            logger.debug("LdapBoundConnFactory: disconnecting master connection");
            this.mMasterConn.close();
            this.mMasterConn = null;
        }
        this.mTotal = 0;
        this.mNumConns = 0;
        if (this.mAuthInfo != null) {
            this.mAuthInfo.reset();
        }
    }

    public LdapConnInfo getConnInfo() {
        return this.mConnInfo;
    }

    public LdapAuthInfo getAuthInfo() {
        return this.mAuthInfo;
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setPasswordStore(PasswordStore passwordStore) {
        this.passwordStore = passwordStore;
    }
}

