/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.usrgrp;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.security.cert.X509Certificate;
import netscape.ldap.LDAPException;

public class CertDNCertUserLocator
extends CertUserLocator {
    protected static final String LDAP_ATTR_CERTDN = "seeAlso";

    @Override
    public String getDescription() {
        return "A subject is authenticated if its first certificate can be matched with one of the certificate in the scope";
    }

    @Override
    public User locateUser(Certificates certs) throws EUsrGrpException, LDAPException, ELdapException {
        UGSubsystem mUG = this.engine.getUGSubsystem();
        X509Certificate[] certificates = certs.getCertificates();
        if (certificates == null) {
            return null;
        }
        String filter = "seeAlso=" + certificates[0].getSubjectDN();
        return mUG.findUsersByCert(filter);
    }
}

