/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.usrgrp;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.security.cert.X509Certificate;
import netscape.ldap.LDAPException;

public class ExactMatchCertUserLocator
extends CertUserLocator {
    @Override
    public String getDescription() {
        return "A subject is authenticated if its first certificate can be matched with one of the certificate in the scope";
    }

    @Override
    public User locateUser(Certificates certs) throws EUsrGrpException, LDAPException, ELdapException {
        UGSubsystem mUG = this.engine.getUGSubsystem();
        X509Certificate[] certificates = certs.getCertificates();
        if (certificates == null) {
            return null;
        }
        int pos = 0;
        if (certificates[0].getSubjectDN().toString().equals(certificates[0].getIssuerDN().toString())) {
            pos = certificates.length - 1;
        }
        String filter = "description=" + mUG.getCertificateString(certificates[pos]);
        return mUG.findUsersByCert(filter);
    }
}

