/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNameUtil;
import org.dogtagpki.legacy.policy.IGeneralNameConfig;
import org.mozilla.jss.netscape.security.x509.GeneralName;

public class GeneralNameConfig
implements IGeneralNameConfig {
    public String mName = null;
    public String mNameDot = null;
    public ConfigStore mConfig;
    public String mGenNameChoice = null;
    public boolean mIsValueConfigured = true;
    public String mValue = null;
    public GeneralName mGeneralName = null;
    public boolean mIsPolicyEnabled = true;
    public String mNameDotChoice = null;
    public String mNameDotValue = null;

    public GeneralNameConfig(String name, ConfigStore config, boolean isValueConfigured, boolean isPolicyEnabled) throws EBaseException {
        this.mIsValueConfigured = isValueConfigured;
        this.mIsPolicyEnabled = isPolicyEnabled;
        this.mName = name;
        if (this.mName != null && this.mName.length() > 0) {
            this.mNameDot = this.mName + ".";
            this.mNameDotChoice = this.mNameDot + "generalNameChoice";
            this.mNameDotValue = this.mNameDot + "generalNameValue";
        } else {
            this.mNameDot = "";
            this.mNameDotChoice = "generalNameChoice";
            this.mNameDotValue = "generalNameValue";
        }
        this.mConfig = config;
        if (this.mConfig.size() == 0) {
            config.putString(this.mNameDotChoice, "");
            if (this.mIsValueConfigured) {
                config.putString(this.mNameDotValue, "");
            }
        }
        String choice = null;
        if (this.mIsPolicyEnabled) {
            choice = this.mConfig.getString("generalNameChoice");
            this.mGenNameChoice = GeneralNameUtil.check_GeneralNameChoice(choice);
        } else {
            choice = this.mConfig.getString("generalNameChoice", "");
            if (choice.length() > 0 && !choice.equals("null")) {
                this.mGenNameChoice = GeneralNameUtil.check_GeneralNameChoice(choice);
            }
        }
        if (this.mIsValueConfigured) {
            if (this.mIsPolicyEnabled) {
                this.mValue = this.mConfig.getString("generalNameValue");
                this.mGeneralName = this.formGeneralName(this.mGenNameChoice, this.mValue);
            } else {
                this.mValue = this.mConfig.getString("generalNameValue", "");
                if (this.mValue != null && this.mValue.length() > 0) {
                    this.mGeneralName = this.formGeneralName(this.mGenNameChoice, this.mValue);
                }
            }
        }
    }

    @Override
    public GeneralName formGeneralName(String value) throws EBaseException {
        return this.formGeneralName(this.mGenNameChoice, value);
    }

    public GeneralName formGeneralName(String choice, String value) throws EBaseException {
        return GeneralNameUtil.form_GeneralName(choice, value);
    }

    @Override
    public Vector<GeneralName> formGeneralNames(Object value) throws EBaseException {
        Vector<GeneralName> gns;
        block6: {
            GeneralName gn;
            block5: {
                gns = new Vector<GeneralName>();
                gn = null;
                if (!(value instanceof String)) break block5;
                if (((String)(value = ((String)value).trim())).length() <= 0) break block6;
                gn = this.formGeneralName(this.mGenNameChoice, (String)value);
                gns.addElement(gn);
                break block6;
            }
            if (value instanceof String[]) {
                String[] vals = (String[])value;
                for (int i = 0; i < vals.length; ++i) {
                    String val = vals[i].trim();
                    if (val == null || val.length() <= 0) continue;
                    gn = this.formGeneralName(this.mGenNameChoice, val);
                    gns.addElement(gn);
                }
            } else if (value instanceof Vector) {
                Vector vals = (Vector)value;
                Enumeration n = vals.elements();
                while (n.hasMoreElements()) {
                    Object val = n.nextElement();
                    if (val == null || !(val instanceof String) || ((String)(val = ((String)val).trim())).length() <= 0) continue;
                    gn = this.formGeneralName(this.mGenNameChoice, (String)val);
                    gns.addElement(gn);
                }
            }
        }
        return gns;
    }

    public String getName() {
        return this.mName;
    }

    public ConfigStore getConfig() {
        return this.mConfig;
    }

    public String getGenNameChoice() {
        return this.mGenNameChoice;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean isValueConfigured() {
        return this.mIsValueConfigured;
    }

    public static void getDefaultParams(String name, boolean isValueConfigured, Vector<String> params) {
        Object nameDot = "";
        if (name != null) {
            nameDot = name + ".";
        }
        GeneralNameUtil.logger.trace("GeneralnameConfig getDefaultParams");
        params.addElement((String)nameDot + "generalNameChoice=");
        if (isValueConfigured) {
            params.addElement((String)nameDot + "generalNameValue=");
        }
    }

    @Override
    public void getInstanceParams(Vector<String> params) {
        String value = this.mValue == null ? "" : this.mValue;
        String choice = this.mGenNameChoice == null ? "" : this.mGenNameChoice;
        params.addElement(this.mNameDotChoice + "=" + choice);
        if (this.mIsValueConfigured) {
            params.addElement(this.mNameDotValue + "=" + value);
        }
    }

    public static void getExtendedPluginInfo(String name, boolean isValueConfigured, Vector<String> info) {
        Object nameDot = "";
        if (name != null && name.length() > 0) {
            nameDot = name + ".";
        }
        info.addElement((String)nameDot + "generalNameChoice;choice(rfc822Name,directoryName,dNSName,ediPartyName,URL,iPAddress,OID,otherName);GeneralName choice. See RFC 2459 appendix B2 on GeneralName.");
        if (isValueConfigured) {
            info.addElement((String)nameDot + "generalNameValue;string;Value according to the GeneralName choice.");
        }
    }
}

