/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server;

import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.certsrv.logging.event.ClientAccessSessionEstablishEvent;
import com.netscape.certsrv.logging.event.ClientAccessSessionTerminatedEvent;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.jss.ssl.SSLAlertDescription;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIClientSocketListener
implements SSLSocketListener {
    private static Logger logger = LoggerFactory.getLogger(PKIClientSocketListener.class);
    protected CMSEngine engine;
    Map<SSLSocket, Map<String, Object>> socketInfos = new WeakHashMap<SSLSocket, Map<String, Object>>();

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void alertReceived(SSLAlertEvent event) {
        String method = "PKIClientSocketListener.alertReceived: ";
        logger.debug(method + "begins");
        Auditor auditor = this.engine.getAuditor();
        try {
            SSLSocket socket = event.getSocket();
            InetAddress serverAddress = socket.getInetAddress();
            InetAddress clientAddress = socket.getLocalAddress();
            String clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
            String serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
            String serverPort = Integer.toString(socket.getPort());
            SSLSecurityStatus status = socket.getStatus();
            String subjectID = "SYSTEM";
            int description = event.getDescription();
            String reason = "clientAlertReceived: " + SSLAlertDescription.valueOf((int)description).toString();
            auditor.log(ClientAccessSessionTerminatedEvent.createEvent(clientIP, serverIP, serverPort, subjectID, reason));
            logger.debug("PKIClientSocketListener: SSL alert received:");
            logger.debug("- reason: " + reason);
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- server port: " + serverPort);
            logger.debug("- subject: " + subjectID);
        }
        catch (Exception e) {
            logger.warn("PKIClientSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }

    public void alertSent(SSLAlertEvent event) {
        String method = "PKIClientSocketListener.alertSent: ";
        logger.debug(method + "begins");
        Auditor auditor = this.engine.getAuditor();
        try {
            SignedAuditEvent auditEvent;
            String subjectID;
            String serverPort;
            String serverIP;
            String clientIP;
            SSLSocket socket = event.getSocket();
            int description = event.getDescription();
            logger.debug(method + "got description:" + description);
            String reason = "clientAlertSent: " + SSLAlertDescription.valueOf((int)description).toString();
            logger.debug(method + "got reason:" + reason);
            if (description == SSLAlertDescription.CLOSE_NOTIFY.getID()) {
                Map<String, Object> info = this.socketInfos.get(socket);
                clientIP = (String)info.get("clientIP");
                serverIP = (String)info.get("serverIP");
                serverPort = (String)info.get("serverPort");
                subjectID = (String)info.get("subjectID");
                auditEvent = ClientAccessSessionTerminatedEvent.createEvent(clientIP, serverIP, serverPort, subjectID, reason);
            } else {
                InetAddress serverAddress = socket.getInetAddress();
                InetAddress clientAddress = socket.getLocalAddress();
                clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
                serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
                serverPort = Integer.toString(socket.getPort());
                SSLSecurityStatus status = socket.getStatus();
                subjectID = "SYSTEM";
                auditEvent = ClientAccessSessionEstablishEvent.createFailureEvent(clientIP, serverIP, serverPort, subjectID, reason);
            }
            auditor.log(auditEvent);
            logger.debug("PKIClientSocketListener: SSL alert sent:");
            logger.debug("- reason: " + reason);
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- subject: " + subjectID);
            logger.debug("- server port: " + serverPort);
        }
        catch (Exception e) {
            logger.warn("PKIClientSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }

    public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
        String method = "PKIClientSocketListener.handshakeCompleted: ";
        logger.debug(method + "begins");
        Auditor auditor = this.engine.getAuditor();
        try {
            SSLSocket socket = event.getSocket();
            InetAddress serverAddress = socket.getInetAddress();
            InetAddress clientAddress = socket.getLocalAddress();
            String serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
            String clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
            String serverPort = Integer.toString(socket.getPort());
            SSLSecurityStatus status = socket.getStatus();
            String subjectID = "SYSTEM";
            logger.debug("PKIClientSocketListener: Handshake completed:");
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- server port: " + serverPort);
            logger.debug("- subject: " + subjectID);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("clientIP", clientIP);
            info.put("serverIP", serverIP);
            info.put("serverPort", serverPort);
            info.put("subjectID", subjectID);
            this.socketInfos.put(socket, info);
            auditor.log(ClientAccessSessionEstablishEvent.createSuccessEvent(clientIP, serverIP, serverPort, subjectID));
        }
        catch (Exception e) {
            logger.warn("PKIClientSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }
}

