/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server;

import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.certsrv.logging.event.AccessSessionEstablishEvent;
import com.netscape.certsrv.logging.event.AccessSessionTerminatedEvent;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.net.InetAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLAlertDescription;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIServerSocketListener
implements SSLSocketListener {
    private static Logger logger = LoggerFactory.getLogger(PKIServerSocketListener.class);
    private static final String defaultUnknown = "--";
    protected CMSEngine engine;
    Map<SSLSocket, Map<String, Object>> socketInfos = new WeakHashMap<SSLSocket, Map<String, Object>>();

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void alertReceived(SSLAlertEvent event) {
        if (this.engine == null || !this.engine.isInRunningState()) {
            return;
        }
        Auditor auditor = this.engine.getAuditor();
        try {
            X509Certificate cert;
            Certificate[] certs;
            JSSSession session;
            SSLSocket socket = event.getSocket();
            JSSEngine engine = event.getEngine();
            InetAddress clientAddress = null;
            InetAddress serverAddress = null;
            String clientIP = defaultUnknown;
            String serverIP = defaultUnknown;
            String subjectID = defaultUnknown;
            String hostname = defaultUnknown;
            SSLSecurityStatus status = null;
            if (socket != null) {
                clientAddress = socket.getInetAddress();
                serverAddress = socket.getLocalAddress();
                clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
                serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
                status = socket.getStatus();
                X509Certificate peerCertificate = status.getPeerCertificate();
                Principal subjectDN = peerCertificate == null ? null : peerCertificate.getSubjectDN();
                subjectID = subjectDN == null ? "" : subjectDN.toString();
            } else if (engine != null && (session = engine.getSession()) != null && (certs = session.getPeerCertificates()) != null && (cert = (X509Certificate)certs[0]) != null) {
                subjectID = cert.getSubjectDN().toString();
            }
            int description = event.getDescription();
            String reason = "serverAlertReceived: " + SSLAlertDescription.valueOf((int)description).toString();
            logger.debug("PKIServerSocketListener: SSL alert received:");
            logger.debug("- reason: " + reason);
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- subject: " + subjectID);
            auditor.log(AccessSessionTerminatedEvent.createEvent(clientIP, serverIP, subjectID, reason));
        }
        catch (Exception e) {
            logger.error("PKIServerSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }

    public void alertSent(SSLAlertEvent event) {
        if (this.engine == null || !this.engine.isInRunningState()) {
            return;
        }
        Auditor auditor = this.engine.getAuditor();
        try {
            SignedAuditEvent auditEvent;
            SSLSocket socket = event.getSocket();
            JSSEngine engine = event.getEngine();
            int description = event.getDescription();
            String reason = "serverAlertSent: " + SSLAlertDescription.valueOf((int)description).toString();
            String clientIP = defaultUnknown;
            String serverIP = defaultUnknown;
            String subjectID = defaultUnknown;
            InetAddress clientAddress = null;
            InetAddress serverAddress = null;
            if (description == SSLAlertDescription.CLOSE_NOTIFY.getID()) {
                Certificate[] certs;
                JSSSession session;
                if (socket != null) {
                    Map<String, Object> info = this.socketInfos.get(socket);
                    clientIP = (String)info.get("clientIP");
                    serverIP = (String)info.get("serverIP");
                    subjectID = (String)info.get("subjectID");
                } else if (engine != null && (session = engine.getSession()) != null && (certs = session.getPeerCertificates()) != null) {
                    X509Certificate cert = (X509Certificate)certs[0];
                    subjectID = cert.getSubjectDN().toString();
                }
                auditEvent = AccessSessionTerminatedEvent.createEvent(clientIP, serverIP, subjectID, reason);
            } else {
                X509Certificate cert;
                Certificate[] certs;
                JSSSession session;
                if (socket != null) {
                    clientAddress = socket.getInetAddress();
                    serverAddress = socket.getLocalAddress();
                    clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
                    serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
                    SSLSecurityStatus status = socket.getStatus();
                    X509Certificate peerCertificate = status.getPeerCertificate();
                    Principal subjectDN = peerCertificate == null ? null : peerCertificate.getSubjectDN();
                    subjectID = subjectDN == null ? "" : subjectDN.toString();
                } else if (engine != null && (session = engine.getSession()) != null && (certs = session.getPeerCertificates()) != null && (cert = (X509Certificate)certs[0]) != null) {
                    subjectID = cert.getSubjectDN().toString();
                }
                auditEvent = AccessSessionEstablishEvent.createFailureEvent(clientIP, serverIP, subjectID, reason);
            }
            logger.debug("PKIServerSocketListener: SSL alert sent:");
            logger.debug("- reason: " + reason);
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- subject: " + subjectID);
            auditor.log(auditEvent);
        }
        catch (Exception e) {
            logger.error("PKIServerSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }

    public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
        if (this.engine == null || !this.engine.isInRunningState()) {
            return;
        }
        Auditor auditor = this.engine.getAuditor();
        try {
            X509Certificate cert;
            Certificate[] certs;
            JSSSession session;
            SSLSocket socket = event.getSocket();
            JSSEngine engine = event.getEngine();
            InetAddress clientAddress = null;
            InetAddress serverAddress = null;
            String clientIP = defaultUnknown;
            String serverIP = defaultUnknown;
            SSLSecurityStatus status = null;
            X509Certificate peerCertificate = null;
            Principal subjectDN = null;
            String subjectID = defaultUnknown;
            if (socket != null) {
                clientAddress = socket.getInetAddress();
                serverAddress = socket.getLocalAddress();
                clientIP = clientAddress == null ? "" : clientAddress.getHostAddress();
                serverIP = serverAddress == null ? "" : serverAddress.getHostAddress();
                status = socket.getStatus();
                peerCertificate = status.getPeerCertificate();
                subjectDN = peerCertificate == null ? null : peerCertificate.getSubjectDN();
                subjectID = subjectDN == null ? "" : subjectDN.toString();
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("clientIP", clientIP);
                info.put("serverIP", serverIP);
                info.put("subjectID", subjectID);
                this.socketInfos.put(socket, info);
            } else if (engine != null && (session = engine.getSession()) != null && (certs = session.getPeerCertificates()) != null && (cert = (X509Certificate)certs[0]) != null) {
                subjectID = cert.getSubjectDN().toString();
            }
            logger.debug("PKIServerSocketListener: Handshake completed:");
            logger.debug("- client: " + clientIP);
            logger.debug("- server: " + serverIP);
            logger.debug("- subject: " + subjectID);
            auditor.log(AccessSessionEstablishEvent.createSuccessEvent(clientIP, serverIP, subjectID));
        }
        catch (Exception e) {
            logger.error("PKIServerSocketListener: " + e.getMessage(), (Throwable)e);
        }
    }
}

