/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.group.GroupCollection;
import com.netscape.certsrv.group.GroupData;
import com.netscape.certsrv.group.GroupMemberData;
import com.netscape.certsrv.group.GroupNotFoundException;
import com.netscape.certsrv.group.GroupResource;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.cms.servlet.admin.GroupMemberProcessor;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupService
extends SubsystemService
implements GroupResource {
    public static Logger logger = LoggerFactory.getLogger(GroupService.class);

    public GroupData createGroupData(Group group) throws Exception {
        String description;
        GroupData groupData = new GroupData();
        String groupID = group.getGroupID();
        if (!StringUtils.isEmpty((CharSequence)groupID)) {
            groupData.setID(groupID);
            groupData.setGroupID(groupID);
        }
        if (!StringUtils.isEmpty((CharSequence)(description = group.getDescription()))) {
            groupData.setDescription(description);
        }
        return groupData;
    }

    public Response findGroups(String filter, Integer start, Integer size) {
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        try {
            int i;
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Enumeration<Group> groups = userGroupManager.listGroups(filter);
            GroupCollection response = new GroupCollection();
            for (i = 0; i < start && groups.hasMoreElements(); ++i) {
                groups.nextElement();
            }
            while (i < start + size && groups.hasMoreElements()) {
                Group group = groups.nextElement();
                response.addEntry((Object)this.createGroupData(group));
                ++i;
            }
            while (groups.hasMoreElements()) {
                groups.nextElement();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (Exception e) {
            logger.error("GroupService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getGroup(String groupID) {
        return this.createOKResponse(this.getGroupData(groupID));
    }

    public GroupData getGroupData(String groupID) {
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
                throw new GroupNotFoundException(groupID);
            }
            return this.createGroupData(group);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(this.getUserMessage("CMS_INTERNAL_ERROR", this.headers, new String[0]));
        }
    }

    public Response addGroup(GroupData groupData) {
        if (groupData == null) {
            throw new BadRequestException("Group data is null.");
        }
        String groupID = groupData.getGroupID();
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Group group = userGroupManager.createGroup(groupID);
            String description = groupData.getDescription();
            if (description != null && !description.equals("")) {
                group.set("description", description);
            }
            userGroupManager.addGroup(group);
            this.auditAddGroup(groupID, groupData, "Success");
            groupData = this.getGroupData(groupID);
            String encodedGroupID = URLEncoder.encode(groupData.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(GroupResource.class).path("{groupID}").build(new Object[]{encodedGroupID});
            return this.createCreatedResponse(groupData, uri);
        }
        catch (PKIException e) {
            this.auditAddGroup(groupID, groupData, "Failure");
            throw e;
        }
        catch (EBaseException | UnsupportedEncodingException e) {
            this.auditAddGroup(groupID, groupData, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public Response modifyGroup(String groupID, GroupData groupData) {
        if (groupData == null) {
            throw new BadRequestException("Group data is null.");
        }
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                throw new ResourceNotFoundException("Group " + groupID + "  not found.");
            }
            String description = groupData.getDescription();
            if (description != null) {
                if (description.equals("")) {
                    group.delete("description");
                } else {
                    group.set("description", description);
                }
            }
            userGroupManager.modifyGroup(group);
            this.auditModifyGroup(groupID, groupData, "Success");
            groupData = this.getGroupData(groupID);
            return this.createOKResponse(groupData);
        }
        catch (PKIException e) {
            this.auditModifyGroup(groupID, groupData, "Failure");
            throw e;
        }
        catch (EBaseException e) {
            this.auditModifyGroup(groupID, groupData, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public Response removeGroup(String groupID) {
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            userGroupManager.removeGroup(groupID);
            this.auditDeleteGroup(groupID, "Success");
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            this.auditDeleteGroup(groupID, "Failure");
            throw e;
        }
        catch (EBaseException e) {
            this.auditDeleteGroup(groupID, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public Response findGroupMembers(String groupID, String filter, Integer start, Integer size) {
        logger.debug("GroupService.findGroupMembers(" + groupID + ", " + filter + ")");
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        try {
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            processor.setUriInfo(this.uriInfo);
            return this.createOKResponse(processor.findGroupMembers(groupID, filter, start, size));
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response getGroupMember(String groupID, String memberID) {
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        if (memberID == null) {
            throw new BadRequestException("Member ID is null.");
        }
        try {
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            processor.setUriInfo(this.uriInfo);
            return this.createOKResponse(processor.getGroupMember(groupID, memberID));
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response addGroupMember(String groupID, GroupMemberData groupMemberData) {
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        if (groupMemberData.getID() == null) {
            throw new BadRequestException("Member ID is null.");
        }
        groupMemberData.setGroupID(groupID);
        try {
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            processor.setUriInfo(this.uriInfo);
            groupMemberData = processor.addGroupMember(groupMemberData);
            String encodedGroupID = URLEncoder.encode(groupID, "UTF-8");
            String encodedGroupMemberID = URLEncoder.encode(groupMemberData.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(GroupResource.class).path("{groupID}/members/{memberID}").build(new Object[]{encodedGroupID, encodedGroupMemberID});
            return this.createCreatedResponse(groupMemberData, uri);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response removeGroupMember(String groupID, String memberID) {
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        if (memberID == null) {
            throw new BadRequestException("Member ID is null.");
        }
        try {
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            processor.setUriInfo(this.uriInfo);
            processor.removeGroupMember(groupID, memberID);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public void auditAddGroup(String groupID, GroupData groupData, String status) {
        this.audit("OP_ADD", groupID, this.getParams(groupData), status);
    }

    public void auditModifyGroup(String groupID, GroupData groupData, String status) {
        this.audit("OP_MODIFY", groupID, this.getParams(groupData), status);
    }

    public void auditDeleteGroup(String groupID, String status) {
        this.audit("OP_DELETE", groupID, null, status);
    }

    public void audit(String type, String id, Map<String, String> params, String status) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        auditor.log(new ConfigRoleEvent(auditor.getSubjectID(), status, auditor.getParamString("groups", type, id, params)));
    }
}

