/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.admin.PolicyAdminServlet;
import com.netscape.kra.KeyRecoveryAuthority;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.dogtagpki.server.kra.KRAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAPolicyAdminServlet
extends PolicyAdminServlet {
    public static final Logger logger = LoggerFactory.getLogger(KRAPolicyAdminServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.debug("KRAPolicyAdminServlet: In Policy Admin Servlet init");
        KRAEngine engine = KRAEngine.getInstance();
        String authority = config.getInitParameter("authority");
        KeyRecoveryAuthority kra = null;
        if (authority != null) {
            kra = (KeyRecoveryAuthority)engine.getSubsystem(authority);
        }
        if (kra == null) {
            throw new ServletException(authority + " does not have policy processor");
        }
        this.mProcessor = kra.getPolicyProcessor();
        String policyStatus = "kra.Policy.enable";
        try {
            if (this.mConfig.getBoolean(policyStatus, true)) {
                logger.debug("KRAPolicyAdminServlet: Certificate Policy Framework (deprecated) is ENABLED");
            } else {
                logger.debug("KRAPolicyAdminServlet: Certificate Policy Framework (deprecated) is DISABLED");
            }
        }
        catch (EBaseException e) {
            throw new ServletException(authority + " does not have a master policy switch called '" + policyStatus + "'");
        }
    }
}

