/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofOfArchival
implements IDBObj {
    private static final long serialVersionUID = -2533562170977678799L;
    public static Logger logger = LoggerFactory.getLogger(ProofOfArchival.class);
    public static final BigInteger DEFAULT_VERSION = new BigInteger("1");
    public static final String ATTR_VERSION = "pofVersion";
    public static final String ATTR_SERIALNO = "pofSerialNo";
    public static final String ATTR_SUBJECT = "pofSubject";
    public static final String ATTR_ISSUER = "pofIssuer";
    public static final String ATTR_DATE_OF_ARCHIVAL = "pofDateOfArchival";
    protected BigInteger mSerialNo = null;
    protected BigInteger mVersion = null;
    protected String mSubject = null;
    protected String mIssuer = null;
    protected Date mDateOfArchival = null;
    protected static Vector<String> mNames = new Vector();

    public ProofOfArchival(BigInteger serialNo, String subject, String issuer, Date dateOfArchival) {
        this.mVersion = DEFAULT_VERSION;
        this.mSerialNo = serialNo;
        this.mSubject = subject;
        this.mIssuer = issuer;
        this.mDateOfArchival = dateOfArchival;
    }

    public ProofOfArchival(InputStream in) throws EBaseException {
        this.decode(in);
    }

    public void set(String name, Object obj) throws EBaseException {
        if (name.equals(ATTR_VERSION)) {
            this.mVersion = (BigInteger)obj;
        } else if (name.equals(ATTR_SERIALNO)) {
            this.mSerialNo = (BigInteger)obj;
        } else if (name.equals(ATTR_SUBJECT)) {
            this.mSubject = (String)obj;
        } else if (name.equals(ATTR_ISSUER)) {
            this.mIssuer = (String)obj;
        } else if (name.equals(ATTR_DATE_OF_ARCHIVAL)) {
            this.mDateOfArchival = (Date)obj;
        } else {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{name}));
        }
    }

    public Object get(String name) throws EBaseException {
        if (name.equals(ATTR_VERSION)) {
            return this.mVersion;
        }
        if (name.equals(ATTR_SERIALNO)) {
            return this.mSerialNo;
        }
        if (name.equals(ATTR_SUBJECT)) {
            return this.mSubject;
        }
        if (name.equals(ATTR_ISSUER)) {
            return this.mIssuer;
        }
        if (name.equals(ATTR_DATE_OF_ARCHIVAL)) {
            return this.mDateOfArchival;
        }
        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{name}));
    }

    public void delete(String name) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{name}));
    }

    public Enumeration<String> getElements() {
        return mNames.elements();
    }

    public Enumeration<String> getSerializableAttrNames() {
        return mNames.elements();
    }

    public BigInteger getVersion() {
        return this.mVersion;
    }

    public BigInteger getSerialNumber() {
        return this.mSerialNo;
    }

    public String getSubjectName() {
        return this.mSubject;
    }

    public String getIssuerName() {
        return this.mIssuer;
    }

    public Date getDateOfArchival() {
        return this.mDateOfArchival;
    }

    public void encode(DerOutputStream out) throws EBaseException {
        try {
            DerOutputStream seq = new DerOutputStream();
            if (!this.mVersion.equals(DEFAULT_VERSION)) {
                DerOutputStream version = new DerOutputStream();
                version.putInteger(new BigInt(this.mVersion));
                seq.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), version);
            }
            seq.putInteger(new BigInt(this.mSerialNo));
            new X500Name(this.mSubject).encode(seq);
            new X500Name(this.mIssuer).encode(seq);
            seq.putUTCTime(this.mDateOfArchival);
            out.write((byte)48, seq);
        }
        catch (IOException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
        }
    }

    public void encodeAndSign(PrivateKey key, String algorithm, String provider, DerOutputStream out) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        try {
            Signature sigEngine = null;
            sigEngine = provider == null ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            sigEngine.initSign(key);
            DerOutputStream tmp = new DerOutputStream();
            this.encode(tmp);
            AlgorithmId sigAlgId = AlgorithmId.get((String)sigEngine.getAlgorithm());
            sigAlgId.encode(tmp);
            byte[] dataToSign = tmp.toByteArray();
            sigEngine.update(dataToSign, 0, dataToSign.length);
            byte[] signature = sigEngine.sign();
            tmp.putBitString(signature);
            out.write((byte)48, tmp);
            return;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_ENCODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
        catch (NoSuchProviderException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_ENCODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_ENCODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
        catch (SignatureException e) {
            logger.error("Unable to sign proof of escrow: " + e.getMessage(), (Throwable)e);
            engine.checkForAndAutoShutdown();
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_ENCODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
        catch (IOException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_ENCODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
    }

    public void decode(InputStream in) throws EBaseException {
        try {
            DerValue val = new DerValue(in);
            DerValue[] seq = new DerValue[3];
            seq[0] = val.data.getDerValue();
            if (seq[0].tag == 48) {
                seq[1] = val.data.getDerValue();
                seq[2] = val.data.getDerValue();
                if (seq[1].data.available() != 0) {
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED_1", (String[])new String[]{"no algorithm found"}));
                }
                if (seq[2].data.available() != 0) {
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED_1", (String[])new String[]{"no signature found"}));
                }
                AlgorithmId algid = AlgorithmId.parse((DerValue)seq[1]);
                byte[] signature = seq[2].getBitString();
                this.decodePOA(val, null);
            } else {
                this.decodePOA(val, seq[0]);
            }
        }
        catch (IOException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
    }

    private void decodePOA(DerValue val, DerValue preprocessed) throws EBaseException {
        try {
            DerValue tmp = null;
            if (preprocessed == null) {
                if (val.tag != 48) {
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED_1", (String[])new String[]{"not start with sequence"}));
                }
                tmp = val.data.getDerValue();
            } else {
                tmp = preprocessed;
            }
            if (tmp.isContextSpecific((byte)0)) {
                if (tmp.isConstructed() && tmp.isContextSpecific()) {
                    DerValue version = tmp.data.getDerValue();
                    BigInt ver = version.getInteger();
                    this.mVersion = ver.toBigInteger();
                    tmp = val.data.getDerValue();
                }
            } else {
                this.mVersion = DEFAULT_VERSION;
            }
            DerValue serialno = tmp;
            this.mSerialNo = serialno.getInteger().toBigInteger();
            DerValue subject = val.data.getDerValue();
            this.mSubject = new String(subject.toByteArray());
            DerValue issuer = val.data.getDerValue();
            this.mIssuer = new String(issuer.toByteArray());
            this.mDateOfArchival = val.data.getUTCTime();
        }
        catch (IOException e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_POA_DECODE_FAILED_1", (String[])new String[]{e.toString()}), (Exception)e);
        }
    }

    public String toString() {
        return "Version: " + this.mVersion.toString() + "\nSerialNo: " + this.mSerialNo.toString() + "\nSubject: " + this.mSubject + "\nIssuer: " + this.mIssuer + "\nDateOfArchival: " + this.mDateOfArchival.toString();
    }

    static {
        mNames.addElement(ATTR_VERSION);
        mNames.addElement(ATTR_SERIALNO);
        mNames.addElement(ATTR_SUBJECT);
        mNames.addElement(ATTR_ISSUER);
        mNames.addElement(ATTR_DATE_OF_ARCHIVAL);
    }
}

