/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.kra.rest;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzUnknownRealm;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.AsymKeyGenerationRequest;
import com.netscape.certsrv.key.KeyArchivalRequest;
import com.netscape.certsrv.key.KeyRecoveryRequest;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.key.KeyRequestInfoCollection;
import com.netscape.certsrv.key.KeyRequestResource;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.key.SymKeyGenerationRequest;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.AsymKeyGenerationEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalRequestEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryStateChangeEvent;
import com.netscape.certsrv.logging.event.SymKeyGenerationEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestNotFoundException;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cms.servlet.key.KeyRequestDAO;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.crypto.SymmetricKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRequestService
extends SubsystemService
implements KeyRequestResource {
    public static Logger logger = LoggerFactory.getLogger(KeyRequestService.class);
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_PAGESIZE = 20;
    public static final int DEFAULT_MAXRESULTS = 100;
    public static final int DEFAULT_MAXTIME = 10;
    public static final Map<String, SymmetricKey.Type> SYMKEY_TYPES = new HashMap<String, SymmetricKey.Type>();

    public Response getRequestInfo(RequestId id) {
        KeyRequestInfo info;
        if (id == null) {
            logger.error("getRequestInfo: is is null");
            throw new BadRequestException("Unable to get Request: invalid ID");
        }
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            info = dao.getRequest(id, this.uriInfo, this.getAuthToken());
        }
        catch (EAuthzAccessDenied e) {
            throw new UnauthorizedException("Not authorized to get request");
        }
        catch (EBaseException e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
        if (info == null) {
            throw new RequestNotFoundException(id);
        }
        return this.createOKResponse(info);
    }

    public Response archiveKey(KeyArchivalRequest data) throws Exception {
        if (data == null) {
            throw new BadRequestException("Missing key archival request");
        }
        logger.info("Request:\n" + data.toJSON());
        if (data.getClientKeyId() == null || data.getDataType() == null) {
            throw new BadRequestException("Invalid key archival request.");
        }
        if (data.getWrappedPrivateData() != null) {
            if (data.getTransWrappedSessionKey() == null || data.getAlgorithmOID() == null || data.getSymmetricAlgorithmParams() == null) {
                throw new BadRequestException("Invalid key archival request.  Missing wrapped session key, algoriithmOIS or symmetric key parameters");
            }
        } else if (data.getPKIArchiveOptions() == null) {
            throw new BadRequestException("Invalid key archival request.  No data to archive");
        }
        if (data.getDataType().equals("symmetricKey") && (data.getKeyAlgorithm() == null || !SYMKEY_TYPES.containsKey(data.getKeyAlgorithm()))) {
            throw new BadRequestException("Invalid key archival request.  Bad algorithm.");
        }
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            if (this.getRequestor() == null) {
                throw new UnauthorizedException("Archival must be performed by an agent");
            }
            String realm = data.getRealm();
            if (realm != null) {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(realm, this.getAuthToken(), null, "certServer.kra.requests.archival", "execute");
            }
            KeyRequestResponse response = dao.submitRequest(data, this.uriInfo, this.getRequestor());
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)this.getRequestor(), null, (RequestId)response.getRequestInfo().getRequestID(), (String)data.getClientKeyId()));
            logger.info("Response:\n" + response.toJSON());
            return this.createCreatedResponse(response, new URI(response.getRequestInfo().getRequestURL()));
        }
        catch (EAuthzAccessDenied e) {
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)this.getRequestor(), null, null, (String)data.getClientKeyId(), (Exception)((Object)e)));
            throw new UnauthorizedException("Not authorized to generate request in this realm", (Throwable)e);
        }
        catch (EAuthzUnknownRealm e) {
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)this.getRequestor(), null, null, (String)data.getClientKeyId(), (Exception)((Object)e)));
            throw new BadRequestException("Invalid realm", (Throwable)e);
        }
        catch (EBaseException | URISyntaxException e) {
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)this.getRequestor(), null, null, (String)data.getClientKeyId(), (Exception)e));
            throw new PKIException(e.toString(), e);
        }
    }

    public Response recoverKey(KeyRecoveryRequest data) {
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            KeyRequestResponse response = data.getCertificate() != null ? dao.submitAsyncKeyRecoveryRequest(data, this.uriInfo, this.getRequestor(), this.getAuthToken()) : dao.submitRequest(data, this.uriInfo, this.getRequestor(), this.getAuthToken());
            this.auditRecoveryRequestMade(response.getRequestInfo().getRequestID(), "Success", data.getKeyId());
            return this.createCreatedResponse(response, new URI(response.getRequestInfo().getRequestURL()));
        }
        catch (EBaseException | URISyntaxException e) {
            e.printStackTrace();
            this.auditRecoveryRequestMade(null, "Failure", data.getKeyId());
            throw new PKIException(e.toString(), e);
        }
    }

    public Response approveRequest(RequestId id) {
        if (id == null) {
            throw new BadRequestException("Invalid request id.");
        }
        KeyRequestDAO dao = new KeyRequestDAO();
        if (this.getRequestor() == null) {
            throw new UnauthorizedException("Request approval must be initiated by an agent");
        }
        try {
            dao.approveRequest(id, this.getRequestor(), this.getAuthToken());
            this.auditRecoveryRequestChange(id, "Success", "approve");
        }
        catch (EAuthzAccessDenied e) {
            throw new UnauthorizedException("Not authorized to approve request", (Throwable)e);
        }
        catch (EBaseException e) {
            e.printStackTrace();
            this.auditRecoveryRequestChange(id, "Failure", "approve");
            throw new PKIException(e.toString(), (Throwable)e);
        }
        return this.createNoContentResponse();
    }

    public Response rejectRequest(RequestId id) {
        if (id == null) {
            throw new BadRequestException("Invalid request id.");
        }
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            dao.rejectRequest(id, this.getAuthToken());
            this.auditRecoveryRequestChange(id, "Success", "reject");
        }
        catch (EAuthzAccessDenied e) {
            throw new UnauthorizedException("Not authorized to reject request", (Throwable)e);
        }
        catch (EBaseException e) {
            e.printStackTrace();
            this.auditRecoveryRequestChange(id, "Failure", "reject");
            throw new PKIException(e.toString(), (Throwable)e);
        }
        return this.createNoContentResponse();
    }

    public Response cancelRequest(RequestId id) {
        if (id == null) {
            throw new BadRequestException("Invalid request id.");
        }
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            dao.cancelRequest(id, this.getAuthToken());
            this.auditRecoveryRequestChange(id, "Success", "cancel");
        }
        catch (EAuthzAccessDenied e) {
            throw new UnauthorizedException("Not authorized to cancel request", (Throwable)e);
        }
        catch (EBaseException e) {
            e.printStackTrace();
            this.auditRecoveryRequestChange(id, "Failure", "cancel");
            throw new PKIException(e.toString(), (Throwable)e);
        }
        return this.createNoContentResponse();
    }

    public Response listRequests(String requestState, String requestType, String clientKeyID, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime, String realm) {
        KeyRequestInfoCollection requests;
        logger.info("KeyRequestService: Listing key requests");
        logger.debug("KeyRequestService: request state: " + requestState);
        logger.debug("KeyRequestService: request type: " + requestType);
        logger.debug("KeyRequestService: client key ID: " + clientKeyID);
        logger.debug("KeyRequestService: realm: " + realm);
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        if (realm != null) {
            try {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(realm, this.getAuthToken(), null, "certServer.kra.requests", "list");
            }
            catch (EAuthzAccessDenied e) {
                throw new UnauthorizedException("Not authorized to list these requests", (Throwable)e);
            }
            catch (EAuthzUnknownRealm e) {
                throw new BadRequestException("Invalid realm", (Throwable)e);
            }
            catch (EBaseException e) {
                logger.error("KeyRequestService: Unable to authorize realm: " + e.getMessage(), (Throwable)e);
                throw new PKIException(e.toString(), (Throwable)e);
            }
        }
        String filter = this.createSearchFilter(requestState, requestType, clientKeyID, realm);
        logger.debug("KeyRequestService: filter: " + filter);
        start = start == null ? new RequestId(0) : start;
        pageSize = pageSize == null ? 20 : pageSize;
        maxResults = maxResults == null ? 100 : maxResults;
        maxTime = maxTime == null ? 10 : maxTime;
        KeyRequestDAO reqDAO = new KeyRequestDAO();
        try {
            requests = reqDAO.listRequests(filter, start, pageSize, maxResults, maxTime, this.uriInfo);
        }
        catch (EBaseException e) {
            logger.error("KeyRequestService: Unable to obtain request results: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.toString(), (Throwable)e);
        }
        return this.createOKResponse(requests);
    }

    private String createSearchFilter(String requestState, String requestType, String clientKeyID, String realm) {
        Object filter = "";
        int matches = 0;
        if (requestState == null && requestType == null && clientKeyID == null) {
            filter = "(requeststate=*)";
            ++matches;
        }
        if (requestState != null) {
            filter = (String)filter + "(requeststate=" + LDAPUtil.escapeFilter((Object)requestState) + ")";
            ++matches;
        }
        if (requestType != null) {
            filter = (String)filter + "(requesttype=" + LDAPUtil.escapeFilter((Object)requestType) + ")";
            ++matches;
        }
        if (clientKeyID != null) {
            filter = (String)filter + "(clientID=" + LDAPUtil.escapeFilter((Object)clientKeyID) + ")";
            ++matches;
        }
        if (realm != null) {
            filter = (String)filter + "(realm=" + LDAPUtil.escapeFilter((Object)realm) + ")";
            ++matches;
        } else {
            filter = (String)filter + "(!(realm=*))";
            ++matches;
        }
        if (matches > 1) {
            filter = "(&" + (String)filter + ")";
        }
        return filter;
    }

    public void auditRecoveryRequestChange(RequestId requestId, String status, String operation) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataRecoveryStateChangeEvent(this.getRequestor(), status, requestId, operation));
    }

    public void auditRecoveryRequestMade(RequestId requestId, String status, KeyId dataId) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SecurityDataRecoveryEvent(this.getRequestor(), status, requestId, dataId, null));
    }

    public void auditSymKeyGenRequestMade(RequestId requestId, String status, String clientKeyID) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new SymKeyGenerationEvent(this.getRequestor(), status, requestId, clientKeyID));
    }

    public void auditAsymKeyGenRequestMade(RequestId requestId, String status, String clientKeyID) {
        Auditor auditor = this.getCMSEngine().getAuditor();
        auditor.log((LogEvent)new AsymKeyGenerationEvent(this.getRequestor(), status, requestId, clientKeyID));
    }

    public Response submitRequest(MultivaluedMap<String, String> form) throws Exception {
        RESTMessage data = new RESTMessage(form);
        return this.submitRequest(data);
    }

    public Response submitRequest(RESTMessage data) throws Exception {
        Object request = null;
        try {
            Class<?> requestClazz = Class.forName(data.getClassName());
            request = requestClazz.getDeclaredConstructor(RESTMessage.class).newInstance(data);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new BadRequestException("Invalid request class." + e, (Throwable)e);
        }
        logger.info("KeyRequestService: Request class: " + request.getClass().getSimpleName());
        if (request instanceof KeyArchivalRequest) {
            return this.archiveKey(new KeyArchivalRequest(data));
        }
        if (request instanceof KeyRecoveryRequest) {
            return this.recoverKey(new KeyRecoveryRequest(data));
        }
        if (request instanceof SymKeyGenerationRequest) {
            return this.generateSymKey(new SymKeyGenerationRequest(data));
        }
        if (request instanceof AsymKeyGenerationRequest) {
            return this.generateAsymKey(new AsymKeyGenerationRequest(data));
        }
        throw new BadRequestException("Invalid request class.");
    }

    public Response generateSymKey(SymKeyGenerationRequest data) {
        if (data == null) {
            throw new BadRequestException("Invalid key generation request.");
        }
        String realm = data.getRealm();
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            if (this.getRequestor() == null) {
                throw new UnauthorizedException("Key generation must be performed by an agent");
            }
            if (realm != null) {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(realm, this.getAuthToken(), null, "certServer.kra.requests.symkey", "execute");
            }
            KeyRequestResponse response = dao.submitRequest(data, this.uriInfo, this.getRequestor());
            this.auditSymKeyGenRequestMade(response.getRequestInfo().getRequestID(), "Success", data.getClientKeyId());
            return this.createCreatedResponse(response, new URI(response.getRequestInfo().getRequestURL()));
        }
        catch (EAuthzAccessDenied e) {
            logger.error("KeyRequestService: Unauthorized access to realm " + realm, (Throwable)e);
            this.auditSymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new UnauthorizedException("Unauthorized access to realm " + realm, (Throwable)e);
        }
        catch (EAuthzUnknownRealm e) {
            logger.error("KeyRequestService: Unknown realm: " + realm, (Throwable)e);
            this.auditSymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new BadRequestException("Unknown realm: " + realm);
        }
        catch (EBaseException | URISyntaxException e) {
            logger.error("KeyRequestService: Unable to generate symmetric key: " + e.getMessage(), e);
            this.auditSymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new PKIException(e.toString(), e);
        }
    }

    public Response generateAsymKey(AsymKeyGenerationRequest data) {
        if (data == null) {
            throw new BadRequestException("Invalid key generation request.");
        }
        KRAEngine engine = (KRAEngine)this.getCMSEngine();
        KeyRequestDAO dao = new KeyRequestDAO();
        try {
            if (this.getRequestor() == null) {
                throw new UnauthorizedException("Key generation must be performed by an agent");
            }
            String realm = data.getRealm();
            if (realm != null) {
                AuthzSubsystem authz = engine.getAuthzSubsystem();
                authz.checkRealm(realm, this.getAuthToken(), null, "certServer.kra.requests.asymkey", "execute");
            }
            KeyRequestResponse response = dao.submitRequest(data, this.uriInfo, this.getRequestor());
            this.auditAsymKeyGenRequestMade(response.getRequestInfo().getRequestID(), "Success", data.getClientKeyId());
            return this.createCreatedResponse(response, new URI(response.getRequestInfo().getRequestURL()));
        }
        catch (EAuthzAccessDenied e) {
            this.auditAsymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new UnauthorizedException("Not authorized to generate request in this realm", (Throwable)e);
        }
        catch (EAuthzUnknownRealm e) {
            this.auditAsymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new BadRequestException("Invalid realm", (Throwable)e);
        }
        catch (EBaseException | URISyntaxException e) {
            e.printStackTrace();
            this.auditAsymKeyGenRequestMade(null, "Failure", data.getClientKeyId());
            throw new PKIException(e.toString(), e);
        }
    }

    private AuthToken getAuthToken() {
        Principal principal = this.servletRequest.getUserPrincipal();
        PKIPrincipal pkiprincipal = (PKIPrincipal)principal;
        AuthToken authToken = pkiprincipal.getAuthToken();
        return authToken;
    }

    private String getRequestor() {
        return this.servletRequest.getUserPrincipal().getName();
    }

    static {
        SYMKEY_TYPES.put("DES", SymmetricKey.DES);
        SYMKEY_TYPES.put("DESede", SymmetricKey.DES3);
        SYMKEY_TYPES.put("DES3", SymmetricKey.DES3);
        SYMKEY_TYPES.put("RC2", SymmetricKey.RC2);
        SYMKEY_TYPES.put("RC4", SymmetricKey.RC4);
        SYMKEY_TYPES.put("AES", SymmetricKey.AES);
    }
}

