/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ocsp.OCSPEngine;

public class ListCAServlet
extends CMSServlet {
    private static final long serialVersionUID = 3764395161795483452L;
    private static final String TPL_FILE = "listCAs.template";
    private String mFormPath = null;
    private OCSPAuthority mOCSPAuthority;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ocsp/listCAs.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSPAuthority = engine.getOCSP();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        IDefStore defStore = this.mOCSPAuthority.getDefaultStore();
        Enumeration<CRLIssuingPointRecord> recs = defStore.searchAllCRLIssuingPointRecord(100);
        header.addStringValue("stateCount", Integer.toString(defStore.getStateCount()));
        while (recs.hasMoreElements()) {
            CRLIssuingPointRecord rec = recs.nextElement();
            ArgBlock rarg = new ArgBlock();
            String thisId = rec.getId();
            rarg.addStringValue("Id", thisId);
            Date thisUpdate = rec.getThisUpdate();
            if (thisUpdate == null) {
                rarg.addStringValue("ThisUpdate", "UNKNOWN");
            } else {
                rarg.addStringValue("ThisUpdate", thisUpdate.toString());
            }
            Date nextUpdate = rec.getNextUpdate();
            if (nextUpdate == null) {
                rarg.addStringValue("NextUpdate", "UNKNOWN");
            } else {
                rarg.addStringValue("NextUpdate", nextUpdate.toString());
            }
            Long rc = rec.getCRLSize();
            if (rc == null) {
                rarg.addLongValue("NumRevoked", 0L);
            } else if (rc == -1L) {
                rarg.addStringValue("NumRevoked", "UNKNOWN");
            } else {
                rarg.addLongValue("NumRevoked", rc.longValue());
            }
            BigInteger crlNumber = rec.getCRLNumber();
            if (crlNumber == null || crlNumber.equals(new BigInteger("-1"))) {
                rarg.addStringValue("CRLNumber", "UNKNOWN");
            } else {
                rarg.addStringValue("CRLNumber", crlNumber.toString());
            }
            rarg.addLongValue("ReqCount", defStore.getReqCount(thisId));
            argSet.addRepeatRecord(rarg);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }
}

