/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.util.JSONSerializer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.dogtagpki.acme.server.ACMEPolicyConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMEEngineConfig
implements JSONSerializer {
    private Boolean enabled = true;
    private URL baseURL;
    private Boolean noncesPersistent;
    @JsonProperty(value="policy")
    private ACMEPolicyConfig policyConfig = new ACMEPolicyConfig();

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public Boolean getNoncesPersistent() {
        return this.noncesPersistent;
    }

    public void setNoncePersistent(Boolean noncesPersistent) {
        this.noncesPersistent = noncesPersistent;
    }

    public ACMEPolicyConfig getPolicyConfig() {
        return this.policyConfig;
    }

    public void setPolicyConfig(ACMEPolicyConfig wildcard) {
        this.policyConfig = wildcard;
    }

    public static ACMEEngineConfig fromProperties(Properties props) throws Exception {
        ACMEEngineConfig config = new ACMEEngineConfig();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.equals("enabled")) {
                config.setEnabled(Boolean.valueOf(value));
                continue;
            }
            if (key.equals("baseURL")) {
                config.setBaseURL(new URL(value));
                continue;
            }
            if (key.equals("nonces.persistent")) {
                config.setNoncePersistent(Boolean.valueOf(value));
                continue;
            }
            if (!key.startsWith("policy.")) continue;
            String policyKey = key.substring(7);
            ACMEPolicyConfig policyConfig = config.getPolicyConfig();
            policyConfig.setProperty(policyKey, value);
        }
        return config;
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ACMEEngineConfig engineConfig = new ACMEEngineConfig();
        System.out.println(engineConfig);
    }
}

