/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="order/{id}")
@ACMEManagedService
public class ACMEOrderService {
    public static Logger logger = LoggerFactory.getLogger(ACMEOrderService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response handlePOST(@PathParam(value="id") String orderID, JWS jws) throws Exception {
        logger.info("Retrieving order " + orderID);
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        URI kid = header.getKid();
        String kidPath = kid.getPath();
        String accountID = kidPath.substring(kidPath.lastIndexOf(47) + 1);
        logger.info("Account ID: " + accountID);
        ACMEAccount account = engine.getAccount(accountID);
        engine.validateJWS(jws, header.getAlg(), account.getJWK());
        ACMEOrder order = engine.getOrder(account, orderID);
        String[] authzIDs = order.getAuthzIDs();
        if (authzIDs != null) {
            ArrayList<URI> authzURLs = new ArrayList<URI>();
            for (String authzID : authzIDs) {
                URI authzURI = this.uriInfo.getBaseUriBuilder().path("authz").path(authzID).build(new Object[0]);
                authzURLs.add(authzURI);
            }
            order.setAuthorizations(authzURLs.toArray(new URI[authzURLs.size()]));
        }
        URI finalizeURL = this.uriInfo.getBaseUriBuilder().path("order").path(orderID).path("finalize").build(new Object[0]);
        order.setFinalize(finalizeURL);
        String certID = order.getCertID();
        if (certID != null) {
            URI certURL = this.uriInfo.getBaseUriBuilder().path("cert").path(certID).build(new Object[0]);
            order.setCertificate(certURL);
        }
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI indexURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(indexURL, "index");
        builder.entity((Object)order);
        return builder.build();
    }
}

