# This script processes a memory.dat file as generated by instperf during
# installation and writes out a graph to memusage.png.
set terminal png size 1024,768
set output "memusage.png"
set title "anaconda Memory Usage"
set xlabel "Time"
set xtics rotate
set xdata time
set timefmt "%H:%M:%S"
set ylabel "Memory Used (in KB)\n(Total-Free-Buffers-Cached)"
set format y "%.0f"
set grid

plot "memory.dat" using 1:2 title "Memory" with lines, \
     "memory.dat" using 1:3 title "Swap" with lines
