###############################################################################
#
# @par
#   BSD LICENSE
# 
#   Copyright(c) 2007-2022 Intel Corporation. All rights reserved.
#   All rights reserved.
# 
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
# 
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in
#       the documentation and/or other materials provided with the
#       distribution.
#     * Neither the name of Intel Corporation nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
# 
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
#  version: QAT.L.4.19.0-00005
###############################################################################
#-----------
# Some default settings
KERNEL_SOURCE_ROOT?=/lib/modules/`uname -r`/build
ICP_OS_LEVEL?=user_space
ICP_OS?=linux_2.6
ICP_CORE?=ia
INTEL_DEV?=YES
RM=rm

#-----------------------------------------------------------------------------
# Subcomponent Paths
#
#-----------------------------------------------------------------------------
ICP_BUILDSYSTEM_PATH?=$(ICP_ROOT)/quickassist/build_system
API_DIR?=$(ICP_ROOT)/quickassist/include
OSAL_DIR?=$(ICP_ROOT)/quickassist/utilities/osal
LAC_DIR?=$(ICP_ROOT)/quickassist/lookaside/access_layer
QAT_FW_API_DIR?=$(ICP_ROOT)/quickassist/lookaside/firmware/include/
COMMON_FW_API_DIR?=$(ICP_ROOT)/quickassist/lookaside/firmware/common/include/
ME_ACCESS_LAYER_CMN_API_DIR?=$(ICP_ROOT)/quickassist/lookaside/firmware/common/include/
ADF_CMN_DIR?=$(ICP_ROOT)/quickassist/lookaside/access_layer/include
QAT_DIRECT_ROOT=$(ICP_ROOT)/quickassist/lookaside/access_layer/src/qat_direct/
KERNEL_PATH=$(ICP_ROOT)/quickassist/lookaside/access_layer/src/qat_kernel/
CMN_MEM_PATH=$(ICP_ROOT)/quickassist/utilities/libusdm_drv
ICP_DEFENSES_ENABLED ?= y
ifeq ($(shell cat /proc/kallsyms | grep -w "__stack_chk_fail" | wc -l), 1)
KERNEL_DEFENSES_STACK_PROTECTION = y
else
KERNEL_DEFENSES_STACK_PROTECTION = n
endif

#----------------------------------------------------------------------
# ADF paths
#----------------------------------------------------------------------
#Component root paths
ifeq ($(ICP_OS_LEVEL), user_space)
ADF_DIR?=$(QAT_DIRECT_ROOT)/
else
ADF_DIR?=$(KERNEL_PATH)/
endif
ICP_ADF_DIR=$(ADF_DIR)
ICP_LAC_DIR=$(LAC_DIR)
ADF_API_DIR=$(ICP_ADF_DIR)/include
