/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.builder.resteasy;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.client.Client;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.mandas.docker.client.builder.BaseDockerClientBuilder;
import org.mandas.docker.client.builder.ProxyConfiguration;

public class ResteasyDockerClientBuilder
extends BaseDockerClientBuilder<ResteasyDockerClientBuilder> {
    @Override
    public ResteasyDockerClientBuilder readTimeoutMillis(long readTimeoutMillis) {
        if (readTimeoutMillis == 0L) {
            return (ResteasyDockerClientBuilder)super.readTimeoutMillis(-1L);
        }
        return (ResteasyDockerClientBuilder)super.readTimeoutMillis(readTimeoutMillis);
    }

    @Override
    public ResteasyDockerClientBuilder connectTimeoutMillis(long connectTimeoutMillis) {
        if (connectTimeoutMillis == 0L) {
            return (ResteasyDockerClientBuilder)super.connectTimeoutMillis(-1L);
        }
        return (ResteasyDockerClientBuilder)super.connectTimeoutMillis(connectTimeoutMillis);
    }

    @Override
    protected Client createClient() {
        ResteasyClientBuilder builder = (ResteasyClientBuilder)ResteasyClientBuilder.newBuilder();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)this.connectTimeoutMillis).setConnectTimeout((int)this.connectTimeoutMillis).setSocketTimeout((int)this.readTimeoutMillis).build();
        Registry<ConnectionSocketFactory> schemeRegistry = this.getSchemeRegistry(this.uri, this.dockerCertificatesStore);
        HttpClientConnectionManager cm = this.getConnectionManager(this.uri, schemeRegistry, this.connectionPoolSize);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig);
        ProxyConfiguration proxyConfiguration = this.proxyFromEnv();
        if (this.useProxy && proxyConfiguration != null) {
            if (proxyConfiguration.username() != null && proxyConfiguration.password() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.username(), proxyConfiguration.password());
                BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(new AuthScope(proxyConfiguration.host(), Integer.parseInt(proxyConfiguration.port())), (Credentials)credentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            }
            httpClientBuilder.setProxy(new HttpHost(proxyConfiguration.host(), Integer.parseInt(proxyConfiguration.port()))).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClientBuilder.build(), false);
        if (this.entityProcessing != null) {
            switch (this.entityProcessing) {
                case BUFFERED: {
                    engine.setChunked(false);
                    break;
                }
                case CHUNKED: {
                    engine.setChunked(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid entity processing mode " + String.valueOf((Object)this.entityProcessing));
                }
            }
        }
        builder.httpEngine((ClientHttpEngine)engine).register((Object)new JacksonJsonProvider());
        return builder.build();
    }
}

