/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class DeferredUpdateManager
extends UpdateManager {
    private Rectangle damage;
    private Map<IFigure, Rectangle> dirtyRegions = new HashMap<IFigure, Rectangle>();
    private GraphicsSource graphicsSource;
    private final List<IFigure> invalidFigures = new ArrayList<IFigure>();
    private IFigure root;
    private boolean updateQueued;
    private boolean updating;
    private boolean validating;
    private RunnableChain afterUpdate;
    private int refreshRate = -1;

    public DeferredUpdateManager() {
    }

    public DeferredUpdateManager(GraphicsSource gs) {
        this.setGraphicsSource(gs);
    }

    @Override
    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    @Override
    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.add(f);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    @Override
    protected void paint(GC gc) {
        if (!this.validating) {
            SWTGraphics graphics = new SWTGraphics(gc);
            if (!this.updating) {
                Rectangle rect = graphics.getClip(new Rectangle());
                HashMap<IFigure, Rectangle> map = new HashMap<IFigure, Rectangle>();
                map.put(this.root, rect);
                this.firePainting(rect, map);
            }
            this.performValidation();
            this.root.paint(graphics);
            graphics.dispose();
        } else {
            this.addDirtyRegion(this.root, new Rectangle(gc.getClipping()));
        }
    }

    @Override
    public synchronized void performUpdate() {
        if (this.isDisposed() || this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public synchronized void performValidation() {
        if (this.invalidFigures.isEmpty() || this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        finally {
            this.invalidFigures.clear();
            this.validating = false;
        }
    }

    @Override
    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.sendUpdateRequest();
            this.updateQueued = true;
        }
    }

    protected void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        if (this.refreshRate <= 0) {
            display.asyncExec((Runnable)new UpdateRequest());
        } else {
            display.timerExec(this.refreshRate, (Runnable)new UpdateRequest());
        }
    }

    protected void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        this.dirtyRegions.forEach((figure, contribution) -> {
            IFigure walker = figure.getParent();
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent((Translatable)contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle((Rectangle)contribution);
            } else {
                this.damage.union((Rectangle)contribution);
            }
        });
        if (!this.dirtyRegions.isEmpty()) {
            Map<IFigure, Rectangle> oldRegions = this.dirtyRegions;
            this.dirtyRegions = new HashMap<IFigure, Rectangle>();
            this.firePainting(this.damage, oldRegions);
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    @Override
    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    @Override
    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    @Override
    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    protected void validateFigures() {
        this.performValidation();
    }

    private static class RunnableChain {
        RunnableChain next;
        Runnable run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.run = run;
            this.next = next;
        }

        void run() {
            if (this.next != null) {
                this.next.run();
            }
            this.run.run();
        }
    }

    protected class UpdateRequest
    implements Runnable {
        @Override
        public void run() {
            DeferredUpdateManager.this.performUpdate();
        }
    }
}

