"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockDateClass = void 0;

var _date = require("./date");

function isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _construct(Parent, args, Class) { if (isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

var mockDateClass = function mockDateClass(D) {
  // if undefined, use real date, or else mock date
  var mockNow = function mockNow() {
    return (0, _date.now)() === undefined ? D.now() : (0, _date.now)();
  };

  function Date() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var dateArgs = args.length === 0 ? [mockNow()] : args;

    var instance = _construct(D, _toConsumableArray(dateArgs));

    Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
    return instance;
  }

  Date.prototype = Object.create(D.prototype);
  Object.setPrototypeOf(Date, D); // undefined means do not mock date

  Date.now = function () {
    return mockNow();
  }; // original Date class


  Date.__OriginalDate__ = D; // current() is for test.

  Date.current = function () {
    return D.now();
  };

  return Date;
};

exports.mockDateClass = mockDateClass;