# @rushstack/node-core-library

This library provides a conservative set of "core" NodeJS utilities whose
purpose is to standardize how we solve common problems across our tooling
projects.  In order to be considered "core", the class must meet ALL of
these criteria:

- small and self-contained (i.e. quick to install)

- solves a ubiquitous problem (i.e. having one standardized approach is better
  than allowing each developer to use their favorite library)

- broad enough applicability to justify imposing it as a dependency for
  nearly every NodeJS project

- code is design reviewed, API approved, and documented

Examples of "core" functionality that meets this criteria:

- basic file/folder manipulation
- JSON file loader/saver/validator
- package.json parser
- build performance timers
- executing shell commands

This package is NOT intended to be a dumping ground for arbitrary utilities
that seem like they might be useful.  Code should start somewhere else, and
then graduate to **node-core-library** after its value has already been
demonstrated.  If in doubt, create your own NPM package.

## Links

- [CHANGELOG.md](
  https://github.com/microsoft/rushstack/blob/master/libraries/node-core-library/CHANGELOG.md) - Find
  out what's new in the latest version
- [API Reference](https://rushstack.io/pages/api/node-core-library/)

`@rushstack/node-core-library` is part of the [Rush Stack](https://rushstack.io/) family of projects.
