/**
 * @beta
 */
export declare enum TerminalProviderSeverity {
    log = 0,
    warning = 1,
    error = 2,
    verbose = 3
}
/**
 * Implement the interface to create a terminal provider. Terminal providers
 * can be registered to a {@link Terminal} instance to receive messages.
 *
 * @beta
 */
export interface ITerminalProvider {
    /**
     * This property should return true only if the terminal provider supports
     * rendering console colors.
     */
    supportsColor: boolean;
    /**
     * This property should return the newline character the terminal provider
     * expects.
     */
    eolCharacter: string;
    /**
     * This function gets called on every terminal provider upon every
     * message function call on the terminal instance.
     *
     * @param data - The terminal message.
     * @param severity - The message severity. Terminal providers can
     * route different kinds of messages to different streams and may choose
     * to ignore verbose messages.
     */
    write(data: string, severity: TerminalProviderSeverity): void;
}
//# sourceMappingURL=ITerminalProvider.d.ts.map