"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A system for sharing tool configurations between projects without duplicating config files.
 *
 * @remarks
 * The `config/rig.json` file is a system that Node.js build tools can support, in order to eliminate
 * duplication of config files when many projects share a common configuration.  This is particularly valuable
 * in a setup where hundreds of projects may be built using a small set of reusable recipes.
 *
 * @packageDocumentation
 */
var RigConfig_1 = require("./RigConfig");
Object.defineProperty(exports, "RigConfig", { enumerable: true, get: function () { return RigConfig_1.RigConfig; } });
//# sourceMappingURL=index.js.map