"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _reactTestRenderer = require("react-test-renderer");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function createTimeoutError(utilName, _ref) {
  var timeout = _ref.timeout;
  var timeoutError = new Error("Timed out in " + utilName + " after " + timeout + "ms.");
  timeoutError.timeout = true;
  return timeoutError;
}

function asyncUtils(addResolver) {
  var nextUpdatePromise = null;

  var waitForNextUpdate =
  /*#__PURE__*/
  function () {
    var _ref2 = (0, _asyncToGenerator2["default"])(
    /*#__PURE__*/
    _regenerator["default"].mark(function _callee(options) {
      var resolveOnNextUpdate;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (options === void 0) {
                options = {};
              }

              if (nextUpdatePromise) {
                _context.next = 6;
                break;
              }

              resolveOnNextUpdate = function resolveOnNextUpdate(resolve, reject) {
                var timeoutId;

                if (options.timeout > 0) {
                  timeoutId = setTimeout(function () {
                    return reject(createTimeoutError('waitForNextUpdate', options));
                  }, options.timeout);
                }

                addResolver(function () {
                  clearTimeout(timeoutId);
                  nextUpdatePromise = null;
                  resolve();
                });
              };

              nextUpdatePromise = new Promise(resolveOnNextUpdate);
              _context.next = 6;
              return (0, _reactTestRenderer.act)(function () {
                return nextUpdatePromise;
              });

            case 6:
              _context.next = 8;
              return nextUpdatePromise;

            case 8:
              return _context.abrupt("return", _context.sent);

            case 9:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function waitForNextUpdate(_x) {
      return _ref2.apply(this, arguments);
    };
  }();

  var wait =
  /*#__PURE__*/
  function () {
    var _ref3 = (0, _asyncToGenerator2["default"])(
    /*#__PURE__*/
    _regenerator["default"].mark(function _callee3(callback, _temp) {
      var _ref4, timeout, _ref4$suppressErrors, suppressErrors, checkResult, waitForResult;

      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _ref4 = _temp === void 0 ? {} : _temp, timeout = _ref4.timeout, _ref4$suppressErrors = _ref4.suppressErrors, suppressErrors = _ref4$suppressErrors === void 0 ? true : _ref4$suppressErrors;

              checkResult = function checkResult() {
                try {
                  var callbackResult = callback();
                  return callbackResult || callbackResult === undefined;
                } catch (e) {
                  if (!suppressErrors) {
                    throw e;
                  }
                }
              };

              waitForResult =
              /*#__PURE__*/
              function () {
                var _ref5 = (0, _asyncToGenerator2["default"])(
                /*#__PURE__*/
                _regenerator["default"].mark(function _callee2() {
                  var initialTimeout, startTime;
                  return _regenerator["default"].wrap(function _callee2$(_context2) {
                    while (1) {
                      switch (_context2.prev = _context2.next) {
                        case 0:
                          initialTimeout = timeout;

                        case 1:
                          if (!true) {
                            _context2.next = 18;
                            break;
                          }

                          startTime = Date.now();
                          _context2.prev = 3;
                          _context2.next = 6;
                          return waitForNextUpdate({
                            timeout: timeout
                          });

                        case 6:
                          if (!checkResult()) {
                            _context2.next = 8;
                            break;
                          }

                          return _context2.abrupt("return");

                        case 8:
                          _context2.next = 15;
                          break;

                        case 10:
                          _context2.prev = 10;
                          _context2.t0 = _context2["catch"](3);

                          if (!_context2.t0.timeout) {
                            _context2.next = 14;
                            break;
                          }

                          throw createTimeoutError('wait', {
                            timeout: initialTimeout
                          });

                        case 14:
                          throw _context2.t0;

                        case 15:
                          timeout -= Date.now() - startTime;
                          _context2.next = 1;
                          break;

                        case 18:
                        case "end":
                          return _context2.stop();
                      }
                    }
                  }, _callee2, null, [[3, 10]]);
                }));

                return function waitForResult() {
                  return _ref5.apply(this, arguments);
                };
              }();

              if (checkResult()) {
                _context3.next = 6;
                break;
              }

              _context3.next = 6;
              return waitForResult();

            case 6:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3);
    }));

    return function wait(_x2, _x3) {
      return _ref3.apply(this, arguments);
    };
  }();

  var waitForValueToChange =
  /*#__PURE__*/
  function () {
    var _ref6 = (0, _asyncToGenerator2["default"])(
    /*#__PURE__*/
    _regenerator["default"].mark(function _callee4(selector, options) {
      var initialValue;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              if (options === void 0) {
                options = {};
              }

              initialValue = selector();
              _context4.prev = 2;
              _context4.next = 5;
              return wait(function () {
                return selector() !== initialValue;
              }, _objectSpread({
                suppressErrors: false
              }, options));

            case 5:
              _context4.next = 12;
              break;

            case 7:
              _context4.prev = 7;
              _context4.t0 = _context4["catch"](2);

              if (!_context4.t0.timeout) {
                _context4.next = 11;
                break;
              }

              throw createTimeoutError('waitForValueToChange', options);

            case 11:
              throw _context4.t0;

            case 12:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4, null, [[2, 7]]);
    }));

    return function waitForValueToChange(_x4, _x5) {
      return _ref6.apply(this, arguments);
    };
  }();

  return {
    wait: wait,
    waitForNextUpdate: waitForNextUpdate,
    waitForValueToChange: waitForValueToChange
  };
}

var _default = asyncUtils;
exports["default"] = _default;