var _excluded = ["className", "children", "data", "innerRef", "path", "angle", "radius", "source", "target"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import cx from 'classnames';
import { linkRadial } from 'd3-shape';
import { getX, getY, getSource, getTarget } from '../../../util/accessors';
export function pathRadialDiagonal(_ref) {
  var source = _ref.source,
      target = _ref.target,
      angle = _ref.angle,
      radius = _ref.radius;
  return function (data) {
    var link = linkRadial();
    link.angle(angle);
    link.radius(radius);
    link.source(source);
    link.target(target);
    return link(data);
  };
}
export default function LinkRadialDiagonal(_ref2) {
  var className = _ref2.className,
      children = _ref2.children,
      data = _ref2.data,
      innerRef = _ref2.innerRef,
      path = _ref2.path,
      _ref2$angle = _ref2.angle,
      angle = _ref2$angle === void 0 ? getX : _ref2$angle,
      _ref2$radius = _ref2.radius,
      radius = _ref2$radius === void 0 ? getY : _ref2$radius,
      _ref2$source = _ref2.source,
      source = _ref2$source === void 0 ? getSource : _ref2$source,
      _ref2$target = _ref2.target,
      target = _ref2$target === void 0 ? getTarget : _ref2$target,
      restProps = _objectWithoutPropertiesLoose(_ref2, _excluded);

  var pathGen = path || pathRadialDiagonal({
    source: source,
    target: target,
    angle: angle,
    radius: radius
  });
  if (children) return /*#__PURE__*/React.createElement(React.Fragment, null, children({
    path: pathGen
  }));
  return /*#__PURE__*/React.createElement("path", _extends({
    ref: innerRef,
    className: cx('visx-link visx-link-radial-diagonal', className),
    d: pathGen(data) || ''
  }, restProps));
}