"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Init = void 0;
const render_1 = require("@betterer/render");
const tasks_1 = require("@betterer/tasks");
const worker_require_1 = require("@phenomnomnominal/worker-require");
const Init = function Init({ automerge, cwd, configPath, resultsPath, ts }) {
    const runCreateTestFile = (0, render_1.useCallback)(async (logger) => {
        const createTestFile = (0, worker_require_1.workerRequire)('./create-test-file');
        try {
            await createTestFile.run(logger, cwd, configPath, ts);
        }
        finally {
            await createTestFile.destroy();
        }
    }, [cwd, configPath, ts]);
    const runUpdagePackageJSON = (0, render_1.useCallback)(async (logger) => {
        const updatePackageJSON = (0, worker_require_1.workerRequire)('./update-package-json');
        try {
            await updatePackageJSON.run(logger, cwd, ts);
        }
        finally {
            await updatePackageJSON.destroy();
        }
    }, [cwd, ts]);
    const runEnableAutomerge = (0, render_1.useCallback)(async (logger) => {
        const enableAutomerge = (0, worker_require_1.workerRequire)('./enable-automerge');
        try {
            await enableAutomerge.run(logger, cwd, resultsPath);
        }
        finally {
            await enableAutomerge.destroy();
        }
    }, []);
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column" },
        render_1.React.createElement(tasks_1.BettererLogo, null),
        render_1.React.createElement(tasks_1.BettererTasksLogger, { name: "Initialising Betterer" },
            render_1.React.createElement(tasks_1.BettererTaskLogger, { name: "Create test file", task: runCreateTestFile }),
            render_1.React.createElement(tasks_1.BettererTaskLogger, { name: "Update package.json", task: runUpdagePackageJSON }),
            automerge && render_1.React.createElement(tasks_1.BettererTaskLogger, { name: "Enable automerge", task: runEnableAutomerge }))));
};
exports.Init = Init;
//# sourceMappingURL=init.js.map