"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = void 0;
const tslib_1 = require("tslib");
const errors_1 = require("@betterer/errors");
const find_up_1 = (0, tslib_1.__importDefault)(require("find-up"));
const fs_1 = require("fs");
// HACK:
// It's easier to use require than to try to get `await import`
// to work right for the package.json...
/* eslint-disable @typescript-eslint/no-var-requires */
const { version } = require('../../package.json');
async function run(logger, cwd, ts) {
    await logger.progress('adding "betterer" to package.json file...');
    let packageJSON;
    let packageJSONPath;
    try {
        packageJSONPath = await (0, find_up_1.default)('package.json', { cwd });
        if (!packageJSONPath) {
            throw new errors_1.BettererError('could not find "package.json".');
        }
        packageJSON = JSON.parse(await fs_1.promises.readFile(packageJSONPath, 'utf-8'));
    }
    catch (_a) {
        throw new errors_1.BettererError('could not read "package.json".');
    }
    packageJSON.scripts = packageJSON.scripts || {};
    if (packageJSON.scripts.betterer) {
        await logger.warn('"betterer" script already exists, moving on...');
    }
    else {
        packageJSON.scripts.betterer = 'betterer';
        await logger.success('added "betterer" script to package.json file.');
    }
    packageJSON.devDependencies = packageJSON.devDependencies || {};
    if (packageJSON.devDependencies['@betterer/cli']) {
        await logger.warn('"@betterer/cli" dependency already exists, moving on...');
    }
    else {
        packageJSON.devDependencies['@betterer/cli'] = `^${version}`;
        await logger.success('added "@betterer/cli" dependency to package.json file');
    }
    if (ts) {
        if (packageJSON.devDependencies['typescript']) {
            await logger.warn('"typescript" dependency already exists, moving on...');
        }
        else {
            packageJSON.devDependencies['typescript'] = `^4`;
            await logger.success('added "typescript" dependency to package.json file');
        }
    }
    try {
        await fs_1.promises.writeFile(packageJSONPath, `${JSON.stringify(packageJSON, null, 2)}\n`, 'utf-8');
    }
    catch (_b) {
        throw new errors_1.BettererError('could not write "package.json".');
    }
}
exports.run = run;
//# sourceMappingURL=update-package-json.js.map