"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setEnv = exports.upgradeCommand = exports.resultsCommand = exports.mergeCommand = exports.initCommand = exports.cliCommand = void 0;
const commander_1 = require("commander");
const types_1 = require("./types");
let command;
function cliCommand(name) {
    command = new commander_1.Command(name);
    cacheOption();
    configPathsOption();
    excludesOption();
    filtersOption();
    ignoresOption();
    reportersOption();
    resultsPathOption();
    silentOption();
    strictOption();
    tsconfigPathOption();
    updateOption();
    workersOption();
    debug();
    return command;
}
exports.cliCommand = cliCommand;
function initCommand() {
    command = new commander_1.Command(types_1.BettererCommand.init);
    automergeOption();
    configPathOption();
    resultsPathOption();
    debug();
    return command;
}
exports.initCommand = initCommand;
function mergeCommand() {
    command = new commander_1.Command(types_1.BettererCommand.merge);
    resultsPathOption();
    debug();
    return command;
}
exports.mergeCommand = mergeCommand;
function resultsCommand() {
    command = new commander_1.Command(types_1.BettererCommand.results);
    configPathsOption();
    excludesOption();
    filtersOption();
    resultsPathOption();
    debug();
    return command;
}
exports.resultsCommand = resultsCommand;
function upgradeCommand() {
    command = new commander_1.Command(types_1.BettererCommand.upgrade);
    configPathsOption();
    saveOption();
    debug();
    return command;
}
exports.upgradeCommand = upgradeCommand;
function debug() {
    command.option('-d, --debug', 'Enable verbose debug logging', false);
    command.option('-l, --debug-log [value]', 'File path to save verbose debug logging to disk', './betterer.log');
}
function setEnv(config) {
    if (config.debug) {
        process.env.BETTERER_DEBUG = '1';
        process.env.BETTERER_DEBUG_TIME = '1';
        process.env.BETTERER_DEBUG_VALUES = '1';
        if (config.debugLog) {
            process.env.BETTERER_DEBUG_LOG = config.debugLog;
        }
    }
}
exports.setEnv = setEnv;
function cacheOption() {
    command.option('--cache', 'When present, Betterer will only run on changed files.');
    command.option('--cachePath [value]', 'Path to Betterer cache file relative to CWD');
}
function configPathOption() {
    command.option('-c, --config [value]', 'Path to test definition file relative to CWD');
}
function configPathsOption() {
    command.option('-c, --config [value]', 'Path to test definition file relative to CWD. Takes multiple values', argsToArray);
}
function automergeOption() {
    command.option('--automerge', 'Enable automatic merging for the Betterer results file');
}
function resultsPathOption() {
    command.option('-r, --results [value]', 'Path to test results file relative to CWD');
}
function tsconfigPathOption() {
    command.option('-t, --tsconfig [value]', 'Path to TypeScript config file relative to CWD');
}
function filtersOption() {
    command.option('-f, --filter [value]', 'RegExp filter for tests to run. Add "!" at the start to negate. Takes multiple values', argsToArray);
}
function excludesOption() {
    command.option('--exclude [value]', 'RegExp filter for files to exclude. Takes multiple values', argsToArray);
}
function ignoresOption() {
    command.option('-i, --ignore [value]', 'Glob pattern for files to ignore. Takes multiple values', argsToArray);
}
function reportersOption() {
    command.option('-R, --reporter [value]', 'npm package name for a Betterer reporter. Takes multiple values', argsToArray);
}
function saveOption() {
    command.option('--save', 'When present, Betterer will save the result of an upgrade to disk.');
}
function silentOption() {
    command.option('-s, --silent', 'When present, all default reporters will be disabled. Custom reporters will still work normally.');
}
function strictOption() {
    command.option('--strict', 'When present, the "how to update" message will not be shown and the `--update` option will be set to false.');
}
function updateOption() {
    command.option('-u, --update', 'When present, the results file will be updated, even if things get worse.');
}
function workersOption() {
    command.option('--workers [value]', 'number of workers to use. Set to `false` to run tests serially. Defaults to number of CPUs - 2.', argsToPrimitive);
}
function argsToArray(value, previous = []) {
    return previous.concat([value]);
}
function argsToPrimitive(value) {
    if (value === 'true') {
        return true;
    }
    if (value === 'false') {
        return false;
    }
    const num = parseInt(value);
    if (num.toString() === value) {
        return num;
    }
    return value;
}
//# sourceMappingURL=options.js.map