"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.results = void 0;
const render_1 = require("@betterer/render");
const options_1 = require("./options");
const results_1 = require("./results/results");
/**
 * Run the **Betterer** `results` command to see the status of the {@link @betterer/betterer#BettererTest | `BettererTest`s}
 * in a project.
 */
function results(cwd) {
    const command = (0, options_1.resultsCommand)();
    command.description();
    command.action(async (config, command) => {
        (0, options_1.setEnv)(config);
        const RENDER_OPTIONS = {
            debug: process.env.NODE_ENV === 'test'
        };
        // Mark options as unknown...
        const options = {
            configPaths: config.config,
            cwd,
            excludes: config.exclude,
            filters: config.filter,
            includes: command.args,
            resultsPath: config.results
        };
        try {
            // And then cast to BettererOptionsResults. This is possibly invalid,
            // but it's nicer to do the options validation in @betterer/betterer
            const app = (0, render_1.render)(render_1.React.createElement(results_1.Results, { options: options }), RENDER_OPTIONS);
            await app.waitUntilExit();
        }
        catch (_a) {
            process.exitCode = 1;
        }
    });
    return command;
}
exports.results = results;
//# sourceMappingURL=results.js.map