"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.diff = void 0;
const logger_1 = require("@betterer/logger");
const chalk_1 = require("chalk");
const DIFF_OPTIONS = {
    aAnnotation: 'Before',
    aIndicator: '-',
    aColor: chalk_1.gray,
    bAnnotation: 'After',
    bColor: chalk_1.greenBright,
    bIndicator: '+',
    expand: true
};
function diff(before, after) {
    return (0, logger_1.diffStrings__)(before, after, DIFF_OPTIONS);
}
exports.diff = diff;
//# sourceMappingURL=diff.js.map