"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.upgradeCJS = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const typescript_1 = require("typescript");
const utils_1 = require("./utils");
// foo
const TEST_NAME_QUERY = 'Identifier[name!=/module/][name!=/exports/]';
// module.exports = {}
const EXPORT_TESTS_QUERY = `BinaryExpression:has(BinaryExpression > PropertyAccessExpression:not(:has(${TEST_NAME_QUERY}))):has(ObjectLiteralExpression)`;
// module.exports.foo
const EXPORT_TEST_QUERY = `BinaryExpression:has(BinaryExpression > PropertyAccessExpression:has(PropertyAccessExpression > ${TEST_NAME_QUERY}))`;
function upgradeCJS(originalSourceFile, configPath) {
    let upgraded = (0, utils_1.reparse)(tsquery_1.tsquery.map(originalSourceFile, EXPORT_TESTS_QUERY, (configExports) => {
        const { left, operatorToken, right } = configExports;
        if ((0, typescript_1.isObjectLiteralExpression)(right)) {
            return typescript_1.factory.createBinaryExpression(left, operatorToken, (0, utils_1.wrapTests)(right));
        }
        return configExports;
    }), configPath);
    upgraded = (0, utils_1.reparse)(tsquery_1.tsquery.map(upgraded, EXPORT_TEST_QUERY, (configExportConst) => {
        const { left, operatorToken, right } = configExportConst;
        const wrapped = !!right && (0, utils_1.wrapTest)(right);
        if (!wrapped) {
            return configExportConst;
        }
        return typescript_1.factory.createBinaryExpression(left, operatorToken, wrapped);
    }), configPath);
    return upgraded;
}
exports.upgradeCJS = upgradeCJS;
//# sourceMappingURL=upgrade-cjs.js.map