"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.watch = void 0;
const betterer_1 = require("@betterer/betterer");
const options_1 = require("./options");
const types_1 = require("./types");
/**
 * Run **Betterer** in `watch` mode.
 */
function watch(cwd) {
    const command = (0, options_1.cliCommand)(types_1.BettererCommand.watch);
    command.description('run Betterer in watch mode');
    command.action(async (config) => {
        (0, options_1.setEnv)(config);
        // Mark options as unknown...
        const options = {
            cache: config.cache,
            cachePath: config.cachePath,
            configPaths: config.config,
            cwd,
            filters: config.filter,
            ignores: config.ignore,
            reporters: config.reporter,
            resultsPath: config.results,
            silent: config.silent,
            strict: config.strict,
            tsconfigPath: config.tsconfig,
            update: config.update,
            workers: config.workers
        };
        // And then cast to BettererOptionsWatch. This is possibly invalid,
        // but it's nicer to do the options validation in @betterer/betterer
        await betterer_1.betterer.watch(options);
    });
    return command;
}
exports.watch = watch;
//# sourceMappingURL=watch.js.map