/// <reference types="node" />
import { Worker } from 'worker_threads';
import { TO_CLONEABLE } from './constants';
import { Remote } from './vendor/comlink';
export declare type WorkerRequireOptions = {
    cache: boolean;
};
export declare type WorkerRequireHandle<RemoteType> = {
    remote: Remote<RemoteType>;
    worker: Worker;
};
export declare type WorkerRequireHandles = Map<string, Array<WorkerRequireHandle<unknown>>>;
export declare type WorkerRequireFunc = (...args: Array<any>) => any;
export declare type WorkerRequireUnknown<U> = keyof U extends never ? U : never;
export declare type WorkerRequireCloneable = WorkerRequireCloneableInstance | WorkerRequireCloneableObject | WorkerRequireCloneableValue;
export declare type WorkerRequireCloneableInstance = {
    [TO_CLONEABLE]: () => WorkerRequireCloneable;
};
declare type WorkerRequireCloneableObject = {
    [index: string]: WorkerRequireCloneable;
};
declare type WorkerRequireCloneableValue = undefined | null | number | Number | boolean | Boolean | string | String | Date | RegExp | ArrayBuffer | ArrayBufferView;
export declare type WorkerRequireError<Type, Message, Details = null> = Details extends null ? {
    errorMessage: Message;
    errorType: Type;
} : {
    errorMessage: Message;
    errorType: Type;
};
export declare type WorkerRequireModule<Module> = {
    [Key in keyof Module]: Module[Key] extends WorkerRequireFunc ? WorkerFunction<Module[Key]> : Module[Key] extends WorkerRequireCloneable ? WorkerRequireError<Module[Key], 'Module should not export primitive values', Module> : WorkerRequireModule<Module[Key]>;
};
export declare type WorkerFunction<F extends WorkerRequireFunc> = F extends (...args: infer Args) => infer Return ? Args extends WorkerArguments<Args> ? Return extends WorkerValue<Return> ? F : WorkerRequireError<F, 'Function return value should not contain synchronous functions', WorkerValue<Return>> : WorkerRequireError<F, 'Function arguments should not contain synchronous functions', WorkerArguments<Args>> : never;
export declare type WorkerObject<O, IsArgument = false> = {
    [Key in keyof O]: O[Key] extends WorkerValue<O[Key], IsArgument> ? O[Key] : WorkerRequireError<O, 'Object properties should not contain synchronous functions', WorkerValue<O[Key], IsArgument>>;
};
export declare type WorkerArray<A extends Array<unknown>, IsArgument = false> = {
    [Index in keyof A]: A[Index] extends WorkerValue<A[Index], IsArgument> ? A[Index] : WorkerRequireError<A, 'Array should not contain synchronous functions', WorkerValue<A[Index], IsArgument>>;
};
export declare type WorkerArguments<A extends Array<unknown>> = {
    [Index in keyof A]: A[Index] extends WorkerArgument<A[Index]> ? A[Index] : WorkerRequireError<A, 'Arguments should not be synchronous functions', WorkerArgument<A[Index]>>;
};
export declare type WorkerFunctionArgument<F extends WorkerRequireFunc> = F extends (...args: infer Args) => infer Return ? Args extends WorkerArguments<Args> ? Return extends Promise<infer Value> ? Value extends WorkerValue<Value> ? F : WorkerRequireError<F, 'Function return value should not contain synchronous functions', WorkerValue<Value>> : WorkerRequireError<F, 'Function should return a Promise'> : WorkerArguments<Args> : never;
export declare type WorkerSet<S extends Set<unknown>, IsArgument = false> = S extends Set<infer Item> ? Item extends WorkerValue<Item, IsArgument> ? S : WorkerRequireError<S, 'Set should not contain synchronous functions', WorkerValue<Item, IsArgument>> : never;
export declare type WorkerMap<M extends Map<unknown, unknown>, IsArgument = false> = M extends Map<infer Key, infer Value> ? Key extends WorkerValue<Key, IsArgument> ? Value extends WorkerValue<Value, IsArgument> ? M : WorkerRequireError<M, 'Map value should not contain synchronous functions', WorkerValue<Value, IsArgument>> : WorkerRequireError<M, 'Map key should not contain synchronous functions', WorkerValue<Key, IsArgument>> : never;
export declare type WorkerError<E extends Error> = keyof E extends keyof Error ? E : WorkerRequireError<E, `Custom Error type has property that will not be transferred: "${Exclude<keyof E & string, keyof Error & string>}"`>;
export declare type WorkerPromiseValue<P extends Promise<unknown>, IsArgument = false> = P extends Promise<infer Value> ? Value extends WorkerValue<Value, IsArgument> ? Value : WorkerRequireError<P, 'Promise value should not contain synchronous functions', WorkerValue<Value, IsArgument>> : never;
export declare type WorkerArgument<Value> = Value extends WorkerRequireCloneable ? Value : Value extends Array<unknown> ? Value extends WorkerArray<Value, true> ? Value : WorkerArray<Value, true> : Value extends WorkerRequireFunc ? Value extends WorkerFunctionArgument<Value> ? Value : WorkerFunctionArgument<Value> : Value extends Set<unknown> ? Value extends WorkerSet<Value, true> ? Value : WorkerSet<Value, true> : Value extends Map<unknown, unknown> ? Value extends WorkerMap<Value, true> ? Value : WorkerMap<Value, true> : Value extends Promise<unknown> ? Value extends Promise<WorkerPromiseValue<Value, true>> ? Promise<WorkerPromiseValue<Value>> : WorkerPromiseValue<Value, true> : Value extends WorkerObject<Value, true> ? Value : WorkerObject<Value, true>;
export declare type WorkerValue<Value, IsArgument = false> = IsArgument extends true ? WorkerArgument<Value> : Value extends WorkerRequireCloneable ? Value : Value extends Array<unknown> ? Value extends WorkerArray<Value> ? Value : WorkerArray<Value> : Value extends WorkerRequireFunc ? Value extends WorkerFunction<Value> ? Value : WorkerFunction<Value> : Value extends Set<unknown> ? Value extends WorkerSet<Value> ? Value : WorkerSet<Value> : Value extends Map<unknown, unknown> ? Value extends WorkerMap<Value> ? Value : WorkerMap<Value> : Value extends Error ? Value extends WorkerError<Value> ? Value : WorkerError<Value> : Value extends Promise<unknown> ? Value extends Promise<WorkerPromiseValue<Value>> ? Promise<WorkerPromiseValue<Value>> : WorkerPromiseValue<Value> : Value extends WorkerRequireUnknown<Value> ? Value : Value extends WorkerObject<Value> ? Value : WorkerObject<Value>;
export declare type WorkerRequireModuleAsync<Module> = {
    [Key in keyof Module]: Module[Key] extends WorkerRequireFunc ? Module[Key] extends WorkerFunction<Module[Key]> ? AsyncWorkerModuleFunction<Module[Key]> : WorkerFunction<Module[Key]> : Module[Key] extends WorkerRequireCloneable ? WorkerRequireError<Module, 'Module must be a WorkerRequireModule', WorkerRequireModule<Module>> : WorkerRequireModuleAsync<Module[Key]>;
} & {
    destroy: () => Promise<void>;
};
export declare type AsyncWorkerModuleFunction<F extends WorkerRequireFunc> = (...args: AsyncWorkerArray<Parameters<F>> extends Array<unknown> ? AsyncWorkerArray<Parameters<F>> : never) => ReturnType<F> extends Promise<infer Return> ? Promise<AsyncWorkerValue<Return>> : Promise<AsyncWorkerValue<ReturnType<F>>>;
export declare type AsyncWorkerModuleValue<V> = V extends Promise<unknown> ? V : Promise<V>;
export declare type AsyncWorkerObject<O> = {
    [Key in keyof O]: AsyncWorkerValue<O[Key]>;
};
export declare type AsyncWorkerArray<A extends Array<unknown>> = {
    [Index in keyof A]: A[Index] extends AsyncWorkerValue<A[Index]> ? AsyncWorkerValue<A[Index]> : never;
};
export declare type AsyncWorkerFunction<F extends WorkerRequireFunc> = (...args: AsyncWorkerArray<Parameters<F>> extends Array<unknown> ? AsyncWorkerArray<Parameters<F>> : never) => ReturnType<F> extends Promise<infer Return> ? AsyncWorkerValue<Return> | Promise<AsyncWorkerValue<Return>> : Promise<AsyncWorkerValue<ReturnType<F>>>;
export declare type AsyncWorkerSet<S extends Set<unknown>> = S extends Set<infer Item> ? Set<AsyncWorkerValue<Item>> : never;
export declare type AsyncWorkerMap<M extends Map<unknown, unknown>> = M extends Map<infer Key, infer Value> ? Map<AsyncWorkerValue<Key>, AsyncWorkerValue<Value>> : never;
export declare type AsyncWorkerPromise<P extends Promise<unknown>> = P extends Promise<infer Value> ? AsyncWorkerValue<Value> | Promise<AsyncWorkerValue<Value>> : never;
export declare type AsyncWorkerUnknown<U> = keyof U extends never ? unknown | Promise<unknown> : never;
export declare type AsyncWorkerValue<Value> = Value extends WorkerRequireCloneable ? Value : Value extends Array<unknown> ? AsyncWorkerArray<Value> : Value extends WorkerRequireFunc ? AsyncWorkerFunction<Value> : Value extends Set<unknown> ? AsyncWorkerSet<Value> : Value extends Map<unknown, unknown> ? AsyncWorkerMap<Value> : Value extends Promise<unknown> ? AsyncWorkerPromise<Value> : Value extends WorkerRequireUnknown<Value> ? AsyncWorkerUnknown<Value> : AsyncWorkerObject<Value>;
export {};
