"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeritageType = void 0;
/**
 * Represents a type referenced via an "extends" or "implements" heritage clause for a TypeScript class.
 * @remarks
 *
 * For example, consider this declaration:
 *
 * ```ts
 * export class Widget extends Controls.WidgetBase implements Controls.IWidget, IDisposable {
 *   // . . .
 * }
 * ```
 *
 * The heritage types are `Controls.WidgetBase`, `Controls.IWidget`, and `IDisposable`.
 * @public
 */
class HeritageType {
    constructor(excerpt) {
        this.excerpt = excerpt;
    }
}
exports.HeritageType = HeritageType;
//# sourceMappingURL=HeritageType.js.map