export interface MapInteface<T, U> {
    get(key: T): U | undefined;
    set(key: T, value: U): any;
}
export declare type MapConstructor<T, U> = new () => MapInteface<T, U>;
export interface ListFormat<T = any> {
    [index: number]: T;
    length: number;
}
export interface DiffResult<T> {
    prevList: T[];
    list: T[];
    added: number[];
    removed: number[];
    changed: number[][];
    ordered: number[][];
    pureChanged: number[][];
    maintained: number[][];
}
