"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadingAppender = void 0;
const DocHeading_1 = require("../../nodes/DocHeading");
const Utilities_1 = require("../../utils/Utilities");
class HeadingAppender {
    constructor(configuration) {
        this._configuration = configuration;
    }
    append(output, apiItem) {
        const title = this._titleFromItem(apiItem);
        if (!title) {
            return;
        }
        output.appendNode(new DocHeading_1.DocHeading({
            configuration: this._configuration,
            title,
            level: 2
        }));
    }
    _titleFromItem(apiItem) {
        const scopedName = apiItem.getScopedNameWithinPackage();
        switch (apiItem.kind) {
            case "Enum" /* Enum */:
                return `${scopedName} enum`;
            case "Constructor" /* Constructor */:
            case "ConstructSignature" /* ConstructSignature */:
                return Utilities_1.Utilities.getGrafanaConciseSignature(apiItem);
            case "Method" /* Method */:
            case "MethodSignature" /* MethodSignature */:
                return `${apiItem.displayName} method`;
            case "Function" /* Function */:
                return `${scopedName} function`;
            case "Namespace" /* Namespace */:
                return `${scopedName} namespace`;
            case "Property" /* Property */:
            case "PropertySignature" /* PropertySignature */:
                return `${apiItem.displayName} property`;
            case "TypeAlias" /* TypeAlias */:
                return `${scopedName} type`;
            case "Variable" /* Variable */:
                return `${scopedName} variable`;
        }
    }
}
exports.HeadingAppender = HeadingAppender;
;
//# sourceMappingURL=HeadingAppender.js.map