import { SnapElementRect } from "src/react-moveable";
import { ElementGuidelineValue, MoveableClientRect, MoveableManagerInterface, SnapDirectionPoses, SnapDirections, SnapGuideline, SnappableProps, SnappableState } from "../../types";
export declare const VERTICAL_NAMES: readonly ["left", "right", "center"];
export declare const HORIZONTAL_NAMES: readonly ["top", "bottom", "middle"];
export declare const VERTICAL_NAMES_MAP: {
    readonly start: "left";
    readonly end: "right";
    readonly center: "center";
};
export declare const HORIZONTAL_NAMES_MAP: {
    readonly start: "top";
    readonly end: "bottom";
    readonly center: "middle";
};
export declare function hasGuidelines(moveable: MoveableManagerInterface<any, any>, ableName: string): moveable is MoveableManagerInterface<SnappableProps, SnappableState>;
export declare function getSnapDirections(snapDirections: SnapDirections | boolean | undefined): SnapDirections;
export declare function mapSnapDirectionPoses(snapDirections: SnapDirections | boolean | undefined, snapPoses: SnapDirectionPoses): SnapDirectionPoses;
export declare function splitSnapDirectionPoses(snapDirections: SnapDirections | boolean | undefined, snapPoses: SnapDirectionPoses): {
    horizontal: number[];
    vertical: number[];
};
export declare function getGapGuidelines(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, targetRect: SnapDirectionPoses, snapThreshold: number): SnapGuideline[];
export declare function getDefaultGuidelines(horizontalGuidelines: number[] | false, verticalGuidelines: number[] | false, width: number, height: number, clientLeft?: number, clientTop?: number, snapOffset?: {
    left: number;
    top: number;
    right: number;
    bottom: number;
}): SnapGuideline[];
export declare function calculateContainerPos(rootMatrix: number[], containerRect: MoveableClientRect, n: number): number[];
export declare function getSnapElementRects(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, values: ElementGuidelineValue[]): SnapElementRect[];
export declare function getElementGuidelines(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): SnapGuideline[];
export declare function getTotalGuidelines(moveable: MoveableManagerInterface<SnappableProps, SnappableState>): SnapGuideline[];
export declare function getGridGuidelines(snapGridWidth: number, snapGridHeight: number, containerWidth: number, containerHeight: number, clientLeft?: number, clientTop?: number): SnapGuideline[];
