import { InvertObject } from "framework-utils";
import { IObject } from "@daybrush/utils";
import { MoveableManagerState, Able, MoveableClientRect, MoveableProps, ControlPose, ArrayFormat, MoveableRefType, MatrixInfo, ExcludeEndParams, ExcludeParams } from "./types";
export declare function round(num: number): number;
export declare function multiply2(pos1: number[], pos2: number[]): number[];
export declare function prefix(...classNames: string[]): string;
export declare function createIdentityMatrix3(): number[];
export declare function getTransformMatrix(transform: string | number[]): number[];
export declare function getAbsoluteMatrix(matrix: number[], n: number, origin: number[]): number[];
export declare function measureSVGSize(el: SVGElement, unit: string, isHorizontal: boolean): number;
export declare function getBeforeTransformOrigin(el: SVGElement): number[];
export declare function getTransformOrigin(style: CSSStyleDeclaration): string[];
export declare function getElementTransform(target: HTMLElement | SVGElement, computedStyle?: CSSStyleDeclaration): string;
export declare function getOffsetInfo(el: SVGElement | HTMLElement | null | undefined, lastParent: SVGElement | HTMLElement | null | undefined, isParent?: boolean): {
    isStatic: boolean;
    isEnd: boolean;
    offsetParent: HTMLElement;
};
export declare function getOffsetPosInfo(el: HTMLElement | SVGElement, style: CSSStyleDeclaration): {
    tagName: string;
    isSVG: boolean;
    hasOffset: boolean;
    offset: number[];
    origin: number[];
    targetOrigin: number[];
};
export declare function getBodyOffset(el: HTMLElement | SVGElement, isSVG: boolean, style?: CSSStyleDeclaration): number[];
export declare function convert3DMatrixes(matrixes: MatrixInfo[]): void;
export declare function getBodyScrollPos(): number[];
export declare function getPositionFixedInfo(el: HTMLElement | SVGElement): {
    fixedContainer: HTMLElement;
    hasTransform: boolean;
};
export declare function getMatrixStackInfo(target: SVGElement | HTMLElement, container?: SVGElement | HTMLElement | null, checkContainer?: boolean): {
    offsetContainer: HTMLElement;
    matrixes: MatrixInfo[];
    targetMatrix: number[];
    transformOrigin: number[];
    targetOrigin: number[];
    is3d: boolean;
    hasFixed: boolean;
};
export declare function calculateElementInfo(target?: SVGElement | HTMLElement | null, container?: SVGElement | HTMLElement | null, rootContainer?: HTMLElement | SVGElement | null | undefined, isAbsolute3d?: boolean): {
    width: number;
    height: number;
    rotation: number;
    rootMatrix: number[];
    beforeMatrix: number[];
    offsetMatrix: number[];
    allMatrix: number[];
    targetMatrix: number[];
    targetTransform: string;
    transformOrigin: number[];
    targetOrigin: number[];
    is3d: boolean;
    left: number;
    top: number;
    right: number;
    bottom: number;
    origin: number[];
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
    direction: number;
    hasFixed: boolean;
};
export declare function getElementInfo(target: SVGElement | HTMLElement, container?: SVGElement | HTMLElement | null, rootContainer?: SVGElement | HTMLElement | null | undefined): {
    width: number;
    height: number;
    rotation: number;
    rootMatrix: number[];
    beforeMatrix: number[];
    offsetMatrix: number[];
    allMatrix: number[];
    targetMatrix: number[];
    targetTransform: string;
    transformOrigin: number[];
    targetOrigin: number[];
    is3d: boolean;
    left: number;
    top: number;
    right: number;
    bottom: number;
    origin: number[];
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
    direction: number;
    hasFixed: boolean;
};
export declare function calculateMatrixStack(target: SVGElement | HTMLElement, container?: SVGElement | HTMLElement | null, rootContainer?: SVGElement | HTMLElement | null | undefined, isAbsolute3d?: boolean): {
    hasFixed: boolean;
    rootMatrix: number[];
    beforeMatrix: number[];
    offsetMatrix: number[];
    allMatrix: number[];
    targetMatrix: number[];
    targetTransform: string;
    transformOrigin: number[];
    targetOrigin: number[];
    is3d: boolean;
};
export declare function makeMatrixCSS(matrix: number[], is3d?: boolean): string;
export declare function getSVGViewBox(el: SVGSVGElement): {
    x: number;
    y: number;
    width: number;
    height: number;
    clientWidth: number;
    clientHeight: number;
};
export declare function getSVGMatrix(el: SVGSVGElement, n: number): number[];
export declare function getSVGGraphicsOffset(el: SVGGraphicsElement, origin: number[]): number[];
export declare function calculatePosition(matrix: number[], pos: number[], n: number): number[];
export declare function calculatePoses(matrix: number[], width: number, height: number, n: number): number[][];
export declare function getRect(poses: number[][]): {
    left: number;
    top: number;
    right: number;
    bottom: number;
    width: number;
    height: number;
};
export declare function calculateRect(matrix: number[], width: number, height: number, n: number): {
    left: number;
    top: number;
    right: number;
    bottom: number;
    width: number;
    height: number;
};
export declare function getSVGOffset(offsetInfo: MatrixInfo, targetInfo: MatrixInfo, container: HTMLElement | SVGElement, n: number, beforeMatrix: number[]): number[];
export declare function calculateMoveablePosition(matrix: number[], origin: number[], width: number, height: number): {
    left: number;
    top: number;
    right: number;
    bottom: number;
    origin: number[];
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
    direction: 1 | -1;
};
export declare function getDistSize(vec: number[]): number;
export declare function getDiagonalSize(pos1: number[], pos2: number[]): number;
export declare function getLineStyle(pos1: number[], pos2: number[], zoom?: number, rad?: number): {
    transform: string;
    width: string;
};
export declare function getControlTransform(rotation: number, zoom: number, ...poses: number[][]): {
    transform: string;
};
export declare function getCSSSize(target: SVGElement | HTMLElement): number[];
interface ElementSizes {
    svg: boolean;
    offsetWidth: number;
    offsetHeight: number;
    clientWidth: number;
    clientHeight: number;
    cssWidth: number;
    cssHeight: number;
}
export declare function getSize(target: SVGElement | HTMLElement, style?: CSSStyleDeclaration): ElementSizes;
export declare function getRotationRad(poses: number[][], direction: number): number;
export declare function getTargetInfo(moveableElement?: HTMLElement | null, target?: HTMLElement | SVGElement | null, container?: HTMLElement | SVGElement | null, parentContainer?: HTMLElement | SVGElement | null, rootContainer?: HTMLElement | SVGElement | null): {
    width: number;
    height: number;
    rotation: number;
    rootMatrix: number[];
    beforeMatrix: number[];
    offsetMatrix: number[];
    allMatrix: number[];
    targetMatrix: number[];
    targetTransform: string;
    transformOrigin: number[];
    targetOrigin: number[];
    is3d: boolean;
    left: number;
    top: number;
    right: number;
    bottom: number;
    origin: number[];
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
    direction: number;
    hasFixed: boolean;
    targetClientRect: MoveableClientRect;
    containerClientRect: MoveableClientRect;
    moveableClientRect: MoveableClientRect;
    beforeDirection: 1 | -1;
    beforeOrigin: number[];
    originalBeforeOrigin: number[];
    target: SVGElement | HTMLElement | null | undefined;
};
export declare function resetClientRect(): MoveableClientRect;
export declare function getClientRect(el: HTMLElement | SVGElement, isExtends?: boolean): MoveableClientRect;
export declare function getDirection(target: SVGElement | HTMLElement): number[] | undefined;
export declare function getAbsolutePoses(poses: number[][], dist: number[]): number[][];
export declare function getAbsolutePosesByState({ left, top, pos1, pos2, pos3, pos4, }: {
    left: number;
    top: number;
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
}): number[][];
export declare function roundSign(num: number): number;
export declare function unset(self: any, name: string): void;
export declare function fillParams<T extends IObject<any>>(moveable: any, e: any, params: ExcludeParams<T>, isBeforeEvent?: boolean): T;
export declare function fillEndParams<T extends IObject<any>>(moveable: any, e: any, params: ExcludeEndParams<T> & {
    isDrag?: boolean;
}): T;
export declare function catchEvent<EventName extends keyof Props, Props extends IObject<any> = MoveableProps>(moveable: any, name: EventName, callback: (e: Props[EventName] extends ((e: infer P) => any) | undefined ? P : IObject<any>) => void): any;
export declare function triggerEvent<EventName extends keyof Props, Props extends IObject<any> = MoveableProps>(moveable: any, name: EventName, params: Props[EventName] extends ((e: infer P) => any) | undefined ? P : IObject<any>, isManager?: boolean): any;
export declare function getComputedStyle(el: Element, pseudoElt?: string | null): CSSStyleDeclaration;
export declare function filterAbles(ables: Able[], methods: Array<keyof Able>, triggerAblesSimultaneously?: boolean): Able<IObject<any>, IObject<any>>[];
export declare function equals(a1: any, a2: any): boolean;
export declare function selectValue<T = any>(...values: any[]): T;
export declare function groupBy<T>(arr: T[], func: (el: T, index: number, arr: T[]) => any): T[][];
export declare function groupByMap<T>(arr: T[], func: (el: T, index: number, arr: T[]) => string | number): T[][];
export declare function flat<T>(arr: T[][]): T[];
export declare function equalSign(a: number, b: number): boolean;
export declare function maxOffset(...args: number[]): number;
export declare function minOffset(...args: number[]): number;
export declare function calculateInversePosition(matrix: number[], pos: number[], n: number): number[];
export declare function convertDragDist(state: MoveableManagerState, e: any): any;
export declare function calculatePadding(matrix: number[], pos: number[], transformOrigin: number[], origin: number[], n: number): number[];
export declare function convertCSSSize(value: number, size: number, isRelative?: boolean): string;
export declare function moveControlPos(controlPoses: ControlPose[], index: number, dist: number[], isRect?: boolean): number[][];
export declare function getTinyDist(v: number): number;
export declare function directionCondition(moveable: any, e: any): any;
export declare function invertObject<T extends IObject<any>>(obj: T): InvertObject<T>;
export declare function convertTransformInfo(transforms: string[], index: number): {
    transforms: string[];
    beforeFunctionMatrix: number[];
    beforeFunctionMatrix2: number[];
    targetFunctionMatrix: number[];
    afterFunctionMatrix: number[];
    afterFunctionMatrix2: number[];
    allFunctionMatrix: number[];
    beforeFunctions: import("css-to-mat").MatrixInfo[];
    beforeFunctions2: import("css-to-mat").MatrixInfo[];
    targetFunction: import("css-to-mat").MatrixInfo;
    afterFunctions: import("css-to-mat").MatrixInfo[];
    afterFunctions2: import("css-to-mat").MatrixInfo[];
    beforeFunctionTexts: string[];
    beforeFunctionTexts2: string[];
    targetFunctionText: string;
    afterFunctionTexts: string[];
    afterFunctionTexts2: string[];
};
export declare function isArrayFormat<T = any>(arr: any): arr is ArrayFormat<T>;
export declare function getRefTarget<T extends Element = HTMLElement | SVGElement>(target: MoveableRefType<T>, isSelector: true): T | null;
export declare function getRefTarget<T extends Element = HTMLElement | SVGElement>(target: MoveableRefType<T>, isSelector?: boolean): T | string | null;
export declare function getRefTargets(targets: MoveableRefType | ArrayFormat<MoveableRefType>, isSelector: true): Array<HTMLElement | SVGElement | null>;
export declare function getRefTargets(targets: MoveableRefType | ArrayFormat<MoveableRefType>, isSelector?: boolean): Array<HTMLElement | SVGElement | string | null>;
export declare function getElementTargets(targets: Array<SVGElement | HTMLElement | string | null | undefined>, selectorMap: IObject<Array<HTMLElement | SVGElement>>): (SVGElement | HTMLElement)[];
export declare function minmax(...values: number[]): number[];
export declare function getAbsoluteRotation(pos1: number[], pos2: number[], direction: number): number;
export declare function getDragDistByState(state: MoveableManagerState, dist: number[]): number[];
export declare function getOffsetSizeDist(sizeDirection: number[], keepRatio: boolean, datas: any, e: any): {
    distWidth: number;
    distHeight: number;
};
export {};
