/// <reference types="react" />
import { BettererError } from '@betterer/errors';
import { FC } from '@betterer/render';
/**
 * @public `props` type for {@link BettererErrorLog | `<BettererErrorLog/>`}.
 */
export interface BettererErrorLogProps {
    /**
     * the `Error` or {@link @betterer/errors#BettererError | `BettererError`} to render.
     */
    error: Error | BettererError;
}
/**
 * @public Ink component for rendering a {@link @betterer/errors#BettererError | `BettererError` }
 * and all its additional information. The `message`, `stack` and `details` of the `error` will be
 * printed. If any `detail` is an `Error` or  {@link @betterer/errors#BettererError | `BettererError`},
 * the component will be rendered recursively.
 */
export declare const BettererErrorLog: FC<BettererErrorLogProps>;
//# sourceMappingURL=error-log.d.ts.map