/// <reference types="react" />
import { FC } from '@betterer/render';
import { BettererTask } from './types';
/**
 * @public `props` type for {@link BettererTaskLogger | `<BettererTaskLogger/>`}.
 */
export interface BettererTaskLoggerProps {
    /**
     * The name of the task that is shown to the user.
     */
    name: string;
    /**
     * The task to be run.
     */
    task: BettererTask;
}
/**
 * @public Ink component for rendering the output of a single {@link BettererTask | `BettererTask`}.
 * The output will update based on the status of the task. Once the task is finished, it will
 * output any logging and any errors (if the task failed).
 */
export declare const BettererTaskLogger: FC<BettererTaskLoggerProps>;
//# sourceMappingURL=TaskLogger.d.ts.map