import { BettererTaskLog, BettererTaskLogs } from './types';
interface BettererTaskState {
    done: boolean;
    running: boolean;
    status: BettererTaskLog | null;
    logs: BettererTaskLogs;
    error: Error | null;
}
interface BettererTaskStateAPI {
    error(error: Error): void;
    start(): void;
    stop(): void;
    reset(): void;
    status(status: BettererTaskLog): Promise<void>;
    log(status: BettererTaskLog): Promise<void>;
}
export declare function useTaskState(): [BettererTaskState, BettererTaskStateAPI];
export {};
//# sourceMappingURL=useTaskState.d.ts.map