"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTaskState = void 0;
const render_1 = require("@betterer/render");
const useTasksState_1 = require("./useTasksState");
const INITIAL_STATE = {
    done: false,
    running: false,
    status: null,
    logs: [],
    error: null
};
function useTaskState() {
    const [state, dispatch] = (0, render_1.useReducer)(reducer, INITIAL_STATE);
    const [, tasks] = (0, useTasksState_1.useTasks)();
    const api = (0, render_1.useRef)({
        reset() {
            dispatch({ type: 'reset' });
        },
        start() {
            tasks.start();
        },
        status(status) {
            return Promise.resolve(dispatch({ type: 'status', data: status }));
        },
        log(log) {
            return Promise.resolve(dispatch({ type: 'log', data: log }));
        },
        stop() {
            dispatch({ type: 'stop' });
            tasks.stop();
        },
        error(error) {
            dispatch({ type: 'error', data: error });
            tasks.error(error);
        }
    });
    return [state, api.current];
}
exports.useTaskState = useTaskState;
function reducer(state, action) {
    switch (action.type) {
        case 'reset': {
            return Object.assign({}, INITIAL_STATE);
        }
        case 'status':
            return Object.assign(Object.assign({}, state), { running: true, status: action.data });
        case 'log': {
            return Object.assign(Object.assign({}, state), { logs: [...state.logs, action.data] });
        }
        case 'stop': {
            return Object.assign(Object.assign({}, state), { running: false, done: true });
        }
        case 'error': {
            return Object.assign(Object.assign({}, state), { error: action.data, running: false, done: true });
        }
        default: {
            return state;
        }
    }
}
//# sourceMappingURL=useTaskState.js.map