"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTasks = exports.BettererTasksContext = exports.useTasksState = void 0;
const errors_1 = require("@betterer/errors");
const render_1 = require("@betterer/render");
const utils_1 = require("../utils");
function useTasksState() {
    const [state, dispatch] = (0, render_1.useReducer)(reducer, getInitialState());
    const api = (0, render_1.useRef)({
        error(error) {
            dispatch({ type: 'error', data: error });
        },
        start() {
            dispatch({ type: 'start' });
        },
        stop() {
            dispatch({ type: 'stop' });
        }
    });
    return [state, api.current];
}
exports.useTasksState = useTasksState;
function getInitialState() {
    return {
        running: 0,
        done: 0,
        errors: 0,
        startTime: (0, utils_1.getPreciseTime)(),
        endTime: null
    };
}
exports.BettererTasksContext = (0, render_1.createContext)(null);
function useTasks() {
    const context = (0, render_1.useContext)(exports.BettererTasksContext);
    if (context === null) {
        throw new errors_1.BettererError('Trying to use `BettererTasksContext` before it was created` 🔥');
    }
    return context;
}
exports.useTasks = useTasks;
function reducer(state, action) {
    switch (action.type) {
        case 'start': {
            if (state.endTime != null) {
                return Object.assign(Object.assign({}, getInitialState()), { running: state.running + 1 });
            }
            return Object.assign(Object.assign({}, state), { running: state.running + 1 });
        }
        case 'stop': {
            return setEndTime(Object.assign(Object.assign({}, state), { running: state.running - 1, done: state.done + 1 }));
        }
        case 'error': {
            return setEndTime(Object.assign(Object.assign({}, state), { running: state.running - 1, done: state.done + 1, errors: state.errors + 1 }));
        }
        default: {
            return state;
        }
    }
}
function setEndTime(state) {
    const shouldExit = state.running === 0;
    if (!shouldExit) {
        return state;
    }
    return Object.assign(Object.assign({}, state), { endTime: (0, utils_1.getPreciseTime)() });
}
//# sourceMappingURL=useTasksState.js.map