"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Dependencies:
var typescript_1 = require("typescript");
function traverse(node, options) {
    if (options.enter) {
        options.enter(node, node.parent || null);
    }
    if (node.forEachChild) {
        node.forEachChild(function (child) { return traverse(child, options); });
    }
    if (options.leave) {
        options.leave(node, node.parent || null);
    }
}
exports.traverse = traverse;
function replace(sourceFile, options) {
    var result = typescript_1.transform(sourceFile, [createReplacer(options)]);
    var transformed = result.transformed[0];
    return transformed;
}
exports.replace = replace;
function createReplacer(options) {
    return function (context) {
        return function visitor(node) {
            return options.visit(node, context) || typescript_1.visitEachChild(node, visitor, context);
        };
    };
}
//# sourceMappingURL=traverse.js.map