import { IObject } from "@daybrush/utils";
import { PROPERTIES, METHODS } from "./consts";
import Selecto from "./Selecto";
import {
    OnDragStart as OnParentDragStart,
    OnDrag as OnParentDrag,
    OnDragEnd as OnParentDragEnd,
} from "gesto";
import { DragScrollOptions } from "@scena/dragscroll";

/**
 * @memberof Selecto
 * @typedef
 * @property -

 * @property -
 * @property -
 * @property -
 * @property -
 * @property -
 * @property - C
 * @property -
 * @property -
 * @property -
 * @property -
 */
export interface SelectoOptions {
    /**
     * The container to add a selection element for vanilla
     */
    container: HTMLElement | null;
    /**
     * Selecto's root container (No transformed container.)
     * @dfeault null
     */
    rootContainer: HTMLElement | null;
    /**
     * The area to drag selection element.
     * @default container
     */
    dragContainer: Element | Window | Element[] | string;
    /**
     * Targets to select. You can register a queryselector or an Element.
     * @default []
     */
    selectableTargets: Array<HTMLElement | string>;
    /**
     * Whether to select from the target inside (If hitTest is 0, it becomes inside select as well)
     * @default true
     */
    selectFromInside: boolean;
    /**
     * Whether to force drag end when selectFromInside, selectByClick is true.
     * @default false
     */
    selectByClick: boolean;
    /**
     * When the target is clicked, the event is stopped and selected. (If hitTest is 0, it becomes click as well.)
     * @default true
     */
    preventDragFromInside: boolean;
    /**
     * Whether to click when mouse(touch) ends while using selectByClick(true)
     * @default false
     */
    clickBySelectEnd: boolean;
    /**
     * After the select, whether to select the next target with the selected target (deselected if the target is selected again)
     * @default false
     */
    continueSelect: boolean;
    /**
     * Whether to continue the previously selected items without deselect when using `continueSelect` or `toggleContinueSelect`.
     * @default false
     */
    continueSelectWithoutDeselect: boolean;
    /**
     * Determines which key to continue selecting the next target via keydown and keyup.
     */
    toggleContinueSelect: string[][] | string[] | string | null;
    /**
     * The container for keydown and keyup events.
     */
    keyContainer: Document | HTMLElement | Window | null;
    /**
     * The rate at which the target overlaps the drag area to be selected. If you want an absolute number, set it to a px value. (ex: 10px)
     * @default 100
     */
    hitRate: number | string;
    /**
     * Container to bound the selection area. If false, do not bound. If true, it is the container of selecto.
     * @default false
     */
    boundContainer: BoundContainer | boolean | HTMLElement | string | null;
    /**
     * Set the scroll options, time, etc. to automatically scroll by dragging.
     * @default null
     */
    scrollOptions: DragScrollOptions;
    /**
     * hecks whether this is an element to input text or contentEditable, and prevents dragging.
     * @default false
     */
    checkInput: boolean;
    /**
     * When dragging, preventDefault is called. (Touch occurs unconditionally)
     * @default false
     */
    preventDefault: boolean;
    /**
     * add nonce property to style for CSP
     * @default ""
     */
    cspNonce: string;
    /**
     * Adjust the ratio of the selection.
     * @default 0
     */
    ratio: number;
    /**
     * A function to get the exact position of an element's rect
     * @default null
     */
    getElementRect: getElementRectFunction;
    /**
     * Conditional function to start dragging
     * @default null
     */
    dragCondition: ((e: OnParentDragStart) => boolean) | null;
    /**
     * Selection Element to apply for framework.
     * @private
     */
    portalContainer: HTMLElement | null;
}
/**
 * @memberof Selecto
 * @typedef
 */
export interface BoundContainer {
    element: HTMLElement | string | boolean;
    left?: boolean;
    top?: boolean;
    right?: boolean;
    bottom?: boolean;
}

export interface Hypertext {
    tag: string;
    className: string;
    style: IObject<any>;
    attributes: object;
    children: Hypertext[];
}
export interface Rect {
    top: number;
    left: number;
    bottom: number;
    right: number;
    width: number;
    height: number;
}

export interface Point {
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
}
/**
 * @memberof Selecto
 * @typedef
 * @property - An Selecto instance itself
 */
export interface CurrentTarget<T = Selecto> {
    currentTarget: T;
}

/**
 * @memberof Selecto
 * @typedef
 * @property - An Selecto instance itself
 * @property - selected elements
 * @property - added elements
 * @property - removed elements
 * @property - Rect of Selection Element
 * @property - inputEvent
 */
export interface OnSelect<T = Selecto> extends CurrentTarget<T> {
    selected: Array<HTMLElement | SVGElement>;
    added: Array<HTMLElement | SVGElement>;
    removed: Array<HTMLElement | SVGElement>;
    rect: Rect;
    inputEvent: any;
}
/**
 * @memberof Selecto
 * @extends Selecto.OnSelect
 * @typedef
 * @property - after added elements
 * @property - after removed elements
 * @property - Whether it is a mousedown or touchstart event
 * @property - Whether it is click
 * @property - Wheter it is double click or double start
 */
export interface OnSelectEnd<T = Selecto> extends OnSelect<T>, CurrentTarget<T> {
    afterAdded: Array<HTMLElement | SVGElement>;
    afterRemoved: Array<HTMLElement | SVGElement>;
    isDragStart: boolean;
    isClick: boolean;
    isDouble: boolean;
}

export interface OnDragEvent {
    datas: IObject<any>;
    clientX: number;
    clientY: number;
    deltaX: number;
    deltaY: number;
    distX: number;
    distY: number;
    isClick?: boolean;
    isDouble?: boolean;
    inputEvent: any;
}
export interface OnKeyEvent<T = Selecto> extends CurrentTarget<T> {
}
export interface OnScroll {
    container: HTMLElement;
    direction: number[];
}
/**
 * @memberof Selecto
 * @typedef
 * @property - Stop all events
 */
export interface OnDragStart<T = Selecto> extends OnParentDragStart<T> {
    stop(): void;
}

/**
 * @memberof Selecto
 * @typedef
 * @property - Rect of Selection Element
 * @property - Whether it is in select
 */
export interface OnDrag<T = Selecto> extends OnParentDrag<T> {
    rect: Rect;
    isSelect: boolean;
}
/**
 * @memberof Selecto
 * @typedef
 * @property - Rect of Selection Element
 * @property - Whether it is in select
 */
export interface OnDragEnd<T = Selecto> extends OnParentDragEnd<T> {
    rect: Rect;
    isSelect: boolean;
}
export interface SelectoEvents {
    dragStart: OnDragStart;
    drag: OnDrag;
    dragEnd: OnDragEnd;
    selectStart: OnSelect;
    select: OnSelect;
    selectEnd: OnSelectEnd;
    keydown: OnKeyEvent;
    keyup: OnKeyEvent;
    scroll: OnScroll;
}
export type SelectoProperties = { [P in typeof PROPERTIES[number]]: SelectoOptions[P] };
export type SelectoMethods = { [P in typeof METHODS[number]]: Selecto[P] };
export type getElementRectFunction = (el: HTMLElement | SVGElement) => PointArea;
export interface PointArea {
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
}
