"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererConstraintResult = void 0;
/**
 * @public The return type of a **Betterer** constraint function. Used to indicate whether
 * the new result is `better`, `worse` or the `same` than the expected result.
 */
var BettererConstraintResult;
(function (BettererConstraintResult) {
    /**
     * The new test result is better than the expected result.
     */
    BettererConstraintResult["better"] = "better";
    /**
     * The new test result is the same as the expected result.
     */
    BettererConstraintResult["same"] = "same";
    /**
     * The new test result is worse than the expected result.
     */
    BettererConstraintResult["worse"] = "worse";
})(BettererConstraintResult = exports.BettererConstraintResult || (exports.BettererConstraintResult = {}));
//# sourceMappingURL=constraint-result.js.map