"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SumAggregator = void 0;
const types_1 = require("../types");
const core_1 = require("@opentelemetry/core");
/** Basic aggregator which calculates a Sum from individual measurements. */
class SumAggregator {
    constructor() {
        this.kind = types_1.AggregatorKind.SUM;
        this._current = 0;
        this._lastUpdateTime = [0, 0];
    }
    update(value) {
        this._current += value;
        this._lastUpdateTime = core_1.hrTime();
    }
    toPoint() {
        return {
            value: this._current,
            timestamp: this._lastUpdateTime,
        };
    }
}
exports.SumAggregator = SumAggregator;
//# sourceMappingURL=Sum.js.map