import { EventEmitter } from "./eventEmitter";
export declare type MessageOptions = {
    message?: string;
    context?: string;
    formats?: Object;
};
export declare type Locale = string;
export declare type Locales = Locale | Locale[];
export declare type LocaleData = {
    plurals?: Function;
};
export declare type AllLocaleData = Record<Locale, LocaleData>;
export declare type CompiledMessage = string | Array<string | Array<string | (string | undefined) | Record<string, unknown>>>;
export declare type Messages = Record<string, CompiledMessage>;
export declare type AllMessages = Record<Locale, Messages>;
export declare type MessageDescriptor = {
    id?: string;
    comment?: string;
    message?: string;
    context?: string;
    values?: Record<string, unknown>;
};
export declare type MissingMessageEvent = {
    locale: Locale;
    id: string;
    context?: string;
};
declare type setupI18nProps = {
    locale?: Locale;
    locales?: Locales;
    messages?: AllMessages;
    localeData?: AllLocaleData;
    missing?: string | ((message: any, id: any, context: any) => string);
};
declare type Events = {
    change: () => void;
    missing: (event: MissingMessageEvent) => void;
};
export declare class I18n extends EventEmitter<Events> {
    _locale: Locale;
    _locales: Locales;
    _localeData: AllLocaleData;
    _messages: AllMessages;
    _missing: string | ((message: any, id: any, context: any) => string);
    constructor(params: setupI18nProps);
    get locale(): string;
    get locales(): Locales;
    get messages(): Messages;
    get localeData(): LocaleData;
    _loadLocaleData(locale: Locale, localeData: LocaleData): void;
    loadLocaleData(allLocaleData: AllLocaleData): void;
    loadLocaleData(locale: Locale, localeData: LocaleData): void;
    _load(locale: Locale, messages: Messages): void;
    load(allMessages: AllMessages): void;
    load(locale: Locale, messages: Messages): void;
    activate(locale: Locale, locales?: Locales): void;
    _(id: MessageDescriptor | string, values?: Object | undefined, { message, formats, context }?: MessageOptions | undefined): string;
    date(value: string | Date, format?: Intl.DateTimeFormatOptions): string;
    number(value: number, format?: Intl.NumberFormatOptions): string;
}
declare function setupI18n(params?: setupI18nProps): I18n;
export { setupI18n };
//# sourceMappingURL=i18n.d.ts.map