/// <reference path="./bridge.d.ts" />

    /** @namespace System */

    /**
     * @memberof System
     * @callback System.Func
     * @return  {T}
     */

declare namespace Kusto.Language {
    /** @namespace Kusto.Language */

    /**
     * Well known aggregates
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Aggregates
     */
    interface Aggregates {
    }
    interface AggregatesFunc extends Function {
        prototype: Aggregates;
        new (): Aggregates;
        Sum: Kusto.Language.Symbols.FunctionSymbol | null;
        SumIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Cnt: Kusto.Language.Symbols.FunctionSymbol | null;
        Count: Kusto.Language.Symbols.FunctionSymbol | null;
        CountIf: Kusto.Language.Symbols.FunctionSymbol | null;
        DCount: Kusto.Language.Symbols.FunctionSymbol | null;
        DCountIf: Kusto.Language.Symbols.FunctionSymbol | null;
        TDigest: Kusto.Language.Symbols.FunctionSymbol | null;
        TDigestMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        MergeTDigests: Kusto.Language.Symbols.FunctionSymbol | null;
        Hll: Kusto.Language.Symbols.FunctionSymbol | null;
        HllMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        Min: Kusto.Language.Symbols.FunctionSymbol | null;
        MinIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Max: Kusto.Language.Symbols.FunctionSymbol | null;
        MaxIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Avg: Kusto.Language.Symbols.FunctionSymbol | null;
        AvgIf: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeList_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeList: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeListIf: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeListWithNulls: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeSet_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeSet: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeSetIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Passthrough: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeDictionary: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeBag: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeBagIf: Kusto.Language.Symbols.FunctionSymbol | null;
        BuildSchema: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryAllOr: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryAllAnd: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryAllXor: Kusto.Language.Symbols.FunctionSymbol | null;
        Percentile: Kusto.Language.Symbols.FunctionSymbol | null;
        Percentiles: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentilesArray: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentileW: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentilesW: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentilesWArray: Kusto.Language.Symbols.FunctionSymbol | null;
        Stdev: Kusto.Language.Symbols.FunctionSymbol | null;
        StdevIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Stdevp: Kusto.Language.Symbols.FunctionSymbol | null;
        Variance: Kusto.Language.Symbols.FunctionSymbol | null;
        VarianceIf: Kusto.Language.Symbols.FunctionSymbol | null;
        Variancep: Kusto.Language.Symbols.FunctionSymbol | null;
        Any: Kusto.Language.Symbols.FunctionSymbol | null;
        TakeAny: Kusto.Language.Symbols.FunctionSymbol | null;
        AnyIf: Kusto.Language.Symbols.FunctionSymbol | null;
        TakeAnyIf: Kusto.Language.Symbols.FunctionSymbol | null;
        ArgMin: Kusto.Language.Symbols.FunctionSymbol | null;
        ArgMax: Kusto.Language.Symbols.FunctionSymbol | null;
        ArgMin_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ArgMax_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        GetAnyResult(table: Kusto.Language.Symbols.TableSymbol | null, args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, unnamedExpressionPrefix: string | null): Kusto.Language.Symbols.TypeSymbol | null;
    }
    var Aggregates: AggregatesFunc;

    /**
     * The global state that a kusto query is associated with.
     *
     * @public
     * @class Kusto.Language.GlobalState
     */
    interface GlobalState {
        /**
         * Known clusters
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Clusters
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Clusters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ClusterSymbol> | null;
        /**
         * The default cluster.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Cluster
         * @type Kusto.Language.Symbols.ClusterSymbol
         */
        Cluster: Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * The default database.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Database
         * @type Kusto.Language.Symbols.DatabaseSymbol
         */
        Database: Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * The default domain suffix
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Domain
         * @type string
         */
        Domain: string | null;
        /**
         * Known functions.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Functions
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Functions: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        /**
         * Known aggregates.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Aggregates
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Aggregates: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        /**
         * Known plug-ins.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function PlugIns
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        PlugIns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        /**
         * Scalar operators
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Operators
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Operators: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OperatorSymbol> | null;
        /**
         * The kind of server that determines what set of control commands are available.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function ServerKind
         * @type string
         */
        ServerKind: string | null;
        /**
         * Ambient parameters
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Parameters
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ParameterSymbol> | null;
        /**
         * Known query options
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Options
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Options: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OptionSymbol> | null;
        /**
         * The {@link } used to store additional accumulated global state.
         If caching is not enabled for this {@link } this property will return null.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.GlobalState
         * @function Cache
         * @type Kusto.Language.KustoCache
         */
        Cache: Kusto.Language.KustoCache | null;
        /**
         * Makes a new instance of this {@link } that contains the same content,
         but possibly clears the cache.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @return  {Kusto.Language.GlobalState}
         */
        Copy(): Kusto.Language.GlobalState | null;
        /**
         * Conditionally creates a new instance of a {@link } if one of the 
         optional arguments is different than the current corresponding value.
         *
         * @instance
         * @private
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Utils.Optional$1}    domain        
         * @param   {Kusto.Language.Utils.Optional$1}    clusters      
         * @param   {Kusto.Language.Utils.Optional$1}    cluster       
         * @param   {Kusto.Language.Utils.Optional$1}    database      
         * @param   {Kusto.Language.Utils.Optional$1}    functions     
         * @param   {Kusto.Language.Utils.Optional$1}    aggregates    
         * @param   {Kusto.Language.Utils.Optional$1}    plugins       
         * @param   {Kusto.Language.Utils.Optional$1}    operators     
         * @param   {Kusto.Language.Utils.Optional$1}    serverKind    
         * @param   {Kusto.Language.Utils.Optional$1}    parameters    
         * @param   {Kusto.Language.Utils.Optional$1}    options       
         * @param   {Kusto.Language.Utils.Optional$1}    properties    
         * @param   {Kusto.Language.Utils.Optional$1}    cache
         * @return  {Kusto.Language.GlobalState}
         */
        /**
         * Constructs a new {@link } with caching enabled.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @return  {Kusto.Language.GlobalState}
         */
        WithCache(): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the specified cluster list.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    clusters
         * @return  {Kusto.Language.GlobalState}
         */
        WithClusterList(clusters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ClusterSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with either
         the cluster with the same name replaced with the new cluster
         or the new cluster added.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.ClusterSymbol}    cluster
         * @return  {Kusto.Language.GlobalState}
         */
        AddOrReplaceCluster(cluster: Kusto.Language.Symbols.ClusterSymbol | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the specified default cluster.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.ClusterSymbol}    cluster
         * @return  {Kusto.Language.GlobalState}
         */
        WithCluster(cluster: Kusto.Language.Symbols.ClusterSymbol | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the specified default domain suffix.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                        domain
         * @return  {Kusto.Language.GlobalState}
         */
        WithDomain(domain: string | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the specified default database.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database
         * @return  {Kusto.Language.GlobalState}
         */
        WithDatabase(database: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.GlobalState | null;
        /**
         * True if the {@link } is part of one of the known databases.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.TableSymbol}    table
         * @return  {boolean}
         */
        IsDatabaseTable(table: Kusto.Language.Symbols.TableSymbol | null): boolean;
        /**
         * True if the {@link } is part of one of the known databases.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.FunctionSymbol}    function
         * @return  {boolean}
         */
        IsDatabaseFunction($function: Kusto.Language.Symbols.FunctionSymbol | null): boolean;
        /**
         * True if the {@link } is contained by one of the known databases.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.Symbol}    symbol
         * @return  {boolean}
         */
        IsDatabaseSymbol(symbol: Kusto.Language.Symbols.Symbol | null): boolean;
        /**
         * Constructs a new {@link } with the specified functions.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    functions
         * @return  {Kusto.Language.GlobalState}
         */
        WithFunctions(functions: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Gets the cluster given the simple name or host name.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                  name
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        GetCluster$1(name: string | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Gets the {@link } that contains the {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        GetCluster(database: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Gets the {@link } that contains the {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.TableSymbol}       table
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        GetDatabase$2(table: Kusto.Language.Symbols.TableSymbol | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Gets the {@link } that contains the {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.FunctionSymbol}    function
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        GetDatabase($function: Kusto.Language.Symbols.FunctionSymbol | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Gets the {@link } that contains this {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.Symbol}            symbol
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        GetDatabase$1(symbol: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Gets the known database's {@link } that contains the {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        GetTable(column: Kusto.Language.Symbols.ColumnSymbol | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets the function with the specified name, or null
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                   name
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        GetFunction(name: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Constructs a new {@link } with the specified aggregates.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    aggregates
         * @return  {Kusto.Language.GlobalState}
         */
        WithAggregates(aggregates: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Gets the aggregate with the specified name, or null.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                   name
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        GetAggregate(name: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Constructs a new {@link } with the specified plug-ins.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    plugins
         * @return  {Kusto.Language.GlobalState}
         */
        WithPlugIns(plugins: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Gets the plug-in with the specified name, or null.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                   name
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        GetPlugIn(name: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * True if the function is a known aggregate.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.FunctionSymbol}    fn
         * @return  {boolean}
         */
        IsAggregateFunction(fn: Kusto.Language.Symbols.FunctionSymbol | null): boolean;
        /**
         * True if the function is a known built-in function.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.FunctionSymbol}    fn
         * @return  {boolean}
         */
        IsBuiltInFunction(fn: Kusto.Language.Symbols.FunctionSymbol | null): boolean;
        /**
         * Constructs a new {@link } with the specified operators.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    operators
         * @return  {Kusto.Language.GlobalState}
         */
        WithOperators(operators: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OperatorSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Gets the built-in operator symbol for the corresponding argument types.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Kusto.Language.Symbols.OperatorKind}      kind
         * @return  {Kusto.Language.Symbols.OperatorSymbol}
         */
        GetOperator(kind: Kusto.Language.Symbols.OperatorKind): Kusto.Language.Symbols.OperatorSymbol | null;
        /**
         * Constructs a new {@link } with the specified server kind {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                        serverKind
         * @return  {Kusto.Language.GlobalState}
         */
        WithServerKind(serverKind: string | null): Kusto.Language.GlobalState | null;
        /**
         * Gets a {@link } given its name.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                  name
         * @return  {Kusto.Language.Symbols.CommandSymbol}
         */
        GetCommand(name: string | null): Kusto.Language.Symbols.CommandSymbol | null;
        /**
         * Constructs a new {@link } with the specified parameters.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    parameters
         * @return  {Kusto.Language.GlobalState}
         */
        WithParameters(parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ParameterSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the additional parameters.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    parameters
         * @return  {Kusto.Language.GlobalState}
         */
        AddParameters$1(parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ParameterSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the additional parameters.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Array.<Kusto.Language.Symbols.ParameterSymbol>}    parameters
         * @return  {Kusto.Language.GlobalState}
         */
        AddParameters(parameters: Kusto.Language.Symbols.ParameterSymbol[] | null): Kusto.Language.GlobalState | null;
        /**
         * Constructs a new {@link } with the specified options.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {System.Collections.Generic.IReadOnlyList$1}    options
         * @return  {Kusto.Language.GlobalState}
         */
        WithOptions(options: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OptionSymbol> | null): Kusto.Language.GlobalState | null;
        /**
         * Gets the {@link } with the specified name, or null if none match.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {string}                                 name
         * @return  {Kusto.Language.Symbols.OptionSymbol}
         */
        GetOption(name: string | null): Kusto.Language.Symbols.OptionSymbol | null;
        /**
         * Gets the value for the specified property
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Function}                                T           
         * @param   {Kusto.Language.GlobalStateProperty$1}    property
         * @return  {T}
         */
        GetProperty<T>(T: {prototype: T}, property: Kusto.Language.GlobalStateProperty$1<T> | null): T;
        /**
         * Constructs a new {@link } instance with the property added or replaced.
         *
         * @instance
         * @public
         * @this Kusto.Language.GlobalState
         * @memberof Kusto.Language.GlobalState
         * @param   {Function}                                T           
         * @param   {Kusto.Language.GlobalStateProperty$1}    property    
         * @param   {T}                                       value
         * @return  {Kusto.Language.GlobalState}
         */
        WithProperty<T>(T: {prototype: T}, property: Kusto.Language.GlobalStateProperty$1<T> | null, value: T): Kusto.Language.GlobalState | null;
    }
    interface GlobalStateFunc extends Function {
        prototype: GlobalState;
        PropertyAndValue: Kusto.Language.GlobalState.PropertyAndValueFunc;
        /**
         * The default {@link }
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.GlobalState
         * @function Default
         * @type Kusto.Language.GlobalState
         */
        Default: Kusto.Language.GlobalState | null;
    }
    var GlobalState: GlobalStateFunc;
    module GlobalState {
        interface PropertyAndValue {
            Property: Kusto.Language.GlobalStateProperty | null;
            Value: any | null;
        }
        interface PropertyAndValueFunc extends Function {
            prototype: PropertyAndValue;
            new (property: Kusto.Language.GlobalStateProperty | null, value: any | null): PropertyAndValue;
        }
    }

    interface GlobalStateProperty {
        Name: string | null;
    }
    interface GlobalStatePropertyFunc extends Function {
        prototype: GlobalStateProperty;
    }
    var GlobalStateProperty: GlobalStatePropertyFunc;

    enum IncludeFunctionKind {
        BuiltInFunctions = 1,
        DatabaseFunctions = 2,
        LocalFunctions = 4,
        None = 0,
        All = 7
    }

    interface KustoCache {
        Globals: Kusto.Language.GlobalState | null;
        WithGlobals(globals: Kusto.Language.GlobalState | null): Kusto.Language.KustoCache | null;
        /**
         * Gets or creates a new instance of {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCache
         * @memberof Kusto.Language.KustoCache
         * @param   {Function}    T
         * @return  {T}
         */
        GetOrCreate<T>(T: {prototype: T}): T;
        /**
         * Gets or creates a new instance of {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCache
         * @memberof Kusto.Language.KustoCache
         * @param   {Function}       T          
         * @param   {System.Func}    creator
         * @return  {T}
         */
        GetOrCreate$1<T>(T: {prototype: T}, creator: {(): T} | null): T;
        /**
         * Gets the value associated with the type or returns false.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCache
         * @memberof Kusto.Language.KustoCache
         * @param   {Function}    T        
         * @param   {T}           value
         * @return  {boolean}
         */
        TryGetValue<T>(T: {prototype: T}, value: {v: T}): boolean;
    }
    interface KustoCacheFunc extends Function {
        prototype: KustoCache;
        new (globals: Kusto.Language.GlobalState | null): KustoCache;
    }
    var KustoCache: KustoCacheFunc;

    /**
     * A model of a Kusto code block, with the breakdown of its syntax, diagnostics and referenced symbols.
     *
     * @public
     * @class Kusto.Language.KustoCode
     */
    interface KustoCode {
        /**
         * The text of the code.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.KustoCode
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * The kind of the code. See {@link }.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.KustoCode
         * @function Kind
         * @type string
         */
        Kind: string | null;
        /**
         * The root {@link } of the parsed code.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoCode
         * @function Syntax
         * @type Kusto.Language.Syntax.SyntaxNode
         */
        Syntax: Kusto.Language.Syntax.SyntaxNode | null;
        /**
         * True if semantic analysis has been performed.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.KustoCode
         * @function HasSemantics
         * @type boolean
         */
        HasSemantics: boolean;
        /**
         * The resulting {@link } of the query or control command in the code.
         This value is only available when semantic analysis has been performed.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.KustoCode
         * @function ResultType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        ResultType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * The {@link } used during parsing and semantic analysis.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.KustoCode
         * @function Globals
         * @type Kusto.Language.GlobalState
         */
        Globals: Kusto.Language.GlobalState | null;
        /**
         * The deepest node depth of the syntax tree.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoCode
         * @function MaxDepth
         * @type number
         */
        MaxDepth: number;
        /**
         * Returns a new {@link } with semantic analysis performed
         or the current instance if semantic analysis has already been performed.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {Kusto.Language.GlobalState}                globals              
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.KustoCode}
         */
        Analyze(globals?: Kusto.Language.GlobalState | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.KustoCode | null;
        /**
         * Creates a new instance of {@link } with the specified {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {Kusto.Language.GlobalState}                globals              
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.KustoCode}
         */
        WithGlobals(globals: Kusto.Language.GlobalState | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.KustoCode | null;
        /**
         * Gets all diagnostics in the code (syntactic and semantic)
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetDiagnostics(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Gets syntax diagnostics in the code.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetSyntaxDiagnostics(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Gets a list of all the symbols in the scope related to the specified text position.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {number}                                        position             
         * @param   {Kusto.Language.Symbols.SymbolMatch}            match                
         * @param   {Kusto.Language.IncludeFunctionKind}            include              
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetSymbolsInScope(position: number, match?: Kusto.Language.Symbols.SymbolMatch, include?: Kusto.Language.IncludeFunctionKind, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        /**
         * Gets the symbol that would be referenced by the name, if the name were to occur at the position in the text.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {number}                                    position             
         * @param   {string}                                    name                 
         * @param   {Kusto.Language.Symbols.SymbolMatch}        match                
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Symbols.Symbol}
         */
        GetSpeculativeReferencedSymbol(position: number, name: string | null, match?: Kusto.Language.Symbols.SymbolMatch, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Symbols.Symbol | null;
        /**
         * Gets the 1-based line and lineOffset for a position in the text.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {number}          position      
         * @param   {System.Int32}    line          
         * @param   {System.Int32}    lineOffset
         * @return  {boolean}
         */
        TryGetLineAndOffset(position: number, line: {v: number}, lineOffset: {v: number}): boolean;
        /**
         * Gets the index of the token that includes the text position.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {number}    position
         * @return  {number}
         */
        GetTokenIndex(position: number): number;
        /**
         * The lexical tokens produced during parsing.
         *
         * @instance
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetLexicalTokens(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.LexicalToken> | null;
    }
    interface KustoCodeFunc extends Function {
        prototype: KustoCode;
        /**
         * The maximum depth of nodes a syntax tree can have before it is considered non-analyzable.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoCode
         * @default 500
         * @type number
         */
        MaxAnalyzableSyntaxDepth: number;
        /**
         * Create a new {@link } instance from the text and globals. Does not perform semantic analysis.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {string}                        text       The code text
         * @param   {Kusto.Language.GlobalState}    globals    The globals to use for parsing and semantic analysis. Defaults to {@link }
         * @return  {Kusto.Language.KustoCode}
         */
        Parse(text: string | null, globals?: Kusto.Language.GlobalState | null): Kusto.Language.KustoCode | null;
        /**
         * Create a new {@link } instance from the text and globals and performs semantic analysis.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {string}                                    text                 The code text
         * @param   {Kusto.Language.GlobalState}                globals              The globals to use for parsing and semantic analysis. Defaults to {@link }
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    A {@link } that can be used to cancel parsing and semantic analysis.
         * @return  {Kusto.Language.KustoCode}
         */
        ParseAndAnalyze(text: string | null, globals?: Kusto.Language.GlobalState | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.KustoCode | null;
        GetTokenStarts(tokens: Kusto.Language.Parsing.LexicalToken[] | null): System.Collections.Generic.List$1<number> | null;
        /**
         * Creates a new {@link } form the already parsed lexical tokens.
         *
         * @static
         * @private
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {string}                                         text                 
         * @param   {Kusto.Language.GlobalState}                     globals              
         * @param   {Array.<Kusto.Language.Parsing.LexicalToken>}    tokens               
         * @param   {System.Collections.Generic.List$1}              tokenStarts          
         * @param   {boolean}                                        analyze              
         * @param   {Kusto.Language.Utils.CancellationToken}         cancellationToken
         * @return  {Kusto.Language.KustoCode}
         */
        /**
         * Determines the result type of a query or control command block.
         *
         * @static
         * @private
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {Kusto.Language.Syntax.SyntaxNode}     root
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Determines the code kind from the text. See {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoCode
         * @memberof Kusto.Language.KustoCode
         * @param   {string}    text
         * @return  {string}
         */
        GetKind(text: string | null): string | null;
    }
    var KustoCode: KustoCodeFunc;

    interface KustoFacts {
    }
    interface KustoFactsFunc extends Function {
        prototype: KustoFacts;
        new (): KustoFacts;
        ParamTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ExtendedParamTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        StorageTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        KnownQueryOperatorParameterNames: string[] | null;
        ChartTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        /**
         * Chart types not shown in intellisense
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoFacts
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        HiddenChartTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        /**
         * Char types shown in intellisense
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoFacts
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        VisibleChartTypes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ChartProperties: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ChartKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ChartLegends: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ChartAxis: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ChartYSplit: System.Collections.Generic.IReadOnlyList$1<string> | null;
        JoinKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        JoinHintRemotes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        PluginHintRemotes: System.Collections.Generic.IReadOnlyList$1<string> | null;
        JoinHintStrategies: System.Collections.Generic.IReadOnlyList$1<string> | null;
        LookupKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        SummarizeHintStrategies: System.Collections.Generic.IReadOnlyList$1<string> | null;
        PartitionHintStrategies: System.Collections.Generic.IReadOnlyList$1<string> | null;
        OrderByHintStrategies: System.Collections.Generic.IReadOnlyList$1<string> | null;
        DistributionHintStrategies: System.Collections.Generic.IReadOnlyList$1<string> | null;
        SearchKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        MakeSeriesKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        MvExpandKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ReduceByKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        UnionWithSourceProperties: System.Collections.Generic.IReadOnlyList$1<string> | null;
        UnionKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ParseKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        DataScopeValues: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ScanStepOutputValues: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ToScalarKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        ToTableKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        LimitExamples: System.Collections.Generic.IReadOnlyList$1<string> | null;
        TopExamples: System.Collections.Generic.IReadOnlyList$1<string> | null;
        AgoExamples: System.Collections.Generic.IReadOnlyList$1<string> | null;
        SpecialKeywordsAfterDot: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null;
        ForkOperatorKinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null;
        /**
         * Query operators that can come after a pipe
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoFacts
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        PostPipeOperatorKinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null;
        ScanOperatorKinds: System.Collections.Generic.IReadOnlyList$1<string> | null;
        /**
         * The quote text at the start and end of a multi-line string.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoFacts
         * @default "```"
         * @type string
         */
        MultiLineStringQuote: string | null;
        /**
         * Alternate quote for multi-line strings, to be depreciated.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.KustoFacts
         * @default "~~~"
         * @type string
         */
        AlternateMultiLineStringQuote: string | null;
        KustoWindowsNet: string | null;
        UnionIsFuzzyProperty: string | null;
        /**
         * True if the query operator is on the right side of a pipe expression
         or is in a context that allows operators that would normally only appear
         on the right side of a pipe expression.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {Kusto.Language.Syntax.QueryOperator}    queryOp
         * @return  {boolean}
         */
        HasPipedInput(queryOp: Kusto.Language.Syntax.QueryOperator | null): boolean;
        /**
         * True if the text can be used as an identifier in all places that declare or reference names.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     text
         * @return  {boolean}
         */
        CanBeIdentifier(text: string | null): boolean;
        /**
         * True if the text is a keyword.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     text
         * @return  {boolean}
         */
        IsKeyword(text: string | null): boolean;
        /**
         * True if the text is a keyword that can be an identifier.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     text
         * @return  {boolean}
         */
        IsKeywordThatCanBeIdentifier(text: string | null): boolean;
        /**
         * Adds bracketting and quoting to name if necessary.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    name
         * @return  {string}
         */
        BracketNameIfNecessary(name: string | null): string | null;
        /**
         * Convert name to bracketed form: name -&gt; ['name']
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    name
         * @return  {string}
         */
        GetBracketedName(name: string | null): string | null;
        /**
         * Gets the single-quoted escaped string literal for the text,
         unless it contains a single quote, and then get the double-quoted escaped string literal.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    text
         * @return  {string}
         */
        GetStringLiteral(text: string | null): string | null;
        /**
         * Gets the single-quoted escaped string literal for the text.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    text
         * @return  {string}
         */
        GetSingleQuotedStringLiteral(text: string | null): string | null;
        /**
         * Gets the double-quoted escaped string literal for the text.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    text
         * @return  {string}
         */
        GetDoubleQuotedStringLiteral(text: string | null): string | null;
        /**
         * Gets the multi-line quoted string literal for the text.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    text
         * @return  {string}
         */
        GetMultiLineStringLiteral(text: string | null): string | null;
        GetExpressionResultName(expr: Kusto.Language.Syntax.Expression | null, defaultName?: string | null, rowScope?: Kusto.Language.Symbols.TableSymbol | null): string | null;
        GetStringLiteralValue(literal: string | null): string | null;
        /**
         * Returns true if the name matches the host name.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     name        
         * @param   {string}     hostName
         * @return  {boolean}
         */
        IsHostName(name: string | null, hostName: string | null): boolean;
        /**
         * Gets the host name from a possible uri
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    clusterUriOrName
         * @return  {string}
         */
        GetHostName(clusterUriOrName: string | null): string | null;
        /**
         * Gets the full name of a host given the short or full name.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    hostname               
         * @param   {string}    defaultDomainSuffix
         * @return  {string}
         */
        GetFullHostName(hostname: string | null, defaultDomainSuffix: string | null): string | null;
        /**
         * Returns true if the hostname has a short name
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     hostname               
         * @param   {string}     defaultDomainSuffix
         * @return  {boolean}
         */
        HasShortHostName(hostname: string | null, defaultDomainSuffix: string | null): boolean;
        /**
         * Returns true if the name is the short name of the host name.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     name                   
         * @param   {string}     hostName               
         * @param   {string}     defaultDomainSuffix
         * @return  {boolean}
         */
        IsShortHostName(name: string | null, hostName: string | null, defaultDomainSuffix: string | null): boolean;
        /**
         * Returns true if the name is a possible short host name
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     name
         * @return  {boolean}
         */
        IsPossibleShortHostName(name: string | null): boolean;
        /**
         * Gets the short name given the full host name, if one exists or null if no short name exists
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}    hostName               
         * @param   {string}    defaultDomainSuffix
         * @return  {string}
         */
        GetShortHostName(hostName: string | null, defaultDomainSuffix: string | null): string | null;
        /**
         * True if the text matches the pattern (*, xxx*, *xxx, *xxx*, xxx*yyy, *xxx*yyy*, ...)
         The * represents any zero-or-more characters.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {string}     pattern       
         * @param   {string}     text          
         * @param   {boolean}    ignoreCase
         * @return  {boolean}
         */
        Matches(pattern: string | null, text: string | null, ignoreCase?: boolean): boolean;
        /**
         * Attempts to determine the tabularity of an expression (scalar, tabular, none, unknown) given syntax.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {Kusto.Language.Syntax.Expression}     expression    
         * @param   {Kusto.Language.GlobalState}           globals
         * @return  {Kusto.Language.Symbols.Tabularity}
         */
        GetSyntaxTabularity(expression: Kusto.Language.Syntax.Expression | null, globals?: Kusto.Language.GlobalState | null): Kusto.Language.Symbols.Tabularity;
        /**
         * Attempts to determine the tabularity of a statement (scalar, tabular, none, unknown) given syntax.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {Kusto.Language.Syntax.Statement}      statement    
         * @param   {Kusto.Language.GlobalState}           globals
         * @return  {Kusto.Language.Symbols.Tabularity}
         */
        GetSyntaxTabularity$1(statement: Kusto.Language.Syntax.Statement | null, globals?: Kusto.Language.GlobalState | null): Kusto.Language.Symbols.Tabularity;
        /**
         * Attempts to determine the tabularity of a block of statements (scalar, tabular, none, unknown) given syntax.
         *
         * @static
         * @public
         * @this Kusto.Language.KustoFacts
         * @memberof Kusto.Language.KustoFacts
         * @param   {Kusto.Language.Syntax.SyntaxList$1}    statements    
         * @param   {Kusto.Language.GlobalState}            globals
         * @return  {Kusto.Language.Symbols.Tabularity}
         */
        GetSyntaxTabularity$2(statements: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement>> | null, globals?: Kusto.Language.GlobalState | null): Kusto.Language.Symbols.Tabularity;
    }
    var KustoFacts: KustoFactsFunc;

    /**
     * Built-in scalar math-like operators
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Operators
     */
    interface Operators {
    }
    interface OperatorsFunc extends Function {
        prototype: Operators;
        new (): Operators;
        UnaryMinus: Kusto.Language.Symbols.OperatorSymbol | null;
        UnaryPlus: Kusto.Language.Symbols.OperatorSymbol | null;
        And: Kusto.Language.Symbols.OperatorSymbol | null;
        Or: Kusto.Language.Symbols.OperatorSymbol | null;
        Add: Kusto.Language.Symbols.OperatorSymbol | null;
        Subtract: Kusto.Language.Symbols.OperatorSymbol | null;
        Multiply: Kusto.Language.Symbols.OperatorSymbol | null;
        Divide: Kusto.Language.Symbols.OperatorSymbol | null;
        Modulo: Kusto.Language.Symbols.OperatorSymbol | null;
        LessThan: Kusto.Language.Symbols.OperatorSymbol | null;
        LessThanOrEqual: Kusto.Language.Symbols.OperatorSymbol | null;
        GreaterThan: Kusto.Language.Symbols.OperatorSymbol | null;
        GreaterThanOrEqual: Kusto.Language.Symbols.OperatorSymbol | null;
        Equal: Kusto.Language.Symbols.OperatorSymbol | null;
        NotEqual: Kusto.Language.Symbols.OperatorSymbol | null;
        EqualTilde: Kusto.Language.Symbols.OperatorSymbol | null;
        BangTilde: Kusto.Language.Symbols.OperatorSymbol | null;
        Has: Kusto.Language.Symbols.OperatorSymbol | null;
        HasCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHas: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHasCs: Kusto.Language.Symbols.OperatorSymbol | null;
        HasPrefix: Kusto.Language.Symbols.OperatorSymbol | null;
        HasPrefixCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHasPrefix: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHasPrefixCs: Kusto.Language.Symbols.OperatorSymbol | null;
        HasSuffix: Kusto.Language.Symbols.OperatorSymbol | null;
        HasSuffixCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHasSuffix: Kusto.Language.Symbols.OperatorSymbol | null;
        NotHasSuffixCs: Kusto.Language.Symbols.OperatorSymbol | null;
        Like: Kusto.Language.Symbols.OperatorSymbol | null;
        LikeCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotLike: Kusto.Language.Symbols.OperatorSymbol | null;
        NotLikeCs: Kusto.Language.Symbols.OperatorSymbol | null;
        Contains: Kusto.Language.Symbols.OperatorSymbol | null;
        ContainsCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotContains: Kusto.Language.Symbols.OperatorSymbol | null;
        NotContainsCs: Kusto.Language.Symbols.OperatorSymbol | null;
        StartsWith: Kusto.Language.Symbols.OperatorSymbol | null;
        StartsWithCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotStartsWith: Kusto.Language.Symbols.OperatorSymbol | null;
        NotStartsWithCs: Kusto.Language.Symbols.OperatorSymbol | null;
        EndsWith: Kusto.Language.Symbols.OperatorSymbol | null;
        EndsWithCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotEndsWith: Kusto.Language.Symbols.OperatorSymbol | null;
        NotEndsWithCs: Kusto.Language.Symbols.OperatorSymbol | null;
        MatchRegex: Kusto.Language.Symbols.OperatorSymbol | null;
        Search: Kusto.Language.Symbols.OperatorSymbol | null;
        In: Kusto.Language.Symbols.OperatorSymbol | null;
        HasAny: Kusto.Language.Symbols.OperatorSymbol | null;
        HasAll: Kusto.Language.Symbols.OperatorSymbol | null;
        InCs: Kusto.Language.Symbols.OperatorSymbol | null;
        NotIn: Kusto.Language.Symbols.OperatorSymbol | null;
        NotInCs: Kusto.Language.Symbols.OperatorSymbol | null;
        Between: Kusto.Language.Symbols.OperatorSymbol | null;
        NotBetween: Kusto.Language.Symbols.OperatorSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OperatorSymbol> | null;
    }
    var Operators: OperatorsFunc;

    /**
     * Well known scalar and special functions.
     *
     * @public
     * @class Kusto.Language.Functions
     */
    interface Functions {
    }
    interface FunctionsFunc extends Function {
        prototype: Functions;
        new (): Functions;
        Cluster: Kusto.Language.Symbols.FunctionSymbol | null;
        Database: Kusto.Language.Symbols.FunctionSymbol | null;
        Table: Kusto.Language.Symbols.FunctionSymbol | null;
        ExternalTable: Kusto.Language.Symbols.FunctionSymbol | null;
        MaterializedView: Kusto.Language.Symbols.FunctionSymbol | null;
        StoredQueryResult: Kusto.Language.Symbols.FunctionSymbol | null;
        Strcat: Kusto.Language.Symbols.FunctionSymbol | null;
        StrcatArray: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayStrcat: Kusto.Language.Symbols.FunctionSymbol | null;
        StrcatDelim: Kusto.Language.Symbols.FunctionSymbol | null;
        Strcmp: Kusto.Language.Symbols.FunctionSymbol | null;
        Strrep: Kusto.Language.Symbols.FunctionSymbol | null;
        Strlen: Kusto.Language.Symbols.FunctionSymbol | null;
        StringSize: Kusto.Language.Symbols.FunctionSymbol | null;
        ToUpper: Kusto.Language.Symbols.FunctionSymbol | null;
        ToLower: Kusto.Language.Symbols.FunctionSymbol | null;
        ToUtf8: Kusto.Language.Symbols.FunctionSymbol | null;
        Substring: Kusto.Language.Symbols.FunctionSymbol | null;
        RegexQuote: Kusto.Language.Symbols.FunctionSymbol | null;
        IndexOf: Kusto.Language.Symbols.FunctionSymbol | null;
        IndexOfRegex: Kusto.Language.Symbols.FunctionSymbol | null;
        HasAnyIndex: Kusto.Language.Symbols.FunctionSymbol | null;
        Reverse: Kusto.Language.Symbols.FunctionSymbol | null;
        Split: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseCommandLine: Kusto.Language.Symbols.FunctionSymbol | null;
        Extract: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtractAll_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtractAll: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtractJson_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtractJson: Kusto.Language.Symbols.FunctionSymbol | null;
        Replace: Kusto.Language.Symbols.FunctionSymbol | null;
        ReplaceRegex: Kusto.Language.Symbols.FunctionSymbol | null;
        ReplaceString: Kusto.Language.Symbols.FunctionSymbol | null;
        TrimStart: Kusto.Language.Symbols.FunctionSymbol | null;
        TrimEnd: Kusto.Language.Symbols.FunctionSymbol | null;
        Trim: Kusto.Language.Symbols.FunctionSymbol | null;
        CountOf: Kusto.Language.Symbols.FunctionSymbol | null;
        Translate: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeString: Kusto.Language.Symbols.FunctionSymbol | null;
        DateTimeToLocaleString: Kusto.Language.Symbols.FunctionSymbol | null;
        NumberToLocaleString: Kusto.Language.Symbols.FunctionSymbol | null;
        ToString: Kusto.Language.Symbols.FunctionSymbol | null;
        ToHex: Kusto.Language.Symbols.FunctionSymbol | null;
        ToDynamic_: Kusto.Language.Symbols.FunctionSymbol | null;
        ToObject_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ToLong: Kusto.Language.Symbols.FunctionSymbol | null;
        ToInt: Kusto.Language.Symbols.FunctionSymbol | null;
        ToReal: Kusto.Language.Symbols.FunctionSymbol | null;
        ToDouble: Kusto.Language.Symbols.FunctionSymbol | null;
        ToDateTime: Kusto.Language.Symbols.FunctionSymbol | null;
        ToTimespan: Kusto.Language.Symbols.FunctionSymbol | null;
        ToTime: Kusto.Language.Symbols.FunctionSymbol | null;
        ToBool: Kusto.Language.Symbols.FunctionSymbol | null;
        ToBoolean: Kusto.Language.Symbols.FunctionSymbol | null;
        ToDecimal: Kusto.Language.Symbols.FunctionSymbol | null;
        ToGuid: Kusto.Language.Symbols.FunctionSymbol | null;
        GetType: Kusto.Language.Symbols.FunctionSymbol | null;
        UrlEncode: Kusto.Language.Symbols.FunctionSymbol | null;
        UrlEncode_Component: Kusto.Language.Symbols.FunctionSymbol | null;
        UrlDecode: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64EncodeString: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64EncodeToString: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64DecodeString: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64DecodeToString: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64DecodeToArray: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64DecodeToGuid: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64EncodeFromGuid: Kusto.Language.Symbols.FunctionSymbol | null;
        Base64EncodeFromArray: Kusto.Language.Symbols.FunctionSymbol | null;
        ZlibDecompressString: Kusto.Language.Symbols.FunctionSymbol | null;
        ZlibCompressString: Kusto.Language.Symbols.FunctionSymbol | null;
        GzipDecompressString: Kusto.Language.Symbols.FunctionSymbol | null;
        GzipCompressString: Kusto.Language.Symbols.FunctionSymbol | null;
        Lz4CompressDynamicArray: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseCsv: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseJson_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseJson: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseXml: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseUrl_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseUrl: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseUrlQuery_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseUrlQuery: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseIPV4: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseIPV4Mask: Kusto.Language.Symbols.FunctionSymbol | null;
        FormatIPV4: Kusto.Language.Symbols.FunctionSymbol | null;
        FormatIPV4Mask: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv4Compare: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv4IsMatch: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv4IsInRange: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv4NetmaskSuffix: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv4IsPrivate: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseIPV6: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseIPV6Mask: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv6Compare: Kusto.Language.Symbols.FunctionSymbol | null;
        Ipv6IsMatch: Kusto.Language.Symbols.FunctionSymbol | null;
        ParsePath: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseUserAgent: Kusto.Language.Symbols.FunctionSymbol | null;
        ParseVersion: Kusto.Language.Symbols.FunctionSymbol | null;
        FormatDatetime: Kusto.Language.Symbols.FunctionSymbol | null;
        FormatTimespan: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeDatetime: Kusto.Language.Symbols.FunctionSymbol | null;
        MakeTimespan: Kusto.Language.Symbols.FunctionSymbol | null;
        DatetimeAdd: Kusto.Language.Symbols.FunctionSymbol | null;
        DatetimeDiff: Kusto.Language.Symbols.FunctionSymbol | null;
        DayOfWeek: Kusto.Language.Symbols.FunctionSymbol | null;
        DayOfMonth: Kusto.Language.Symbols.FunctionSymbol | null;
        DayOfYear: Kusto.Language.Symbols.FunctionSymbol | null;
        HourOfDay: Kusto.Language.Symbols.FunctionSymbol | null;
        WeekOfYear: Kusto.Language.Symbols.FunctionSymbol | null;
        WeekOfYearISO: Kusto.Language.Symbols.FunctionSymbol | null;
        MonthOfYear: Kusto.Language.Symbols.FunctionSymbol | null;
        StartOfDay: Kusto.Language.Symbols.FunctionSymbol | null;
        StartOfWeek: Kusto.Language.Symbols.FunctionSymbol | null;
        StartOfMonth: Kusto.Language.Symbols.FunctionSymbol | null;
        StartOfYear: Kusto.Language.Symbols.FunctionSymbol | null;
        EndOfDay: Kusto.Language.Symbols.FunctionSymbol | null;
        EndOfWeek: Kusto.Language.Symbols.FunctionSymbol | null;
        EndOfMonth: Kusto.Language.Symbols.FunctionSymbol | null;
        EndOfYear: Kusto.Language.Symbols.FunctionSymbol | null;
        GetYear: Kusto.Language.Symbols.FunctionSymbol | null;
        GetMonth: Kusto.Language.Symbols.FunctionSymbol | null;
        DatePart: Kusto.Language.Symbols.FunctionSymbol | null;
        DatetimePart: Kusto.Language.Symbols.FunctionSymbol | null;
        Now: Kusto.Language.Symbols.FunctionSymbol | null;
        Ago: Kusto.Language.Symbols.FunctionSymbol | null;
        UnixTimeSecondsToDateTime: Kusto.Language.Symbols.FunctionSymbol | null;
        UnixTimeMillisecondsToDateTime: Kusto.Language.Symbols.FunctionSymbol | null;
        UnixTimeMicrosecondsToDateTime: Kusto.Language.Symbols.FunctionSymbol | null;
        UnixTimeNanosecondsToDateTime: Kusto.Language.Symbols.FunctionSymbol | null;
        HashCrc32: Kusto.Language.Symbols.FunctionSymbol | null;
        HashManyCrc32: Kusto.Language.Symbols.FunctionSymbol | null;
        HashDjb2: Kusto.Language.Symbols.FunctionSymbol | null;
        InternalHashXXH64: Kusto.Language.Symbols.FunctionSymbol | null;
        Hash: Kusto.Language.Symbols.FunctionSymbol | null;
        HashXXH64: Kusto.Language.Symbols.FunctionSymbol | null;
        HashSha256: Kusto.Language.Symbols.FunctionSymbol | null;
        HashMd5: Kusto.Language.Symbols.FunctionSymbol | null;
        HashSha1: Kusto.Language.Symbols.FunctionSymbol | null;
        HashCombine: Kusto.Language.Symbols.FunctionSymbol | null;
        HashMany: Kusto.Language.Symbols.FunctionSymbol | null;
        Iif: Kusto.Language.Symbols.FunctionSymbol | null;
        Iff: Kusto.Language.Symbols.FunctionSymbol | null;
        Case: Kusto.Language.Symbols.FunctionSymbol | null;
        Assert: Kusto.Language.Symbols.FunctionSymbol | null;
        Bin: Kusto.Language.Symbols.FunctionSymbol | null;
        Floor: Kusto.Language.Symbols.FunctionSymbol | null;
        BinAt: Kusto.Language.Symbols.FunctionSymbol | null;
        BinAuto: Kusto.Language.Symbols.FunctionSymbol | null;
        Not: Kusto.Language.Symbols.FunctionSymbol | null;
        NotNull_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        IsNotNull: Kusto.Language.Symbols.FunctionSymbol | null;
        IsNull: Kusto.Language.Symbols.FunctionSymbol | null;
        NotEmpty_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        IsNotEmpty: Kusto.Language.Symbols.FunctionSymbol | null;
        IsEmpty: Kusto.Language.Symbols.FunctionSymbol | null;
        IsAscii: Kusto.Language.Symbols.FunctionSymbol | null;
        IsUtf8: Kusto.Language.Symbols.FunctionSymbol | null;
        IsColumnExists: Kusto.Language.Symbols.FunctionSymbol | null;
        ColumnIfExists_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ColumnIfExists: Kusto.Language.Symbols.FunctionSymbol | null;
        Around: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryAnd: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryOr: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryXor: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryNot: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryShiftRight: Kusto.Language.Symbols.FunctionSymbol | null;
        BinaryShiftLeft: Kusto.Language.Symbols.FunctionSymbol | null;
        BitsetCountOnes: Kusto.Language.Symbols.FunctionSymbol | null;
        TreePath: Kusto.Language.Symbols.FunctionSymbol | null;
        Repeat: Kusto.Language.Symbols.FunctionSymbol | null;
        Arraylength_Deprecated: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayLength: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayReverse: Kusto.Language.Symbols.FunctionSymbol | null;
        Range: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayConcat: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayIff: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayIif: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayIndexOf: Kusto.Language.Symbols.FunctionSymbol | null;
        SetHasElement: Kusto.Language.Symbols.FunctionSymbol | null;
        ArraySlice: Kusto.Language.Symbols.FunctionSymbol | null;
        ArraySplit: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayShiftLeft: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayShiftRight: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayRotateLeft: Kusto.Language.Symbols.FunctionSymbol | null;
        ArrayRotateRight: Kusto.Language.Symbols.FunctionSymbol | null;
        ArraySortAsc: Kusto.Language.Symbols.FunctionSymbol | null;
        ArraySortDesc: Kusto.Language.Symbols.FunctionSymbol | null;
        BagKeys: Kusto.Language.Symbols.FunctionSymbol | null;
        Zip: Kusto.Language.Symbols.FunctionSymbol | null;
        Pack: Kusto.Language.Symbols.FunctionSymbol | null;
        PackDictionary: Kusto.Language.Symbols.FunctionSymbol | null;
        BagPack: Kusto.Language.Symbols.FunctionSymbol | null;
        PackAll: Kusto.Language.Symbols.FunctionSymbol | null;
        PackArray: Kusto.Language.Symbols.FunctionSymbol | null;
        SetUnion: Kusto.Language.Symbols.FunctionSymbol | null;
        SetIntersect: Kusto.Language.Symbols.FunctionSymbol | null;
        SetDifference: Kusto.Language.Symbols.FunctionSymbol | null;
        BagMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        DynamicToJson: Kusto.Language.Symbols.FunctionSymbol | null;
        BagRemoveKeys: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentileTDigest: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentileArrayTDigest: Kusto.Language.Symbols.FunctionSymbol | null;
        PercentRankTDigest: Kusto.Language.Symbols.FunctionSymbol | null;
        RankTDigest: Kusto.Language.Symbols.FunctionSymbol | null;
        TdigestIsValid: Kusto.Language.Symbols.FunctionSymbol | null;
        TDigestMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        MergeTDigests: Kusto.Language.Symbols.FunctionSymbol | null;
        HllMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        DCountHll: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFir: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesStats: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesStatsDynamic: Kusto.Language.Symbols.FunctionSymbol | null;
        ArraySum: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFft: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesIFft: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFitPoly: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFitLine: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFitLineDynamic: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFit2Lines: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFit2LinesDynamic: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesOutliers: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesIIR: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesPeriodsDetect: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesPeriodsValidate: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFillBackwards: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFillForward: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFillConst: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesFillLinear: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesAdd: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesSubtract: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesMultiply: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesDivide: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesPow: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesGreater: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesGreaterEquals: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesLess: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesLessEquals: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesEquals: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesNotEquals: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesSeasonal: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesExp: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesSign: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesAbs: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesSin: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesAsin: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesCos: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesAcos: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesTan: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesAtan: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesDecompose: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesDecomposeForecast: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesDecomposeAnomalies: Kusto.Language.Symbols.FunctionSymbol | null;
        SeriesPearsonCorrelation: Kusto.Language.Symbols.FunctionSymbol | null;
        Round: Kusto.Language.Symbols.FunctionSymbol | null;
        Ceiling: Kusto.Language.Symbols.FunctionSymbol | null;
        Pow: Kusto.Language.Symbols.FunctionSymbol | null;
        Sqrt: Kusto.Language.Symbols.FunctionSymbol | null;
        Log: Kusto.Language.Symbols.FunctionSymbol | null;
        Log2: Kusto.Language.Symbols.FunctionSymbol | null;
        Log10: Kusto.Language.Symbols.FunctionSymbol | null;
        Exp: Kusto.Language.Symbols.FunctionSymbol | null;
        Exp2: Kusto.Language.Symbols.FunctionSymbol | null;
        Exp10: Kusto.Language.Symbols.FunctionSymbol | null;
        PI: Kusto.Language.Symbols.FunctionSymbol | null;
        Cos: Kusto.Language.Symbols.FunctionSymbol | null;
        Sin: Kusto.Language.Symbols.FunctionSymbol | null;
        Tan: Kusto.Language.Symbols.FunctionSymbol | null;
        Acos: Kusto.Language.Symbols.FunctionSymbol | null;
        Asin: Kusto.Language.Symbols.FunctionSymbol | null;
        Atan: Kusto.Language.Symbols.FunctionSymbol | null;
        Atan2: Kusto.Language.Symbols.FunctionSymbol | null;
        Abs: Kusto.Language.Symbols.FunctionSymbol | null;
        Cot: Kusto.Language.Symbols.FunctionSymbol | null;
        Degrees: Kusto.Language.Symbols.FunctionSymbol | null;
        Radians: Kusto.Language.Symbols.FunctionSymbol | null;
        Sign: Kusto.Language.Symbols.FunctionSymbol | null;
        Rand: Kusto.Language.Symbols.FunctionSymbol | null;
        BetaCdf: Kusto.Language.Symbols.FunctionSymbol | null;
        BetaInv: Kusto.Language.Symbols.FunctionSymbol | null;
        BetaPdf: Kusto.Language.Symbols.FunctionSymbol | null;
        Gamma: Kusto.Language.Symbols.FunctionSymbol | null;
        LogGamma: Kusto.Language.Symbols.FunctionSymbol | null;
        IsNan: Kusto.Language.Symbols.FunctionSymbol | null;
        IsInf: Kusto.Language.Symbols.FunctionSymbol | null;
        IsFinite: Kusto.Language.Symbols.FunctionSymbol | null;
        Coalesce: Kusto.Language.Symbols.FunctionSymbol | null;
        MaxOf: Kusto.Language.Symbols.FunctionSymbol | null;
        MinOf: Kusto.Language.Symbols.FunctionSymbol | null;
        WelchTest: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoDistance2Points: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoDistancePointToLine: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoDistancePointToPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPointInCircle: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPointInPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineIntersectsLine: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineIntersectsPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonIntersectsPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonsUnion: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLinesUnion: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonToS2Cells: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonDensify: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonArea: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonCentroid: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonPerimeter: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineLength: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineCentroid: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineDensify: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineSimplify: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoLineValidate: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPolygonValidate: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPointToGeohash: Kusto.Language.Symbols.FunctionSymbol | null;
        GeohashToCentralPoint: Kusto.Language.Symbols.FunctionSymbol | null;
        GeohashToPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPointToS2Cell: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoS2CellToCentralPoint: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoS2CellToPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoPointToH3Cell: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellToCentralPoint: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellToPolygon: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellChildren: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellParent: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellRings: Kusto.Language.Symbols.FunctionSymbol | null;
        GeoH3CellLevel: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentClusterEndpoint: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentDatabase: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentPrincipal: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentPrincipalDetails: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentPrincipalIsMemberOf: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtentId: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtentId2: Kusto.Language.Symbols.FunctionSymbol | null;
        ExtentTags: Kusto.Language.Symbols.FunctionSymbol | null;
        CurrentNodeId: Kusto.Language.Symbols.FunctionSymbol | null;
        IngestionTime: Kusto.Language.Symbols.FunctionSymbol | null;
        CursorAfter: Kusto.Language.Symbols.FunctionSymbol | null;
        CursorBeforeOrAt: Kusto.Language.Symbols.FunctionSymbol | null;
        CursorCurrent: Kusto.Language.Symbols.FunctionSymbol | null;
        CursorCurrent2: Kusto.Language.Symbols.FunctionSymbol | null;
        FormatBytes: Kusto.Language.Symbols.FunctionSymbol | null;
        RowNumber: Kusto.Language.Symbols.FunctionSymbol | null;
        RowCumSum: Kusto.Language.Symbols.FunctionSymbol | null;
        RowRank: Kusto.Language.Symbols.FunctionSymbol | null;
        RowWindowSession: Kusto.Language.Symbols.FunctionSymbol | null;
        Prev: Kusto.Language.Symbols.FunctionSymbol | null;
        Next: Kusto.Language.Symbols.FunctionSymbol | null;
        RowstoreOrdinalRange: Kusto.Language.Symbols.FunctionSymbol | null;
        EstimateDataSize: Kusto.Language.Symbols.FunctionSymbol | null;
        NewGuid: Kusto.Language.Symbols.FunctionSymbol | null;
        InternalFunnelCompletion: Kusto.Language.Symbols.FunctionSymbol | null;
        HasIpv4: Kusto.Language.Symbols.FunctionSymbol | null;
        HasIpv4Prefix: Kusto.Language.Symbols.FunctionSymbol | null;
        HasAnyIpv4: Kusto.Language.Symbols.FunctionSymbol | null;
        HasAnyIpv4Prefix: Kusto.Language.Symbols.FunctionSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
    }
    var Functions: FunctionsFunc;

    /**
     * Well known query options
     *
     * @public
     * @class Kusto.Language.Options
     */
    interface Options {
    }
    interface OptionsFunc extends Function {
        prototype: Options;
        new (): Options;
        DebugPython: Kusto.Language.Symbols.OptionSymbol | null;
        DeferPartialQueryFailures: Kusto.Language.Symbols.OptionSymbol | null;
        DoNotImpersonate: Kusto.Language.Symbols.OptionSymbol | null;
        MaterializedViewShuffleQuery: Kusto.Language.Symbols.OptionSymbol | null;
        MaxEntitiesToUnion: Kusto.Language.Symbols.OptionSymbol | null;
        MaxMemoryConsumptionPerIterator: Kusto.Language.Symbols.OptionSymbol | null;
        MaxMemoryConsumptionPerQueryPerNode: Kusto.Language.Symbols.OptionSymbol | null;
        MaxOutputColumns: Kusto.Language.Symbols.OptionSymbol | null;
        NoRequestTimeout: Kusto.Language.Symbols.OptionSymbol | null;
        NoTruncation: Kusto.Language.Symbols.OptionSymbol | null;
        ProgressiveProgressReportPeriod: Kusto.Language.Symbols.OptionSymbol | null;
        ProgressiveQueryMinRowCountPerUpdate: Kusto.Language.Symbols.OptionSymbol | null;
        PushSelectionThroughAggregation: Kusto.Language.Symbols.OptionSymbol | null;
        QueryBinAutoAt: Kusto.Language.Symbols.OptionSymbol | null;
        QueryBinAutoSize: Kusto.Language.Symbols.OptionSymbol | null;
        QueryCursorAfterDefault: Kusto.Language.Symbols.OptionSymbol | null;
        QueryCursorBeforeOrAtDefault: Kusto.Language.Symbols.OptionSymbol | null;
        QueryCursorCurrent: Kusto.Language.Symbols.OptionSymbol | null;
        QueryCursorDisabled: Kusto.Language.Symbols.OptionSymbol | null;
        QueryCursorScopedTables: Kusto.Language.Symbols.OptionSymbol | null;
        QueryDataScope: Kusto.Language.Symbols.OptionSymbol | null;
        QueryDateTimeScopeColumn: Kusto.Language.Symbols.OptionSymbol | null;
        QueryDateTimeScopeFrom: Kusto.Language.Symbols.OptionSymbol | null;
        QueryDateTimeScopeTo: Kusto.Language.Symbols.OptionSymbol | null;
        QueryDistributionNodesSpanSize: Kusto.Language.Symbols.OptionSymbol | null;
        QueryFanoutNodesPercent: Kusto.Language.Symbols.OptionSymbol | null;
        QueryFanoutThreadsPercent: Kusto.Language.Symbols.OptionSymbol | null;
        QueryForceRowLevelSecurity: Kusto.Language.Symbols.OptionSymbol | null;
        QueryLanguage: Kusto.Language.Symbols.OptionSymbol | null;
        QueryLogQueryParameters: Kusto.Language.Symbols.OptionSymbol | null;
        QueryNow: Kusto.Language.Symbols.OptionSymbol | null;
        QueryResultsApplyGetSchema: Kusto.Language.Symbols.OptionSymbol | null;
        QueryResultsCacheMaxAge: Kusto.Language.Symbols.OptionSymbol | null;
        QueryResultsCachePerShardEnabled: Kusto.Language.Symbols.OptionSymbol | null;
        QueryWeakConsistencySessionId: Kusto.Language.Symbols.OptionSymbol | null;
        RequestAppName: Kusto.Language.Symbols.OptionSymbol | null;
        RequestBlockRowLevelSecurity: Kusto.Language.Symbols.OptionSymbol | null;
        RequestCalloutDisabled: Kusto.Language.Symbols.OptionSymbol | null;
        RequestDescription: Kusto.Language.Symbols.OptionSymbol | null;
        RequestExternalTableDisabled: Kusto.Language.Symbols.OptionSymbol | null;
        RequestReadOnly: Kusto.Language.Symbols.OptionSymbol | null;
        RequestRemoteEntitiesDisabled: Kusto.Language.Symbols.OptionSymbol | null;
        RequestSandboxedExecutionDisabled: Kusto.Language.Symbols.OptionSymbol | null;
        RequestUser: Kusto.Language.Symbols.OptionSymbol | null;
        ResultsProgressiveEnabled: Kusto.Language.Symbols.OptionSymbol | null;
        ServerTimeout: Kusto.Language.Symbols.OptionSymbol | null;
        TakeMaxRecords: Kusto.Language.Symbols.OptionSymbol | null;
        TruncationMaxRecords: Kusto.Language.Symbols.OptionSymbol | null;
        TruncationMaxSize: Kusto.Language.Symbols.OptionSymbol | null;
        ValidatePermissions: Kusto.Language.Symbols.OptionSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.OptionSymbol> | null;
    }
    var Options: OptionsFunc;

    /**
     * A {@link } that represents the evaluated body of the function called,
     as if it were expanded inline at the location of the call with the arguments and local variables in scope considered.
     *
     * @class Kusto.Language.FunctionCallExpansion
     * @augments Kusto.Language.Syntax.SyntaxTree
     */
    interface FunctionCallExpansion extends Kusto.Language.Syntax.SyntaxTree {
        Body: Kusto.Language.Syntax.FunctionBody | null;
    }
    interface FunctionCallExpansionFunc extends Function {
        prototype: FunctionCallExpansion;
        new (body: Kusto.Language.Syntax.FunctionBody | null): FunctionCallExpansion;
    }
    var FunctionCallExpansion: FunctionCallExpansionFunc;

    /**
     * Describes a parameter that a query operator may have.
     *
     * @public
     * @class Kusto.Language.QueryOperatorParameter
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface QueryOperatorParameter extends Kusto.Language.Symbols.Symbol {
        /**
         * The kind that the value can take.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function ValueKind
         * @type Kusto.Language.QueryOperatorParameterValueKind
         */
        ValueKind: Kusto.Language.QueryOperatorParameterValueKind;
        /**
         * True if token/keyword value matches are case sensitive.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function IsCaseSensitive
         * @type boolean
         */
        IsCaseSensitive: boolean;
        /**
         * The set of known parameter values.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function Values
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Values: System.Collections.Generic.IReadOnlyList$1<string> | null;
        /**
         * True if the parameter can be specified more than once.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function IsRepeatable
         * @type boolean
         */
        IsRepeatable: boolean;
        /**
         * True if the parameter is typed with no equals token between the name and value
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function HasNoEquals
         * @type boolean
         */
        HasNoEquals: boolean;
        /**
         * Any additional names that the parameter can be referenced by.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.QueryOperatorParameter
         * @function Aliases
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Aliases: System.Collections.Generic.IReadOnlyList$1<string> | null;
        IsHidden: boolean;
        Kind: Kusto.Language.Symbols.SymbolKind;
        WithIsHidden(isHidden: boolean): Kusto.Language.QueryOperatorParameter | null;
        WithValues(values: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.QueryOperatorParameter | null;
        WithHasNoEquals(hasNoEquals: boolean): Kusto.Language.QueryOperatorParameter | null;
        Hide(): Kusto.Language.QueryOperatorParameter | null;
    }
    interface QueryOperatorParameterFunc extends Function {
        prototype: QueryOperatorParameter;
        $ctor1: {
            new (name: string | null, kind: Kusto.Language.QueryOperatorParameterValueKind, caseSensitive: boolean, values: System.Collections.Generic.IEnumerable$1<string> | null, isRepeatable: boolean, aliases: System.Collections.Generic.IReadOnlyList$1<string> | null): QueryOperatorParameter
        };
    }
    var QueryOperatorParameter: QueryOperatorParameterFunc;

    /**
     * Well known plugins.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.PlugIns
     */
    interface PlugIns {
    }
    interface PlugInsFunc extends Function {
        prototype: PlugIns;
        new (): PlugIns;
        ActiveUseCounts: Kusto.Language.Symbols.FunctionSymbol | null;
        ActivityCountsMetrics: Kusto.Language.Symbols.FunctionSymbol | null;
        ActivityEngagement: Kusto.Language.Symbols.FunctionSymbol | null;
        ActivityMetrics: Kusto.Language.Symbols.FunctionSymbol | null;
        NewActivityMetrics: Kusto.Language.Symbols.FunctionSymbol | null;
        AutoClusterColumns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        AutoCluster: Kusto.Language.Symbols.FunctionSymbol | null;
        BagUnpack: Kusto.Language.Symbols.FunctionSymbol | null;
        BasketColumns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        Basket: Kusto.Language.Symbols.FunctionSymbol | null;
        DCountIntersect: Kusto.Language.Symbols.FunctionSymbol | null;
        DiffPatternsColumns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        DiffPatterns: Kusto.Language.Symbols.FunctionSymbol | null;
        EstimateRowsCount: Kusto.Language.Symbols.FunctionSymbol | null;
        ExecuteShowCommand: Kusto.Language.Symbols.FunctionSymbol | null;
        ExecuteQuery: Kusto.Language.Symbols.FunctionSymbol | null;
        ExternalDatatable: Kusto.Language.Symbols.FunctionSymbol | null;
        FunnelSequence: Kusto.Language.Symbols.FunctionSymbol | null;
        FunnelSequenceCompletion: Kusto.Language.Symbols.FunctionSymbol | null;
        HttpRequestColumns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        HttpRequest: Kusto.Language.Symbols.FunctionSymbol | null;
        HttpRequestPost: Kusto.Language.Symbols.FunctionSymbol | null;
        Identity: Kusto.Language.Symbols.FunctionSymbol | null;
        IdentityV3: Kusto.Language.Symbols.FunctionSymbol | null;
        InferStorageSchema: Kusto.Language.Symbols.FunctionSymbol | null;
        SchemaMerge: Kusto.Language.Symbols.FunctionSymbol | null;
        NarrowColumns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        Narrow: Kusto.Language.Symbols.FunctionSymbol | null;
        Pivot: Kusto.Language.Symbols.FunctionSymbol | null;
        Preview: Kusto.Language.Symbols.FunctionSymbol | null;
        CSharp: Kusto.Language.Symbols.FunctionSymbol | null;
        Python: Kusto.Language.Symbols.FunctionSymbol | null;
        R: Kusto.Language.Symbols.FunctionSymbol | null;
        RollingPercentile: Kusto.Language.Symbols.FunctionSymbol | null;
        RowsNear: Kusto.Language.Symbols.FunctionSymbol | null;
        SessionCount: Kusto.Language.Symbols.FunctionSymbol | null;
        SequenceDetect: Kusto.Language.Symbols.FunctionSymbol | null;
        SlidingWindowCounts: Kusto.Language.Symbols.FunctionSymbol | null;
        SqlRequest: Kusto.Language.Symbols.FunctionSymbol | null;
        MySqlRequest: Kusto.Language.Symbols.FunctionSymbol | null;
        CosmosdbSqlRequest: Kusto.Language.Symbols.FunctionSymbol | null;
        AzureDigitalTwinsQueryRequest: Kusto.Language.Symbols.FunctionSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        /**
         * Gets the plug-in function given the name, or null if no plug-in is defined with the specified name.
         *
         * @static
         * @public
         * @this Kusto.Language.PlugIns
         * @memberof Kusto.Language.PlugIns
         * @param   {string}                                   name
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        GetPlugIn(name: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
    }
    var PlugIns: PlugInsFunc;

    /**
     * The set of predefined {@link }.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Properties
     */
    interface Properties {
    }
    interface PropertiesFunc extends Function {
        prototype: Properties;
        new (): Properties;
        AllowClientParameters: Kusto.Language.GlobalStateProperty$1<boolean> | null;
    }
    var Properties: PropertiesFunc;

    /**
     * Known parameters for specific query operators or expressions
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.QueryOperatorParameters
     */
    interface QueryOperatorParameters {
    }
    interface QueryOperatorParametersFunc extends Function {
        prototype: QueryOperatorParameters;
        new (): QueryOperatorParameters;
        BagExpansion: Kusto.Language.QueryOperatorParameter | null;
        DecodeBlocks: Kusto.Language.QueryOperatorParameter | null;
        Flags: Kusto.Language.QueryOperatorParameter | null;
        HintDotConcurrency: Kusto.Language.QueryOperatorParameter | null;
        HintDotDistribution: Kusto.Language.QueryOperatorParameter | null;
        HintDotMaterialized: Kusto.Language.QueryOperatorParameter | null;
        HintDotNumPartitions: Kusto.Language.QueryOperatorParameter | null;
        HintDotProgressiveTop: Kusto.Language.QueryOperatorParameter | null;
        HintDotRemote: Kusto.Language.QueryOperatorParameter | null;
        HintDotShuffleKey: Kusto.Language.QueryOperatorParameter | null;
        HintDotSpread: Kusto.Language.QueryOperatorParameter | null;
        HintDotStrategy: Kusto.Language.QueryOperatorParameter | null;
        IsFuzzy: Kusto.Language.QueryOperatorParameter | null;
        Kind: Kusto.Language.QueryOperatorParameter | null;
        WithMatchId: Kusto.Language.QueryOperatorParameter | null;
        WithItemIndex: Kusto.Language.QueryOperatorParameter | null;
        WithSource: Kusto.Language.QueryOperatorParameter | null;
        /**
         * All query operator parameters.
         Does not include parameters used for other syntax clauses (like render with properties)
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.QueryOperatorParameters
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        AllParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        AsParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ConsumeParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        DataTableParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        DistinctParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        EvaluateParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ExternalDataWithClauseProperties: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        FilterParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        FindParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        JoinParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        LookupParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        MakeSeriesParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        MvApplyParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        MvExpandParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ParseParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        PartitionParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        RenderKind: Kusto.Language.QueryOperatorParameter | null;
        RenderTitle: Kusto.Language.QueryOperatorParameter | null;
        RenderAccumulate: Kusto.Language.QueryOperatorParameter | null;
        RenderWithDeprecated: Kusto.Language.QueryOperatorParameter | null;
        RenderByDeprecated: Kusto.Language.QueryOperatorParameter | null;
        RenderParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        RenderWithProperties: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ReduceParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ReduceWithParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SampleParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SampleDistinctParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ScanParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SearchParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SerializedParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SortParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        SummarizeParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        TakeParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        TopParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
        ToScalarKindParameter: Kusto.Language.QueryOperatorParameter | null;
        ToTableKindParameter: Kusto.Language.QueryOperatorParameter | null;
        UnionParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.QueryOperatorParameter> | null;
    }
    var QueryOperatorParameters: QueryOperatorParametersFunc;

    enum QueryOperatorParameterValueKind {
        ScalarLiteral = 0,
        IntegerLiteral = 1,
        NumericLiteral = 2,
        ForcedRealLiteral = 3,
        StringLiteral = 4,
        BoolLiteral = 5,
        SummableLiteral = 6,
        Word = 7,
        WordOrNumber = 8,
        NameDeclaration = 9,
        Column = 10,
        ColumnList = 11
    }

    /**
     * The kinds of servers that can be connected to.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.ServerKinds
     */
    interface ServerKinds {
    }
    interface ServerKindsFunc extends Function {
        prototype: ServerKinds;
        new (): ServerKinds;
        Engine: string | null;
        DataManager: string | null;
        ClusterManager: string | null;
        AriaBridge: string | null;
    }
    var ServerKinds: ServerKindsFunc;

    interface TestHelpers {
    }
    interface TestHelpersFunc extends Function {
        prototype: TestHelpers;
        new (): TestHelpers;
        GetGlobalExpansionCacheSize(globals: Kusto.Language.GlobalState | null): number;
        Bind(syntax: Kusto.Language.Syntax.SyntaxNode | null, globals: Kusto.Language.GlobalState | null): void;
    }
    var TestHelpers: TestHelpersFunc;

    interface GlobalStateProperty$1<T> extends Kusto.Language.GlobalStateProperty {
        DefaultValue: T;
    }
    interface GlobalStateProperty$1Func extends Function {
        <T>($T: Bridge.TypeRef<T>): {
            prototype: GlobalStateProperty$1<T>;
            new (name: string | null, defaultValue: T): GlobalStateProperty$1<T>;
        }
    }
    var GlobalStateProperty$1: GlobalStateProperty$1Func;

    /**
     * A class full of helper API's used when building custom return types for functions.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.FunctionHelpers
     */
    interface FunctionHelpers {
    }
    interface FunctionHelpersFunc extends Function {
        prototype: FunctionHelpers;
        new (): FunctionHelpers;
        /**
         * The largest number of ocurrances for a repeatable parameter
         *
         * @static
         * @public
         * @memberof Kusto.Language.FunctionHelpers
         * @constant
         * @default 32767
         * @type number
         */
        MaxRepeat: number;
        MakePrefixedTuple(signature: Kusto.Language.Symbols.Signature | null, parameterName: string | null, args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, baseTuple: Kusto.Language.Symbols.TupleSymbol | null): Kusto.Language.Symbols.TupleSymbol | null;
        /**
         * Makes a column name by joining multiple parts using underscores.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {Array.<string>}    nameParts
         * @return  {string}
         */
        MakeColumnName(nameParts: string[] | null): string | null;
        /**
         * Gets the range of arguments all associated with the same repeating parameter.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.List$1}    argumentParameters    
         * @param   {Kusto.Language.Symbols.Parameter}     parameter             
         * @param   {System.Int32}                         start                 
         * @param   {System.Int32}                         length
         * @return  {void}
         */
        GetArgumentRange(argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null, parameter: Kusto.Language.Symbols.Parameter | null, start: {v: number}, length: {v: number}): void;
        /**
         * Adds the column referenced by the argument corresponding to the specified parameter to the list.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.List$1}             columns          
         * @param   {System.Collections.Generic.IReadOnlyList$1}    args             
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {string}                                        parameterName
         * @return  {void}
         */
        AddReferencedColumn(columns: System.Collections.Generic.List$1<Kusto.Language.Symbols.ColumnSymbol> | null, args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, signature: Kusto.Language.Symbols.Signature | null, parameterName: string | null): void;
        /**
         * Adds the columns referenced by the arguments corresponding to the specified parameter to the list.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.List$1}             columns          
         * @param   {System.Collections.Generic.IReadOnlyList$1}    args             
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {string}                                        parameterName
         * @return  {void}
         */
        AddReferencedColumns(columns: System.Collections.Generic.List$1<Kusto.Language.Symbols.ColumnSymbol> | null, args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, signature: Kusto.Language.Symbols.Signature | null, parameterName: string | null): void;
        /**
         * Gets the first argument associated with the parameter, or null if no parameter is associated with the specified arguments.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    args             The arguments.
         * @param   {Kusto.Language.Symbols.Signature}              signature        The signature of the function.
         * @param   {string}                                        parameterName    The name of the parameter.
         * @return  {Kusto.Language.Syntax.Expression}
         */
        GetArgument(args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, signature: Kusto.Language.Symbols.Signature | null, parameterName: string | null): Kusto.Language.Syntax.Expression | null;
        /**
         * Gets the arguments for the specified parameter.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    args             The arguments.
         * @param   {Kusto.Language.Symbols.Signature}              signature        The signature of the function.
         * @param   {string}                                        parameterName    The name of the parameter.
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        GetArguments(args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, signature: Kusto.Language.Symbols.Signature | null, parameterName: string | null): System.Collections.Generic.IEnumerable$1<Kusto.Language.Syntax.Expression> | null;
        /**
         * Gets the column name that will be used in a projection list for the expression.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {Kusto.Language.Syntax.Expression}      expr           
         * @param   {string}                                defaultName    
         * @param   {Kusto.Language.Symbols.TableSymbol}    rowScope
         * @return  {string}
         */
        GetExpressionResultName(expr: Kusto.Language.Syntax.Expression | null, defaultName?: string | null, rowScope?: Kusto.Language.Symbols.TableSymbol | null): string | null;
        /**
         * Gets the value of the literal expression.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {Kusto.Language.Syntax.Expression}    expr
         * @return  {string}
         */
        GetLiteralValue(expr: Kusto.Language.Syntax.Expression | null): string | null;
        /**
         * Converts all non letters and digits into underscores.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {string}    text
         * @return  {string}
         */
        MakeValidNameFragment(text: string | null): string | null;
        /**
         * Gets the {@link }s referenced in the by clause of the summarize operator
         given the args to an invocation of an aggregate.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    args
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetSummarizeByColumns(args: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        /**
         * Get the list of {@link } referenced by the expressions in a list of expressions.
         *
         * @static
         * @public
         * @this Kusto.Language.FunctionHelpers
         * @memberof Kusto.Language.FunctionHelpers
         * @param   {Kusto.Language.Syntax.SyntaxList$1}            exprs
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetColumnSymbols(exprs: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
    }
    var FunctionHelpers: FunctionHelpersFunc;

    interface EngineCommands {
    }
    interface EngineCommandsFunc extends Function {
        prototype: EngineCommands;
        new (): EngineCommands;
        ShowDatabase: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicies: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseDataStats: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterDatabases: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterDatabasesDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterDatabasesIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterDatabasesPolicies: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterDatabasesDataStats: Kusto.Language.Symbols.CommandSymbol | null;
        CreateDatabasePersist: Kusto.Language.Symbols.CommandSymbol | null;
        CreateDatabaseVolatile: Kusto.Language.Symbols.CommandSymbol | null;
        AttachDatabase: Kusto.Language.Symbols.CommandSymbol | null;
        AttachDatabaseMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        DetachDatabase: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePrettyName: Kusto.Language.Symbols.CommandSymbol | null;
        DropDatabasePrettyName: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePersistMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        SetAccess: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseSchemaAsJson: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseSchemaAsCslScript: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseCslSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseSchemaViolations: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasesSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasesSchemaAsJson: Kusto.Language.Symbols.CommandSymbol | null;
        CreateDatabaseIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabaseIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseIngestionMappings: Kusto.Language.Symbols.CommandSymbol | null;
        ShowIngestionMappings: Kusto.Language.Symbols.CommandSymbol | null;
        DropDatabaseIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTables: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTable: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablesDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableCslSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableSchemaAsJson: Kusto.Language.Symbols.CommandSymbol | null;
        CreateTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateTableBasedOnAnother: Kusto.Language.Symbols.CommandSymbol | null;
        CreateMergeTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateTables: Kusto.Language.Symbols.CommandSymbol | null;
        CreateMergeTables: Kusto.Language.Symbols.CommandSymbol | null;
        DefineTables: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTable: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTable: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableDocString: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableFolder: Kusto.Language.Symbols.CommandSymbol | null;
        RenameTable: Kusto.Language.Symbols.CommandSymbol | null;
        RenameTables: Kusto.Language.Symbols.CommandSymbol | null;
        DropTable: Kusto.Language.Symbols.CommandSymbol | null;
        UndoDropTable: Kusto.Language.Symbols.CommandSymbol | null;
        DropTables: Kusto.Language.Symbols.CommandSymbol | null;
        CreateTableIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableIngestionMappings: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        DropTableIngestionMapping: Kusto.Language.Symbols.CommandSymbol | null;
        RenameColumn: Kusto.Language.Symbols.CommandSymbol | null;
        RenameColumns: Kusto.Language.Symbols.CommandSymbol | null;
        AlterColumnType: Kusto.Language.Symbols.CommandSymbol | null;
        DropColumn: Kusto.Language.Symbols.CommandSymbol | null;
        DropTableColumns: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableColumnDocStrings: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTableColumnDocStrings: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFunctions: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFunction: Kusto.Language.Symbols.CommandSymbol | null;
        CreateFunction: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFunction: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAlterFunction: Kusto.Language.Symbols.CommandSymbol | null;
        DropFunction: Kusto.Language.Symbols.CommandSymbol | null;
        DropFunctions: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFunctionDocString: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFunctionFolder: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTables: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTableCslSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTableSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTableArtifacts: Kusto.Language.Symbols.CommandSymbol | null;
        DropExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateStorageExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        AlterStorageExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAlterStorageExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateSqlExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        AlterSqlExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAlterSqlExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateExternalTableMapping: Kusto.Language.Symbols.CommandSymbol | null;
        SetExternalTableAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        AddExternalTableAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        DropExternalTableAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExternalTableDocString: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExternalTableFolder: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTablePrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFabric: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExternalTableMapping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTableMappings: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTableMapping: Kusto.Language.Symbols.CommandSymbol | null;
        DropExternalTableMapping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowWorkloadGroups: Kusto.Language.Symbols.CommandSymbol | null;
        ShowWorkloadGroup: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAleterWorkloadGroup: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeWorkloadGroup: Kusto.Language.Symbols.CommandSymbol | null;
        DropWorkloadGroup: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowColumnPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterColumnPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteColumnPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteMaterializedViewPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyIngestionTime: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyIngestionTime: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyIngestionTime: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyIngestionTime: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyIngestionTime: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewPolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeMaterializedViewPolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyHardRetentionViolations: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicySoftRetentionViolations: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewPolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteMaterializedViewPolicyRowLevelSecurity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyRowOrder: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyUpdate: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyUpdate: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyUpdate: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyUpdate: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyUpdate: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyIngestionBatching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowColumnPolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableColumnsPolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterColumnPolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterColumnPolicyEncodingType: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeColumnPolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteColumnPolicyEncoding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewPolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeMaterializedViewPolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteMaterializedViewPolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyRestrictedViewAccess: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyRestrictedViewAccess: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyRestrictedViewAccess: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablesPolicyRestrictedViewAccess: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyRestrictedViewAccess: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicySandbox: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicySandbox: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicySandbox: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterSandboxesStats: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicySharding: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyShardsGrouping: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyShardsGrouping: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyShardsGrouping: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyShardsGrouping: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeTablePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyStreamingIngestion: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyManagedIdentity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyAutoDelete: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyAutoDelete: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyAutoDelete: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyCallout: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyCallout: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyCallout: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyCallout: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyCapacity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyCapacity: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyCapacity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyRequestClassification: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyRequestClassification: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyRequestClassification: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteClusterPolicyRequestClassification: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyMultiDatabaseAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyMultiDatabaseAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyMultiDatabaseAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeDatabasePolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPolicyQueryWeakConsistency: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterPolicyQueryWeakConsistency: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMergeClusterPolicyQueryWeakConsistency: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableStarPolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTablePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabasePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTablePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteDatabasePolicyExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowPrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExternalTablesPrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFunctionPrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPrincipalRoles: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablePrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFunctionPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        AddClusterRole: Kusto.Language.Symbols.CommandSymbol | null;
        DropClusterRole: Kusto.Language.Symbols.CommandSymbol | null;
        SetClusterRole: Kusto.Language.Symbols.CommandSymbol | null;
        AddDatabaseRole: Kusto.Language.Symbols.CommandSymbol | null;
        DropDatabaseRole: Kusto.Language.Symbols.CommandSymbol | null;
        SetDatabaseRole: Kusto.Language.Symbols.CommandSymbol | null;
        AddTableRole: Kusto.Language.Symbols.CommandSymbol | null;
        DropTableRole: Kusto.Language.Symbols.CommandSymbol | null;
        SetTableRole: Kusto.Language.Symbols.CommandSymbol | null;
        AddFunctionRole: Kusto.Language.Symbols.CommandSymbol | null;
        DropFunctionRole: Kusto.Language.Symbols.CommandSymbol | null;
        SetFunctionRole: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterBlockedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        AddClusterBlockedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        DropClusterBlockedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        IngestIntoTable: Kusto.Language.Symbols.CommandSymbol | null;
        IngestInlineIntoTable: Kusto.Language.Symbols.CommandSymbol | null;
        SetTable: Kusto.Language.Symbols.CommandSymbol | null;
        AppendTable: Kusto.Language.Symbols.CommandSymbol | null;
        SetOrAppendTable: Kusto.Language.Symbols.CommandSymbol | null;
        SetOrReplaceTable: Kusto.Language.Symbols.CommandSymbol | null;
        ExportToStorage: Kusto.Language.Symbols.CommandSymbol | null;
        ExportToSqlTable: Kusto.Language.Symbols.CommandSymbol | null;
        ExportToExternalTable: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAlterContinuousExport: Kusto.Language.Symbols.CommandSymbol | null;
        ShowContinuousExport: Kusto.Language.Symbols.CommandSymbol | null;
        ShowContinuousExports: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterPendingContinuousExports: Kusto.Language.Symbols.CommandSymbol | null;
        ShowContinuousExportExportedArtifacts: Kusto.Language.Symbols.CommandSymbol | null;
        ShowContinuousExportFailures: Kusto.Language.Symbols.CommandSymbol | null;
        SetContinuousExportCursor: Kusto.Language.Symbols.CommandSymbol | null;
        DropContinuousExport: Kusto.Language.Symbols.CommandSymbol | null;
        EnableContinuousExport: Kusto.Language.Symbols.CommandSymbol | null;
        DisableContinuousExport: Kusto.Language.Symbols.CommandSymbol | null;
        CreateMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        RenameMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViews: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewsDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPolicyRetention: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPolicyMerge: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPolicyPartitioning: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewExtents: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        CreateOrAlterMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        DropMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        EnableDisableMaterializedView: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewSchemaAsJson: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewCslSchema: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewFolder: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewDocString: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewLookback: Kusto.Language.Symbols.CommandSymbol | null;
        AlterMaterializedViewAutoUpdateSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ClearMaterializedViewData: Kusto.Language.Symbols.CommandSymbol | null;
        SetMaterializedViewCursor: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCluster: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCapacity: Kusto.Language.Symbols.CommandSymbol | null;
        ShowOperations: Kusto.Language.Symbols.CommandSymbol | null;
        ShowOperationDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowJournal: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseJournal: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterJournal: Kusto.Language.Symbols.CommandSymbol | null;
        ShowQueries: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRunningQueries: Kusto.Language.Symbols.CommandSymbol | null;
        CancelQuery: Kusto.Language.Symbols.CommandSymbol | null;
        ShowQueryPlan: Kusto.Language.Symbols.CommandSymbol | null;
        ShowBasicAuthUsers: Kusto.Language.Symbols.CommandSymbol | null;
        CreateBasicAuthUser: Kusto.Language.Symbols.CommandSymbol | null;
        DropBasicAuthUser: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCache: Kusto.Language.Symbols.CommandSymbol | null;
        AlterCache: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCommands: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCommandsAndQueries: Kusto.Language.Symbols.CommandSymbol | null;
        ShowIngestionFailures: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterExtents: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterExtentsMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseExtents: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseExtentsMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseExtentTagsStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableExtents: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableExtentsMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        TableShardGroupsShow: Kusto.Language.Symbols.CommandSymbol | null;
        TableShardGroupsStatisticsShow: Kusto.Language.Symbols.CommandSymbol | null;
        DatabaseShardGroupsStatisticsShow: Kusto.Language.Symbols.CommandSymbol | null;
        MergeExtents: Kusto.Language.Symbols.CommandSymbol | null;
        MergeExtentsDryrun: Kusto.Language.Symbols.CommandSymbol | null;
        MoveExtentsFrom: Kusto.Language.Symbols.CommandSymbol | null;
        MoveExtentsQuery: Kusto.Language.Symbols.CommandSymbol | null;
        ReplaceExtents: Kusto.Language.Symbols.CommandSymbol | null;
        DropExtent: Kusto.Language.Symbols.CommandSymbol | null;
        DropExtents: Kusto.Language.Symbols.CommandSymbol | null;
        DropExtentsPartitionMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        DropPretendExtentsByProperties: Kusto.Language.Symbols.CommandSymbol | null;
        ShowVersion: Kusto.Language.Symbols.CommandSymbol | null;
        ClearTableData: Kusto.Language.Symbols.CommandSymbol | null;
        ClearTableCacheStreamingIngestionSchema: Kusto.Language.Symbols.CommandSymbol | null;
        StoredQueryResultSet: Kusto.Language.Symbols.CommandSymbol | null;
        StoredQueryResultsShow: Kusto.Language.Symbols.CommandSymbol | null;
        StoredQueryResultShowSchema: Kusto.Language.Symbols.CommandSymbol | null;
        StoredQueryResultDrop: Kusto.Language.Symbols.CommandSymbol | null;
        StoredQueryResultsDrop: Kusto.Language.Symbols.CommandSymbol | null;
        CreateRequestSupport: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRequestSupport: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterAdminState: Kusto.Language.Symbols.CommandSymbol | null;
        ClearRemoteClusterDatabaseSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterMonitoring: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterScaleIn: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterNetwork: Kusto.Language.Symbols.CommandSymbol | null;
        AlterClusterStorageKeys: Kusto.Language.Symbols.CommandSymbol | null;
        ShowClusterStorageKeysHash: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExtentContainersAdd: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExtentContainersDrop: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExtentContainersRecycle: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExtentContainersSet: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExtentContainers: Kusto.Language.Symbols.CommandSymbol | null;
        DropEmptyExtentContainers: Kusto.Language.Symbols.CommandSymbol | null;
        CleanDatabaseExtentContainers: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseExtentContainersCleanOperations: Kusto.Language.Symbols.CommandSymbol | null;
        ClearDatabaseCacheQueryResults: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabaseCacheQueryResults: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasesManagementGroups: Kusto.Language.Symbols.CommandSymbol | null;
        AlterDatabaseStorageKeys: Kusto.Language.Symbols.CommandSymbol | null;
        ClearDatabaseCacheStreamingIngestionSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ClearDatabaseCacheQueryWeakConsistency: Kusto.Language.Symbols.CommandSymbol | null;
        ShowEntitySchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExtentDetails: Kusto.Language.Symbols.CommandSymbol | null;
        ShowExtentColumnStorageStats: Kusto.Language.Symbols.CommandSymbol | null;
        AttachExtentsIntoTableByContainer: Kusto.Language.Symbols.CommandSymbol | null;
        AttachExtentsIntoTableByMetadata: Kusto.Language.Symbols.CommandSymbol | null;
        AlterExtentTagsFromQuery: Kusto.Language.Symbols.CommandSymbol | null;
        DropExtentTagsRetention: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFollowerClusterConfiguration: Kusto.Language.Symbols.CommandSymbol | null;
        AddFollowerDatabaseAuthorizedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        DropFollowerDatabaseAuthorizedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFollowerDatabaseAuthorizedPrincipals: Kusto.Language.Symbols.CommandSymbol | null;
        DropFollowerDatabasePolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFollowerDatabaseChildEntities: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFollowerDatabaseConfiguration: Kusto.Language.Symbols.CommandSymbol | null;
        DropFollowerDatabases: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFollowerDatabase: Kusto.Language.Symbols.CommandSymbol | null;
        AlterFollowerTablesPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        DropFollowerTablesPolicyCaching: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFreshness: Kusto.Language.Symbols.CommandSymbol | null;
        ShowFunctionSchemaAsJson: Kusto.Language.Symbols.CommandSymbol | null;
        SetMaterializedViewAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        AddMaterializedViewAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        DropMaterializedViewAdmins: Kusto.Language.Symbols.CommandSymbol | null;
        SetMaterializedViewConcurrency: Kusto.Language.Symbols.CommandSymbol | null;
        ClearMaterializedViewStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewDiagnostics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMaterializedViewFailures: Kusto.Language.Symbols.CommandSymbol | null;
        ShowMemory: Kusto.Language.Symbols.CommandSymbol | null;
        CancelOperation: Kusto.Language.Symbols.CommandSymbol | null;
        DisablePlugin: Kusto.Language.Symbols.CommandSymbol | null;
        EnablePlugin: Kusto.Language.Symbols.CommandSymbol | null;
        ShowPlugins: Kusto.Language.Symbols.CommandSymbol | null;
        ShowPrincipalAccess: Kusto.Language.Symbols.CommandSymbol | null;
        ShowDatabasePurgeOperation: Kusto.Language.Symbols.CommandSymbol | null;
        ShowQueryExecution: Kusto.Language.Symbols.CommandSymbol | null;
        AlterPoliciesOfRetention: Kusto.Language.Symbols.CommandSymbol | null;
        DeletePoliciesOfRetention: Kusto.Language.Symbols.CommandSymbol | null;
        CreateRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        DropRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRowStores: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRowStoreTransactions: Kusto.Language.Symbols.CommandSymbol | null;
        ShowRowStoreSeals: Kusto.Language.Symbols.CommandSymbol | null;
        ShowSchema: Kusto.Language.Symbols.CommandSymbol | null;
        ShowCallStacks: Kusto.Language.Symbols.CommandSymbol | null;
        ShowStreamingIngestionFailures: Kusto.Language.Symbols.CommandSymbol | null;
        ShowStreamingIngestionStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDropKey: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDropRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDropBlockedKeys: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDisableKey: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDisableRowStore: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableRowStoreReferencesDisableBlockedKeys: Kusto.Language.Symbols.CommandSymbol | null;
        SetTableRowStoreReferences: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableRowStoreReferences: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableColumnStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        AlterTableColumnStatisticsMethod: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableColumnStatitics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableDimensions: Kusto.Language.Symbols.CommandSymbol | null;
        DeleteTableRecords: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableColumnsClassification: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableRowStores: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableRowStoreSealInfo: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTablesColumnStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableUsageStatistics: Kusto.Language.Symbols.CommandSymbol | null;
        ShowTableUsageStatisticsDetails: Kusto.Language.Symbols.CommandSymbol | null;
        CreateTempStorage: Kusto.Language.Symbols.CommandSymbol | null;
        DropTempStorage: Kusto.Language.Symbols.CommandSymbol | null;
        DropStoredQueryResultContainers: Kusto.Language.Symbols.CommandSymbol | null;
        DropUnusedStoredQueryResultContainers: Kusto.Language.Symbols.CommandSymbol | null;
        EnableDatabaseMaintenanceMode: Kusto.Language.Symbols.CommandSymbol | null;
        DisableDatabaseMaintenanceMode: Kusto.Language.Symbols.CommandSymbol | null;
        ShowQueryCallTree: Kusto.Language.Symbols.CommandSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.CommandSymbol> | null;
    }
    var EngineCommands: EngineCommandsFunc;

    interface DiagnosticSeverity {
    }
    interface DiagnosticSeverityFunc extends Function {
        prototype: DiagnosticSeverity;
        new (): DiagnosticSeverity;
        /**
         * A diagnostic that represents code that will fail to execute.
         *
         * @static
         * @public
         * @memberof Kusto.Language.DiagnosticSeverity
         * @constant
         * @default "Error"
         * @type string
         */
        Error: string | null;
        /**
         * A diagnostic that represents code that will execute but with possible unintended consequence.
         *
         * @static
         * @public
         * @memberof Kusto.Language.DiagnosticSeverity
         * @constant
         * @default "Warning"
         * @type string
         */
        Warning: string | null;
        /**
         * A diagnostic that represents a suggestion to improve the code.
         *
         * @static
         * @public
         * @memberof Kusto.Language.DiagnosticSeverity
         * @constant
         * @default "Suggestion"
         * @type string
         */
        Suggestion: string | null;
        /**
         * A diagnostic that represents information about the code.
         *
         * @static
         * @public
         * @memberof Kusto.Language.DiagnosticSeverity
         * @constant
         * @default "Information"
         * @type string
         */
        Information: string | null;
        /**
         * A diagnostic that is not meant to be relayed to the user.
         *
         * @static
         * @public
         * @memberof Kusto.Language.DiagnosticSeverity
         * @constant
         * @default "Hidden"
         * @type string
         */
        Hidden: string | null;
    }
    var DiagnosticSeverity: DiagnosticSeverityFunc;

    interface DiagnosticFacts {
    }
    interface DiagnosticFactsFunc extends Function {
        prototype: DiagnosticFacts;
        new (): DiagnosticFacts;
        GetMissingText(text: string | null): Kusto.Language.Diagnostic | null;
        GetUnexpectedCharacter(text: string | null): Kusto.Language.Diagnostic | null;
        GetMalformedToken(term: string | null): Kusto.Language.Diagnostic | null;
        GetMalformedLiteral(): Kusto.Language.Diagnostic | null;
        GetTermsExpected(terms: string[] | null): Kusto.Language.Diagnostic | null;
        GetTokenExpected(kinds: Kusto.Language.Syntax.SyntaxKind[] | null): Kusto.Language.Diagnostic | null;
        GetTokenExpected$2(kinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null): Kusto.Language.Diagnostic | null;
        GetTokenExpected$1(texts: System.Collections.Generic.IEnumerable$1<string> | null): Kusto.Language.Diagnostic | null;
        GetTokenExpected$3(tokens: string[] | null): Kusto.Language.Diagnostic | null;
        GetMissingName(): Kusto.Language.Diagnostic | null;
        GetMissingValue(): Kusto.Language.Diagnostic | null;
        GetMissingExpression(): Kusto.Language.Diagnostic | null;
        GetMissingNumber(): Kusto.Language.Diagnostic | null;
        GetMissingString(): Kusto.Language.Diagnostic | null;
        GetMissingBoolean(): Kusto.Language.Diagnostic | null;
        GetMissingTypeOfLiteral(): Kusto.Language.Diagnostic | null;
        GetMissingFunctionCall(): Kusto.Language.Diagnostic | null;
        GetMissingFunctionDeclaration(): Kusto.Language.Diagnostic | null;
        GetMissingTypeName(): Kusto.Language.Diagnostic | null;
        GetMissingParameter(): Kusto.Language.Diagnostic | null;
        GetMissingFirstOrLast(): Kusto.Language.Diagnostic | null;
        GetMissingAllLastOrNone(): Kusto.Language.Diagnostic | null;
        GetMissingJsonValue(): Kusto.Language.Diagnostic | null;
        GetMissingJoinOnClause(): Kusto.Language.Diagnostic | null;
        GetMissingJsonPair(): Kusto.Language.Diagnostic | null;
        GetMissingStatement(): Kusto.Language.Diagnostic | null;
        GetMissingPatternMatch(): Kusto.Language.Diagnostic | null;
        GetMissingClause(): Kusto.Language.Diagnostic | null;
        GetMissingClause$1(clauseName: string | null): Kusto.Language.Diagnostic | null;
        GetMissingSchemaDeclaration(): Kusto.Language.Diagnostic | null;
        GetParsePatternMustStartWithColumnNameOrStar(): Kusto.Language.Diagnostic | null;
        GetParsePatternNameDoesNotFollowStringLiteral(): Kusto.Language.Diagnostic | null;
        GetParsePatternStringLiteralMustFollowStar(): Kusto.Language.Diagnostic | null;
        GetParsePatternUsingStarAfterStringColumnIsAmbiguous(): Kusto.Language.Diagnostic | null;
        GetInvalidPatternPart(): Kusto.Language.Diagnostic | null;
        GetIdentifierNameOnly(): Kusto.Language.Diagnostic | null;
        GetOperatorNotDefined(name: string | null, argumentTypes: Kusto.Language.Symbols.TypeSymbol[] | null): Kusto.Language.Diagnostic | null;
        GetOperatorNotDefined$1(name: string | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Diagnostic | null;
        GetTypeExpected(type: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Diagnostic | null;
        GetTypeExpected$1(types: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Diagnostic | null;
        GetScalarTypeExpected(): Kusto.Language.Diagnostic | null;
        GetColumnExpected(): Kusto.Language.Diagnostic | null;
        GetRenameAssignmentExpected(): Kusto.Language.Diagnostic | null;
        GetTableExpected(): Kusto.Language.Diagnostic | null;
        GetTableOrScalarExpected(): Kusto.Language.Diagnostic | null;
        GetSingleColumnTableExpected(): Kusto.Language.Diagnostic | null;
        GetDatabaseExpected(): Kusto.Language.Diagnostic | null;
        GetClusterExpected(): Kusto.Language.Diagnostic | null;
        GetTypeNotAllowed(type: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Diagnostic | null;
        GetFunctionRequiresArgumentList(functionName: string | null): Kusto.Language.Diagnostic | null;
        GetArgumentCountExpected(count: number): Kusto.Language.Diagnostic | null;
        GetFunctionExpectsArgumentCountExact(functionName: string | null, count: number): Kusto.Language.Diagnostic | null;
        GetFunctionExpectsArgumentCountRange(functionName: string | null, min: number, max: number): Kusto.Language.Diagnostic | null;
        GetFunctionHasIncorrectNumberOfArguments(): Kusto.Language.Diagnostic | null;
        GetScalarFunctionNotDefined(name: string | null): Kusto.Language.Diagnostic | null;
        GetAggregateFunctionNotDefined(name: string | null): Kusto.Language.Diagnostic | null;
        GetPlugInFunctionNotDefined(name: string | null): Kusto.Language.Diagnostic | null;
        GetPlugInFunctionIsNotEnabled(name: string | null): Kusto.Language.Diagnostic | null;
        GetPluginNotAllowedInThisContext(name: string | null): Kusto.Language.Diagnostic | null;
        GetFunctionNotDefinedWithMatchingParameters(name: string | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null): Kusto.Language.Diagnostic | null;
        GetNameIsNotAFunction(name: string | null): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeConstant(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeConstantOrIdentifier(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeLiteral(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeLiteralScalarValue(): Kusto.Language.Diagnostic | null;
        GetExpressionMustNotBeEmpty(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeInteger(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeRealOrDecimal(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeIntegerOrDynamic(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeNumeric(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeNumericOrBool(): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeSummable(): Kusto.Language.Diagnostic | null;
        GetMultiValuedExpressionCannotBeAssignedToVariable(): Kusto.Language.Diagnostic | null;
        GetExpressionMustHaveValue$1<T>(T: {prototype: T}, values: System.Collections.Generic.IReadOnlyList$1<T> | null): Kusto.Language.Diagnostic | null;
        GetExpressionMustHaveValue<T>(T: {prototype: T}, values: T[] | null): Kusto.Language.Diagnostic | null;
        GetExpressionMustHaveType$1<S>(S: {prototype: S}, types: System.Collections.Generic.IReadOnlyList$1<S> | null): Kusto.Language.Diagnostic | null;
        GetExpressionMustHaveType<S>(S: {prototype: S}, types: S[] | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownItem(name: string | null): Kusto.Language.Diagnostic | null;
        GetFunctionNotDefined(name: string | null): Kusto.Language.Diagnostic | null;
        GetAggregateNotAllowedInThisContext(name: string | null): Kusto.Language.Diagnostic | null;
        GetColumnMustExistOnBothSidesOfJoin(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameRefersToMoreThanOneItem(name: string | null): Kusto.Language.Diagnostic | null;
        GetTheElementAccessOperatorIsNotAllowedInThisContext(): Kusto.Language.Diagnostic | null;
        GetTheExpressionHasNoName(): Kusto.Language.Diagnostic | null;
        GetTheExpressionDoesNotHaveMultipleValues(): Kusto.Language.Diagnostic | null;
        GetTheNameDoesNotHaveCorrespondingExpression(): Kusto.Language.Diagnostic | null;
        GetInvalidTypeName(name: string | null): Kusto.Language.Diagnostic | null;
        GetInvalidColumnDeclaration(): Kusto.Language.Diagnostic | null;
        GetDuplicateColumnDeclaration(name: string | null): Kusto.Language.Diagnostic | null;
        GetInvalidTypeExpression(): Kusto.Language.Diagnostic | null;
        GetIncorrectNumberOfDataValues(multiple: number): Kusto.Language.Diagnostic | null;
        GetQueryOperatorCannotBeFirst(): Kusto.Language.Diagnostic | null;
        GetQueryOperatorMustBeFirst(): Kusto.Language.Diagnostic | null;
        GetQueryOperatorExpected(): Kusto.Language.Diagnostic | null;
        GetQueryOperatorNotAllowedInContext(name: string | null): Kusto.Language.Diagnostic | null;
        GetTypeIsNotIntervalType(intervalType: Kusto.Language.Symbols.Symbol | null, rangeType: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Diagnostic | null;
        GetUnknownQueryOperatorParameterName(name: string | null): Kusto.Language.Diagnostic | null;
        GetParameterAlreadySpecified(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToTable(name: string | null): Kusto.Language.Diagnostic | null;
        GetInvalidJoinCondition(): Kusto.Language.Diagnostic | null;
        GetInvalidJoinConditionOperand(prefix: string | null): Kusto.Language.Diagnostic | null;
        GetTheExpressionRefersToMoreThanOneColumn(): Kusto.Language.Diagnostic | null;
        GetPackMustBeLastItemInList(): Kusto.Language.Diagnostic | null;
        GetValueCountMustEqualParameterCount(): Kusto.Language.Diagnostic | null;
        GetPathValueWithNoPathParameter(): Kusto.Language.Diagnostic | null;
        GetPathValueExpected(): Kusto.Language.Diagnostic | null;
        GetNoPatternMatchesArguments(): Kusto.Language.Diagnostic | null;
        GetDefaultValueExpected(): Kusto.Language.Diagnostic | null;
        GetTableHasNoColumns(): Kusto.Language.Diagnostic | null;
        GetStarExpressionNotAllowed(): Kusto.Language.Diagnostic | null;
        GetStarExpressionMustBeLastArgument(): Kusto.Language.Diagnostic | null;
        GetNamedArgumentsNotSupported(): Kusto.Language.Diagnostic | null;
        GetCompoundNamedArgumentsNotSupported(): Kusto.Language.Diagnostic | null;
        GetUnnamedArgumentAfterOutofOrderNamedArgument(): Kusto.Language.Diagnostic | null;
        GetUnknownArgumentName(): Kusto.Language.Diagnostic | null;
        GetMissingArgumentForParameter(parameterName: string | null): Kusto.Language.Diagnostic | null;
        GetIncompleteFragment(): Kusto.Language.Diagnostic | null;
        GetNoColumnsInScope(): Kusto.Language.Diagnostic | null;
        GetErrorInExpansion(name: string | null, errors: string | null): Kusto.Language.Diagnostic | null;
        GetVariableAlreadyDeclared(name: string | null): Kusto.Language.Diagnostic | null;
        GetMaterializedViewNameMustBeStringLiteral(): Kusto.Language.Diagnostic | null;
        AnalysisFailure(analyzerName: string | null, message: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownTable(name: string | null): Kusto.Language.Diagnostic | null;
        GetFuzzyUnionOperandNotDefined(name: string | null): Kusto.Language.Diagnostic | null;
        GetExpressionMustBeOrderable(): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownCluster(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownDatabase(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownExternalTable(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownMaterializedView(name: string | null): Kusto.Language.Diagnostic | null;
        GetNameDoesNotReferToAnyKnownFunction(name: string | null): Kusto.Language.Diagnostic | null;
        GetClientParametersNotSupported(): Kusto.Language.Diagnostic | null;
        GetRawGuidLiteralNotAllowed(): Kusto.Language.Diagnostic | null;
        GetMissingCommand(): Kusto.Language.Diagnostic | null;
    }
    var DiagnosticFacts: DiagnosticFactsFunc;

    interface DiagnosticCategory {
    }
    interface DiagnosticCategoryFunc extends Function {
        prototype: DiagnosticCategory;
        new (): DiagnosticCategory;
        General: string | null;
        Correctness: string | null;
        Performance: string | null;
    }
    var DiagnosticCategory: DiagnosticCategoryFunc;

    interface Diagnostic {
        /**
         * The code that uniquely identifies the specific kind of diagnostic.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Diagnostic
         * @function Code
         * @type string
         */
        Code: string | null;
        /**
         * The category of the diagnostic; Correctness, Performance, General, etc
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Diagnostic
         * @function Category
         * @type string
         */
        Category: string | null;
        /**
         * The severity of the diagnostic; Error, Warning, Suggestion, etc
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Diagnostic
         * @function Severity
         * @type string
         */
        Severity: string | null;
        /**
         * A short description of the diagnostic.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Diagnostic
         * @function Description
         * @type string
         */
        Description: string | null;
        /**
         * The message of the diagnostic.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Diagnostic
         * @function Message
         * @type string
         */
        Message: string | null;
        /**
         * True if the diagnostic has a source location
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Diagnostic
         * @function HasLocation
         * @type boolean
         */
        HasLocation: boolean;
        /**
         * Start of diagnostic location in the source.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Diagnostic
         * @function Start
         * @type number
         */
        Start: number;
        /**
         * Length of diagnostic location in the source.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Diagnostic
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The position after the end of the diagnostic in source.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Diagnostic
         * @function End
         * @type number
         */
        End: number;
        WithCode(code: string | null): Kusto.Language.Diagnostic | null;
        WithCategory(category: string | null): Kusto.Language.Diagnostic | null;
        WithSeverity(severity: string | null): Kusto.Language.Diagnostic | null;
        WithMessage(message: string | null): Kusto.Language.Diagnostic | null;
        WithLocation(location: Kusto.Language.Syntax.SyntaxElement | null): Kusto.Language.Diagnostic | null;
        WithLocation$1(start: number, length: number): Kusto.Language.Diagnostic | null;
    }
    interface DiagnosticFunc extends Function {
        prototype: Diagnostic;
        ctor: {
            new (code: string | null, message: string | null): Diagnostic
        };
        $ctor1: {
            new (code: string | null, category: string | null, severity: string | null, description: string | null): Diagnostic
        };
        $ctor2: {
            new (code: string | null, category: string | null, severity: string | null, description: string | null, message: string | null): Diagnostic
        };
        NoDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
    }
    var Diagnostic: DiagnosticFunc;

    interface DataManagerCommands {
    }
    interface DataManagerCommandsFunc extends Function {
        prototype: DataManagerCommands;
        new (): DataManagerCommands;
        ShowVersion: Kusto.Language.Symbols.CommandSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.CommandSymbol> | null;
    }
    var DataManagerCommands: DataManagerCommandsFunc;

    interface ClusterManagerCommands {
    }
    interface ClusterManagerCommandsFunc extends Function {
        prototype: ClusterManagerCommands;
        new (): ClusterManagerCommands;
        ShowVersion: Kusto.Language.Symbols.CommandSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.CommandSymbol> | null;
    }
    var ClusterManagerCommands: ClusterManagerCommandsFunc;

    interface AriaBridgeCommands {
    }
    interface AriaBridgeCommandsFunc extends Function {
        prototype: AriaBridgeCommands;
        new (): AriaBridgeCommands;
        ShowVersion: Kusto.Language.Symbols.CommandSymbol | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.CommandSymbol> | null;
    }
    var AriaBridgeCommands: AriaBridgeCommandsFunc;

}

    /**
     * @memberof System
     * @callback System.Action
     * @param   {Kusto.Language.Syntax.SyntaxNode}       arg1    
     * @param   {Kusto.Language.Binding.SemanticInfo}    arg2
     * @return  {void}
     */

declare namespace Kusto.Language.Binding {
    /** @namespace Kusto.Language.Binding */

    /**
     * The binder performs general semantic analysis of the syntax tree, 
     identifying the symbols corresponding to named references, 
     the return types of operations and generating error diagnostics.
     *
     * @class Kusto.Language.Binding.Binder
     */
    interface Binder {
        RowScopeOrEmpty: Kusto.Language.Symbols.TableSymbol | null;
        RightRowScopeOrEmpty: Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Sets the context of the binder to the specified node and text position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxNode}    contextNode    
         * @param   {number}                              position
         * @return  {void}
         */
        /**
         * Binds a function call or pattern invocation expression
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall
         * @return  {Kusto.Language.Binding.SemanticInfo}
         */
        /**
         * Binds a function call
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall    
         * @param   {Kusto.Language.Symbols.FunctionSymbol}           fn
         * @return  {Kusto.Language.Binding.SemanticInfo}
         */
        /**
         * Binds a pattern
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall    
         * @param   {Kusto.Language.Symbols.PatternSymbol}            pattern
         * @return  {Kusto.Language.Binding.SemanticInfo}
         */
        /**
         * Gets the set of pattern signatures that match the arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures            
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.List$1}             matchingSignatures
         * @return  {void}
         */
        /**
         * Determines if the pattern signature matches the arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.PatternSignature}       signature    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments    
         * @param   {boolean}                                       exact
         * @return  {boolean}
         */
        /**
         * Gets the return type of the set of pattern signatures.
         The return type is either the type of the signature body if there is no path,
         or a database symbol containing variables named for each path.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Extracts the argument expressions and their result types into two separate lists.
         Handles the special case of the implicit invoke operator argument
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    functionCall     
         * @param   {System.Collections.Generic.List$1}               arguments        
         * @param   {System.Collections.Generic.List$1}               argumentTypes
         * @return  {void}
         */
        /**
         * Gets the result information for the function call or operator invocation when invoked with the specified arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
         * @param   {System.Collections.Generic.List$1}             diagnostics
         * @return  {Kusto.Language.Binding.FunctionCallResult}
         */
        /**
         * Gets the result information of the function call or operator invocation when invoked with the specified arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes         
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters    
         * @param   {System.Collections.Generic.List$1}             diagnostics
         * @return  {Kusto.Language.Binding.FunctionCallResult}
         */
        /**
         * Gets the cluster for the specified name, or an empty open cluster.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                                  name           
         * @param   {Kusto.Language.Syntax.SyntaxNode}        location       
         * @param   {System.Collections.Generic.List$1}       diagnostics
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        /**
         * Gets the result for an invocation of the database() function
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               nameOrPattern    
         * @param   {Kusto.Language.Syntax.SyntaxNode}     location         
         * @param   {System.Collections.Generic.List$1}    diagnostics
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the named database or group of databases
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               nameOrPattern     
         * @param   {Kusto.Language.Symbols.Symbol}        clusterOrGroup
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the result of calling the table() function in the current context.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               nameOrPattern    
         * @param   {Kusto.Language.Syntax.SyntaxNode}     location         
         * @param   {System.Collections.Generic.List$1}    diagnostics
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the matching table or group of tables
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               nameOrPattern      
         * @param   {Kusto.Language.Symbols.Symbol}        databaseOrGroup
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets all matching tables
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                                   nameOrPattern    
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database         
         * @param   {System.Collections.Generic.List$1}        matches
         * @return  {void}
         */
        /**
         * Gets the result of calling the external_table() function in the current context.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               name           
         * @param   {Kusto.Language.Syntax.SyntaxNode}     location       
         * @param   {System.Collections.Generic.List$1}    diagnostics
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the result of calling the materialized_view() function in the current context.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                               name           
         * @param   {Kusto.Language.Syntax.SyntaxNode}     location       
         * @param   {System.Collections.Generic.List$1}    diagnostics
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the common return type across a set of signatures, or error if there is no common type.
         The common return type is the return type all the signatures share, or the error type if the return types differ.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures       
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Gets the signatures that best match the specified arguments.
         If there is no best match, then multiple signatures will be returned.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    signatures       
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
         * @param   {System.Collections.Generic.List$1}             result
         * @return  {void}
         */
        /**
         * Determines if {@link } is a better match than {@link } for the specified arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature1       
         * @param   {Kusto.Language.Symbols.Signature}              signature2       
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {boolean}
         */
        /**
         * Determines if {@link } is a better match than {@link } for the specified argument at the corresponding parameter position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature1       
         * @param   {Kusto.Language.Symbols.Signature}              signature2       
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
         * @param   {number}                                        argumentIndex
         * @return  {boolean}
         */
        /**
         * Determines the number of arguments that match their corresponding signature parameter.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {number}
         */
        /**
         * Gets {@link } for computed functions that have bodies that must be parsed and bound before understanding the result type.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {Kusto.Language.Binding.FunctionCallResult}
         */
        /**
         * Gets the inline expansion of a function call
         *
         * @instance
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
         * @param   {Kusto.Language.Binding.LocalScope}             outerScope
         * @return  {Kusto.Language.FunctionCallExpansion}
         */
        /**
         * True if the signature is declared by a symbol that is part of database known to the current {@link }
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}    signature
         * @return  {boolean}
         */
        /**
         * Gets the {@link } for the function invocation
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}            expr
         * @return  {Kusto.Language.Symbols.FunctionBodyFlags}
         */
        GetDeclaredAndInferredColumns(table: Kusto.Language.Symbols.TableSymbol | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        TryGetDeclaredOrInferredColumn(table: Kusto.Language.Symbols.TableSymbol | null, name: string | null, column: {v: Kusto.Language.Symbols.ColumnSymbol | null}): boolean;
        /**
         * Gets a tuple with the same columns (declared and inferred) as the table.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.TableSymbol}    table
         * @return  {Kusto.Language.Symbols.TupleSymbol}
         */
        /**
         * A table that contains all the columns in the specified list of tables, unified on name.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * A table that contains all the columns in the specified list of tables, unified on name and type.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * A table that contains the common columns in the specified list of tables.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    tables
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * Gets the {@link } in effect for a function's arguments.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    fc            
         * @param   {Kusto.Language.Binding.ScopeKind}                outerScope
         * @return  {Kusto.Language.Binding.ScopeKind}
         */
        /**
         * Gets the type referenced in the type expression.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.TypeExpression}    typeExpression    
         * @param   {System.Collections.Generic.List$1}       diagnostics
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Checks that the data value expressions have the types corresponding to the columns.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxList$1}    expressions    
         * @param   {System.Collections.Generic.List$1}     columns        
         * @param   {System.Collections.Generic.List$1}     diagnostics
         * @return  {void}
         */
        /**
         * Checks the invocation of a method/operator signature
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    
         * @param   {Kusto.Language.Syntax.SyntaxElement}           location         
         * @param   {System.Collections.Generic.List$1}             dx
         * @return  {void}
         */
        /**
         * True if named arguments are allowed for this signature.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}    signature
         * @return  {boolean}
         */
        IsInsideDatabaseFunctionDeclaration(location: Kusto.Language.Syntax.SyntaxNode | null): boolean;
        /**
         * Creates projection columns for all the expressions.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxList$1}          expressions    
         * @param   {Kusto.Language.Binding.ProjectionBuilder}    builder        
         * @param   {System.Collections.Generic.List$1}           diagnostics    
         * @param   {number}                                      style          
         * @param   {boolean}                                     doNotRepeat
         * @return  {void}
         */
        /**
         * Creates projection columns for the expression.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}            expression     
         * @param   {Kusto.Language.Binding.ProjectionBuilder}    builder        
         * @param   {System.Collections.Generic.List$1}           diagnostics    
         * @param   {number}                                      style          
         * @param   {boolean}                                     doNotRepeat    
         * @param   {Kusto.Language.Symbols.TypeSymbol}           columnType     
         * @param   {string}                                      columnName
         * @return  {void}
         */
        /**
         * Adds all the columns declared by the symbol to the list of columns.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Symbol}        symbol     
         * @param   {System.Collections.Generic.List$1}    columns
         * @return  {void}
         */
        /**
         * Add the table (or all the tables in a group) to the list of tables.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Symbol}        symbol    
         * @param   {System.Collections.Generic.List$1}    tables
         * @return  {void}
         */
        /**
         * Gets a table representing the aggregate set of columns in scope
         for find operator expressions.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FindOperator}    node
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * Get the set of tables applicable to the find operator.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FindOperator}            node
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        /**
         * Gets the set of columns from the tables applicable to the search operator.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SearchOperator}    node
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * Gets the set of tables used by the search operator
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SearchOperator}          node
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        /**
         * Gets all the tables accessible to the current operator through osmosis,
         not from pipe operator or sub clause.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        /**
         * Gets all the declared views in scope
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.List$1}    views
         * @return  {void}
         */
        /**
         * Gets the set of tables referenced by the entity expressions, 
         where each expression is a reference to a table or group of tables.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxList$1}            list
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        /**
         * Gets the columns referenced by all expressions
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxList$1}    expressions    
         * @param   {System.Collections.Generic.List$1}     columns        
         * @param   {System.Collections.Generic.List$1}     diagnostics
         * @return  {void}
         */
        /**
         * Gets the columns referenced by one expression.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}     expression     
         * @param   {System.Collections.Generic.List$1}    columns        
         * @param   {System.Collections.Generic.List$1}    diagnostics
         * @return  {void}
         */
        /**
         * Gets all the columns referenced in the syntax tree.
         *
         * @instance
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxNode}     node       
         * @param   {System.Collections.Generic.List$1}    columns
         * @return  {void}
         */
    }
    interface BinderFunc extends Function {
        prototype: Binder;
        AsContextBuilder: Kusto.Language.Binding.Binder.AsContextBuilderFunc;
        ProjectionStyle: Binder.ProjectionStyleFunc;
        ContextBuilder: Kusto.Language.Binding.Binder.ContextBuilderFunc;
        SearchPredicateBinder: Kusto.Language.Binding.Binder.SearchPredicateBinderFunc;
        TreeBinder: Kusto.Language.Binding.Binder.TreeBinderFunc;
        NodeBinder: Kusto.Language.Binding.Binder.NodeBinderFunc;
        /**
         * Do semantic analysis over the syntax tree.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxTree}            tree                  
         * @param   {Kusto.Language.GlobalState}                  globals               
         * @param   {Kusto.Language.Binding.LocalBindingCache}    localBindingCache     
         * @param   {System.Action}                               semanticInfoSetter    
         * @param   {Kusto.Language.Utils.CancellationToken}      cancellationToken
         * @return  {boolean}
         */
        TryBind(tree: Kusto.Language.Syntax.SyntaxTree | null, globals: Kusto.Language.GlobalState | null, localBindingCache?: Kusto.Language.Binding.LocalBindingCache | null, semanticInfoSetter?: {(arg1: Kusto.Language.Syntax.SyntaxNode, arg2: Kusto.Language.Binding.SemanticInfo): void} | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): boolean;
        /**
         * Do semantic analysis over an inline expansion of a function body.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxTree}            expansionTree      
         * @param   {Kusto.Language.Binding.Binder}               outer              
         * @param   {Kusto.Language.Symbols.ClusterSymbol}        currentCluster     
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}       currentDatabase    
         * @param   {Kusto.Language.Symbols.FunctionSymbol}       currentFunction    
         * @param   {Kusto.Language.Binding.LocalScope}           outerScope         
         * @param   {System.Collections.Generic.IEnumerable$1}    locals
         * @return  {boolean}
         */
        TryBindExpansion(expansionTree: Kusto.Language.Syntax.SyntaxTree | null, outer: Kusto.Language.Binding.Binder | null, currentCluster: Kusto.Language.Symbols.ClusterSymbol | null, currentDatabase: Kusto.Language.Symbols.DatabaseSymbol | null, currentFunction: Kusto.Language.Symbols.FunctionSymbol | null, outerScope: Kusto.Language.Binding.LocalScope | null, locals: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null): boolean;
        /**
         * Gets the computed return type for functions specified with a body or declaration.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {Kusto.Language.GlobalState}                    globals          
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetComputedReturnType(signature: Kusto.Language.Symbols.Signature | null, globals: Kusto.Language.GlobalState | null, argumentTypes?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the symbol that would be referenced at the specified location.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
         * @param   {number}                                    position             
         * @param   {string}                                    name                 
         * @param   {Kusto.Language.GlobalState}                globals              
         * @param   {Kusto.Language.Symbols.SymbolMatch}        match                
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Symbols.Symbol}
         */
        GetReferencedSymbol(tree: Kusto.Language.Syntax.SyntaxTree | null, position: number, name: string | null, globals: Kusto.Language.GlobalState | null, match: Kusto.Language.Symbols.SymbolMatch, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Symbols.Symbol | null;
        /**
         * Gets the {@link } that is in scope as the implicit set of columns accessible within a query.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
         * @param   {number}                                    position             
         * @param   {Kusto.Language.GlobalState}                globals              
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        GetRowScope(tree: Kusto.Language.Syntax.SyntaxTree | null, position: number, globals: Kusto.Language.GlobalState | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets all the symbols that are in scope at the text position.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxTree}          tree                 
         * @param   {number}                                    position             
         * @param   {Kusto.Language.GlobalState}                globals              
         * @param   {Kusto.Language.Symbols.SymbolMatch}        match                
         * @param   {Kusto.Language.IncludeFunctionKind}        include              
         * @param   {System.Collections.Generic.List$1}         list                 
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {void}
         */
        GetSymbolsInScope(tree: Kusto.Language.Syntax.SyntaxTree | null, position: number, globals: Kusto.Language.GlobalState | null, match: Kusto.Language.Symbols.SymbolMatch, include: Kusto.Language.IncludeFunctionKind, list: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
        /**
         * Gets the value of the literal if the expression is a literal or refers to literal
         *
         * @static
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}    expression    
         * @param   {System.Object}                       value
         * @return  {boolean}
         */
        /**
         * Determines if the name is a pattern (contains a *)
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}     name
         * @return  {boolean}
         */
        /**
         * Gets the matching databases in the specified cluster
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {string}                                  nameOrPattern    
         * @param   {Kusto.Language.Symbols.ClusterSymbol}    cluster          
         * @param   {System.Collections.Generic.List$1}       matches
         * @return  {void}
         */
        /**
         * Determines if {@link } can be promoted to {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.TypeSymbol}    type1    
         * @param   {Kusto.Language.Symbols.TypeSymbol}    type2
         * @return  {boolean}
         */
        IsPromotable(type1: Kusto.Language.Symbols.TypeSymbol | null, type2: Kusto.Language.Symbols.TypeSymbol | null): boolean;
        /**
         * Promotes a type to its most general form.  int -&gt; long, decimal -&gt; real
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.TypeSymbol}    symbol
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        Promote(symbol: Kusto.Language.Symbols.TypeSymbol | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the widest numeric type of the argument types.
         The widest type is the one that can contain the values of all the other types:
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature        
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetWidestArgumentType(signature: Kusto.Language.Symbols.Signature | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the common argument type for arguments corresponding to parameters constrained to specific {@link }.CommonXXX values.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetCommonArgumentType(argumentParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the common scalar type amongst a set of types.
         This is either the one type if they are all them same type, the most promoted of the types, or the common type of the types that are not dynamic.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Array.<Kusto.Language.Symbols.TypeSymbol>}    types
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        /**
         * Determines the kind of match that the argument has with its corresponding signature parameter.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}              signature                      
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes                  
         * @param   {Kusto.Language.Symbols.Parameter}              parameter                      
         * @param   {Kusto.Language.Syntax.Expression}              argument                       
         * @param   {Kusto.Language.Symbols.TypeSymbol}             argumentType                   
         * @param   {boolean}                                       allowLooseParameterMatching
         * @return  {Kusto.Language.Binding.ParameterMatchKind}
         */
        GetParameterMatchKind(signature: Kusto.Language.Symbols.Signature | null, argumentParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, parameter: Kusto.Language.Symbols.Parameter | null, argument: Kusto.Language.Syntax.Expression | null, argumentType: Kusto.Language.Symbols.TypeSymbol | null, allowLooseParameterMatching: boolean): Kusto.Language.Binding.ParameterMatchKind;
        /**
         * Builds an expanded declaration of the function customized given the arguments used at the call site.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Signature}    signature
         * @return  {string}
         */
        /**
         * Entry point for {@link } to access the cache.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.FunctionSymbol}       symbol     
         * @param   {Kusto.Language.GlobalState}                  globals    
         * @param   {Kusto.Language.Symbols.FunctionBodyFacts}    facts
         * @return  {boolean}
         */
        TryGetDatabaseFunctionBodyFacts(symbol: Kusto.Language.Symbols.FunctionSymbol | null, globals: Kusto.Language.GlobalState | null, facts: {v: Kusto.Language.Symbols.FunctionBodyFacts | null}): boolean;
        IsOrderable(type: Kusto.Language.Symbols.TypeSymbol | null): boolean;
        SymbolsAssignable$1(targetTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, sourceType: Kusto.Language.Symbols.Symbol | null, conversion?: Kusto.Language.Binding.Conversion): boolean;
        /**
         * True if a value of type {@link } can be assigned to a parameter of type {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.Symbol}        targetType    
         * @param   {Kusto.Language.Symbols.Symbol}        sourceType    
         * @param   {Kusto.Language.Binding.Conversion}    conversion
         * @return  {boolean}
         */
        SymbolsAssignable(targetType: Kusto.Language.Symbols.Symbol | null, sourceType: Kusto.Language.Symbols.Symbol | null, conversion?: Kusto.Language.Binding.Conversion): boolean;
        MembersEqual(target: Kusto.Language.Symbols.Symbol | null, source: Kusto.Language.Symbols.Symbol | null): boolean;
        /**
         * True if a table value can be assigned to a parameter of a specific table type.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.TableSymbol}    target    
         * @param   {Kusto.Language.Symbols.TableSymbol}    source
         * @return  {boolean}
         */
        /**
         * True if any argument type is an error type or unknown.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes
         * @return  {boolean}
         */
        /**
         * True if member access operators (dot) on this apply to the members
         as opposed to matching the members themselves.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.GroupSymbol}    group
         * @return  {boolean}
         */
        /**
         * Determine if the element (a name) is in a known tabular context
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxElement}    element
         * @return  {boolean}
         */
        /**
         * Determine if the element is the operand of a fuzzy union
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SyntaxElement}    element
         * @return  {boolean}
         */
        GetResultColumn(expr: Kusto.Language.Syntax.Expression | null): Kusto.Language.Symbols.ColumnSymbol | null;
        IsConversionFunction$1(expr: Kusto.Language.Syntax.Expression | null): boolean;
        IsConversionFunction(fn: Kusto.Language.Symbols.FunctionSymbol | null): boolean;
        /**
         * Gets the name that a function call expression will use as its column name in a projection.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.FunctionCallExpression}    fc             
         * @param   {string}                                          defaultName    
         * @param   {Kusto.Language.Symbols.TableSymbol}              row
         * @return  {string}
         */
        /**
         * Gets the name that an expression will use for its column name in a projection.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}      expr           
         * @param   {string}                                defaultName    
         * @param   {Kusto.Language.Symbols.TableSymbol}    row
         * @return  {string}
         */
        GetExpressionResultName(expr: Kusto.Language.Syntax.Expression | null, defaultName?: string | null, row?: Kusto.Language.Symbols.TableSymbol | null): string | null;
        /**
         * Gets the declared name of a {@link } or null.
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}    expr
         * @return  {string}
         */
        GetExpressionDeclaredName(expr: Kusto.Language.Syntax.Expression | null): string | null;
        /**
         * Gets the expression underlying adornments such as name assignment or ordering
         *
         * @static
         * @public
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.Expression}    expression
         * @return  {Kusto.Language.Syntax.Expression}
         */
        GetUnderlyingExpression(expression: Kusto.Language.Syntax.Expression | null): Kusto.Language.Syntax.Expression | null;
        GetNameDeclarationName(expr: Kusto.Language.Syntax.Expression | null): string | null;
        /**
         * Converts a list of columns into a list of unique (unioned columns)
         Columns with the same name and type will be merged into one column.
         Columns with the same name but different type will be renamed to include the type name as a suffix.
         *
         * @static
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.List$1}    columns
         * @return  {void}
         */
        /**
         * Converts list of columns to a list of columns with distinct names.
         If multiple columns have the same name, but differ in type, the resulting single columns has the type dynamic.
         *
         * @static
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.List$1}    columns
         * @return  {void}
         */
        /**
         * Converts a list of columns into a list of unique columns by name.
         Columns with the same name will be renamed to include a numeric suffix.
         *
         * @static
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.List$1}    columns
         * @return  {void}
         */
        /**
         * Builds a map between names and columns with that name.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.List$1}          columns
         * @return  {System.Collections.Generic.Dictionary$2}
         */
        /**
         * Gets the columns that appear in both list of columns (by name)
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsA    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsB    
         * @param   {System.Collections.Generic.List$1}             result
         * @return  {void}
         */
        /**
         * Gets the columns that appear in both list of columns (by name)
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsA    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    columnsB    
         * @param   {System.Collections.Generic.List$1}             result
         * @return  {void}
         */
        /**
         * Gets the columns that appear in all tables.
         *
         * @static
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {System.Collections.Generic.IReadOnlyList$1}    tables    
         * @param   {System.Collections.Generic.List$1}             common
         * @return  {void}
         */
        /**
         * Gets a column with a unique name (given a set of already used names).
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Symbols.ColumnSymbol}     column         
         * @param   {Kusto.Language.Utils.UniqueNameTable}    uniqueNames
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        /**
         * Creates column symbols for all the columns declared in the schema.
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.SchemaTypeExpression}    schema           
         * @param   {System.Collections.Generic.List$1}             columns          
         * @param   {System.Collections.Generic.HashSet$1}          declaredNames    
         * @param   {System.Collections.Generic.List$1}             diagnostics
         * @return  {void}
         */
        /**
         * Creates a column symbol for the column declared by the {@link }
         *
         * @static
         * @private
         * @this Kusto.Language.Binding.Binder
         * @memberof Kusto.Language.Binding.Binder
         * @param   {Kusto.Language.Syntax.NameAndTypeDeclaration}    declaration      
         * @param   {System.Collections.Generic.List$1}               columns          
         * @param   {System.Collections.Generic.HashSet$1}            declaredNames    
         * @param   {System.Collections.Generic.List$1}               diagnostics
         * @return  {void}
         */
    }
    var Binder: BinderFunc;
    module Binder {
        interface AsContextBuilder extends Kusto.Language.Syntax.DefaultSyntaxVisitor {
            VisitAsOperator(node: Kusto.Language.Syntax.AsOperator | null): void;
            VisitFunctionBody(node: Kusto.Language.Syntax.FunctionBody | null): void;
            VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): void;
            VisitMaterializedViewCombineExpression(node: Kusto.Language.Syntax.MaterializedViewCombineExpression | null): void;
        }
        interface AsContextBuilderFunc extends Function {
            prototype: AsContextBuilder;
            new (position: number, binder: Kusto.Language.Binding.Binder | null): AsContextBuilder;
        }

        interface ProjectionStyle {
        }
        interface ProjectionStyleFunc extends Function {
            prototype: ProjectionStyle;
            Default: number;
            Extend: number;
            Print: number;
            Rename: number;
            Replace: number;
            Reorder: number;
            Summarize: number;
        }

        /**
         * The {@link } is a {@link } that puts
         a {@link } into the same state that existed for a given {@link } during 
         the full semantic analysis.
         *
         * @private
         * @class Kusto.Language.Binding.Binder.ContextBuilder
         * @augments Kusto.Language.Syntax.DefaultSyntaxVisitor
         */
        interface ContextBuilder extends Kusto.Language.Syntax.DefaultSyntaxVisitor {
            VisitPathExpression(node: Kusto.Language.Syntax.PathExpression | null): void;
            VisitElementExpression(node: Kusto.Language.Syntax.ElementExpression | null): void;
            VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): void;
            VisitFunctionCallExpression(node: Kusto.Language.Syntax.FunctionCallExpression | null): void;
            VisitPipeExpression(node: Kusto.Language.Syntax.PipeExpression | null): void;
            VisitEvaluateOperator(node: Kusto.Language.Syntax.EvaluateOperator | null): void;
            VisitSummarizeOperator(node: Kusto.Language.Syntax.SummarizeOperator | null): void;
            VisitNamedParameter(node: Kusto.Language.Syntax.NamedParameter | null): void;
            VisitMakeSeriesOperator(node: Kusto.Language.Syntax.MakeSeriesOperator | null): void;
            VisitTopNestedClause(node: Kusto.Language.Syntax.TopNestedClause | null): void;
            VisitFunctionDeclaration(node: Kusto.Language.Syntax.FunctionDeclaration | null): void;
            VisitFunctionBody(node: Kusto.Language.Syntax.FunctionBody | null): void;
            VisitQueryBlock(node: Kusto.Language.Syntax.QueryBlock | null): void;
            VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): void;
            VisitPatternDeclaration(node: Kusto.Language.Syntax.PatternDeclaration | null): void;
            VisitJoinOperator(node: Kusto.Language.Syntax.JoinOperator | null): void;
            VisitLookupOperator(node: Kusto.Language.Syntax.LookupOperator | null): void;
            VisitUnionOperator(node: Kusto.Language.Syntax.UnionOperator | null): void;
            VisitFindOperator(node: Kusto.Language.Syntax.FindOperator | null): void;
            VisitSearchOperator(node: Kusto.Language.Syntax.SearchOperator | null): void;
            VisitMvApplyOperator(node: Kusto.Language.Syntax.MvApplyOperator | null): void;
            VisitInvokeOperator(node: Kusto.Language.Syntax.InvokeOperator | null): void;
            VisitPartitionOperator(node: Kusto.Language.Syntax.PartitionOperator | null): void;
            VisitScanOperator(node: Kusto.Language.Syntax.ScanOperator | null): void;
            VisitCustomCommand(node: Kusto.Language.Syntax.CustomCommand | null): void;
            VisitInExpression(node: Kusto.Language.Syntax.InExpression | null): void;
            VisitToScalarExpression(node: Kusto.Language.Syntax.ToScalarExpression | null): void;
            VisitToTableExpression(node: Kusto.Language.Syntax.ToTableExpression | null): void;
            VisitSetOptionStatement(node: Kusto.Language.Syntax.SetOptionStatement | null): void;
        }
        interface ContextBuilderFunc extends Function {
            prototype: ContextBuilder;
            new (binder: Kusto.Language.Binding.Binder | null, position: number): ContextBuilder;
            /**
             * The node ends in a list or optional element
             *
             * @static
             * @private
             * @this Kusto.Language.Binding.Binder.ContextBuilder
             * @memberof Kusto.Language.Binding.Binder.ContextBuilder
             * @param   {Kusto.Language.Syntax.SyntaxNode}    node
             * @return  {boolean}
             */
            /**
             * The node has a missing element as its last child.
             *
             * @static
             * @private
             * @this Kusto.Language.Binding.Binder.ContextBuilder
             * @memberof Kusto.Language.Binding.Binder.ContextBuilder
             * @param   {Kusto.Language.Syntax.SyntaxNode}    node
             * @return  {boolean}
             */
        }

        /**
         * The {@link } handles special binding logic for predicates used by search and find operators.
         *
         * @private
         * @class Kusto.Language.Binding.Binder.SearchPredicateBinder
         * @augments Kusto.Language.Syntax.DefaultSyntaxVisitor
         */
        interface SearchPredicateBinder extends Kusto.Language.Syntax.DefaultSyntaxVisitor {
            RowScopeOrEmpty: Kusto.Language.Symbols.TableSymbol | null;
            VisitStarExpression(node: Kusto.Language.Syntax.StarExpression | null): void;
            VisitLiteralExpression(node: Kusto.Language.Syntax.LiteralExpression | null): void;
            VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): void;
            VisitBinaryExpression(node: Kusto.Language.Syntax.BinaryExpression | null): void;
        }
        interface SearchPredicateBinderFunc extends Function {
            prototype: SearchPredicateBinder;
            new (binder: Kusto.Language.Binding.Binder | null, treeBinder: Kusto.Language.Binding.Binder.TreeBinder | null): SearchPredicateBinder;
        }

        /**
         * The {@link } is a {@link } that orchestrates binding the entire syntax tree.
         From the top down, it adjusts the {@link }'s state to determine symbols in scope for each node and its descendants, etc.
         From bottom up, it invokes the {@link } on each {@link } to evalute its {@link } if any.
         All child nodes are thus bound before any parent nodes.
         *
         * @private
         * @class Kusto.Language.Binding.Binder.TreeBinder
         * @augments Kusto.Language.Syntax.DefaultSyntaxVisitor
         */
        interface TreeBinder extends Kusto.Language.Syntax.DefaultSyntaxVisitor {
            VisitPathExpression(node: Kusto.Language.Syntax.PathExpression | null): void;
            VisitPipeExpression(node: Kusto.Language.Syntax.PipeExpression | null): void;
            VisitLookupOperator(node: Kusto.Language.Syntax.LookupOperator | null): void;
            VisitJoinOperator(node: Kusto.Language.Syntax.JoinOperator | null): void;
            VisitJoinOnClause(node: Kusto.Language.Syntax.JoinOnClause | null): void;
            VisitUnionOperator(node: Kusto.Language.Syntax.UnionOperator | null): void;
            VisitSummarizeOperator(node: Kusto.Language.Syntax.SummarizeOperator | null): void;
            VisitMakeSeriesOperator(node: Kusto.Language.Syntax.MakeSeriesOperator | null): void;
            VisitTopNestedClause(node: Kusto.Language.Syntax.TopNestedClause | null): void;
            VisitAsOperator(node: Kusto.Language.Syntax.AsOperator | null): void;
            VisitPartitionOperator(node: Kusto.Language.Syntax.PartitionOperator | null): void;
            VisitForkOperator(node: Kusto.Language.Syntax.ForkOperator | null): void;
            VisitMaterializedViewCombineExpression(node: Kusto.Language.Syntax.MaterializedViewCombineExpression | null): void;
            VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): void;
            VisitFunctionCallExpression(node: Kusto.Language.Syntax.FunctionCallExpression | null): void;
            VisitInvokeOperator(node: Kusto.Language.Syntax.InvokeOperator | null): void;
            VisitEvaluateOperator(node: Kusto.Language.Syntax.EvaluateOperator | null): void;
            VisitLetStatement(node: Kusto.Language.Syntax.LetStatement | null): void;
            VisitFunctionDeclaration(node: Kusto.Language.Syntax.FunctionDeclaration | null): void;
            VisitFunctionParameters(node: Kusto.Language.Syntax.FunctionParameters | null): void;
            VisitQueryParametersStatement(node: Kusto.Language.Syntax.QueryParametersStatement | null): void;
            VisitScanOperator(node: Kusto.Language.Syntax.ScanOperator | null): void;
            VisitPatternStatement(node: Kusto.Language.Syntax.PatternStatement | null): void;
            VisitPatternDeclaration(node: Kusto.Language.Syntax.PatternDeclaration | null): void;
            VisitAliasStatement(node: Kusto.Language.Syntax.AliasStatement | null): void;
            VisitFindOperator(node: Kusto.Language.Syntax.FindOperator | null): void;
            VisitSearchOperator(node: Kusto.Language.Syntax.SearchOperator | null): void;
            VisitMvApplyOperator(node: Kusto.Language.Syntax.MvApplyOperator | null): void;
            VisitNameReference(node: Kusto.Language.Syntax.NameReference | null): void;
            VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): void;
            VisitToScalarExpression(node: Kusto.Language.Syntax.ToScalarExpression | null): void;
            VisitToTableExpression(node: Kusto.Language.Syntax.ToTableExpression | null): void;
            VisitInExpression(node: Kusto.Language.Syntax.InExpression | null): void;
        }
        interface TreeBinderFunc extends Function {
            prototype: TreeBinder;
            new (binder: Kusto.Language.Binding.Binder | null): TreeBinder;
        }

        /**
         * The {@link } is a {@link } that computes
         the {@link } foreach each kind of {@link }.
         *
         * @private
         * @class Kusto.Language.Binding.Binder.NodeBinder
         * @augments Kusto.Language.Syntax.SyntaxVisitor$1
         */
        interface NodeBinder extends Kusto.Language.Syntax.SyntaxVisitor$1<Kusto.Language.Binding.SemanticInfo> {
            RowScopeOrEmpty: Kusto.Language.Symbols.TableSymbol | null;
            RightRowScopeOrEmpty: Kusto.Language.Symbols.TableSymbol | null;
            VisitNameAndTypeDeclaration(node: Kusto.Language.Syntax.NameAndTypeDeclaration | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFunctionDeclaration(node: Kusto.Language.Syntax.FunctionDeclaration | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFunctionParameter(node: Kusto.Language.Syntax.FunctionParameter | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDefaultValueDeclaration(node: Kusto.Language.Syntax.DefaultValueDeclaration | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFunctionBody(node: Kusto.Language.Syntax.FunctionBody | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFunctionParameters(node: Kusto.Language.Syntax.FunctionParameters | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPatternStatement(node: Kusto.Language.Syntax.PatternStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPatternDeclaration(node: Kusto.Language.Syntax.PatternDeclaration | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMaterializeExpression(node: Kusto.Language.Syntax.MaterializeExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitNameDeclaration(node: Kusto.Language.Syntax.NameDeclaration | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitLiteralExpression(node: Kusto.Language.Syntax.LiteralExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTypeOfLiteralExpression(node: Kusto.Language.Syntax.TypeOfLiteralExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDynamicExpression(node: Kusto.Language.Syntax.DynamicExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCompoundStringLiteralExpression(node: Kusto.Language.Syntax.CompoundStringLiteralExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBinaryExpression(node: Kusto.Language.Syntax.BinaryExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPrefixUnaryExpression(node: Kusto.Language.Syntax.PrefixUnaryExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitInExpression(node: Kusto.Language.Syntax.InExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitHasAnyExpression(node: Kusto.Language.Syntax.HasAnyExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitHasAllExpression(node: Kusto.Language.Syntax.HasAllExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBetweenExpression(node: Kusto.Language.Syntax.BetweenExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitToScalarExpression(node: Kusto.Language.Syntax.ToScalarExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitToTableExpression(node: Kusto.Language.Syntax.ToTableExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTokenName(node: Kusto.Language.Syntax.TokenName | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBracketedName(node: Kusto.Language.Syntax.BracketedName | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBracedName(node: Kusto.Language.Syntax.BracedName | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitWildcardedName(node: Kusto.Language.Syntax.WildcardedName | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBracketedWildcardedName(node: Kusto.Language.Syntax.BracketedWildcardedName | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitNameReference(node: Kusto.Language.Syntax.NameReference | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBracketedExpression(node: Kusto.Language.Syntax.BracketedExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPathExpression(node: Kusto.Language.Syntax.PathExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitElementExpression(node: Kusto.Language.Syntax.ElementExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFunctionCallExpression(node: Kusto.Language.Syntax.FunctionCallExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitEntityGroup(node: Kusto.Language.Syntax.EntityGroup | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitOrderedExpression(node: Kusto.Language.Syntax.OrderedExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSimpleNamedExpression(node: Kusto.Language.Syntax.SimpleNamedExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCompoundNamedExpression(node: Kusto.Language.Syntax.CompoundNamedExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPipeExpression(node: Kusto.Language.Syntax.PipeExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitAtExpression(node: Kusto.Language.Syntax.AtExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDataScopeExpression(node: Kusto.Language.Syntax.DataScopeExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExpressionCouple(node: Kusto.Language.Syntax.ExpressionCouple | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExpressionList(node: Kusto.Language.Syntax.ExpressionList | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitForkExpression(node: Kusto.Language.Syntax.ForkExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPartitionSubquery(node: Kusto.Language.Syntax.PartitionSubquery | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPartitionQuery(node: Kusto.Language.Syntax.PartitionQuery | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPartitionScope(node: Kusto.Language.Syntax.PartitionScope | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJsonArrayExpression(node: Kusto.Language.Syntax.JsonArrayExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJsonObjectExpression(node: Kusto.Language.Syntax.JsonObjectExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJsonPair(node: Kusto.Language.Syntax.JsonPair | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitList(list: Kusto.Language.Syntax.SyntaxList | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSeparatedElement(separatedElement: Kusto.Language.Syntax.SeparatedElement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesExpression(node: Kusto.Language.Syntax.MakeSeriesExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitNamedParameter(node: Kusto.Language.Syntax.NamedParameter | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPackExpression(node: Kusto.Language.Syntax.PackExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPatternMatch(node: Kusto.Language.Syntax.PatternMatch | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPatternPathValue(node: Kusto.Language.Syntax.PatternPathValue | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPatternPathParameter(node: Kusto.Language.Syntax.PatternPathParameter | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPrimitiveTypeExpression(node: Kusto.Language.Syntax.PrimitiveTypeExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSchemaTypeExpression(node: Kusto.Language.Syntax.SchemaTypeExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitQueryBlock(node: Kusto.Language.Syntax.QueryBlock | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSkippedTokens(node: Kusto.Language.Syntax.SkippedTokens | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitRenameList(node: Kusto.Language.Syntax.RenameList | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitNameReferenceList(node: Kusto.Language.Syntax.NameReferenceList | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitStarExpression(node: Kusto.Language.Syntax.StarExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTypedColumnReference(node: Kusto.Language.Syntax.TypedColumnReference | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCustom(node: Kusto.Language.Syntax.CustomNode | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMaterializedViewCombineExpression(node: Kusto.Language.Syntax.MaterializedViewCombineExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMaterializedViewCombineNameClause(node: Kusto.Language.Syntax.MaterializedViewCombineNameClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMaterializedViewCombineClause(node: Kusto.Language.Syntax.MaterializedViewCombineClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBadQueryOperator(node: Kusto.Language.Syntax.BadQueryOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFilterOperator(node: Kusto.Language.Syntax.FilterOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTakeOperator(node: Kusto.Language.Syntax.TakeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSampleOperator(node: Kusto.Language.Syntax.SampleOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSampleDistinctOperator(node: Kusto.Language.Syntax.SampleDistinctOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCountOperator(node: Kusto.Language.Syntax.CountOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitProjectOperator(node: Kusto.Language.Syntax.ProjectOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitProjectAwayOperator(node: Kusto.Language.Syntax.ProjectAwayOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitProjectKeepOperator(node: Kusto.Language.Syntax.ProjectKeepOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitProjectRenameOperator(node: Kusto.Language.Syntax.ProjectRenameOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitProjectReorderOperator(node: Kusto.Language.Syntax.ProjectReorderOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExtendOperator(node: Kusto.Language.Syntax.ExtendOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSummarizeOperator(node: Kusto.Language.Syntax.SummarizeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDistinctOperator(node: Kusto.Language.Syntax.DistinctOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopOperator(node: Kusto.Language.Syntax.TopOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopHittersOperator(node: Kusto.Language.Syntax.TopHittersOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopNestedOperator(node: Kusto.Language.Syntax.TopNestedOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitConsumeOperator(node: Kusto.Language.Syntax.ConsumeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExecuteAndCacheOperator(node: Kusto.Language.Syntax.ExecuteAndCacheOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDataTableExpression(node: Kusto.Language.Syntax.DataTableExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitContextualDataTableExpression(node: Kusto.Language.Syntax.ContextualDataTableExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExternalDataExpression(node: Kusto.Language.Syntax.ExternalDataExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSortOperator(node: Kusto.Language.Syntax.SortOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSerializeOperator(node: Kusto.Language.Syntax.SerializeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitAsOperator(node: Kusto.Language.Syntax.AsOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitForkOperator(node: Kusto.Language.Syntax.ForkOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPartitionOperator(node: Kusto.Language.Syntax.PartitionOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSearchOperator(node: Kusto.Language.Syntax.SearchOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFindOperator(node: Kusto.Language.Syntax.FindOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitUnionOperator(node: Kusto.Language.Syntax.UnionOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitLookupOperator(node: Kusto.Language.Syntax.LookupOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJoinOperator(node: Kusto.Language.Syntax.JoinOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitRangeOperator(node: Kusto.Language.Syntax.RangeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFacetOperator(node: Kusto.Language.Syntax.FacetOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesOperator(node: Kusto.Language.Syntax.MakeSeriesOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvExpandOperator(node: Kusto.Language.Syntax.MvExpandOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvExpandExpression(node: Kusto.Language.Syntax.MvExpandExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvApplyOperator(node: Kusto.Language.Syntax.MvApplyOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvApplyExpression(node: Kusto.Language.Syntax.MvApplyExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvApplySubqueryExpression(node: Kusto.Language.Syntax.MvApplySubqueryExpression | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitPrintOperator(node: Kusto.Language.Syntax.PrintOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitReduceByOperator(node: Kusto.Language.Syntax.ReduceByOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitRenderOperator(node: Kusto.Language.Syntax.RenderOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitParseWhereOperator(node: Kusto.Language.Syntax.ParseWhereOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitParseOperator(node: Kusto.Language.Syntax.ParseOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitInvokeOperator(node: Kusto.Language.Syntax.InvokeOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitEvaluateOperator(node: Kusto.Language.Syntax.EvaluateOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitGetSchemaOperator(node: Kusto.Language.Syntax.GetSchemaOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanOperator(node: Kusto.Language.Syntax.ScanOperator | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanOrderByClause(node: Kusto.Language.Syntax.ScanOrderByClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanPartitionByClause(node: Kusto.Language.Syntax.ScanPartitionByClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanDeclareClause(node: Kusto.Language.Syntax.ScanDeclareClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanAssignment(node: Kusto.Language.Syntax.ScanAssignment | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanStep(node: Kusto.Language.Syntax.ScanStep | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanStepOutput(node: Kusto.Language.Syntax.ScanStepOutput | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitScanComputationClause(node: Kusto.Language.Syntax.ScanComputationClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCountAsIdentifierClause(node: Kusto.Language.Syntax.CountAsIdentifierClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDataScopeClause(node: Kusto.Language.Syntax.DataScopeClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDefaultExpressionClause(node: Kusto.Language.Syntax.DefaultExpressionClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExternalDataWithClause(node: Kusto.Language.Syntax.ExternalDataWithClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFacetWithOperatorClause(node: Kusto.Language.Syntax.FacetWithOperatorClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFacetWithExpressionClause(node: Kusto.Language.Syntax.FacetWithExpressionClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFindInClause(node: Kusto.Language.Syntax.FindInClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitFindProjectClause(node: Kusto.Language.Syntax.FindProjectClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJoinOnClause(node: Kusto.Language.Syntax.JoinOnClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitJoinWhereClause(node: Kusto.Language.Syntax.JoinWhereClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesByClause(node: Kusto.Language.Syntax.MakeSeriesByClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesInRangeClause(node: Kusto.Language.Syntax.MakeSeriesInRangeClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesFromClause(node: Kusto.Language.Syntax.MakeSeriesFromClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesToClause(node: Kusto.Language.Syntax.MakeSeriesToClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesStepClause(node: Kusto.Language.Syntax.MakeSeriesStepClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesFromToStepClause(node: Kusto.Language.Syntax.MakeSeriesFromToStepClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMakeSeriesOnClause(node: Kusto.Language.Syntax.MakeSeriesOnClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvExpandRowLimitClause(node: Kusto.Language.Syntax.MvExpandRowLimitClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvApplyRowLimitClause(node: Kusto.Language.Syntax.MvApplyRowLimitClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitMvApplyContextIdClause(node: Kusto.Language.Syntax.MvApplyContextIdClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitNameEqualsClause(node: Kusto.Language.Syntax.NameEqualsClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitOrderingClause(node: Kusto.Language.Syntax.OrderingClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitOrderingNullsClause(node: Kusto.Language.Syntax.OrderingNullsClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitReduceByWithClause(node: Kusto.Language.Syntax.ReduceByWithClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitRenderWithClause(node: Kusto.Language.Syntax.RenderWithClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSummarizeByClause(node: Kusto.Language.Syntax.SummarizeByClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopHittersByClause(node: Kusto.Language.Syntax.TopHittersByClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopNestedClause(node: Kusto.Language.Syntax.TopNestedClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitTopNestedWithOthersClause(node: Kusto.Language.Syntax.TopNestedWithOthersClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitToTypeOfClause(node: Kusto.Language.Syntax.ToTypeOfClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitEvaluateSchemaClause(node: Kusto.Language.Syntax.EvaluateSchemaClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitAliasStatement(node: Kusto.Language.Syntax.AliasStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitExpressionStatement(node: Kusto.Language.Syntax.ExpressionStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitLetStatement(node: Kusto.Language.Syntax.LetStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitQueryParametersStatement(node: Kusto.Language.Syntax.QueryParametersStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitRestrictStatement(node: Kusto.Language.Syntax.RestrictStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitSetOptionStatement(node: Kusto.Language.Syntax.SetOptionStatement | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitOptionValueClause(node: Kusto.Language.Syntax.OptionValueClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCommandWithValueClause(node: Kusto.Language.Syntax.CommandWithValueClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCommandWithPropertyListClause(node: Kusto.Language.Syntax.CommandWithPropertyListClause | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitBadCommand(node: Kusto.Language.Syntax.BadCommand | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitCustomCommand(node: Kusto.Language.Syntax.CustomCommand | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitUnknownCommand(node: Kusto.Language.Syntax.UnknownCommand | null): Kusto.Language.Binding.SemanticInfo | null;
            VisitDirectiveBlock(node: Kusto.Language.Syntax.DirectiveBlock | null): Kusto.Language.Binding.SemanticInfo | null;
        }
        interface NodeBinderFunc extends Function {
            prototype: NodeBinder;
            new (binder: Kusto.Language.Binding.Binder | null): NodeBinder;
        }
    }

    /**
     * The kinds of conversions allowed between values of two different types.
     *
     * @class Kusto.Language.Binding.Conversion
     */
    enum Conversion {
        None = 0,
        Promotable = 1,
        Compatible = 2,
        Any = 3
    }

    /**
     * The semantic information associated with a {@link }.
     *
     * @class Kusto.Language.Binding.SemanticInfo
     */
    interface SemanticInfo {
        /**
         * The symbol referenced by the {@link },
         a column, function, operator, etc.
         May be null.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function ReferencedSymbol
         * @type Kusto.Language.Symbols.Symbol
         */
        ReferencedSymbol: Kusto.Language.Symbols.Symbol | null;
        /**
         * The matching signature of the function or operator symbol referenced by the {@link }.
         May be null.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function ReferencedSignature
         * @type Kusto.Language.Symbols.Signature
         */
        ReferencedSignature: Kusto.Language.Symbols.Signature | null;
        /**
         * The result type of the expression.
         May be null if the node is not an expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function ResultType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        ResultType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * If true then the expression is considered constant.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function IsConstant
         * @type boolean
         */
        IsConstant: boolean;
        /**
         * Diagnostics discovered during binding.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function Diagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * The expansion of the function called
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @function CalledFunctionInfo
         * @type Kusto.Language.Binding.FunctionCallInfo
         */
        CalledFunctionInfo: Kusto.Language.Binding.FunctionCallInfo | null;
        WithReferencedSymbol(symbol: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Binding.SemanticInfo | null;
        WithReferencedSignature(signature: Kusto.Language.Symbols.Signature | null): Kusto.Language.Binding.SemanticInfo | null;
        WithResultType(type: Kusto.Language.Symbols.TypeSymbol | null): Kusto.Language.Binding.SemanticInfo | null;
        WithDiagnostics(diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null): Kusto.Language.Binding.SemanticInfo | null;
        WithIsConstant(isConstant: boolean): Kusto.Language.Binding.SemanticInfo | null;
        WithCalledFunctionInfo(calledFunctionInfo: Kusto.Language.Binding.FunctionCallInfo | null): Kusto.Language.Binding.SemanticInfo | null;
    }
    interface SemanticInfoFunc extends Function {
        prototype: SemanticInfo;
        $ctor3: {
            new (referencedSymbol: Kusto.Language.Symbols.Symbol | null, result: Kusto.Language.Symbols.TypeSymbol | null, diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null, isConstant: boolean, calledFunctionInfo: Kusto.Language.Binding.FunctionCallInfo | null): SemanticInfo
        };
        $ctor1: {
            new (referencedSignature: Kusto.Language.Symbols.Signature | null, result: Kusto.Language.Symbols.TypeSymbol | null, diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null, isConstant: boolean, calledFunctionInfo: Kusto.Language.Binding.FunctionCallInfo | null): SemanticInfo
        };
        $ctor5: {
            new (result: Kusto.Language.Symbols.TypeSymbol | null, diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null, isConstant: boolean, calledFunctionInfo: Kusto.Language.Binding.FunctionCallInfo | null): SemanticInfo
        };
        $ctor2: {
            new (referencedSymbol: Kusto.Language.Symbols.Symbol | null, result: Kusto.Language.Symbols.TypeSymbol | null, diagnostic: Kusto.Language.Diagnostic | null): SemanticInfo
        };
        ctor: {
            new (referencedSignature: Kusto.Language.Symbols.Signature | null, result: Kusto.Language.Symbols.TypeSymbol | null, diagnostic: Kusto.Language.Diagnostic | null): SemanticInfo
        };
        $ctor4: {
            new (result: Kusto.Language.Symbols.TypeSymbol | null, diagnostic: Kusto.Language.Diagnostic | null): SemanticInfo
        };
        $ctor6: {
            new (diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null): SemanticInfo
        };
        /**
         * A default {@link } for nodes that are determined to have not information.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Binding.SemanticInfo
         * @type Kusto.Language.Binding.SemanticInfo
         */
        Empty: Kusto.Language.Binding.SemanticInfo | null;
    }
    var SemanticInfo: SemanticInfoFunc;

    /**
     * Binding state that exists for the duration of the binder.
     *
     * @class Kusto.Language.Binding.LocalBindingCache
     */
    interface LocalBindingCache {
    }
    interface LocalBindingCacheFunc extends Function {
        prototype: LocalBindingCache;
        new (): LocalBindingCache;
    }
    var LocalBindingCache: LocalBindingCacheFunc;

    /**
     * Represents the result information for a function or operator invocation.
     *
     * @class Kusto.Language.Binding.FunctionCallResult
     */
    interface FunctionCallResult {
        /**
         * The result type of this signature.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.FunctionCallResult
         * @function Type
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        Type: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * The extended semantic info for the function call.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.FunctionCallResult
         * @function Info
         * @type Kusto.Language.Binding.FunctionCallInfo
         */
        Info: Kusto.Language.Binding.FunctionCallInfo | null;
        $clone(to: Kusto.Language.Binding.FunctionCallResult): Kusto.Language.Binding.FunctionCallResult;
    }
    interface FunctionCallResultFunc extends Function {
        prototype: FunctionCallResult;
        $ctor1: {
            new (type: Kusto.Language.Symbols.TypeSymbol | null, info: Kusto.Language.Binding.FunctionCallInfo | null): FunctionCallResult
        };
        new (): FunctionCallResult;
        ctor: {
            new (): FunctionCallResult
        };
        op_Implicit(type: Kusto.Language.Symbols.TypeSymbol): Kusto.Language.Binding.FunctionCallResult;
    }
    var FunctionCallResult: FunctionCallResultFunc;

    /**
     * Binding state that persists across multiple bindings (lifetime of {@link })
     *
     * @class Kusto.Language.Binding.GlobalBindingCache
     */
    interface GlobalBindingCache {
    }
    interface GlobalBindingCacheFunc extends Function {
        prototype: GlobalBindingCache;
        new (): GlobalBindingCache;
    }
    var GlobalBindingCache: GlobalBindingCacheFunc;

    /**
     * Models nested scoping for let variables and function parameters.
     *
     * @class Kusto.Language.Binding.LocalScope
     */
    interface LocalScope {
        /**
         * Returns true if the local scope constains a symbol with the given name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {string}     name
         * @return  {boolean}
         */
        ContainsSymbol(name: string | null): boolean;
        /**
         * Makes a copy of this {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @return  {Kusto.Language.Binding.LocalScope}
         */
        Copy(): Kusto.Language.Binding.LocalScope | null;
        /**
         * Add a {@link } to the {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {Kusto.Language.Symbols.Symbol}    symbol
         * @return  {boolean}
         */
        AddSymbol(symbol: Kusto.Language.Symbols.Symbol | null): boolean;
        /**
         * Adds a collection of {@link } to the {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {System.Collections.Generic.IEnumerable$1}    symbols
         * @return  {void}
         */
        AddSymbols(symbols: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null): void;
        /**
         * Gets all the matching symbols in the scope, and then from any outer scopes.
         If any named matches are found in this scope, all other named matches from outer scopes are ignored.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {string}                                name       
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
         * @param   {System.Collections.Generic.List$1}     symbols
         * @return  {void}
         */
        GetSymbols$1(name: string | null, match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null): void;
        /**
         * Gets all the matching symbols in the scope, and then from any outer scopes.
         If any named matches are found in this scope, all other named matches from outer scopes are ignored.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
         * @param   {System.Collections.Generic.List$1}     symbols
         * @return  {void}
         */
        GetSymbols(match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null): void;
    }
    interface LocalScopeFunc extends Function {
        prototype: LocalScope;
        /**
         * Create a new instance of a {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.LocalScope
         * @memberof Kusto.Language.Binding.LocalScope
         * @param   {Kusto.Language.Binding.LocalScope}    outerScope    An optional outer scope.
         * @return  {void}
         */
        ctor: {
            new (outerScope: Kusto.Language.Binding.LocalScope | null): LocalScope
        };
    }
    var LocalScope: LocalScopeFunc;

    /**
     * The kind of match that an argument can have with its corresponding signature parameter.
     *
     * @class Kusto.Language.Binding.ParameterMatchKind
     */
    enum ParameterMatchKind {
        None = 0,
        Unknown = 1,
        NotType = 2,
        Scalar = 3,
        Summable = 4,
        Orderable = 5,
        Number = 6,
        Compatible = 7,
        Promoted = 8,
        Tabular = 9,
        Table = 10,
        Database = 11,
        Cluster = 12,
        OneOfTwo = 13,
        Exact = 14
    }

    /**
     * A class that manages building a list of columns in a projection
     *
     * @class Kusto.Language.Binding.ProjectionBuilder
     */
    interface ProjectionBuilder {
        /**
         * Clears the {@link } so it can be used again.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @return  {void}
         */
        Clear(): void;
        /**
         * Gets the projected columns.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetProjection(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        /**
         * Adds one or more columns to the projection list, renaming them if necessary.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {System.Collections.Generic.IEnumerable$1}    columns        The list of columns to add.
         * @param   {boolean}                                     declare        If true, then consider these columns to have been explicitly declared, so further declarations cannot use their name.
         * @param   {boolean}                                     doNotRepeat    If true then ignore any further attempt to add these columns.
         * @return  {void}
         */
        AddRange(columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null, declare?: boolean, doNotRepeat?: boolean): void;
        /**
         * Ignore any further attempt to add this column to the projection.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
         * @return  {void}
         */
        DoNotAdd(column: Kusto.Language.Symbols.ColumnSymbol | null): void;
        /**
         * Ignore any further attempt to add any of these columns to the projection.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {System.Collections.Generic.IEnumerable$1}    columns
         * @return  {void}
         */
        DoNotAddAny(columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null): void;
        /**
         * True if an attempt to add the column will succeed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
         * @return  {boolean}
         */
        CanAdd(column: Kusto.Language.Symbols.ColumnSymbol | null): boolean;
        /**
         * Adds a new undeclared column to the projection list.
         The name will be changed if it conflicts with a previously added column.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column         The column to add.
         * @param   {string}                                 baseName       The base name to use when generating an alternate unique name for this column.
         * @param   {boolean}                                replace        If true, allow this column to replace any previously added column with the same name.
         * @param   {boolean}                                doNotRepeat    If true, ignore any further attempts to add this column.
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        Add(column: Kusto.Language.Symbols.ColumnSymbol | null, baseName?: string | null, replace?: boolean, doNotRepeat?: boolean): Kusto.Language.Symbols.ColumnSymbol | null;
        /**
         * The column is added if a column with the same name is not already declared.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column         The column to declare.
         * @param   {System.Collections.Generic.List$1}      diagnostics    The diagnostics list to add diagnostics to if the column's name has already been declared.
         * @param   {Kusto.Language.Syntax.SyntaxNode}       location       The syntax location used to associate with diagnostics.
         * @param   {boolean}                                replace        If true, allow this column to replace any previously added column with the same name, but not specifically declared.
         * @return  {void}
         */
        Declare(column: Kusto.Language.Symbols.ColumnSymbol | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, location: Kusto.Language.Syntax.SyntaxNode | null, replace?: boolean): void;
        /**
         * Rename a column that exists from a previous query source.
         *
         * @instance
         * @public
         * @this Kusto.Language.Binding.ProjectionBuilder
         * @memberof Kusto.Language.Binding.ProjectionBuilder
         * @param   {string}                                 oldName        The name of a column already in the projection
         * @param   {string}                                 newName        The new name for the column.
         * @param   {System.Collections.Generic.List$1}      diagnostics    The diagnostics list to add diagnostics to if the column's name has already been declared.
         * @param   {Kusto.Language.Syntax.SyntaxNode}       location       The syntax location used to associate with any diagnostics added.
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        Rename(oldName: string | null, newName: string | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, location: Kusto.Language.Syntax.SyntaxNode | null): Kusto.Language.Symbols.ColumnSymbol | null;
    }
    interface ProjectionBuilderFunc extends Function {
        prototype: ProjectionBuilder;
        new (): ProjectionBuilder;
    }
    var ProjectionBuilder: ProjectionBuilderFunc;

    /**
     * Scope kind.
     *
     * @class Kusto.Language.Binding.ScopeKind
     */
    enum ScopeKind {
        Normal = 0,
        Aggregate = 1,
        PlugIn = 2,
        Option = 3
    }

    /**
     * Extended semantic information for function calls.
     *
     * @class Kusto.Language.Binding.FunctionCallInfo
     */
    interface FunctionCallInfo {
        /**
         * The expansion of the function called
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Binding.FunctionCallInfo
         * @function Expansion
         * @type Kusto.Language.FunctionCallExpansion
         */
        Expansion: Kusto.Language.FunctionCallExpansion | null;
        HasErrors: boolean;
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
    }
    interface FunctionCallInfoFunc extends Function {
        prototype: FunctionCallInfo;
        $ctor1: {
            new (expander: {(): Kusto.Language.FunctionCallExpansion} | null, hasErrors: boolean): FunctionCallInfo
        };
        ctor: {
            new (expansion: Kusto.Language.FunctionCallExpansion | null, hasErrors: boolean): FunctionCallInfo
        };
    }
    var FunctionCallInfo: FunctionCallInfoFunc;

    /**
     * Represents the information known at the location of a user function call.
     *
     * @class Kusto.Language.Binding.CallSiteInfo
     */
    interface CallSiteInfo {
        /**
         * The signature of the function being called.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.CallSiteInfo
         * @function Signature
         * @type Kusto.Language.Symbols.Signature
         */
        Signature: Kusto.Language.Symbols.Signature | null;
        /**
         * The parameters of the function represented as local variables.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Binding.CallSiteInfo
         * @function Locals
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Locals: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.VariableSymbol> | null;
        toString(): string | null;
    }
    interface CallSiteInfoFunc extends Function {
        prototype: CallSiteInfo;
        Comparer: Kusto.Language.Binding.CallSiteInfo.ComparerFunc;
        new (signature: Kusto.Language.Symbols.Signature | null, locals: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.VariableSymbol> | null): CallSiteInfo;
    }
    var CallSiteInfo: CallSiteInfoFunc;
    module CallSiteInfo {
        interface Comparer extends System.Collections.Generic.IEqualityComparer$1<Kusto.Language.Binding.CallSiteInfo> {
            equals2(x: Kusto.Language.Binding.CallSiteInfo | null, y: Kusto.Language.Binding.CallSiteInfo | null): boolean;
            getHashCode2(obj: Kusto.Language.Binding.CallSiteInfo | null): number;
        }
        interface ComparerFunc extends Function {
            prototype: Comparer;
            new (): Comparer;
            Instance: Kusto.Language.Binding.CallSiteInfo.Comparer | null;
        }
    }

}

declare namespace Kusto.Language.Editor {
    interface ClientParameter extends Kusto.Language.Editor.SyntaxReference {
        Name: string | null;
    }
    interface ClientParameterFunc extends Function {
        prototype: ClientParameter;
        new (name: string | null, position: number, length: number): ClientParameter;
    }
    var ClientParameter: ClientParameterFunc;

    /** @namespace Kusto.Language.Editor */

    /**
     * The location of a reference to a cluster in the text of the code.
     *
     * @public
     * @class Kusto.Language.Editor.ClusterReference
     * @augments Kusto.Language.Editor.SyntaxReference
     */
    interface ClusterReference extends Kusto.Language.Editor.SyntaxReference {
        /**
         * The name of the cluster referenced.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClusterReference
         * @function Cluster
         * @type string
         */
        Cluster: string | null;
    }
    interface ClusterReferenceFunc extends Function {
        prototype: ClusterReference;
        new (cluster: string | null, start: number, length: number): ClusterReference;
    }
    var ClusterReference: ClusterReferenceFunc;

    interface ColumnHasSameNameAsVariableAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface ColumnHasSameNameAsVariableAnalyzerFunc extends Function {
        prototype: ColumnHasSameNameAsVariableAnalyzer;
        new (): ColumnHasSameNameAsVariableAnalyzer;
    }
    var ColumnHasSameNameAsVariableAnalyzer: ColumnHasSameNameAsVariableAnalyzerFunc;

    /**
     * The location of a reference to a database in the text of the code.
     *
     * @public
     * @class Kusto.Language.Editor.DatabaseReference
     * @augments Kusto.Language.Editor.SyntaxReference
     */
    interface DatabaseReference extends Kusto.Language.Editor.SyntaxReference {
        /**
         * The name of the database that is explicitly referenced.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.DatabaseReference
         * @function Database
         * @type string
         */
        Database: string | null;
        /**
         * The cluster that the database is associated with, either implied or explicitly referenced.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.DatabaseReference
         * @function Cluster
         * @type string
         */
        Cluster: string | null;
    }
    interface DatabaseReferenceFunc extends Function {
        prototype: DatabaseReference;
        new (database: string | null, cluster: string | null, start: number, length: number): DatabaseReference;
    }
    var DatabaseReference: DatabaseReferenceFunc;

    interface InlineDatabaseFunctionActor extends Kusto.Language.Editor.KustoActor {
        GetActions(code: Kusto.Language.KustoCode | null, position: number, additionalDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null, actions: System.Collections.Generic.List$1<Kusto.Language.Editor.CodeAction> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
        ApplyAction(code: Kusto.Language.KustoCode | null, position: number, additionalDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null, action: Kusto.Language.Editor.CodeAction | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
    }
    interface InlineDatabaseFunctionActorFunc extends Function {
        prototype: InlineDatabaseFunctionActor;
        new (): InlineDatabaseFunctionActor;
    }
    var InlineDatabaseFunctionActor: InlineDatabaseFunctionActorFunc;

    /**
     * A {@link } for Kusto queries and commands.
     *
     * @public
     * @class Kusto.Language.Editor.KustoCodeService
     * @augments Kusto.Language.Editor.CommonCodeService
     */
    interface KustoCodeService extends Kusto.Language.Editor.CommonCodeService {
        Kind: string | null;
        /**
         * Gets the {@link } for the text without waiting for semantic analysis.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCodeService
         * @memberof Kusto.Language.Editor.KustoCodeService
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    
         * @param   {boolean}                                   waitForAnalysis      
         * @param   {Kusto.Language.KustoCode}                  code
         * @return  {boolean}
         */
        /**
         * Gets the {@link } for the text with semantic analysis done.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCodeService
         * @memberof Kusto.Language.Editor.KustoCodeService
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    
         * @param   {boolean}                                   waitForAnalysis      
         * @param   {Kusto.Language.KustoCode}                  code
         * @return  {boolean}
         */
        IsFeatureSupported(feature: string | null, position: number): boolean;
        TryGetCachedDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetDiagnostics(waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        TryGetCachedAnalyzerDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetAnalyzerDiagnostics(analyzers?: System.Collections.Generic.IReadOnlyList$1<string> | null, waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        GetAnalyzers(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.AnalyzerInfo> | null;
        GetCodeActions(position: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionInfo | null;
        ApplyCodeAction(position: number, codeAction: Kusto.Language.Editor.CodeAction | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
        GetClassifications(start: number, length: number, clipToRange?: boolean, waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.ClassificationInfo | null;
        GetClientParameters(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClientParameter> | null;
        GetOutlines(cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.OutlineInfo | null;
        ShouldAutoComplete(position: number, key: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): boolean;
        GetCompletionItems(position: number, options?: Kusto.Language.Editor.CompletionOptions | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CompletionInfo | null;
        GetQuickInfo(position: number, options?: Kusto.Language.Editor.QuickInfoOptions | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.QuickInfo | null;
        GetElement(position: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.TextRange | null;
        GetRelatedElements(position: number, options?: Kusto.Language.Editor.FindRelatedOptions, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.RelatedInfo | null;
        GetClusterReferences(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClusterReference> | null;
        GetDatabaseReferences(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.DatabaseReference> | null;
        GetMinimalText(kind: Kusto.Language.Editor.MinimalTextKind, cancellationToken?: Kusto.Language.Utils.CancellationToken): string | null;
        GetFormattedText(options?: Kusto.Language.Editor.FormattingOptions | null, cursorPosition?: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.FormattedText | null;
    }
    interface KustoCodeServiceFunc extends Function {
        prototype: KustoCodeService;
        $ctor1: {
            new (text: string | null, globals: Kusto.Language.GlobalState | null): KustoCodeService
        };
        ctor: {
            new (code: Kusto.Language.KustoCode | null): KustoCodeService
        };
        /**
         * The set of known analyzer diagnostics
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.KustoCodeService
         * @function AnalyzerDiagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        AnalyzerDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Returns true if the text appears parsable
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCodeService
         * @memberof Kusto.Language.Editor.KustoCodeService
         * @param   {string}     text
         * @return  {boolean}
         */
        /**
         * Determines if the parsed syntax can be analyzed
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCodeService
         * @memberof Kusto.Language.Editor.KustoCodeService
         * @param   {Kusto.Language.KustoCode}    code
         * @return  {boolean}
         */
        GetIncludeTrivia(kind: Kusto.Language.Editor.MinimalTextKind): Kusto.Language.Syntax.IncludeTrivia;
    }
    var KustoCodeService: KustoCodeServiceFunc;

    interface NullAggregationAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface NullAggregationAnalyzerFunc extends Function {
        prototype: NullAggregationAnalyzer;
        new (): NullAggregationAnalyzer;
    }
    var NullAggregationAnalyzer: NullAggregationAnalyzerFunc;

    interface PreferUsingMaterializedViewIntrinsicAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface PreferUsingMaterializedViewIntrinsicAnalyzerFunc extends Function {
        prototype: PreferUsingMaterializedViewIntrinsicAnalyzer;
        new (): PreferUsingMaterializedViewIntrinsicAnalyzer;
        /**
         * Try to identify whether the materialized view being referenced is a down sampling one, by checking 
         if it has a group by key with one of the functions in {@link }. 
         If it is, suggest to change to using the materialized_view() function.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.PreferUsingMaterializedViewIntrinsicAnalyzer
         * @memberof Kusto.Language.Editor.PreferUsingMaterializedViewIntrinsicAnalyzer
         * @param   {Kusto.Language.Syntax.NameReference}              nameReference             
         * @param   {Kusto.Language.Symbols.MaterializedViewSymbol}    materializedViewSymbol    
         * @param   {Kusto.Language.KustoCode}                         code                      
         * @param   {Kusto.Language.Diagnostic}                        dx                        
         * @param   {System.Collections.Generic.List$1}                diagnostics
         * @return  {void}
         */
    }
    var PreferUsingMaterializedViewIntrinsicAnalyzer: PreferUsingMaterializedViewIntrinsicAnalyzerFunc;

    interface StdevTimespanConversionAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface StdevTimespanConversionAnalyzerFunc extends Function {
        prototype: StdevTimespanConversionAnalyzer;
        new (): StdevTimespanConversionAnalyzer;
    }
    var StdevTimespanConversionAnalyzer: StdevTimespanConversionAnalyzerFunc;

    /**
     * A {@link } for an unknown kind of code.
     *
     * @public
     * @class Kusto.Language.Editor.UnknownCodeService
     * @augments Kusto.Language.Editor.CommonCodeService
     */
    interface UnknownCodeService extends Kusto.Language.Editor.CommonCodeService {
        Kind: string | null;
    }
    interface UnknownCodeServiceFunc extends Function {
        prototype: UnknownCodeService;
        new (text: string | null): UnknownCodeService;
    }
    var UnknownCodeService: UnknownCodeServiceFunc;

    interface AvoidUsingShortStringComparisionAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingShortStringComparisionAnalyzerFunc extends Function {
        prototype: AvoidUsingShortStringComparisionAnalyzer;
        new (): AvoidUsingShortStringComparisionAnalyzer;
    }
    var AvoidUsingShortStringComparisionAnalyzer: AvoidUsingShortStringComparisionAnalyzerFunc;

    interface AvoidUsingObsoleteFunctionsAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingObsoleteFunctionsAnalyzerFunc extends Function {
        prototype: AvoidUsingObsoleteFunctionsAnalyzer;
        new (): AvoidUsingObsoleteFunctionsAnalyzer;
    }
    var AvoidUsingObsoleteFunctionsAnalyzer: AvoidUsingObsoleteFunctionsAnalyzerFunc;

    interface AvoidUsingLegacyPartitionAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingLegacyPartitionAnalyzerFunc extends Function {
        prototype: AvoidUsingLegacyPartitionAnalyzer;
        new (): AvoidUsingLegacyPartitionAnalyzer;
    }
    var AvoidUsingLegacyPartitionAnalyzer: AvoidUsingLegacyPartitionAnalyzerFunc;

    /**
     * An element of the text that is related in some way to another element.
     *
     * @public
     * @class Kusto.Language.Editor.RelatedElement
     * @augments Kusto.Language.Editor.TextRange
     */
    interface RelatedElement extends Kusto.Language.Editor.TextRange {
        /**
         * The kind of related element.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.RelatedElement
         * @function Kind
         * @type Kusto.Language.Editor.RelatedElementKind
         */
        Kind: Kusto.Language.Editor.RelatedElementKind;
        /**
         * The placement of the cursor when moving to the left,
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.RelatedElement
         * @function CursorLeft
         * @type number
         */
        CursorLeft: number;
        /**
         * The placement of the cursor when moving to the right.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.RelatedElement
         * @function CursorRight
         * @type number
         */
        CursorRight: number;
    }
    interface RelatedElementFunc extends Function {
        prototype: RelatedElement;
        $ctor1: {
            new (start: number, length: number, kind: Kusto.Language.Editor.RelatedElementKind, cursorLeft: number, cursorRight: number): RelatedElement
        };
        ctor: {
            new (start: number, length: number, kind: Kusto.Language.Editor.RelatedElementKind): RelatedElement
        };
    }
    var RelatedElement: RelatedElementFunc;

    /**
     * A factory for creating {@link }
     *
     * @public
     * @class Kusto.Language.Editor.KustoCodeServiceFactory
     * @augments Kusto.Language.Editor.CodeServiceFactory
     */
    interface KustoCodeServiceFactory extends Kusto.Language.Editor.CodeServiceFactory {
        /**
         * The {@link } to instantiate new {@link } with.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.KustoCodeServiceFactory
         * @function Globals
         * @type Kusto.Language.GlobalState
         */
        Globals: Kusto.Language.GlobalState | null;
        /**
         * Creates a new {@link } with {@link } changed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.KustoCodeServiceFactory
         * @memberof Kusto.Language.Editor.KustoCodeServiceFactory
         * @param   {Kusto.Language.GlobalState}                       globals
         * @return  {Kusto.Language.Editor.KustoCodeServiceFactory}
         */
        WithGlobals(globals: Kusto.Language.GlobalState | null): Kusto.Language.Editor.KustoCodeServiceFactory | null;
        TryGetCodeService(text: string | null, service: {v: Kusto.Language.Editor.CodeService | null}): boolean;
    }
    interface KustoCodeServiceFactoryFunc extends Function {
        prototype: KustoCodeServiceFactory;
        /**
         * Creates a new instance of {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.KustoCodeServiceFactory
         * @memberof Kusto.Language.Editor.KustoCodeServiceFactory
         * @param   {Kusto.Language.GlobalState}    globals
         * @return  {void}
         */
        new (globals: Kusto.Language.GlobalState | null): KustoCodeServiceFactory;
        /**
         * Returns true if the text is believed to be Kusto syntax.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCodeServiceFactory
         * @memberof Kusto.Language.Editor.KustoCodeServiceFactory
         * @param   {string}     text
         * @return  {boolean}
         */
        /**
         * Returns true if the text is believed to be SQL syntax.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCodeServiceFactory
         * @memberof Kusto.Language.Editor.KustoCodeServiceFactory
         * @param   {string}     text
         * @return  {boolean}
         */
    }
    var KustoCodeServiceFactory: KustoCodeServiceFactoryFunc;

    /**
     * @abstract
     * @public
     * @class Kusto.Language.Editor.KustoActor
     * @augments Kusto.Language.Editor.CodeActor
     */
    interface KustoActor extends Kusto.Language.Editor.CodeActor {
        /**
         * Gets the set of actions that this actor offers for the code at the given position.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.KustoActor
         * @memberof Kusto.Language.Editor.KustoActor
         * @param   {Kusto.Language.KustoCode}                      code                     
         * @param   {number}                                        position                 
         * @param   {System.Collections.Generic.IReadOnlyList$1}    additionalDiagnostics    
         * @param   {System.Collections.Generic.List$1}             actions                  
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken
         * @return  {void}
         */
        GetActions(code: Kusto.Language.KustoCode | null, position: number, additionalDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null, actions: System.Collections.Generic.List$1<Kusto.Language.Editor.CodeAction> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
        /**
         * Applies the action at the specified position if possible.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.KustoActor
         * @memberof Kusto.Language.Editor.KustoActor
         * @param   {Kusto.Language.KustoCode}                      code                     
         * @param   {number}                                        position                 
         * @param   {System.Collections.Generic.IReadOnlyList$1}    additionalDiagnostics    
         * @param   {Kusto.Language.Editor.CodeAction}              action                   
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken
         * @return  {Kusto.Language.Editor.CodeActionResult}
         */
        ApplyAction(code: Kusto.Language.KustoCode | null, position: number, additionalDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null, action: Kusto.Language.Editor.CodeAction | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
    }
    interface KustoActorFunc extends Function {
        prototype: KustoActor;
        new (): KustoActor;
    }
    var KustoActor: KustoActorFunc;

    /**
     * A {@link } with default implementations for each feature API.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CommonCodeService
     * @augments Kusto.Language.Editor.CodeService
     */
    interface CommonCodeService extends Kusto.Language.Editor.CodeService {
        Text: string | null;
        IsFeatureSupported(feature: string | null, position?: number): boolean;
        TryGetCachedDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetDiagnostics(waitForAnalysis: boolean, cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        TryGetCachedAnalyzerDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetAnalyzerDiagnostics(analyzers: System.Collections.Generic.IReadOnlyList$1<string> | null, waitForAnalysis: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        GetAnalyzers(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.AnalyzerInfo> | null;
        GetCodeActions(position: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionInfo | null;
        ApplyCodeAction(position: number, codeAction: Kusto.Language.Editor.CodeAction | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
        GetClassifications(start: number, length: number, clipToRange: boolean, waitForAnalysis: boolean, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.ClassificationInfo | null;
        GetOutlines(cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.OutlineInfo | null;
        ShouldAutoComplete(position: number, key: number, cancellationToken: Kusto.Language.Utils.CancellationToken): boolean;
        GetCompletionItems(position: number, options: Kusto.Language.Editor.CompletionOptions | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CompletionInfo | null;
        GetQuickInfo(position: number, options: Kusto.Language.Editor.QuickInfoOptions | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.QuickInfo | null;
        GetElement(position: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.TextRange | null;
        GetRelatedElements(position: number, options: Kusto.Language.Editor.FindRelatedOptions, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.RelatedInfo | null;
        GetClusterReferences(cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClusterReference> | null;
        GetDatabaseReferences(cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.DatabaseReference> | null;
        GetMinimalText(kind: Kusto.Language.Editor.MinimalTextKind, cancellationToken: Kusto.Language.Utils.CancellationToken): string | null;
        GetFormattedText(options: Kusto.Language.Editor.FormattingOptions | null, cursorPosition: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.FormattedText | null;
        GetClientParameters(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClientParameter> | null;
    }
    interface CommonCodeServiceFunc extends Function {
        prototype: CommonCodeService;
        /**
         * Add the two classification ranges together.
         If any overlap, classifications from {@link } take precedence.
         *
         * @static
         * @protected
         * @this Kusto.Language.Editor.CommonCodeService
         * @memberof Kusto.Language.Editor.CommonCodeService
         * @param   {System.Collections.Generic.IReadOnlyList$1}    classifications1    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    classifications2
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
    }
    var CommonCodeService: CommonCodeServiceFunc;

    /**
     * The location of a piece of syntax in the text of the code.
     *
     * @public
     * @class Kusto.Language.Editor.SyntaxReference
     * @augments Kusto.Language.Editor.TextRange
     */
    interface SyntaxReference extends Kusto.Language.Editor.TextRange {
    }
    interface SyntaxReferenceFunc extends Function {
        prototype: SyntaxReference;
        new (start: number, length: number): SyntaxReference;
    }
    var SyntaxReference: SyntaxReferenceFunc;

    /**
     * The base class for any {@link } analyzer.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.KustoAnalyzer
     * @augments Kusto.Language.Editor.CodeAnalyzer
     */
    interface KustoAnalyzer extends Kusto.Language.Editor.CodeAnalyzer {
        /**
         * The diagnostics produced by this analyzer.
         *
         * @instance
         * @public
         * @override
         * @readonly
         * @memberof Kusto.Language.Editor.KustoAnalyzer
         * @function Diagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Override this method to suppy the example set of diagnostics that the analyzer produces.
         *
         * @instance
         * @abstract
         * @protected
         * @this Kusto.Language.Editor.KustoAnalyzer
         * @memberof Kusto.Language.Editor.KustoAnalyzer
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        /**
         * Analyzes the {@link } and outputs any diagnostics found into the diagnostics list.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.KustoAnalyzer
         * @memberof Kusto.Language.Editor.KustoAnalyzer
         * @param   {Kusto.Language.KustoCode}                  code                 
         * @param   {System.Collections.Generic.List$1}         diagnostics          
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {void}
         */
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface KustoAnalyzerFunc extends Function {
        prototype: KustoAnalyzer;
        new (): KustoAnalyzer;
    }
    var KustoAnalyzer: KustoAnalyzerFunc;

    /**
     * Find parsers with annotations that are considered for a specific input
     *
     * @class Kusto.Language.Editor.AnnotationFinder$1
     * @augments Kusto.Language.Parsing.ParserVisitor$3
     */
    interface AnnotationFinder$1<TInput> extends Kusto.Language.Parsing.ParserVisitor$3<TInput,number,number> {
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null, start: number): number;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null, start: number): number;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null, start: number): number;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null, start: number): number;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null, start: number): number;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null, start: number): number;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null, start: number): number;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null, start: number): number;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null, start: number): number;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null, start: number): number;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null, start: number): number;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null, start: number): number;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null, start: number): number;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null, start: number): number;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null, start: number): number;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null, start: number): number;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null, start: number): number;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null, start: number): number;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null, start: number): number;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null, start: number): number;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null, start: number): number;
    }
    interface AnnotationFinder$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: AnnotationFinder$1<TInput>;
            /**
             * Finds the parsers with annotations that are considered at the specified input offset.
             *
             * @static
             * @public
             * @this Kusto.Language.Editor.AnnotationFinder$1
             * @memberof Kusto.Language.Editor.AnnotationFinder$1
             * @param   {Kusto.Language.Parsing.Source$1}      source              The input source
             * @param   {number}                               findOffset          The offset of the input item within the input source
             * @param   {Kusto.Language.Parsing.Parser$1}      root                The root/start of the grammar
             * @param   {number}                               start               The starting offset associated with the root grammar
             * @param   {System.Collections.Generic.List$1}    annotatedParsers    The output list of annotated parsers.
             * @return  {void}
             */
            FindAnnotations(source: Kusto.Language.Parsing.Source$1<TInput> | null, findOffset: number, root: Kusto.Language.Parsing.Parser$1<TInput> | null, start: number, annotatedParsers: System.Collections.Generic.List$1<Kusto.Language.Parsing.Parser$1<TInput>> | null): void;
        }
    }
    var AnnotationFinder$1: AnnotationFinder$1Func;

    /**
     * Analyzer for detecting usage of short string comparisons
     *
     * @class Kusto.Language.Editor.AvoidUsingIsNullStringComparisonAnalyzer
     * @augments Kusto.Language.Editor.KustoAnalyzer
     */
    interface AvoidUsingIsNullStringComparisonAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingIsNullStringComparisonAnalyzerFunc extends Function {
        prototype: AvoidUsingIsNullStringComparisonAnalyzer;
        new (): AvoidUsingIsNullStringComparisonAnalyzer;
    }
    var AvoidUsingIsNullStringComparisonAnalyzer: AvoidUsingIsNullStringComparisonAnalyzerFunc;

    interface AvoidUsingFormatDateTimeInPredicateAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingFormatDateTimeInPredicateAnalyzerFunc extends Function {
        prototype: AvoidUsingFormatDateTimeInPredicateAnalyzer;
        new (): AvoidUsingFormatDateTimeInPredicateAnalyzer;
    }
    var AvoidUsingFormatDateTimeInPredicateAnalyzer: AvoidUsingFormatDateTimeInPredicateAnalyzerFunc;

    interface AvoidUsingContainsAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingContainsAnalyzerFunc extends Function {
        prototype: AvoidUsingContainsAnalyzer;
        new (): AvoidUsingContainsAnalyzer;
    }
    var AvoidUsingContainsAnalyzer: AvoidUsingContainsAnalyzerFunc;

    interface CalledFunctionHasErrorsAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface CalledFunctionHasErrorsAnalyzerFunc extends Function {
        prototype: CalledFunctionHasErrorsAnalyzer;
        new (): CalledFunctionHasErrorsAnalyzer;
    }
    var CalledFunctionHasErrorsAnalyzer: CalledFunctionHasErrorsAnalyzerFunc;

    interface AvoidJoinWithoutKindAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidJoinWithoutKindAnalyzerFunc extends Function {
        prototype: AvoidJoinWithoutKindAnalyzer;
        new (): AvoidJoinWithoutKindAnalyzer;
    }
    var AvoidJoinWithoutKindAnalyzer: AvoidJoinWithoutKindAnalyzerFunc;

    /**
     * A {@link } that wraps another service and adjusts the positions used in the feature API's by a fixed offset.
     *
     * @public
     * @class Kusto.Language.Editor.OffsetCodeService
     * @augments Kusto.Language.Editor.CodeService
     */
    interface OffsetCodeService extends Kusto.Language.Editor.CodeService {
        Kind: string | null;
        Text: string | null;
        WithOffset(offset: number): Kusto.Language.Editor.OffsetCodeService | null;
        GetClassifications(start: number, length: number, clipToRange: boolean, waitForAnalysis: boolean, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.ClassificationInfo | null;
        GetClientParameters(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClientParameter> | null;
        GetClusterReferences(cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClusterReference> | null;
        GetCompletionItems(position: number, options: Kusto.Language.Editor.CompletionOptions | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CompletionInfo | null;
        GetDatabaseReferences(cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.DatabaseReference> | null;
        TryGetCachedDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetDiagnostics(waitForAnalysis: boolean, cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        TryGetCachedAnalyzerDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        GetAnalyzerDiagnostics(analyzers: System.Collections.Generic.IReadOnlyList$1<string> | null, waitForAnalysis: boolean, cancellationToken: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        GetAnalyzers(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.AnalyzerInfo> | null;
        GetCodeActions(position: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionInfo | null;
        ApplyCodeAction(position: number, codeAction: Kusto.Language.Editor.CodeAction | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
        GetFormattedText(options: Kusto.Language.Editor.FormattingOptions | null, cursorPosition: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.FormattedText | null;
        GetMinimalText(kind: Kusto.Language.Editor.MinimalTextKind, cancellationToken: Kusto.Language.Utils.CancellationToken): string | null;
        GetOutlines(cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.OutlineInfo | null;
        GetQuickInfo(position: number, options: Kusto.Language.Editor.QuickInfoOptions | null, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.QuickInfo | null;
        GetElement(position: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.TextRange | null;
        GetRelatedElements(position: number, options: Kusto.Language.Editor.FindRelatedOptions, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.RelatedInfo | null;
        IsFeatureSupported(feature: string | null, position?: number): boolean;
        ShouldAutoComplete(position: number, key: number, cancellationToken: Kusto.Language.Utils.CancellationToken): boolean;
    }
    interface OffsetCodeServiceFunc extends Function {
        prototype: OffsetCodeService;
        new (service: Kusto.Language.Editor.CodeService | null, offset: number): OffsetCodeService;
    }
    var OffsetCodeService: OffsetCodeServiceFunc;

    interface SymbolDisplay {
    }
    interface SymbolDisplayFunc extends Function {
        prototype: SymbolDisplay;
        new (): SymbolDisplay;
        GetSymbolDisplay(symbol: Kusto.Language.Symbols.Symbol | null, type: Kusto.Language.Symbols.TypeSymbol | null, texts: System.Collections.Generic.List$1<Kusto.Language.Editor.ClassifiedText> | null, showDescription?: boolean): void;
        GetSignatureDisplay(sig: Kusto.Language.Symbols.Signature | null, texts: System.Collections.Generic.List$1<Kusto.Language.Editor.ClassifiedText> | null): void;
        GetTypeDisplay(type: Kusto.Language.Symbols.TypeSymbol | null, texts: System.Collections.Generic.List$1<Kusto.Language.Editor.ClassifiedText> | null, useName?: boolean): void;
    }
    var SymbolDisplay: SymbolDisplayFunc;

    interface AnalyzerInfo {
        /**
         * The name of the analyzer.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.AnalyzerInfo
         * @function Name
         * @type string
         */
        Name: string | null;
        /**
         * The diagnostic codes produced by this analyzer.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.AnalyzerInfo
         * @function Diagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
    }
    interface AnalyzerInfoFunc extends Function {
        prototype: AnalyzerInfo;
        new (name: string | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): AnalyzerInfo;
    }
    var AnalyzerInfo: AnalyzerInfoFunc;

    enum RelatedElementKind {
        Syntax = 0,
        Reference = 1,
        Declaration = 2,
        Other = 3
    }

    /**
     * Diagnostic codes produced by kusto analyzers.
     They must be unique.
     *
     * @static
     * @abstract
     * @class Kusto.Language.Editor.KustoAnalyzerCodes
     */
    interface KustoAnalyzerCodes {
    }
    interface KustoAnalyzerCodesFunc extends Function {
        prototype: KustoAnalyzerCodes;
        new (): KustoAnalyzerCodes;
    }
    var KustoAnalyzerCodes: KustoAnalyzerCodesFunc;

    interface KustoActors {
    }
    interface KustoActorsFunc extends Function {
        prototype: KustoActors;
        new (): KustoActors;
        FunctionInliner: Kusto.Language.Editor.KustoActor | null;
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.KustoActor> | null;
        TryGetActor(name: string | null, fixer: {v: Kusto.Language.Editor.KustoActor | null}): boolean;
    }
    var KustoActors: KustoActorsFunc;

    interface FormattingOptions {
        /**
         * The number of spaces used per indentation level.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function IndentationSize
         * @type number
         */
        IndentationSize: number;
        /**
         * Automatically add any missing tokens.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function InsertMissingTokens
         * @type boolean
         */
        InsertMissingTokens: boolean;
        /**
         * Bracketting style: (), [], {}
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function BrackettingStyle
         * @type Kusto.Language.Editor.BrackettingStyle
         */
        BrackettingStyle: Kusto.Language.Editor.BrackettingStyle;
        /**
         * Placement style of pipe operator.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function PipeOperatorStyle
         * @type Kusto.Language.Editor.PlacementStyle
         */
        PipeOperatorStyle: Kusto.Language.Editor.PlacementStyle;
        /**
         * Placement style of query statements.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function StatementStyle
         * @type Kusto.Language.Editor.PlacementStyle
         */
        StatementStyle: Kusto.Language.Editor.PlacementStyle;
        /**
         * Placement style of semicolons between statements.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattingOptions
         * @function SemicolonStyle
         * @type Kusto.Language.Editor.PlacementStyle
         */
        SemicolonStyle: Kusto.Language.Editor.PlacementStyle;
        WithIndentationSize(size: number): Kusto.Language.Editor.FormattingOptions | null;
        WithInsertMissingTokens(enable: boolean): Kusto.Language.Editor.FormattingOptions | null;
        WithBrackettingStyle(style: Kusto.Language.Editor.BrackettingStyle): Kusto.Language.Editor.FormattingOptions | null;
        WithPipeOperatorStyle(style: Kusto.Language.Editor.PlacementStyle): Kusto.Language.Editor.FormattingOptions | null;
        WithStatementStyle(style: Kusto.Language.Editor.PlacementStyle): Kusto.Language.Editor.FormattingOptions | null;
        WithSemicolonStyle(style: Kusto.Language.Editor.PlacementStyle): Kusto.Language.Editor.FormattingOptions | null;
    }
    interface FormattingOptionsFunc extends Function {
        prototype: FormattingOptions;
        Default: Kusto.Language.Editor.FormattingOptions | null;
    }
    var FormattingOptions: FormattingOptionsFunc;

    /**
     * The elements in the code that are related to the element at a particular cursor position.
     *
     * @public
     * @class Kusto.Language.Editor.RelatedInfo
     */
    interface RelatedInfo {
        Elements: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.RelatedElement> | null;
        CurrentIndex: number;
        GetNextIndex(index: number): number;
        GetPreviousIndex(index: number): number;
    }
    interface RelatedInfoFunc extends Function {
        prototype: RelatedInfo;
        new (elements: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.RelatedElement> | null, currentIndex: number): RelatedInfo;
        Empty: Kusto.Language.Editor.RelatedInfo | null;
    }
    var RelatedInfo: RelatedInfoFunc;

    enum FindRelatedOptions {
        None = 0,
        SeeThroughVariables = 1
    }

    interface DisabledDiagnostics {
        toString(): string | null;
        IsSeverityEnabled(severity: string | null): boolean;
        IsServerityDisabled(severity: string | null): boolean;
        IsCodeEnabled(code: string | null): boolean;
        IsCodeDisabled(code: string | null): boolean;
        IsDiagnosticEnabled(diagnostic: Kusto.Language.Diagnostic | null): boolean;
        IsDiagnosticDisabled(diagnostic: Kusto.Language.Diagnostic | null): boolean;
        SetSeverityEnabled(severity: string | null, enabled: boolean): void;
        SetCodeEnabled(code: string | null, enabled: boolean): void;
    }
    interface DisabledDiagnosticsFunc extends Function {
        prototype: DisabledDiagnostics;
        $ctor1: {
            new (text: string | null): DisabledDiagnostics
        };
        new (): DisabledDiagnostics;
        ctor: {
            new (): DisabledDiagnostics
        };
        Parse(text: string | null): Kusto.Language.Editor.DisabledDiagnostics | null;
        CanDisableSeverity(severity: string | null): boolean;
        CanDisableCode(code: string | null): boolean;
    }
    var DisabledDiagnostics: DisabledDiagnosticsFunc;

    /**
     * The priority that controls the order ranking of completion items
     when presented.
     *
     * @public
     * @class Kusto.Language.Editor.CompletionPriority
     */
    enum CompletionPriority {
        Top = 0,
        High = 1,
        Normal = 2,
        Low = 3
    }

    interface CompletionOptions {
        IncludeSymbols: boolean;
        IncludeSyntax: boolean;
        IncludePunctuationOnlySyntax: boolean;
        EnableParameterInjection: boolean;
        AutoAppendWhitespace: boolean;
        IncludeFunctions: Kusto.Language.IncludeFunctionKind;
        WithIncludeSymbols(include: boolean): Kusto.Language.Editor.CompletionOptions | null;
        WithIncludeFunctions(kind: Kusto.Language.IncludeFunctionKind): Kusto.Language.Editor.CompletionOptions | null;
        WithIncludeFunctions$1(include: boolean): Kusto.Language.Editor.CompletionOptions | null;
        WithIncludeSyntax(include: boolean): Kusto.Language.Editor.CompletionOptions | null;
        WithIncludePunctuationOnlySyntax(include: boolean): Kusto.Language.Editor.CompletionOptions | null;
        WithEnableParameterInjection(enable: boolean): Kusto.Language.Editor.CompletionOptions | null;
        WithAutoAppendWhitespace(enable: boolean): Kusto.Language.Editor.CompletionOptions | null;
    }
    interface CompletionOptionsFunc extends Function {
        prototype: CompletionOptions;
        OptionFlags: CompletionOptions.OptionFlagsFunc;
        Default: Kusto.Language.Editor.CompletionOptions | null;
    }
    var CompletionOptions: CompletionOptionsFunc;
    module CompletionOptions {
        interface OptionFlags {
        }
        interface OptionFlagsFunc extends Function {
            prototype: OptionFlags;
            IncludeSymbols: number;
            IncludeSyntax: number;
            IncludePunctuation: number;
            EnableParameterInjection: number;
            AutoAppendWhitespace: number;
            Default: number;
        }
    }

    enum CompletionKind {
        Unknown = 0,
        Keyword = 1,
        Punctuation = 2,
        Syntax = 3,
        Identifier = 4,
        Example = 5,
        ScalarPrefix = 6,
        TabularPrefix = 7,
        TabularSuffix = 8,
        QueryPrefix = 9,
        CommandPrefix = 10,
        ScalarInfix = 11,
        RenderChart = 12,
        Column = 13,
        Table = 14,
        BuiltInFunction = 15,
        LocalFunction = 16,
        DatabaseFunction = 17,
        AggregateFunction = 18,
        Parameter = 19,
        Variable = 20,
        Database = 21,
        Cluster = 22,
        MaterialiedView = 23,
        ScalarType = 24,
        Option = 25
    }

    /**
     * @public
     * @class Kusto.Language.Editor.CompletionItem
     */
    interface CompletionItem {
        /**
         * The kind of {@link }.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function Kind
         * @type Kusto.Language.Editor.CompletionKind
         */
        Kind: Kusto.Language.Editor.CompletionKind;
        /**
         * The text to display for the {@link }.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function DisplayText
         * @type string
         */
        DisplayText: string | null;
        /**
         * The text to match
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function MatchText
         * @type string
         */
        MatchText: string | null;
        /**
         * The text to insert/replace with.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function EditText
         * @type string
         */
        EditText: string | null;
        /**
         * The text insert/replace with after the cursor.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function AfterText
         * @type string
         */
        AfterText: string | null;
        /**
         * The priority of the completion item.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionItem
         * @function Priority
         * @type Kusto.Language.Editor.CompletionPriority
         */
        Priority: Kusto.Language.Editor.CompletionPriority;
        WithKind(kind: Kusto.Language.Editor.CompletionKind): Kusto.Language.Editor.CompletionItem | null;
        WithDisplayText(displayText: string | null): Kusto.Language.Editor.CompletionItem | null;
        WithEditText(editText: string | null): Kusto.Language.Editor.CompletionItem | null;
        WithAfterText(afterText: string | null): Kusto.Language.Editor.CompletionItem | null;
        WithMatchText(matchText: string | null): Kusto.Language.Editor.CompletionItem | null;
        WithPriority(priority: Kusto.Language.Editor.CompletionPriority): Kusto.Language.Editor.CompletionItem | null;
    }
    interface CompletionItemFunc extends Function {
        prototype: CompletionItem;
        new (kind: Kusto.Language.Editor.CompletionKind, displayText: string | null, editText: string | null, afterText: string | null, matchText: string | null, priority: Kusto.Language.Editor.CompletionPriority): CompletionItem;
    }
    var CompletionItem: CompletionItemFunc;

    /**
     * The completion info resulting from a call to {@link }
     *
     * @public
     * @class Kusto.Language.Editor.CompletionInfo
     */
    interface CompletionInfo {
        /**
         * The completion items.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionInfo
         * @function Items
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Items: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.CompletionItem> | null;
        /**
         * The start of the text that each {@link } will replace.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionInfo
         * @function EditStart
         * @type number
         */
        EditStart: number;
        /**
         * The length of the text that each {@link } will replace.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CompletionInfo
         * @function EditLength
         * @type number
         */
        EditLength: number;
    }
    interface CompletionInfoFunc extends Function {
        prototype: CompletionInfo;
        new (items: System.Collections.Generic.IEnumerable$1<Kusto.Language.Editor.CompletionItem> | null, editStart: number, editLength: number): CompletionInfo;
        Empty: Kusto.Language.Editor.CompletionInfo | null;
    }
    var CompletionInfo: CompletionInfoFunc;

    /**
     * A hint that describes the category of syntax element that belongs in
     an associated syntax node location, used to determine appropriate
     completion items.
     *
     * @public
     * @class Kusto.Language.Editor.CompletionHint
     */
    enum CompletionHint {
        None = 0,
        Inherit = 1,
        Expression = 2,
        Scalar = 4,
        Tabular = 8,
        Boolean = 16,
        Number = 32,
        Literal = 64,
        Aggregate = 128,
        TabularFunction = 256,
        ScalarFunction = 512,
        DatabaseFunction = 1024,
        Function = 2048,
        Declaration = 4096,
        Column = 8192,
        Table = 16384,
        Database = 32768,
        Cluster = 65536,
        Syntax = 131072,
        Query = 262144,
        Command = 524288,
        Keyword = 1048576,
        Clause = 2097152,
        MaterializedView = 4194304,
        Option = 8388608,
        ExternalTable = 16777216
    }

    interface CodeServiceFeatures {
    }
    interface CodeServiceFeaturesFunc extends Function {
        prototype: CodeServiceFeatures;
        new (): CodeServiceFeatures;
        Diagnostics: string | null;
        Classification: string | null;
        Completion: string | null;
        Outlining: string | null;
        QuickInfo: string | null;
        ClusterReferences: string | null;
        DatabaseReferences: string | null;
        MinimalText: string | null;
        Formatting: string | null;
        ClientParameters: string | null;
    }
    var CodeServiceFeatures: CodeServiceFeaturesFunc;

    /**
     * The known kusto analyzers
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Editor.KustoAnalyzers
     */
    interface KustoAnalyzers {
    }
    interface KustoAnalyzersFunc extends Function {
        prototype: KustoAnalyzers;
        new (): KustoAnalyzers;
        AvoidUsingContains: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingIsNullStringComparison: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingShortStringComparision: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingToBoolOnNumerics: Kusto.Language.Editor.KustoAnalyzer | null;
        NullAggregation: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingFormatDatetimeInPredicate: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingLegacyPartition: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidUsingObsoleteFunctions: Kusto.Language.Editor.KustoAnalyzer | null;
        AvoidJoinWithoutKind: Kusto.Language.Editor.KustoAnalyzer | null;
        StdevTimespanConversion: Kusto.Language.Editor.KustoAnalyzer | null;
        ColumnHasSameNameAsVariable: Kusto.Language.Editor.KustoAnalyzer | null;
        PreferUsingMaterializedViewIntrinsic: Kusto.Language.Editor.KustoAnalyzer | null;
        CalledFunctionHasErrors: Kusto.Language.Editor.KustoAnalyzer | null;
        /**
         * The set of all known kusto analyzers
         *
         * @static
         * @public
         * @memberof Kusto.Language.Editor.KustoAnalyzers
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.KustoAnalyzer> | null;
    }
    var KustoAnalyzers: KustoAnalyzersFunc;

    /**
     * A factory that constructs {@link } instances over blocks of code.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeServiceFactory
     */
    interface CodeServiceFactory {
        /**
         * .Gets a specific factory from the set of factories that compose this factory.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeServiceFactory
         * @memberof Kusto.Language.Editor.CodeServiceFactory
         * @param   {Function}    TFactory
         * @return  {TFactory}
         */
        GetFactory<TFactory>(TFactory: {prototype: TFactory}): TFactory | null;
        /**
         * Combine an additional factory with this factory.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeServiceFactory
         * @memberof Kusto.Language.Editor.CodeServiceFactory
         * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
         * @return  {Kusto.Language.Editor.CodeServiceFactory}
         */
        WithFactory(factory: Kusto.Language.Editor.CodeServiceFactory | null): Kusto.Language.Editor.CodeServiceFactory | null;
        TryGetCodeService(text: string | null, service: {v: Kusto.Language.Editor.CodeService | null}): boolean;
    }
    interface CodeServiceFactoryFunc extends Function {
        prototype: CodeServiceFactory;
        AggregateCodeServiceFactory: Kusto.Language.Editor.CodeServiceFactory.AggregateCodeServiceFactoryFunc;
        new (): CodeServiceFactory;
    }
    var CodeServiceFactory: CodeServiceFactoryFunc;
    module CodeServiceFactory {
        /**
         * A {@link } used when more than one kind of factory is needed.
         *
         * @private
         * @class Kusto.Language.Editor.CodeServiceFactory.AggregateCodeServiceFactory
         * @augments Kusto.Language.Editor.CodeServiceFactory
         */
        interface AggregateCodeServiceFactory extends Kusto.Language.Editor.CodeServiceFactory {
            TryGetCodeService(text: string | null, service: {v: Kusto.Language.Editor.CodeService | null}): boolean;
            GetFactory<TFactory>(TFactory: {prototype: TFactory}): TFactory | null;
            WithFactory(factory: Kusto.Language.Editor.CodeServiceFactory | null): Kusto.Language.Editor.CodeServiceFactory | null;
        }
        interface AggregateCodeServiceFactoryFunc extends Function {
            prototype: AggregateCodeServiceFactory;
            new (factories: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.CodeServiceFactory> | null): AggregateCodeServiceFactory;
        }
    }

    /**
     * A script that contains a sequence of independent {@link }s,
     each with its own {@link } for intellisense and editor related features.
     *
     * @public
     * @class Kusto.Language.Editor.CodeScript
     */
    interface CodeScript {
        /**
         * The text that contains the sequence of {@link }s.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CodeScript
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * The factory used to construct a {@link } for each block.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CodeScript
         * @function Factory
         * @type Kusto.Language.Editor.CodeServiceFactory
         */
        Factory: Kusto.Language.Editor.CodeServiceFactory | null;
        /**
         * The collection of individual {@link }s.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeScript
         * @function Blocks
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Blocks: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.CodeBlock> | null;
        /**
         * The {@link } used by Kusto {@link }s.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeScript
         * @function Globals
         * @type Kusto.Language.GlobalState
         */
        Globals: Kusto.Language.GlobalState | null;
        LineStarts: System.Collections.Generic.IReadOnlyList$1<number> | null;
        /**
         * Creates a new {@link } with the text changed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                              newText
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        WithText(newText: string | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Creates a new {@link } with the {@link } changed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        WithFactory(factory: Kusto.Language.Editor.CodeServiceFactory | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Creates a new {@link } with the text and globals changed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                                      newText    
         * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        WithTextAndFactory(newText: string | null, factory: Kusto.Language.Editor.CodeServiceFactory | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Creates a new {@link } with the kusto globals changed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {Kusto.Language.GlobalState}          newGlobals
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        WithGlobals(newGlobals: Kusto.Language.GlobalState | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Gets the block corresponding to the text position.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {number}                             position
         * @return  {Kusto.Language.Editor.CodeBlock}
         */
        GetBlockAtPosition(position: number): Kusto.Language.Editor.CodeBlock | null;
        /**
         * Gets the text position for the line number and character offset.
         Returns true if the position is determined, or false if the line/character is outside the text.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {number}          line          The line number (1 based)
         * @param   {number}          lineOffset    The offset of the character in the line (1 based)
         * @param   {System.Int32}    position      The position in the text.
         * @return  {boolean}
         */
        TryGetTextPosition(line: number, lineOffset: number, position: {v: number}): boolean;
        /**
         * Gets the 1-based line and lineOffset for a position in the text.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {number}          position      
         * @param   {System.Int32}    line          
         * @param   {System.Int32}    lineOffset
         * @return  {boolean}
         */
        TryGetLineAndOffset(position: number, line: {v: number}, lineOffset: {v: number}): boolean;
    }
    interface CodeScriptFunc extends Function {
        prototype: CodeScript;
        /**
         * Create a new {@link } from the specified text and a {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                                      text       
         * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        From(text: string | null, factory: Kusto.Language.Editor.CodeServiceFactory | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Create a new {@link } from the specified text and globals.
         *
         * @static
         * @public
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                              text       
         * @param   {Kusto.Language.GlobalState}          globals
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        From$1(text: string | null, globals: Kusto.Language.GlobalState | null): Kusto.Language.Editor.CodeScript | null;
        /**
         * Creates a {@link } from the text
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                                      text              
         * @param   {Kusto.Language.Editor.CodeServiceFactory}    factory           
         * @param   {System.Collections.Generic.IEnumerable$1}    existingBlocks
         * @return  {Kusto.Language.Editor.CodeScript}
         */
        /**
         * Gets the starting offset of all the lines and script blocks.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.CodeScript
         * @memberof Kusto.Language.Editor.CodeScript
         * @param   {string}                               text           
         * @param   {System.Collections.Generic.List$1}    lineStarts     
         * @param   {System.Collections.Generic.List$1}    blockStarts
         * @return  {void}
         */
    }
    var CodeScript: CodeScriptFunc;

    /**
     * Known code kinds.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeKinds
     */
    interface CodeKinds {
    }
    interface CodeKindsFunc extends Function {
        prototype: CodeKinds;
        new (): CodeKinds;
        /**
         * The code is a Kusto Query.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Editor.CodeKinds
         * @constant
         * @default "Query"
         * @type string
         */
        Query: string | null;
        /**
         * The code is a Kusto Commmand.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Editor.CodeKinds
         * @constant
         * @default "Command"
         * @type string
         */
        Command: string | null;
        /**
         * The code is a Kusto Directive
         *
         * @static
         * @public
         * @memberof Kusto.Language.Editor.CodeKinds
         * @constant
         * @default "Directive"
         * @type string
         */
        Directive: string | null;
        /**
         * The code kind is not known.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Editor.CodeKinds
         * @constant
         * @default "Unknown"
         * @type string
         */
        Unknown: string | null;
    }
    var CodeKinds: CodeKindsFunc;

    /**
     * A class that details the range of text of a unique block of code in a {@link } and its associated {@link }.
     *
     * @public
     * @class Kusto.Language.Editor.CodeBlock
     */
    interface CodeBlock {
        /**
         * The text of the {@link }
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * The start of the {@link } within the {@link }.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function Start
         * @type number
         */
        Start: number;
        /**
         * The length of the {@link } within the {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The end of the {@link } within the {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function End
         * @type number
         */
        End: number;
        /**
         * The kind of code in the {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function Kind
         * @type string
         */
        Kind: string | null;
        /**
         * The {@link } associated with this {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeBlock
         * @function Service
         * @type Kusto.Language.Editor.CodeService
         */
        Service: Kusto.Language.Editor.CodeService | null;
        /**
         * Creates a new {@link } with a modified starting position.
         *
         * @instance
         * @this Kusto.Language.Editor.CodeBlock
         * @memberof Kusto.Language.Editor.CodeBlock
         * @param   {number}                             start
         * @return  {Kusto.Language.Editor.CodeBlock}
         */
    }
    interface CodeBlockFunc extends Function {
        prototype: CodeBlock;
    }
    var CodeBlock: CodeBlockFunc;

    interface CodeActor {
        /**
         * The name of the {@link }
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeActor
         * @function Name
         * @type string
         */
        Name: string | null;
    }
    interface CodeActorFunc extends Function {
        prototype: CodeActor;
        new (): CodeActor;
    }
    var CodeActor: CodeActorFunc;

    interface CodeActionResult {
        NewText: string | null;
        NewPosition: number;
        FailureReason: string | null;
    }
    interface CodeActionResultFunc extends Function {
        prototype: CodeActionResult;
    }
    var CodeActionResult: CodeActionResultFunc;

    interface CodeActionInfo {
        Actions: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.CodeAction> | null;
    }
    interface CodeActionInfoFunc extends Function {
        prototype: CodeActionInfo;
    }
    var CodeActionInfo: CodeActionInfoFunc;

    interface CodeAction {
        Actor: string | null;
        Name: string | null;
        Description: string | null;
        Data: string | null;
    }
    interface CodeActionFunc extends Function {
        prototype: CodeAction;
    }
    var CodeAction: CodeActionFunc;

    /**
     * A range of text.
     *
     * @public
     * @class Kusto.Language.Editor.TextRange
     */
    interface TextRange {
        /**
         * The starting position of the range in the text.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.TextRange
         * @function Start
         * @type number
         */
        Start: number;
        /**
         * The length of the range in the text.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.TextRange
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The ending of the range in the text.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.TextRange
         * @function End
         * @type number
         */
        End: number;
    }
    interface TextRangeFunc extends Function {
        prototype: TextRange;
        new (start: number, length: number): TextRange;
    }
    var TextRange: TextRangeFunc;

    interface ClassifiedText {
        /**
         * The {@link } of the text.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClassifiedText
         * @function Kind
         * @type Kusto.Language.Editor.ClassificationKind
         */
        Kind: Kusto.Language.Editor.ClassificationKind;
        /**
         * The text itself.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClassifiedText
         * @function Text
         * @type string
         */
        Text: string | null;
    }
    interface ClassifiedTextFunc extends Function {
        prototype: ClassifiedText;
        $ctor1: {
            new (text: string | null): ClassifiedText
        };
        ctor: {
            new (kind: Kusto.Language.Editor.ClassificationKind, text: string | null): ClassifiedText
        };
    }
    var ClassifiedText: ClassifiedTextFunc;

    /**
     * A {@link } and text range.
     *
     * @public
     * @class Kusto.Language.Editor.ClassifiedRange
     */
    interface ClassifiedRange {
        /**
         * The classification.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClassifiedRange
         * @function Kind
         * @type Kusto.Language.Editor.ClassificationKind
         */
        Kind: Kusto.Language.Editor.ClassificationKind;
        /**
         * The starting text position of the classified range.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClassifiedRange
         * @function Start
         * @type number
         */
        Start: number;
        /**
         * The length (in characters) of the classified range.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.ClassifiedRange
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The end of the classification range.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.ClassifiedRange
         * @function End
         * @type number
         */
        End: number;
    }
    interface ClassifiedRangeFunc extends Function {
        prototype: ClassifiedRange;
        new (kind: Kusto.Language.Editor.ClassificationKind, start: number, length: number): ClassifiedRange;
    }
    var ClassifiedRange: ClassifiedRangeFunc;

    enum ClassificationKind {
        PlainText = 0,
        Comment = 1,
        Punctuation = 2,
        Directive = 3,
        Literal = 4,
        StringLiteral = 5,
        Type = 6,
        Column = 7,
        Table = 8,
        Database = 9,
        Function = 10,
        Parameter = 11,
        Variable = 12,
        Identifier = 13,
        ClientParameter = 14,
        QueryParameter = 15,
        ScalarOperator = 16,
        MathOperator = 17,
        QueryOperator = 18,
        Command = 19,
        Keyword = 20,
        MaterializedView = 21,
        SchemaMember = 22,
        SignatureParameter = 23,
        Option = 24
    }

    interface ClassificationInfo {
        Classifications: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClassifiedRange> | null;
    }
    interface ClassificationInfoFunc extends Function {
        prototype: ClassificationInfo;
        new (classifications: System.Collections.Generic.IEnumerable$1<Kusto.Language.Editor.ClassifiedRange> | null): ClassificationInfo;
        Empty: Kusto.Language.Editor.ClassificationInfo | null;
    }
    var ClassificationInfo: ClassificationInfoFunc;

    enum BrackettingStyle {
        None = 0,
        Vertical = 1,
        Diagonal = 2
    }

    interface CodeAnalyzer {
        /**
         * The name of this {@link }
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeAnalyzer
         * @function Name
         * @type string
         */
        Name: string | null;
        /**
         * The diagnostics produced by this {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeAnalyzer
         * @function Diagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
    }
    interface CodeAnalyzerFunc extends Function {
        prototype: CodeAnalyzer;
        new (): CodeAnalyzer;
    }
    var CodeAnalyzer: CodeAnalyzerFunc;

    /**
     * A service that provides intellisense and other editor related features over a piece of code.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Editor.CodeService
     */
    interface CodeService {
        /**
         * The kind of code found in the text (see {@link }).
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeService
         * @function Kind
         * @type string
         */
        Kind: string | null;
        /**
         * The text of the code.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Editor.CodeService
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * Determines if the feature is supported at the position within the text.
         If the position is not specified, then the feature is considered over the entire text.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {string}     feature     The name of feature. See {@link }
         * @param   {number}     position    The text position where the feature support is in question. If not specified, the entire block is considered.
         * @return  {boolean}
         */
        IsFeatureSupported(feature: string | null, position?: number): boolean;
        /**
         * Gets the diagnostics if already computed.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {System.Collections.Generic.IReadOnlyList}    diagnostics
         * @return  {boolean}
         */
        TryGetCachedDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        /**
         * Gets the diagnostics for the code.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {boolean}                                       waitForAnalysis      If false, only return pre-computed results if any.
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken    Optional cancellation token.
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetDiagnostics(waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Gets the analyzers diagnostics if already computed.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {System.Collections.Generic.IReadOnlyList}    diagnostics
         * @return  {boolean}
         */
        TryGetCachedAnalyzerDiagnostics(diagnostics: {v: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null}): boolean;
        /**
         * Gets any additional diagnostics for the code.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {System.Collections.Generic.IReadOnlyList$1}    analyzers            An optional list of analyzers to use. If null, all known analyzers are used.
         * @param   {boolean}                                       waitForAnalysis      If false, only return pre-computed results if any.
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken    Optional cancellation token.
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetAnalyzerDiagnostics(analyzers?: System.Collections.Generic.IReadOnlyList$1<string> | null, waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Gets the list of information about the analyzers available via this {@link }.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetAnalyzers(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.AnalyzerInfo> | null;
        /**
         * Gets the set of code actions available at the specified position.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                    position             
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Editor.CodeActionInfo}
         */
        GetCodeActions(position: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionInfo | null;
        /**
         * Applies the code action at ths specified position.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                    position             
         * @param   {Kusto.Language.Editor.CodeAction}          codeAction           
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Editor.CodeActionResult}
         */
        ApplyCodeAction(position: number, codeAction: Kusto.Language.Editor.CodeAction | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CodeActionResult | null;
        /**
         * Gets the classifications for the elements the specified text range.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                      start                The start of the text range to get classifications for.
         * @param   {number}                                      length               The length of the text range to get classifications for.
         * @param   {boolean}                                     clipToRange          If true, then adjust the start and end of classification ranges so they do not start before or go beyond the specified range.
         * @param   {boolean}                                     waitForAnalysis      If false, do not require semantic analysis to be performed.
         * @param   {Kusto.Language.Utils.CancellationToken}      cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.ClassificationInfo}
         */
        GetClassifications(start: number, length: number, clipToRange?: boolean, waitForAnalysis?: boolean, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.ClassificationInfo | null;
        /**
         * Gets the ranges of the text that can be expanded or collapsed.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.OutlineInfo}
         */
        GetOutlines(cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.OutlineInfo | null;
        /**
         * Determines if a completion list should be shown automatically during typing.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                    position             The text position of the caret.
         * @param   {number}                                    key                  The last key typed.
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    Optional cancellation token.
         * @return  {boolean}
         */
        ShouldAutoComplete(position: number, key: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): boolean;
        /**
         * Gets the completion items for the position within the text.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                     position             The text position of the caret.
         * @param   {Kusto.Language.Editor.CompletionOptions}    options              Optional options.
         * @param   {Kusto.Language.Utils.CancellationToken}     cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.CompletionInfo}
         */
        GetCompletionItems(position: number, options?: Kusto.Language.Editor.CompletionOptions | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.CompletionInfo | null;
        /**
         * Gets the {@link } associated with the position within the text.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                    position             The text position of the caret.
         * @param   {Kusto.Language.Editor.QuickInfoOptions}    options              Any options specified for quick info.
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.QuickInfo}
         */
        GetQuickInfo(position: number, options?: Kusto.Language.Editor.QuickInfoOptions | null, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.QuickInfo | null;
        /**
         * Gets the {@link } of the syntax element at or adjacent to the text position.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                    position             The text position of the caret.
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.TextRange}
         */
        GetElement(position: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.TextRange | null;
        /**
         * Gets a list of all the syntax elements related to the syntax element at or adjacent to the text position.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {number}                                      position             The text position of the caret.
         * @param   {Kusto.Language.Editor.FindRelatedOptions}    options              Optional options
         * @param   {Kusto.Language.Utils.CancellationToken}      cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.RelatedInfo}
         */
        GetRelatedElements(position: number, options?: Kusto.Language.Editor.FindRelatedOptions, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.RelatedInfo | null;
        /**
         * Gets a list of all the explicit cluster references in the text.
         These are clusters specified in calls to the cluster() function.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken    Optional cancellation token.
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetClusterReferences(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClusterReference> | null;
        /**
         * Gets a list of all the explicit database references in the text.
         These are databases specified in calls to the database() function.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {Kusto.Language.Utils.CancellationToken}        cancellationToken    Optional cancellation token.
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetDatabaseReferences(cancellationToken?: Kusto.Language.Utils.CancellationToken): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.DatabaseReference> | null;
        /**
         * Gets the text with all whitespace/trivia minimized.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {Kusto.Language.Editor.MinimalTextKind}     kind                 The kind of minimal text to produce.
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken    Optional cancellation token.
         * @return  {string}
         */
        GetMinimalText(kind: Kusto.Language.Editor.MinimalTextKind, cancellationToken?: Kusto.Language.Utils.CancellationToken): string | null;
        /**
         * Gets the text with all the whitespace/trivia formatted using the specified options.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @param   {Kusto.Language.Editor.FormattingOptions}    options              Optional options.
         * @param   {number}                                     cursorPosition       The text position of the caret before formatting.
         * @param   {Kusto.Language.Utils.CancellationToken}     cancellationToken    Optional cancellation token.
         * @return  {Kusto.Language.Editor.FormattedText}
         */
        GetFormattedText(options?: Kusto.Language.Editor.FormattingOptions | null, cursorPosition?: number, cancellationToken?: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.FormattedText | null;
        /**
         * Gets the client parameter references embedded in the text.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Editor.CodeService
         * @memberof Kusto.Language.Editor.CodeService
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetClientParameters(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.ClientParameter> | null;
    }
    interface CodeServiceFunc extends Function {
        prototype: CodeService;
        new (): CodeService;
    }
    var CodeService: CodeServiceFunc;

    interface KustoClassifier {
    }
    interface KustoClassifierFunc extends Function {
        prototype: KustoClassifier;
        new (): KustoClassifier;
        GetClassifications(root: Kusto.Language.Syntax.SyntaxNode | null, start: number, length: number, clipToRange: boolean, list: System.Collections.Generic.List$1<Kusto.Language.Editor.ClassifiedRange> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
        /**
         * Determines if an identifier token is being used as a keyword (not a name)
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoClassifier
         * @memberof Kusto.Language.Editor.KustoClassifier
         * @param   {Kusto.Language.Syntax.SyntaxToken}    token
         * @return  {boolean}
         */
    }
    var KustoClassifier: KustoClassifierFunc;

    interface FormattedText {
        /**
         * The formatted text
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattedText
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * The new cursor position within the newly formatted text.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.FormattedText
         * @function Position
         * @type number
         */
        Position: number;
    }
    interface FormattedTextFunc extends Function {
        prototype: FormattedText;
        new (newText: string | null, newPosition: number): FormattedText;
    }
    var FormattedText: FormattedTextFunc;

    interface QuickInfoOptions {
        /**
         * A comma separated list of diagnostic codes that are disabled.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.QuickInfoOptions
         * @function DisabledDiagnostics
         * @type string
         */
        DisabledDiagnostics: string | null;
        WithDisabledDiagnostics(disabledDiagnostics: string | null): Kusto.Language.Editor.QuickInfoOptions | null;
    }
    interface QuickInfoOptionsFunc extends Function {
        prototype: QuickInfoOptions;
        Default: Kusto.Language.Editor.QuickInfoOptions | null;
    }
    var QuickInfoOptions: QuickInfoOptionsFunc;

    enum QuickInfoKind {
        Text = 0,
        Error = 1,
        Warning = 2,
        Suggestion = 3,
        Column = 4,
        Table = 5,
        Database = 6,
        Cluster = 7,
        Literal = 8,
        Type = 9,
        Pattern = 10,
        Parameter = 11,
        Scalar = 12,
        Variable = 13,
        LocalFunction = 14,
        BuiltInFunction = 15,
        DatabaseFunction = 16,
        Operator = 17,
        Command = 18,
        Option = 19
    }

    interface QuickInfoItem {
        Kind: Kusto.Language.Editor.QuickInfoKind;
        Parts: System.Collections.Generic.IReadOnlyCollection$1<Kusto.Language.Editor.ClassifiedText> | null;
        Text: string | null;
    }
    interface QuickInfoItemFunc extends Function {
        prototype: QuickInfoItem;
        $ctor2: {
            new (kind: Kusto.Language.Editor.QuickInfoKind, text: string | null): QuickInfoItem
        };
        ctor: {
            new (kind: Kusto.Language.Editor.QuickInfoKind, parts: Kusto.Language.Editor.ClassifiedText[] | null): QuickInfoItem
        };
        $ctor1: {
            new (kind: Kusto.Language.Editor.QuickInfoKind, parts: System.Collections.Generic.IEnumerable$1<Kusto.Language.Editor.ClassifiedText> | null): QuickInfoItem
        };
    }
    var QuickInfoItem: QuickInfoItemFunc;

    interface QuickInfo {
        Items: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.QuickInfoItem> | null;
        Text: string | null;
    }
    interface QuickInfoFunc extends Function {
        prototype: QuickInfo;
        $ctor2: {
            new (text: string | null): QuickInfo
        };
        ctor: {
            new (items: Kusto.Language.Editor.QuickInfoItem[] | null): QuickInfo
        };
        $ctor1: {
            new (items: System.Collections.Generic.IEnumerable$1<Kusto.Language.Editor.QuickInfoItem> | null): QuickInfo
        };
        Empty: Kusto.Language.Editor.QuickInfo | null;
    }
    var QuickInfo: QuickInfoFunc;

    enum PlacementStyle {
        None = 0,
        NewLine = 1,
        Smart = 2
    }

    interface OutlineRange {
        /**
         * The start of the outline range.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.OutlineRange
         * @function Start
         * @type number
         */
        Start: number;
        /**
         * The length of the outline range.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.OutlineRange
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The text to show when the range is collapsed.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Editor.OutlineRange
         * @function CollapsedText
         * @type string
         */
        CollapsedText: string | null;
    }
    interface OutlineRangeFunc extends Function {
        prototype: OutlineRange;
        new (start: number, length: number, collapsedText: string | null): OutlineRange;
    }
    var OutlineRange: OutlineRangeFunc;

    interface OutlineInfo {
        Ranges: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.OutlineRange> | null;
    }
    interface OutlineInfoFunc extends Function {
        prototype: OutlineInfo;
        new (ranges: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.OutlineRange> | null): OutlineInfo;
        Empty: Kusto.Language.Editor.OutlineInfo | null;
    }
    var OutlineInfo: OutlineInfoFunc;

    enum MinimalTextKind {
        RemoveLeadingWhitespaceAndComments = 0,
        MinimizeWhitespaceAndRemoveComments = 1,
        SingleLine = 2
    }

    interface KustoRelatedElementFinder {
        FindRelatedElements(position: number, options?: Kusto.Language.Editor.FindRelatedOptions): Kusto.Language.Editor.RelatedInfo | null;
        GetRelatedNameReferencesAndDeclarations(token: Kusto.Language.Syntax.SyntaxToken | null, elements: System.Collections.Generic.List$1<Kusto.Language.Editor.RelatedElement> | null, options: Kusto.Language.Editor.FindRelatedOptions): void;
    }
    interface KustoRelatedElementFinderFunc extends Function {
        prototype: KustoRelatedElementFinder;
        new (code: Kusto.Language.KustoCode | null): KustoRelatedElementFinder;
        /**
         * Returns true if the symbol of element <b />
         is equal to <b />
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoRelatedElementFinder
         * @memberof Kusto.Language.Editor.KustoRelatedElementFinder
         * @param   {Kusto.Language.Symbols.Symbol}               symbol     
         * @param   {Kusto.Language.Syntax.SyntaxElement}         element    
         * @param   {Kusto.Language.Editor.FindRelatedOptions}    options
         * @return  {boolean}
         */
    }
    var KustoRelatedElementFinder: KustoRelatedElementFinderFunc;

    interface KustoQuickInfoBuilder {
        /**
         * Gets the quick info for the item near the specified text position.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.KustoQuickInfoBuilder
         * @memberof Kusto.Language.Editor.KustoQuickInfoBuilder
         * @param   {number}                                    position             
         * @param   {Kusto.Language.Utils.CancellationToken}    cancellationToken
         * @return  {Kusto.Language.Editor.QuickInfo}
         */
        GetQuickInfo(position: number, cancellationToken: Kusto.Language.Utils.CancellationToken): Kusto.Language.Editor.QuickInfo | null;
    }
    interface KustoQuickInfoBuilderFunc extends Function {
        prototype: KustoQuickInfoBuilder;
        new (service: Kusto.Language.Editor.KustoCodeService | null, code: Kusto.Language.KustoCode | null, options: Kusto.Language.Editor.QuickInfoOptions | null): KustoQuickInfoBuilder;
    }
    var KustoQuickInfoBuilder: KustoQuickInfoBuilderFunc;

    interface KustoCompleter {
        GetCompletionItems(position: number): Kusto.Language.Editor.CompletionInfo | null;
        /**
         * Determines if a completion list should be shown automatically during typing.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}     position    The text position of the caret.
         * @param   {number}     key         The last key typed.
         * @return  {boolean}
         */
        ShouldAutoComplete(position: number, key: number): boolean;
        /**
         * Determines if completion should be shown at the specified text position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}     position
         * @return  {boolean}
         */
        /**
         * Get the token that the position has affinity with,
         or null if the position does not have affinity (in whitespace between tokens).
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                               position
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Get's completion items for local variables in scope that are type requested type
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Symbols.SymbolMatch}                        match          
         * @param   {Kusto.Language.Symbols.ScalarSymbol}                       type           
         * @param   {number}                                                    position       
         * @param   {Kusto.Language.Syntax.SyntaxNode}                          contextNode    
         * @param   {Kusto.Language.Editor.KustoCompleter.CompletionBuilder}    builder
         * @return  {void}
         */
        /**
         * Gets the {@link } at the specified text position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                                  position
         * @return  {Kusto.Language.Editor.CompletionHint}
         */
        /**
         * Gets the {@link } for the specified child slot of the context node
         and any following slots that can offer additional hints.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Syntax.SyntaxNode}        contextNode    
         * @param   {number}                                  childIndex     
         * @param   {Kusto.Language.Editor.CompletionHint}    defaultHint
         * @return  {Kusto.Language.Editor.CompletionHint}
         */
        /**
         * Gets the {@link } for the specified child slot of the context node.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Syntax.SyntaxNode}        contextNode    
         * @param   {number}                                  childIndex     
         * @param   {Kusto.Language.Editor.CompletionHint}    default
         * @return  {Kusto.Language.Editor.CompletionHint}
         */
        GetParameterHint(signatures: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Signature> | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, parameterName: string | null, iArgument: number): Kusto.Language.Editor.CompletionHint;
        /**
         * Find the most suitable node and child slot that contains the text position.
         *
         * @instance
         * @public
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                              position             
         * @param   {Kusto.Language.Syntax.SyntaxNode}    contextNode          
         * @param   {System.Int32}                        contextChildIndex
         * @return  {boolean}
         */
        TryGetCompletionContext(position: number, contextNode: {v: Kusto.Language.Syntax.SyntaxNode | null}, contextChildIndex: {v: number}): boolean;
        /**
         * Gets the annotations on the grammar rules that are invoke for the token at the specified text position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                                        position
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        /**
         * Gets a list of all annotated parsers that are invoked for the token at the specified text position.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                               position            
         * @param   {System.Collections.Generic.List$1}    annotatedParsers
         * @return  {void}
         */
        /**
         * Find a nearby starting point (contextNode) and grammar rule to search with
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {number}                           position       
         * @param   {System.Int32}                     searchStart    
         * @param   {Kusto.Language.Parsing.Parser}    grammar
         * @return  {void}
         */
        /**
         * Returns true if the operator is defined for the left operand type.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Symbols.OperatorKind}     kind              
         * @param   {Kusto.Language.Symbols.TypeSymbol}       arg0Type          
         * @param   {Kusto.Language.Editor.CompletionHint}    returnTypeHint
         * @return  {boolean}
         */
    }
    interface KustoCompleterFunc extends Function {
        prototype: KustoCompleter;
        CompletionBuilder: Kusto.Language.Editor.KustoCompleter.CompletionBuilderFunc;
        CompletionMode: KustoCompleter.CompletionModeFunc;
        OrderingRank: KustoCompleter.OrderingRankFunc;
        new (code: Kusto.Language.KustoCode | null, options: Kusto.Language.Editor.CompletionOptions | null, cancellationToken: Kusto.Language.Utils.CancellationToken): KustoCompleter;
        /**
         * True if the node only contains one descendant {@link }
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Syntax.SyntaxNode}    node
         * @return  {boolean}
         */
        /**
         * Gets the index of a child node within the parent context corresponding to the text position.
         If the position is between nodes (in trivia/whitespace) it chooses the best index between existing nodes, that currently has no child node.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Syntax.SyntaxNode}    node        
         * @param   {number}                              position
         * @return  {number}
         */
        /**
         * determines if the node has an empty child appropriate for the position.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoCompleter
         * @memberof Kusto.Language.Editor.KustoCompleter
         * @param   {Kusto.Language.Syntax.SyntaxElement}    element     
         * @param   {number}                                 position
         * @return  {boolean}
         */
    }
    var KustoCompleter: KustoCompleterFunc;
    module KustoCompleter {
        interface CompletionBuilder {
            ToList(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Editor.CompletionItem> | null;
            Add(item: Kusto.Language.Editor.CompletionItem | null): void;
            AddRange(items: System.Collections.Generic.IEnumerable$1<Kusto.Language.Editor.CompletionItem> | null): void;
        }
        interface CompletionBuilderFunc extends Function {
            prototype: CompletionBuilder;
            new (): CompletionBuilder;
        }

        interface CompletionMode {
        }
        interface CompletionModeFunc extends Function {
            prototype: CompletionMode;
            /**
             * The completions should be shown alone
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 0
             * @type number
             */
            Isolated: number;
            /**
             * The completions should be shown with other completions
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 1
             * @type number
             */
            Combined: number;
        }

        interface OrderingRank {
        }
        interface OrderingRankFunc extends Function {
            prototype: OrderingRank;
            Literal: number;
            Aggregate: number;
            Column: number;
            Table: number;
            Variable: number;
            Function: number;
            MaterializedView: number;
            Keyword: number;
            StringOperator: number;
            MathOperator: number;
            Other: number;
        }
    }

    interface AvoidUsingToBoolOnNumericsAnalyzer extends Kusto.Language.Editor.KustoAnalyzer {
        Analyze(code: Kusto.Language.KustoCode | null, diagnostics: System.Collections.Generic.List$1<Kusto.Language.Diagnostic> | null, cancellationToken: Kusto.Language.Utils.CancellationToken): void;
    }
    interface AvoidUsingToBoolOnNumericsAnalyzerFunc extends Function {
        prototype: AvoidUsingToBoolOnNumericsAnalyzer;
        new (): AvoidUsingToBoolOnNumericsAnalyzer;
    }
    var AvoidUsingToBoolOnNumericsAnalyzer: AvoidUsingToBoolOnNumericsAnalyzerFunc;

    /**
     * Rewrites whitespace to conform to formatting options.
     *
     * @class Kusto.Language.Editor.KustoFormatter
     */
    interface KustoFormatter {
        /**
         * Writes the node to text, applying the formatting rules
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}    node           
         * @param   {number}                              indentation
         * @return  {void}
         */
        /**
         * Identify formatting rules for all nodes and tokens.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}    node
         * @return  {void}
         */
        /**
         * Add spacing and alignment rules for individual tokens
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    token
         * @return  {void}
         */
        /**
         * Add spacing and alignment rules specific to types of nodes
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}    node
         * @return  {void}
         */
        /**
         * Place operator that is part of an operator chain that is part of a query operator or clause (not nested in parens, etc)
          on new line if the overall chain is large.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.BinaryExpression}    be
         * @return  {void}
         */
        /**
         * Create and indentation (alignment) rule.
         If the relativeTo item is specified, the resulting alignment will be relative to this items alignment.
         If the relaetiveTo item is not specified, the resulting alignment will be relative to the current alignment.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxElement}                   relativeTo
         * @return  {Kusto.Language.Editor.KustoFormatter.AlignmentRule}
         */
        /**
         * Add a spacing rule for the first token of the specified node.
         If a spacing rule already exists, this one takes precidence.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}                    node    
         * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
         * @return  {void}
         */
        /**
         * Add a spacing rule for the specified token.
         If a spacing rule already exists, this one takes precidence.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}                   token    
         * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
         * @return  {void}
         */
        /**
         * Returns true if the tokens are currently or will end up on different lines.
         Returns null if the outcome is unknown due to cyclic dependencies between formatting rules.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
         * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
        /**
         * Returns true if the tokens of the node are currently or will end up on different lines.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
        /**
         * Returns true if the tokens will end up on different lines.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
         * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
        /**
         * Returns true if the tokens of the node will end up on different lines.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
        /**
         * Returns true if the token's trivia will end up with at least one line break.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    token
         * @return  {boolean}
         */
        /**
         * Returns true if the token's trivia definitely will have a line break added.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    token
         * @return  {boolean}
         */
        /**
         * Returns true if the token's trivia will definitely have its line breaks removed.
         *
         * @instance
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    token
         * @return  {boolean}
         */
    }
    interface KustoFormatterFunc extends Function {
        prototype: KustoFormatter;
        SpacingRule: Kusto.Language.Editor.KustoFormatter.SpacingRuleFunc;
        SpacingKind: KustoFormatter.SpacingKindFunc;
        AlignmentRule: Kusto.Language.Editor.KustoFormatter.AlignmentRuleFunc;
        ComputationState: KustoFormatter.ComputationStateFunc;
        /**
         * Gets the formatted text for the node.
         *
         * @static
         * @public
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}           node              
         * @param   {Kusto.Language.Editor.FormattingOptions}    options           
         * @param   {number}                                     cursorPosition
         * @return  {Kusto.Language.Editor.FormattedText}
         */
        GetFormattedText(node: Kusto.Language.Syntax.SyntaxNode | null, options: Kusto.Language.Editor.FormattingOptions | null, cursorPosition: number): Kusto.Language.Editor.FormattedText | null;
        /**
         * Returns true if the tokens were originally on different lines.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxToken}    first        
         * @param   {Kusto.Language.Syntax.SyntaxToken}    last         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
        /**
         * Returns true if the tokens of the node are currently on different lines.
         *
         * @static
         * @private
         * @this Kusto.Language.Editor.KustoFormatter
         * @memberof Kusto.Language.Editor.KustoFormatter
         * @param   {Kusto.Language.Syntax.SyntaxNode}     node         
         * @param   {boolean}                              inclusive    
         * @param   {Kusto.Language.Syntax.SyntaxToken}    excluded
         * @return  {boolean}
         */
    }
    var KustoFormatter: KustoFormatterFunc;
    module KustoFormatter {
        /**
         * A formating rule that dictates the spacing/trivia between tokens.
         *
         * @private
         * @class Kusto.Language.Editor.KustoFormatter.SpacingRule
         */
        interface SpacingRule {
            GetKind(): number;
            /**
             * Create a new {@link } that applies another rule if this rule does not apply.
             *
             * @instance
             * @public
             * @this Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @memberof Kusto.Language.Editor.KustoFormatter.SpacingRule
             * @param   {Kusto.Language.Editor.KustoFormatter.SpacingRule}    rule
             * @return  {Kusto.Language.Editor.KustoFormatter.SpacingRule}
             */
            Otherwise(rule: Kusto.Language.Editor.KustoFormatter.SpacingRule | null): Kusto.Language.Editor.KustoFormatter.SpacingRule | null;
        }
        interface SpacingRuleFunc extends Function {
            prototype: SpacingRule;
            new (kind: number, condition: {(): boolean} | null, otherwise: Kusto.Language.Editor.KustoFormatter.SpacingRule | null): SpacingRule;
            From(kind: number): Kusto.Language.Editor.KustoFormatter.SpacingRule | null;
        }

        interface SpacingKind {
        }
        interface SpacingKindFunc extends Function {
            prototype: SpacingKind;
            /**
             * Spacing is unknown.  This value is not used.
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 0
             * @type number
             */
            Unknown: number;
            /**
             * Leave spacing as is.
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 2
             * @type number
             */
            AsIs: number;
            /**
             * Align leading spacing between tokens if they are on separate lines
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 4
             * @type number
             */
            AlignOnly: number;
            /**
             * No space between tokens
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 8
             * @type number
             */
            NoSpace: number;
            /**
             * No space between tokens if they are on the same line.
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 16
             * @type number
             */
            NoSpaceIfOnSameLine: number;
            /**
             * A single space between tokens.
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 32
             * @type number
             */
            SingleSpace: number;
            /**
             * A single space between tokens if they are on the same line.
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 64
             * @type number
             */
            SingleSpaceIfOnSameLine: number;
            /**
             * A single new line between tokens if they are on the same line
             *
             * @static
             * @public
             * @memberof number
             * @constant
             * @default 128
             * @type number
             */
            NewLine: number;
        }

        /**
         * A formatting rule that determines the relative alignment between syntax elements
         when they appear on separate lines.
         *
         * @private
         * @class Kusto.Language.Editor.KustoFormatter.AlignmentRule
         */
        interface AlignmentRule {
            /**
             * The element to align relative to.
             If this value is null, alignment is relative to the current default.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.KustoFormatter.AlignmentRule
             * @function RelativeToElement
             * @type Kusto.Language.Syntax.SyntaxElement
             */
            RelativeToElement: Kusto.Language.Syntax.SyntaxElement | null;
            /**
             * The relative indentation (number of spaces to indent/exdent?).
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Editor.KustoFormatter.AlignmentRule
             * @function IndentationDelta
             * @type number
             */
            IndentationDelta: number;
        }
        interface AlignmentRuleFunc extends Function {
            prototype: AlignmentRule;
            ctor: {
                new (relativeTo: Kusto.Language.Syntax.SyntaxElement | null, indentationDelta: number): AlignmentRule
            };
            $ctor1: {
                new (indentationDelta: number): AlignmentRule
            };
        }

        interface ComputationState {
        }
        interface ComputationStateFunc extends Function {
            prototype: ComputationState;
            Uncomputed: number;
            Computing: number;
            Computed: number;
        }
    }

}

    /**
     * @memberof Kusto.Language.Parsing
     * @callback Kusto.Language.Parsing.SourceConsumer
     * @param   {Kusto.Language.Parsing.Source$1}    source    
     * @param   {number}                             start
     * @return  {number}
     */

    /**
     * @memberof Kusto.Language.Parsing
     * @callback Kusto.Language.Parsing.SourceProducer
     * @param   {Kusto.Language.Parsing.Source$1}    source    
     * @param   {number}                             start     
     * @param   {number}                             length
     * @return  {TOutput}
     */

declare namespace Kusto.Language.Parsing {
    interface MapParser$2<TInput,TOutput> extends Kusto.Language.Parsing.ResultPrimaryParser$2<TInput,TOutput> {
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface MapParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: MapParser$2<TInput,TOutput>;
            Node: Kusto.Language.Parsing.MapParser$2.NodeFunc;
            $ctor1: {
                new (keyValuePairs: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.KeyValuePair$2<System.Collections.Generic.IEnumerable$1<TInput>,{(): TOutput}>> | null): MapParser$2<TInput,TOutput>
            };
        }
    }
    var MapParser$2: MapParser$2Func;
    module MapParser$2 {
        interface Node<TInput,TOutput> {
            HasValue: boolean;
            Value: {(): TOutput} | null;
            TryGetValueNode(key: TInput, node: {v: Kusto.Language.Parsing.MapParser$2.Node<TInput,TOutput> | null}): boolean;
        }
        interface NodeFunc extends Function {
            <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
                prototype: Node<TInput,TOutput>;
                From(keyValuePairs: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.KeyValuePair$2<System.Collections.Generic.IEnumerable$1<TInput>,{(): TOutput}>> | null): Kusto.Language.Parsing.MapParser$2.Node<TInput,TOutput> | null;
            }
        }
    }

    interface OneOrMoreParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface OneOrMoreParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: OneOrMoreParser$1<TInput>;
            new (parser: Kusto.Language.Parsing.Parser$1<TInput> | null): OneOrMoreParser$1<TInput>;
        }
    }
    var OneOrMoreParser$1: OneOrMoreParser$1Func;

    /** @namespace Kusto.Language.Parsing */

    /**
     * A source of text for syntax parsing
     *
     * @public
     * @class Kusto.Language.Parsing.TextSource
     * @augments Kusto.Language.Parsing.Source$1
     */
    interface TextSource extends Kusto.Language.Parsing.Source$1<number> {
        /**
         * The current position within the source text.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.TextSource
         * @function Position
         * @type number
         */
        Position: number;
        Peek(n?: number): number;
        IsEnd(n?: number): boolean;
        /**
         * Eat the specified number of characters from the input.
         *
         * @instance
         * @public
         * @override
         * @this Kusto.Language.Parsing.TextSource
         * @memberof Kusto.Language.Parsing.TextSource
         * @param   {number}    n
         * @return  {void}
         */
        Eat(n: number): void;
        PeekText(length: number): string | null;
        PeekText$1(start: number, length: number): string | null;
        Matches(start: number, text: string | null): boolean;
        Matches$1(start: number, text: string | null, ignoreCase: boolean): boolean;
        EatText(length: number): string | null;
    }
    interface TextSourceFunc extends Function {
        prototype: TextSource;
        $ctor1: {
            new (source: string | null, offset: number, length: number): TextSource
        };
        ctor: {
            new (source: string | null): TextSource
        };
    }
    var TextSource: TextSourceFunc;

    interface ZeroOrMoreParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
        ZeroOrOne: boolean;
        IsOptional: boolean;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface ZeroOrMoreParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: ZeroOrMoreParser$1<TInput>;
            new (parser: Kusto.Language.Parsing.Parser$1<TInput> | null, zeroOrOne: boolean): ZeroOrMoreParser$1<TInput>;
        }
    }
    var ZeroOrMoreParser$1: ZeroOrMoreParser$1Func;

    /**
     * A parser that will produce exactly one output item if it succeeds.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.Parser$2
     * @augments Kusto.Language.Parsing.Parser$1
     */
    interface Parser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        /**
         * Creates a copy of this {@link } with the tag specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @param   {string}                             tag
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        WithTag$1(tag: string | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        /**
         * Creates a copy of this {@link } with the annotations specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @param   {System.Collections.Generic.IEnumerable$1}    annotations
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        WithAnnotations$1(annotations: System.Collections.Generic.IEnumerable$1<any> | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        /**
         * Creates a copy of this {@link } with the IsHidden property specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @param   {boolean}                            isHidden
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        WithIsHidden$1(isHidden: boolean): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        /**
         * Creates a copy of this {@link } with the IsHidden property set to true.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Hide$1(): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        /**
         * Creates a copy of this {@link } that converts its output to the specified type.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @param   {Function}                           TNewOutput    The type to convert the output to.
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Cast<TNewOutput>(TNewOutput: {prototype: TNewOutput}): Kusto.Language.Parsing.Parser$2<TInput,TNewOutput> | null;
        /**
         * Parses input source items and produces a single output item.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$2
         * @memberof Kusto.Language.Parsing.Parser$2
         * @param   {Kusto.Language.Parsing.Source$1}         input         
         * @param   {number}                                  inputStart
         * @return  {Kusto.Language.Parsing.ParseResult$1}
         */
        Parse$1(input: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
    }
    interface Parser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: Parser$2<TInput,TOutput>;
            new (): Parser$2<TInput,TOutput>;
        }
    }
    var Parser$2: Parser$2Func;

    interface ApplyParser$3<TInput,TLeft,TOutput> extends Kusto.Language.Parsing.ListPrimaryParser$2<TInput,TOutput> {
        LeftParser: Kusto.Language.Parsing.Parser$2<TInput,TLeft> | null;
        RightParser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        ApplyKind: Kusto.Language.Parsing.ApplyKind;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface ApplyParser$3Func extends Function {
        <TInput, TLeft, TOutput>($TInput: Bridge.TypeRef<TInput>, $TLeft: Bridge.TypeRef<TLeft>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ApplyParser$3<TInput,TLeft,TOutput>;
            $ctor1: {
                new (kind: Kusto.Language.Parsing.ApplyKind, leftParser: Kusto.Language.Parsing.Parser$2<TInput,TLeft> | null, rightParser: Kusto.Language.Parsing.RightParser$2<TInput,TOutput>): ApplyParser$3<TInput,TLeft,TOutput>
            };
        }
    }
    var ApplyParser$3: ApplyParser$3Func;

    /**
     * A parser that converts a series of scanned input items into an output item
     *
     * @public
     * @class Kusto.Language.Parsing.ConvertParser$2
     * @augments Kusto.Language.Parsing.ResultPrimaryParser$2
     */
    interface ConvertParser$2<TInput,TOutput> extends Kusto.Language.Parsing.ResultPrimaryParser$2<TInput,TOutput> {
        Pattern: Kusto.Language.Parsing.Parser$1<TInput> | null;
        ListProducer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null;
        SingleProducer: {(arg: TInput): TOutput} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface ConvertParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ConvertParser$2<TInput,TOutput>;
            ctor: {
                new (pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null): ConvertParser$2<TInput,TOutput>
            };
            $ctor3: {
                new (pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TInput>): TOutput} | null): ConvertParser$2<TInput,TOutput>
            };
            $ctor2: {
                new (pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: TInput): TOutput} | null): ConvertParser$2<TInput,TOutput>
            };
        }
    }
    var ConvertParser$2: ConvertParser$2Func;

    interface ArraySource$1<TInput> extends Kusto.Language.Parsing.Source$1<TInput> {
        Peek(n: number): TInput;
        IsEnd(n?: number): boolean;
        Eat(n: number): void;
    }
    interface ArraySource$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: ArraySource$1<TInput>;
            new (input: System.Collections.Generic.IReadOnlyList$1<TInput> | null, start: number, length: number): ArraySource$1<TInput>;
        }
    }
    var ArraySource$1: ArraySource$1Func;

    interface ForwardParser$2<TInput,TOutput> extends Kusto.Language.Parsing.ListPrimaryParser$2<TInput,TOutput> {
        DeferredParser: {(): Kusto.Language.Parsing.Parser$2<TInput,TOutput>} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface ForwardParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ForwardParser$2<TInput,TOutput>;
            new (deferredParser: {(): Kusto.Language.Parsing.Parser$2<TInput,TOutput>} | null): ForwardParser$2<TInput,TOutput>;
        }
    }
    var ForwardParser$2: ForwardParser$2Func;

    interface MatchParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
    }
    interface MatchParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: MatchParser$1<TInput>;
            ctor: {
                new (consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null): MatchParser$1<TInput>
            };
            $ctor1: {
                new (predicate: {(arg: TInput): boolean} | null): MatchParser$1<TInput>
            };
        }
    }
    var MatchParser$1: MatchParser$1Func;

    interface IfParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Test: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface IfParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: IfParser$1<TInput>;
            new (test: Kusto.Language.Parsing.Parser$1<TInput> | null, parser: Kusto.Language.Parsing.Parser$1<TInput> | null): IfParser$1<TInput>;
        }
    }
    var IfParser$1: IfParser$1Func;

    interface FirstParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputCount: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface FirstParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: FirstParser$1<TInput>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null): FirstParser$1<TInput>;
        }
    }
    var FirstParser$1: FirstParser$1Func;

    interface FailsParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Pattern: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface FailsParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: FailsParser$1<TInput>;
            new (pattern: Kusto.Language.Parsing.Parser$1<TInput> | null): FailsParser$1<TInput>;
        }
    }
    var FailsParser$1: FailsParser$1Func;

    interface EngineCommandGrammar extends Kusto.Language.Parsing.CommandGrammar {
    }
    interface EngineCommandGrammarFunc extends Function {
        prototype: EngineCommandGrammar;
        new (globals: Kusto.Language.GlobalState | null): EngineCommandGrammar;
    }
    var EngineCommandGrammar: EngineCommandGrammarFunc;

    interface AriaBridgeCommandGrammar extends Kusto.Language.Parsing.CommandGrammar {
    }
    interface AriaBridgeCommandGrammarFunc extends Function {
        prototype: AriaBridgeCommandGrammar;
        new (globals: Kusto.Language.GlobalState | null): AriaBridgeCommandGrammar;
    }
    var AriaBridgeCommandGrammar: AriaBridgeCommandGrammarFunc;

    interface ClusterManagerCommandGrammar extends Kusto.Language.Parsing.CommandGrammar {
    }
    interface ClusterManagerCommandGrammarFunc extends Function {
        prototype: ClusterManagerCommandGrammar;
        new (globals: Kusto.Language.GlobalState | null): ClusterManagerCommandGrammar;
    }
    var ClusterManagerCommandGrammar: ClusterManagerCommandGrammarFunc;

    interface RuleParser$2<TInput,TProducer> extends Kusto.Language.Parsing.ListPrimaryParser$2<TInput,TProducer> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null;
        ListProducer: {(arg1: System.Collections.Generic.List$1<any>, arg2: number): TProducer} | null;
        ResultProducer: {(arg1: Kusto.Language.Parsing.Source$1<TInput>, arg2: number): Kusto.Language.Parsing.ParseResult$1<TProducer>} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TProducer>;
        Parse(input: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
    }
    interface RuleParser$2Func extends Function {
        <TInput, TProducer>($TInput: Bridge.TypeRef<TInput>, $TProducer: Bridge.TypeRef<TProducer>): {
            prototype: RuleParser$2<TInput,TProducer>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null, listProducer: {(arg1: System.Collections.Generic.List$1<any>, arg2: number): TProducer} | null, resultProducer: {(arg1: Kusto.Language.Parsing.Source$1<TInput>, arg2: number): Kusto.Language.Parsing.ParseResult$1<TProducer>} | null): RuleParser$2<TInput,TProducer>;
        }
    }
    var RuleParser$2: RuleParser$2Func;

    interface ProduceParser$2<TInput,TProducer> extends Kusto.Language.Parsing.ListPrimaryParser$2<TInput,TProducer> {
        Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Producer: {(arg1: System.Collections.Generic.List$1<any>, arg2: number): TProducer} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface ProduceParser$2Func extends Function {
        <TInput, TProducer>($TInput: Bridge.TypeRef<TInput>, $TProducer: Bridge.TypeRef<TProducer>): {
            prototype: ProduceParser$2<TInput,TProducer>;
            new (parser: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg1: System.Collections.Generic.List$1<any>, arg2: number): TProducer} | null): ProduceParser$2<TInput,TProducer>;
        }
    }
    var ProduceParser$2: ProduceParser$2Func;

    interface BestParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface BestParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: BestParser$1<TInput>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null): BestParser$1<TInput>;
        }
    }
    var BestParser$1: BestParser$1Func;

    interface StackSafeParser$1<TInput> extends Kusto.Language.Parsing.ParserVisitor$2<TInput,Kusto.Language.Parsing.Parser$1<TInput>> {
        Initialize(source: Kusto.Language.Parsing.Source$1<TInput> | null, output: System.Collections.Generic.List$1<any> | null): void;
        Clear(): void;
        /**
         * Parse using private stack, does not use the call stack.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.StackSafeParser$1
         * @memberof Kusto.Language.Parsing.StackSafeParser$1
         * @param   {Kusto.Language.Parsing.Parser$1}    parser         
         * @param   {number}                             inputStart     
         * @param   {number}                             outputStart
         * @return  {number}
         */
        Parse(parser: Kusto.Language.Parsing.Parser$1<TInput> | null, inputStart: number, outputStart: number): number;
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
    }
    interface StackSafeParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: StackSafeParser$1<TInput>;
            ParseState: Kusto.Language.Parsing.StackSafeParser$1.ParseStateFunc;
            new (source: Kusto.Language.Parsing.Source$1<TInput> | null, output: System.Collections.Generic.List$1<any> | null): StackSafeParser$1<TInput>;
        }
    }
    var StackSafeParser$1: StackSafeParser$1Func;
    module StackSafeParser$1 {
        interface ParseState<TInput> {
            /**
             * The accumulated input length consumed by this parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            InputLength: number;
            /**
             * The output start for the next parser.
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            NextOutputStart: number;
            /**
             * The parser execution state
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            State: number;
            /**
             * The result of the last sub-parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            LastResult: number;
            /**
             * The result length of the best failed parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            BestFailedResult: number;
            /**
             * The result length of the best successful parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @type number
             */
            BestSuccessResult: number;
            Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * The input start
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @function InputStart
             * @type number
             */
            InputStart: number;
            /**
             * The true start of the output for the production
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @function OutputStart
             * @type number
             */
            OutputStart: number;
            /**
             * The output count at the beginning of the parse. 
             This may occur after the OutputStart in right-side parsers
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeParser$1.ParseState
             * @function OriginalOutputCount
             * @type number
             */
            OriginalOutputCount: number;
            Init(parser: Kusto.Language.Parsing.Parser$1<TInput> | null, inputStart: number, outputStart: number, outputCount: number): void;
        }
        interface ParseStateFunc extends Function {
            <TInput>($TInput: Bridge.TypeRef<TInput>): {
                prototype: ParseState<TInput>;
                new (): ParseState<TInput>;
            }
        }
    }

    interface SequenceParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface SequenceParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: SequenceParser$1<TInput>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null): SequenceParser$1<TInput>;
        }
    }
    var SequenceParser$1: SequenceParser$1Func;

    interface NotParser$1<TInput> extends Kusto.Language.Parsing.Parser$1<TInput> {
        Pattern: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface NotParser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: NotParser$1<TInput>;
            new (parser: Kusto.Language.Parsing.Parser$1<TInput> | null): NotParser$1<TInput>;
        }
    }
    var NotParser$1: NotParser$1Func;

    interface DataManagerCommandGrammar extends Kusto.Language.Parsing.CommandGrammar {
    }
    interface DataManagerCommandGrammarFunc extends Function {
        prototype: DataManagerCommandGrammar;
        new (globals: Kusto.Language.GlobalState | null): DataManagerCommandGrammar;
    }
    var DataManagerCommandGrammar: DataManagerCommandGrammarFunc;

    /**
     * All predefined rules used by command grammar parsers
     *
     * @public
     * @class Kusto.Language.Parsing.PredefinedRuleParsers
     */
    interface PredefinedRuleParsers {
        RawGuidLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        GuidLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        AnyGuidLiteralOrString: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        StringLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        ColumnNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        TableNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        ExternalTableNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        MaterializedViewNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        ClusterNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseFunctionNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseOrTableNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseTableNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseOrTableOrColumnNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        DatabaseTableColumnNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        TableOrColumnNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        TableColumnNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        BracketedStringLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        Value: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        Type: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        NameDeclarationOrStringLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        WildcardedNameDeclaration: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        QualifiedWildcardedNameDeclaration: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        FunctionDeclaration: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        FunctionBody: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        CommandInput: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        InputText: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        BracketedInputText: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        MissingStringLiteral: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingValue: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingType: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingNameReference: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingNameDeclaration: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingFunctionDeclaration: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingFunctionBody: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingExpression: {(): Kusto.Language.Syntax.SyntaxElement} | null;
        MissingInputText: {(): Kusto.Language.Syntax.SyntaxElement} | null;
    }
    interface PredefinedRuleParsersFunc extends Function {
        prototype: PredefinedRuleParsers;
        new (queryParser: Kusto.Language.Parsing.QueryGrammar | null, command: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Command> | null): PredefinedRuleParsers;
    }
    var PredefinedRuleParsers: PredefinedRuleParsersFunc;

    interface BestParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$2<TInput,TOutput>> | null;
        IsBetter: {(arg1: TOutput, arg2: TOutput): boolean} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface BestParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: BestParser$2<TInput,TOutput>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$2<TInput,TOutput>> | null, fnIsBetter: {(arg1: TOutput, arg2: TOutput): boolean} | null): BestParser$2<TInput,TOutput>;
        }
    }
    var BestParser$2: BestParser$2Func;

    interface SafeScanner {
    }
    interface SafeScannerFunc extends Function {
        prototype: SafeScanner;
        ScannerPool$1: Kusto.Language.Parsing.SafeScanner.ScannerPool$1Func;
        new (): SafeScanner;
        ScanSafe<TInput>(TInput: {prototype: TInput}, parser: Kusto.Language.Parsing.Parser$1<TInput> | null, source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    var SafeScanner: SafeScannerFunc;
    module SafeScanner {
        interface ScannerPool$1<TInput> {
        }
        interface ScannerPool$1Func extends Function {
            <TInput>($TInput: Bridge.TypeRef<TInput>): {
                prototype: ScannerPool$1<TInput>;
                new (): ScannerPool$1<TInput>;
                Pool: Kusto.Language.Utils.ObjectPool$1<Kusto.Language.Parsing.StackSafeScanner$1<TInput>> | null;
            }
        }
    }

    interface SafeParser {
    }
    interface SafeParserFunc extends Function {
        prototype: SafeParser;
        ParserPool$1: Kusto.Language.Parsing.SafeParser.ParserPool$1Func;
        new (): SafeParser;
        ParseSafe<TInput>(TInput: {prototype: TInput}, parser: Kusto.Language.Parsing.Parser$1<TInput> | null, source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
    }
    var SafeParser: SafeParserFunc;
    module SafeParser {
        interface ParserPool$1<TInput> {
        }
        interface ParserPool$1Func extends Function {
            <TInput>($TInput: Bridge.TypeRef<TInput>): {
                prototype: ParserPool$1<TInput>;
                new (): ParserPool$1<TInput>;
                Pool: Kusto.Language.Utils.ObjectPool$1<Kusto.Language.Parsing.StackSafeParser$1<TInput>> | null;
            }
        }
    }

    /**
     * A parser that is allowed on the right side of an Apply.
     *
     * @public
     * @class Kusto.Language.Parsing.RightParser$2
     */
    interface RightParser$2<TInput,TOutput> {
        /**
         * Creates a copy of this {@link } with the tag specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.RightParser$2
         * @memberof Kusto.Language.Parsing.RightParser$2
         * @param   {string}                                  tag
         * @return  {Kusto.Language.Parsing.RightParser$2}
         */
        WithTag(tag: string | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
        /**
         * Creates a copy of this {@link } with the annotations specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.RightParser$2
         * @memberof Kusto.Language.Parsing.RightParser$2
         * @param   {System.Collections.Generic.IEnumerable$1}    annotations
         * @return  {Kusto.Language.Parsing.RightParser$2}
         */
        WithAnnotations(annotations: System.Collections.Generic.IEnumerable$1<any> | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
        /**
         * Creates a copy of this {@link } with the IsHidden property specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.RightParser$2
         * @memberof Kusto.Language.Parsing.RightParser$2
         * @param   {boolean}                                 isHidden
         * @return  {Kusto.Language.Parsing.RightParser$2}
         */
        WithIsHidden(isHidden: boolean): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
        /**
         * Creates a copy of this {@link } with the IsHidden property set to true.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.RightParser$2
         * @memberof Kusto.Language.Parsing.RightParser$2
         * @return  {Kusto.Language.Parsing.RightParser$2}
         */
        Hide(): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
        $clone(to: Kusto.Language.Parsing.RightParser$2<TInput,TOutput>): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
    }
    interface RightParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: RightParser$2<TInput,TOutput>;
            new (): RightParser$2<TInput,TOutput>;
            ctor: {
                new (): RightParser$2<TInput,TOutput>
            };
        }
    }
    var RightParser$2: RightParser$2Func;

    interface QueryParser {
        /**
         * Returns the next {@link }
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Parsing.LexicalToken}
         */
        /**
         * Returns the next {@link }
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {number}                                 offset
         * @return  {Kusto.Language.Parsing.LexicalToken}
         */
        /**
         * Returns the next {@link } as a {@link },
         or null if there are no more tokens.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Returns the next {@link } if it matches the kind or null.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {Kusto.Language.Syntax.SyntaxKind}     kind
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Returns the next {@link } if it matches one of the kinds or null.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {System.Collections.Generic.IReadOnlyList$1}    kinds
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Parses one or more adjacent lexical tokens that together matches the text into a single token,
         or returns null.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {string}                               text
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Returns the next {@link } if it matches the kind or a missing version of that token kind.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {Kusto.Language.Syntax.SyntaxKind}     kind
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Parses one or more adjacent lexical tokens that together matches the text into a single token,
         or returns a missing token.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {string}                               text
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        /**
         * Scans one or more adjacent lexical tokens that together matches the text.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {string}    text      
         * @param   {number}    offset
         * @return  {number}
         */
        /**
         * Scans one or more adjacent lexical tokens that together matches the one of the texts.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {System.Collections.Generic.IReadOnlyList$1}    texts     
         * @param   {number}                                        offset
         * @return  {number}
         */
        /**
         * Parses a schema delaration:  (name: type, name: type, ...)
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Syntax.SchemaTypeExpression}
         */
        /**
         * Parses a multi-part schema declaration:  (name: type, name: type, ...)
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Syntax.SchemaTypeExpression}
         */
        /**
         * Parses function parameter list:  (name: type [= value], name: type [= value], ...)
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Syntax.FunctionParameters}
         */
        /**
         * Parses and entire query
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @return  {Kusto.Language.Syntax.QueryBlock}
         */
    }
    interface QueryParserFunc extends Function {
        prototype: QueryParser;
        ParseExpression(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.Expression | null;
        ParseExpression$1(text: string | null): Kusto.Language.Syntax.Expression | null;
        ParseQuery(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.QueryBlock | null;
        ParseQuery$1(text: string | null): Kusto.Language.Syntax.QueryBlock | null;
        ParseFunctionParameters(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.FunctionParameters | null;
        ParseFunctionParameters$1(text: string | null): Kusto.Language.Syntax.FunctionParameters | null;
        ParseFunctionBody(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.FunctionBody | null;
        ParseFunctionBody$1(text: string | null): Kusto.Language.Syntax.FunctionBody | null;
        ParseLiteral(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.Expression | null;
        ParseLiteral$1(text: string | null): Kusto.Language.Syntax.Expression | null;
        ParseSchemaType(tokens: Kusto.Language.Parsing.LexicalToken[] | null, start?: number): Kusto.Language.Syntax.SchemaTypeExpression | null;
        ParseSchemaType$1(text: string | null): Kusto.Language.Syntax.SchemaTypeExpression | null;
        /**
         * Returns the next {@link } if it matches one of the kinds or a missing version of that token kind.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.QueryParser
         * @memberof Kusto.Language.Parsing.QueryParser
         * @param   {System.Collections.Generic.IReadOnlyList$1}    kinds
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
    }
    var QueryParser: QueryParserFunc;

    /**
     * Parsers for the Kusto query grammar.
     *
     * @public
     * @class Kusto.Language.Parsing.QueryGrammar
     */
    interface QueryGrammar {
        QueryBlock: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.QueryBlock> | null;
        Statement: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Statement> | null;
        StatementList: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement>>> | null;
        FunctionBody: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.FunctionBody> | null;
        FunctionParameters: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.FunctionParameters> | null;
        QueryOperator: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.QueryOperator> | null;
        PipeExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        PipeSubExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        FollowingPipeElementExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.QueryOperator> | null;
        Expression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        NamedExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        UnnamedExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        SimpleNameDeclaration: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.NameDeclaration> | null;
        SimpleNameDeclarationExpression: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        BracketedNameDeclaration: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.NameDeclaration> | null;
        IdentifierName: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Name> | null;
        BracketedName: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Name> | null;
        BracedName: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Name> | null;
        ParamTypeExtended: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.TypeExpression> | null;
        SchemaType: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SchemaTypeExpression> | null;
        SimpleNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        WildcardedNameReference: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        WildcardedIdentifier: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        Literal: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        StringLiteral: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Expression> | null;
        LiteralList: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>>> | null;
        SkippedTokens: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SkippedTokens> | null;
        /**
         * Constructs the grammar as a Parser
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.QueryGrammar
         * @memberof Kusto.Language.Parsing.QueryGrammar
         * @return  {void}
         */
    }
    interface QueryGrammarFunc extends Function {
        prototype: QueryGrammar;
        MissingNameDeclarationNode: Kusto.Language.Syntax.NameDeclaration | null;
        MissingNameDeclaration: {(): Kusto.Language.Syntax.NameDeclaration} | null;
        MissingNameDeclarationExpression: {(): Kusto.Language.Syntax.Expression} | null;
        MissingNameReferenceNode: Kusto.Language.Syntax.NameReference | null;
        MissingNameReference: {(): Kusto.Language.Syntax.Expression} | null;
        MissingExpressionNode: Kusto.Language.Syntax.Expression | null;
        MissingExpression: {(): Kusto.Language.Syntax.Expression} | null;
        MissingNamedExpressionNode: Kusto.Language.Syntax.NamedExpression | null;
        MissingNamedExpression: {(): Kusto.Language.Syntax.NamedExpression} | null;
        MissingScanAssignmentNode: Kusto.Language.Syntax.ScanAssignment | null;
        MissingScanAssignment: {(): Kusto.Language.Syntax.ScanAssignment} | null;
        MissingValueNode: Kusto.Language.Syntax.Expression | null;
        MissingValue: {(): Kusto.Language.Syntax.Expression} | null;
        MissingTypeNode: Kusto.Language.Syntax.TypeExpression | null;
        MissingType: {(): Kusto.Language.Syntax.TypeExpression} | null;
        MissingLongLiteralNode: Kusto.Language.Syntax.Expression | null;
        MissingLongLiteral: {(): Kusto.Language.Syntax.Expression} | null;
        MissingRealLiteralNode: Kusto.Language.Syntax.Expression | null;
        MissingRealLiteral: {(): Kusto.Language.Syntax.Expression} | null;
        MissingStringLiteralNode: Kusto.Language.Syntax.Expression | null;
        MissingStringLiteral: {(): Kusto.Language.Syntax.Expression} | null;
        MissingBooleanLiteralNode: Kusto.Language.Syntax.Expression | null;
        MissingBooleanLiteral: {(): Kusto.Language.Syntax.Expression} | null;
        MissingTypeofLiteralNode: Kusto.Language.Syntax.TypeOfLiteralExpression | null;
        MissingTypeOfLiteral: {(): Kusto.Language.Syntax.Expression} | null;
        MissingJsonValueNode: Kusto.Language.Syntax.Expression | null;
        MissingJsonValue: {(): Kusto.Language.Syntax.Expression} | null;
        MissingJsonPairNode: Kusto.Language.Syntax.JsonPair | null;
        MissingJoinOnClauseNode: Kusto.Language.Syntax.JoinOnClause | null;
        MissingJoinOnClause: {(): Kusto.Language.Syntax.JoinConditionClause} | null;
        MissingJsonPair: {(): Kusto.Language.Syntax.JsonPair} | null;
        MissingFunctionCallNode: Kusto.Language.Syntax.FunctionCallExpression | null;
        MissingFunctionCall: {(): Kusto.Language.Syntax.FunctionCallExpression} | null;
        MissingFunctionCallExpression: {(): Kusto.Language.Syntax.Expression} | null;
        MissingSchemaNode: Kusto.Language.Syntax.SchemaTypeExpression | null;
        MissingSchema: {(): Kusto.Language.Syntax.SchemaTypeExpression} | null;
        MissingQueryOperatorNode: Kusto.Language.Syntax.QueryOperator | null;
        MissingQueryOperator: {(): Kusto.Language.Syntax.QueryOperator} | null;
        MissingQueryOperatorExpression: {(): Kusto.Language.Syntax.Expression} | null;
        MissingMakeSeriesExpressionNode: Kusto.Language.Syntax.MakeSeriesExpression | null;
        MissingMakeSeriesExpression: {(): Kusto.Language.Syntax.MakeSeriesExpression} | null;
        MissingMvExpandExpressionNode: Kusto.Language.Syntax.MvExpandExpression | null;
        MissingMvExpandExpression: {(): Kusto.Language.Syntax.MvExpandExpression} | null;
        MissingMvApplyExpressionNode: Kusto.Language.Syntax.MvApplyExpression | null;
        MissingMvApplyExpression: {(): Kusto.Language.Syntax.MvApplyExpression} | null;
        MissingMvApplySubqueryExpressionNode: Kusto.Language.Syntax.MvApplySubqueryExpression | null;
        MissingMvApplySubqueryExpression: {(): Kusto.Language.Syntax.MvApplySubqueryExpression} | null;
        MissingForkExpressionNode: Kusto.Language.Syntax.ForkExpression | null;
        MissingForkExpression: {(): Kusto.Language.Syntax.ForkExpression} | null;
        MissingPartitionOperandNode: Kusto.Language.Syntax.PartitionOperand | null;
        MissingPartitionOperand: {(): Kusto.Language.Syntax.PartitionOperand} | null;
        MissingStatementNode: Kusto.Language.Syntax.Statement | null;
        MissingStatement: {(): Kusto.Language.Syntax.Statement} | null;
        MissingStatementElementNode: Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement> | null;
        MissingStatementElement: {(): Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement>} | null;
        MissingNameAndTypeDeclarationNode: Kusto.Language.Syntax.NameAndTypeDeclaration | null;
        MissingNameAndTypeDeclaration: {(): Kusto.Language.Syntax.NameAndTypeDeclaration} | null;
        MissingFunctionParameterNode: Kusto.Language.Syntax.FunctionParameter | null;
        MissingFunctionParameter: {(): Kusto.Language.Syntax.FunctionParameter} | null;
        MissingNamedParameterNode: Kusto.Language.Syntax.NamedParameter | null;
        MissingNamedParameter: {(): Kusto.Language.Syntax.NamedParameter} | null;
        MissingFunctionDeclarationNode: Kusto.Language.Syntax.FunctionDeclaration | null;
        MissingFunctionDeclaration: {(): Kusto.Language.Syntax.FunctionDeclaration} | null;
        StringOperatorMap: System.Collections.Generic.Dictionary$2<Kusto.Language.Syntax.SyntaxKind,Kusto.Language.Syntax.SyntaxKind> | null;
        /**
         * Gets the {@link } associated with the specified {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.QueryGrammar
         * @memberof Kusto.Language.Parsing.QueryGrammar
         * @param   {Kusto.Language.GlobalState}             globals
         * @return  {Kusto.Language.Parsing.QueryGrammar}
         */
        From(globals: Kusto.Language.GlobalState | null): Kusto.Language.Parsing.QueryGrammar | null;
        MissingTokenLiteralNode(tokens: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.Syntax.Expression | null;
        MissingTokenLiteral(tokens: System.Collections.Generic.IReadOnlyList$1<string> | null): {(): Kusto.Language.Syntax.Expression} | null;
        MissingTokenLiteral$1(tokens: string[] | null): {(): Kusto.Language.Syntax.Expression} | null;
    }
    var QueryGrammar: QueryGrammarFunc;

    interface ParserVisitor$2<TInput,TResult> {
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null): TResult;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null): TResult;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null): TResult;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null): TResult;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null): TResult;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null): TResult;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null): TResult;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null): TResult;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null): TResult;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null): TResult;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null): TResult;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null): TResult;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null): TResult;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null): TResult;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null): TResult;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null): TResult;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null): TResult;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null): TResult;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null): TResult;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null): TResult;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null): TResult;
    }
    interface ParserVisitor$2Func extends Function {
        <TInput, TResult>($TInput: Bridge.TypeRef<TInput>, $TResult: Bridge.TypeRef<TResult>): {
            prototype: ParserVisitor$2<TInput,TResult>;
            new (): ParserVisitor$2<TInput,TResult>;
        }
    }
    var ParserVisitor$2: ParserVisitor$2Func;

    /**
     * Parser combinators, APIs to combine/construt parsers out of other parsers.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.Parsers$1
     */
    interface Parsers$1<TInput> {
    }
    interface Parsers$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: Parsers$1<TInput>;
            LeftValue$1: Kusto.Language.Parsing.Parsers$1.LeftValue$1Func;
            ElementProducer$2: Kusto.Language.Parsing.Parsers$1.ElementProducer$2Func;
            ElementAndSeparatorProducer$3: Kusto.Language.Parsing.Parsers$1.ElementAndSeparatorProducer$3Func;
            new (): Parsers$1<TInput>;
            /**
             * A parser that always consumes one input item, but produces nothing.
             *
             * @static
             * @public
             * @readonly
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @type Kusto.Language.Parsing.Parser$1
             */
            Any: Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes all the input items successfully consumed by the specified parsers.
             Fails if any parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Array.<Kusto.Language.Parsing.Parser$1>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            And(parsers: Kusto.Language.Parsing.Parser$1<TInput>[] | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that yields the result of the left-hand applied to the right-hand parser.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TLeft            
             * @param   {Function}                           TOutput          
             * @param   {Kusto.Language.Parsing.Parser$2}    leftParser       
             * @param   {System.Func}                        fnRightParser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Apply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, leftParser: Kusto.Language.Parsing.Parser$2<TInput,TLeft> | null, fnRightParser: {(arg: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that yields the result of the left-hand parser or the result of applying that value to the right-hand parser.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput          
             * @param   {Kusto.Language.Parsing.Parser$2}    leftParser       
             * @param   {System.Func}                        fnRightParser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            ApplyOptional<TOutput>(TOutput: {prototype: TOutput}, leftParser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, fnRightParser: {(arg: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TOutput>): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A left associative parser that yields the result of the left-hand parser, or the result of applying that value (and subsequent results) to the right-hand parser zero or more times.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput          
             * @param   {Kusto.Language.Parsing.Parser$2}    leftParser       
             * @param   {System.Func}                        fnRightParser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            ApplyZeroOrMore<TOutput>(TOutput: {prototype: TOutput}, leftParser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, fnRightParser: {(arg: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TOutput>): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that yields the result of the parser that consumed the most input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Array.<Kusto.Language.Parsing.Parser$1>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Best(parsers: Kusto.Language.Parsing.Parser$1<TInput>[] | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that yields the result of the parser that consumed the most input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                   TOutput    
             * @param   {Array.<Kusto.Language.Parsing.Parser$2>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Best$1<TOutput>(TOutput: {prototype: TOutput}, parsers: Kusto.Language.Parsing.Parser$2<TInput,TOutput>[] | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that yields the result of the parser that produced the best output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                   TOutput     
             * @param   {Array.<Kusto.Language.Parsing.Parser$2>}    parsers     
             * @param   {System.Func}                                fnBetter
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Best$2<TOutput>(TOutput: {prototype: TOutput}, parsers: Kusto.Language.Parsing.Parser$2<TInput,TOutput>[] | null, fnBetter: {(arg1: TOutput, arg2: TOutput): boolean} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that yields the result of the parser that consumed the most input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TOutput    
             * @param   {Array.<Kusto.Language.Parsing.RightParser$2>}    parsers
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            Best$3<TOutput>(TOutput: {prototype: TOutput}, parsers: Kusto.Language.Parsing.RightParser$2<TInput,TOutput>[] | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that converts all the successfully scanned input items into a single output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                 TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}          pattern     
             * @param   {Kusto.Language.Parsing.SourceProducer}    producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Convert$1<TOutput>(TOutput: {prototype: TOutput}, pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that converts all the successfully scanned input items into a single output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Convert$3<TOutput>(TOutput: {prototype: TOutput}, pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TInput>): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that converts all the successfully scanned input characters into a single output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Convert$4<TOutput>(TOutput: {prototype: TOutput}, pattern: Kusto.Language.Parsing.Parser$1<number> | null, producer: {(arg: string): TOutput} | null): Kusto.Language.Parsing.Parser$2<number,TOutput> | null;
            /**
             * A parser that converts all the successfully scanned input items into a single output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Convert$2<TOutput>(TOutput: {prototype: TOutput}, pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: TInput): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that converts all the successfully scanned input items into a single output item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput    
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern    
             * @param   {TOutput}                            value
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Convert<TOutput>(TOutput: {prototype: TOutput}, pattern: Kusto.Language.Parsing.Parser$1<TInput> | null, value: TOutput): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that produces the count of the number of successfully scanned and consumed input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    scanner
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Count(scanner: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$2<TInput,number> | null;
            /**
             * A parser that succeeds (without consuming input) if the specified parser scan fails. Does not produce output.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Fails(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that yields the result of the first parser to succeed.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                   TOutput    
             * @param   {Array.<Kusto.Language.Parsing.Parser$2>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            First$1<TOutput>(TOutput: {prototype: TOutput}, parsers: Kusto.Language.Parsing.Parser$2<TInput,TOutput>[] | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that yields the result of the first parser to succeed.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Array.<Kusto.Language.Parsing.Parser$1>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            First(parsers: Kusto.Language.Parsing.Parser$1<TInput>[] | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that yields the result of the first parser to succeed.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TOutput    
             * @param   {Array.<Kusto.Language.Parsing.RightParser$2>}    parsers
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            First$2<TOutput>(TOutput: {prototype: TOutput}, parsers: Kusto.Language.Parsing.RightParser$2<TInput,TOutput>[] | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that forwards to a deferred parser.
             This parser is typically used to resolve cycles in grammar.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput           
             * @param   {System.Func}                        deferredParser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Forward<TOutput>(TOutput: {prototype: TOutput}, deferredParser: {(): Kusto.Language.Parsing.Parser$2<TInput,TOutput>} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that produces the result of the specified parser only if a scan of the test parser succeeds.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput    
             * @param   {Kusto.Language.Parsing.Parser$1}    test       
             * @param   {Kusto.Language.Parsing.Parser$2}    parser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            If$1<TOutput>(TOutput: {prototype: TOutput}, test: Kusto.Language.Parsing.Parser$1<TInput> | null, parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that produces the result of the specified parser only if a scan of the test parser succeeds.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                TOutput    
             * @param   {Kusto.Language.Parsing.Parser$1}         test       
             * @param   {Kusto.Language.Parsing.RightParser$2}    parser
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            If$2<TOutput>(TOutput: {prototype: TOutput}, test: Kusto.Language.Parsing.Parser$1<TInput> | null, parser: Kusto.Language.Parsing.RightParser$2<TInput,TOutput>): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that produces the result of the specified parser only if a scan of the test parser succeeds.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    test      
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            If(test: Kusto.Language.Parsing.Parser$1<TInput> | null, parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * Creates a parser that parses a list of elements.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement         
             * @param   {Function}                           TProducer        
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser    The parser for each element.
             * @param   {boolean}                            oneOrMore        If true, the generated parser expects at least one element to exist.
             * @param   {System.Func}                        producer         A function that converts the series of elements into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List<TElement, TProducer>(TElement: {prototype: TElement}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, oneOrMore: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TElement>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement          
             * @param   {Function}                           TProducer         
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser     The parser for each element.
             * @param   {System.Func}                        missingElement    An optional function that constructs a new element to be used when an expected element is missing.
             * @param   {boolean}                            oneOrMore         If true, the generated parser expects at least one element to exist.
             * @param   {System.Func}                        producer          A function that converts the series of elements into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List$1<TElement, TProducer>(TElement: {prototype: TElement}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, missingElement: {(): TElement} | null, oneOrMore: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TElement>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement                   
             * @param   {Function}                           TSeparator                 
             * @param   {Function}                           TProducer                  
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser              The parser for the primary element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser            The parser for each separator.
             * @param   {Kusto.Language.Parsing.Parser$2}    secondaryElementParser     The parser for any elements after the first separator.
             * @param   {System.Func}                        missingElement             An optional function that constructs a new element to be used when the element is missing (between two separators).
             * @param   {System.Func}                        missingSeparator           An optional function that constructs a new separator instance to be used when the separator is missing (between two elements).
             * @param   {System.Func}                        missingSecondaryElement    An optional function that constructs a new element to be used when a second element is missing (between two separators).
             * @param   {Kusto.Language.Parsing.Parser$1}    endOfList                  An optional parser that quickly determines if there are not more elements.
             * @param   {boolean}                            oneOrMore                  If true, the generated parser expects at least one element to exist.
             * @param   {boolean}                            allowTrailingSeparator     If true, it is legal for a final separator to occur without a following element.
             * @param   {System.Func}                        producer                   A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List$3<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, secondaryElementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, missingElement: {(): TElement} | null, missingSeparator: {(): TSeparator} | null, missingSecondaryElement: {(): TElement} | null, endOfList: Kusto.Language.Parsing.Parser$1<TInput> | null, oneOrMore: boolean, allowTrailingSeparator: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement                  
             * @param   {Function}                           TSeparator                
             * @param   {Function}                           TProducer                 
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser             The parser for the primary element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser           The parser for the separator.
             * @param   {System.Func}                        missingElement            An optional function that constructs a new element to be used when the element is missing (between two separators).
             * @param   {System.Func}                        missingSeparator          An optional function that constructs a new separator instance to be used when the separator is missing (between two elements).
             * @param   {Kusto.Language.Parsing.Parser$1}    endOfList                 An optional parser that quickly determines if there are not more elements.
             * @param   {boolean}                            oneOrMore                 If true, the generated parser expects at least one element to exist.
             * @param   {boolean}                            allowTrailingSeparator    If true, it is legal for a final separator to occur without a following element.
             * @param   {System.Func}                        producer                  A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List$5<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, missingElement: {(): TElement} | null, missingSeparator: {(): TSeparator} | null, endOfList: Kusto.Language.Parsing.Parser$1<TInput> | null, oneOrMore: boolean, allowTrailingSeparator: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement                  
             * @param   {Function}                           TSeparator                
             * @param   {Function}                           TProducer                 
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser             The parser for the primary element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser           The parser for the separator.
             * @param   {Kusto.Language.Parsing.Parser$2}    secondaryElementParser    The parser for any elements after the first separator.
             * @param   {boolean}                            oneOrMore                 If true, the generated parser expects at least one element to exist.
             * @param   {System.Func}                        producer                  A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List$2<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, secondaryElementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, oneOrMore: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement           
             * @param   {Function}                           TSeparator         
             * @param   {Function}                           TProducer          
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser      The parser for the primary element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser    The parser for the separator.
             * @param   {boolean}                            oneOrMore          If true, the generated parser expects at least one element to exist.
             * @param   {System.Func}                        producer           A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            List$4<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, oneOrMore: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement                  
             * @param   {Function}                           TSeparator                
             * @param   {Function}                           TProducer                 
             * @param   {Kusto.Language.Parsing.Parser$2}    elementParser             The parser for each element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser           The parser for each separator.
             * @param   {System.Func}                        missingElement            An optional function that constructs a new element to be used when the element is missing (between two separators).
             * @param   {System.Func}                        missingSeparator          An optional function that constructs a new separator instance to be used when the separator is missing (between two elements).
             * @param   {Kusto.Language.Parsing.Parser$1}    endOfList                 An optional parser that quickly determines if there are no more elements.
             * @param   {boolean}                            oneOrMore                 If true, the generated parser expects at least one element to exist.
             * @param   {boolean}                            allowTrailingSeparator    If true, it is legal for a final separator to occur without a following element.
             * @param   {System.Func}                        producer                  A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            OList$1<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, elementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, missingElement: {(): TElement} | null, missingSeparator: {(): TSeparator} | null, endOfList: Kusto.Language.Parsing.Parser$1<TInput> | null, oneOrMore: boolean, allowTrailingSeparator: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<any>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * Creates a parser that parses a list of elements and separators.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement                   
             * @param   {Function}                           TSeparator                 
             * @param   {Function}                           TProducer                  
             * @param   {Kusto.Language.Parsing.Parser$2}    primaryElementParser       The parser for the primary element.
             * @param   {Kusto.Language.Parsing.Parser$2}    separatorParser            The parser for each separator.
             * @param   {Kusto.Language.Parsing.Parser$2}    secondaryElementParser     The parser for any element after the first separator.
             * @param   {System.Func}                        missingPrimaryElement      An optional function that constructs a new element to be used when the primary element is missing (between two separators).
             * @param   {System.Func}                        missingSeparator           An optional function that constructs a new separator instance to be used when the separator is missing (between two elements).
             * @param   {System.Func}                        missingSecondaryElement    An optional function that constructs a new element to be used when the secondary element is missing (between two separators).
             * @param   {Kusto.Language.Parsing.Parser$1}    endOfList                  An optional parser that quickly determines if there are not more elements.
             * @param   {boolean}                            oneOrMore                  If true, the generated parser expects at least one element to exist.
             * @param   {boolean}                            allowTrailingSeparator     If true, it is legal for a final separator to occur without a following element.
             * @param   {System.Func}                        producer                   A function that converts the series of elements and separators into the produced value.
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            OList<TElement, TSeparator, TProducer>(TElement: {prototype: TElement}, TSeparator: {prototype: TSeparator}, TProducer: {prototype: TProducer}, primaryElementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, separatorParser: Kusto.Language.Parsing.Parser$2<TInput,TSeparator> | null, secondaryElementParser: Kusto.Language.Parsing.Parser$2<TInput,TElement> | null, missingPrimaryElement: {(): TElement} | null, missingSeparator: {(): TSeparator} | null, missingSecondaryElement: {(): TElement} | null, endOfList: Kusto.Language.Parsing.Parser$1<TInput> | null, oneOrMore: boolean, allowTrailingSeparator: boolean, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<any>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * A parser that maps sequences of input values to output values.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                    TOutput          
             * @param   {System.Collections.Generic.IEnumerable$1}    keyValuePairs
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Map<TOutput>(TOutput: {prototype: TOutput}, keyValuePairs: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.KeyValuePair$2<System.Collections.Generic.IEnumerable$1<TInput>,TOutput>> | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that maps sequences of input values to output values.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                    TOutput          
             * @param   {System.Collections.Generic.IEnumerable$1}    keyValuePairs
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Map$1<TOutput>(TOutput: {prototype: TOutput}, keyValuePairs: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.KeyValuePair$2<System.Collections.Generic.IEnumerable$1<TInput>,{(): TOutput}>> | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that consumes one input item if it matches the predicate. Does not produce output.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {System.Func}                        predicate
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$5(predicate: {(arg: TInput): boolean} | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes one or more input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.SourceConsumer}    consumer
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$2(consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes one matching input item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {TInput}                             item
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match(item: TInput): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes one matching input item.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {TInput}                                           item        
             * @param   {System.Collections.Generic.EqualityComparer$1}    comparer
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$1(item: TInput, comparer: System.Collections.Generic.EqualityComparer$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes one or more sequential matching input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {System.Collections.Generic.IReadOnlyList$1}    items
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$3(items: System.Collections.Generic.IReadOnlyList$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes one or more sequential matching input items.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {System.Collections.Generic.IReadOnlyList$1}       items       
             * @param   {System.Collections.Generic.EqualityComparer$1}    comparer
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$4(items: System.Collections.Generic.IReadOnlyList$1<TInput> | null, comparer: System.Collections.Generic.EqualityComparer$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that consumes a matching character.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {number}                             ch            
             * @param   {boolean}                            ignoreCase
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$6(ch: number, ignoreCase?: boolean): Kusto.Language.Parsing.Parser$1<number> | null;
            /**
             * A parser that consumes one or more sequential matching characters.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {string}                             text          
             * @param   {boolean}                            ignoreCase
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Match$7(text: string | null, ignoreCase?: boolean): Kusto.Language.Parsing.Parser$1<number> | null;
            /**
             * A parser that producers a single output value from a single input value if it matches the predicate.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput      
             * @param   {System.Func}                        predicate    
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Match$9<TOutput>(TOutput: {prototype: TOutput}, predicate: {(arg: TInput): boolean} | null, producer: {(arg: TInput): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that producers a single output value from one or more input values.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                 TOutput     
             * @param   {Kusto.Language.Parsing.SourceConsumer}    consumer    
             * @param   {Kusto.Language.Parsing.SourceProducer}    producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Match$8<TOutput>(TOutput: {prototype: TOutput}, consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null, producer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that consumes one input item if the specified parser scan fails. Does not produce output.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Not(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that combines one or more parsed values into a single value.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser      
             * @param   {Function}                           TProducer    
             * @param   {Kusto.Language.Parsing.Parser$2}    parser       
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            OneOrMore$1<TParser, TProducer>(TParser: {prototype: TParser}, TProducer: {prototype: TProducer}, parser: Kusto.Language.Parsing.Parser$2<TInput,TParser> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TParser>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * A parser that parsers one or more values from the specified parser.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            OneOrMore(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that produces the specified parser's result or nothing if the specified parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Optional(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that produces the specified parser's result or the default value if the specified parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput    
             * @param   {Kusto.Language.Parsing.Parser$2}    parser
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Optional$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that produces the specified parser's result or the value from the producer function if the specified parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser      
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Optional$2<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, producer: {(): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that succeeds if any of the specified parsers succeed, consuming the greatest number of input items consumed.
             This parser is a synonym for {@link }.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Array.<Kusto.Language.Parsing.Parser$1>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Or(parsers: Kusto.Language.Parsing.Parser$1<TInput>[] | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that combines one or more values produced by a single parser into a new value.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    parser      
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Produce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<any>): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines one or more values produced by a single parser into a new value.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    parser      
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Produce$1<TElement, TOutput>(TElement: {prototype: TElement}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$1<TInput> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TElement>): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines one or more values produced by a single parser into a new value.
             *
             * @static
             * @private
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TElement    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$1}    parser      
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            /**
             * A parser that produces the specified parsers result or the value of the producer.
             This parser behaves like optional, except that a producer must be specified and has UI behavior differences.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser      
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Required<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, producer: {(): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that converts the output of one parser into a new value.
             If the specified parser fails, then this parser fails too.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule<TParser1, TOutput>(TParser1: {prototype: TParser1}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, producer: {(arg: TParser1): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If either parser fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$1<TParser1, TParser2, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, producer: {(arg1: TParser1, arg2: TParser2): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$2<TParser1, TParser2, TParser3, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$3<TParser1, TParser2, TParser3, TParser4, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TParser5    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser5     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$4<TParser1, TParser2, TParser3, TParser4, TParser5, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TParser5: {prototype: TParser5}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, parser5: Kusto.Language.Parsing.Parser$2<TInput,TParser5> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4, arg5: TParser5): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TParser5    
             * @param   {Function}                           TParser6    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser5     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser6     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$5<TParser1, TParser2, TParser3, TParser4, TParser5, TParser6, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TParser5: {prototype: TParser5}, TParser6: {prototype: TParser6}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, parser5: Kusto.Language.Parsing.Parser$2<TInput,TParser5> | null, parser6: Kusto.Language.Parsing.Parser$2<TInput,TParser6> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4, arg5: TParser5, arg6: TParser6): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TParser5    
             * @param   {Function}                           TParser6    
             * @param   {Function}                           TParser7    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser5     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser6     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser7     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$6<TParser1, TParser2, TParser3, TParser4, TParser5, TParser6, TParser7, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TParser5: {prototype: TParser5}, TParser6: {prototype: TParser6}, TParser7: {prototype: TParser7}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, parser5: Kusto.Language.Parsing.Parser$2<TInput,TParser5> | null, parser6: Kusto.Language.Parsing.Parser$2<TInput,TParser6> | null, parser7: Kusto.Language.Parsing.Parser$2<TInput,TParser7> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4, arg5: TParser5, arg6: TParser6, arg7: TParser7): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TParser5    
             * @param   {Function}                           TParser6    
             * @param   {Function}                           TParser7    
             * @param   {Function}                           TParser8    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser5     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser6     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser7     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser8     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$7<TParser1, TParser2, TParser3, TParser4, TParser5, TParser6, TParser7, TParser8, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TParser5: {prototype: TParser5}, TParser6: {prototype: TParser6}, TParser7: {prototype: TParser7}, TParser8: {prototype: TParser8}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, parser5: Kusto.Language.Parsing.Parser$2<TInput,TParser5> | null, parser6: Kusto.Language.Parsing.Parser$2<TInput,TParser6> | null, parser7: Kusto.Language.Parsing.Parser$2<TInput,TParser7> | null, parser8: Kusto.Language.Parsing.Parser$2<TInput,TParser8> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4, arg5: TParser5, arg6: TParser6, arg7: TParser7, arg8: TParser8): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that combines the output of multiple parsers into a new value.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser1    
             * @param   {Function}                           TParser2    
             * @param   {Function}                           TParser3    
             * @param   {Function}                           TParser4    
             * @param   {Function}                           TParser5    
             * @param   {Function}                           TParser6    
             * @param   {Function}                           TParser7    
             * @param   {Function}                           TParser8    
             * @param   {Function}                           TParser9    
             * @param   {Function}                           TOutput     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser3     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser4     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser5     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser6     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser7     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser8     
             * @param   {Kusto.Language.Parsing.Parser$2}    parser9     
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Rule$8<TParser1, TParser2, TParser3, TParser4, TParser5, TParser6, TParser7, TParser8, TParser9, TOutput>(TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TParser4: {prototype: TParser4}, TParser5: {prototype: TParser5}, TParser6: {prototype: TParser6}, TParser7: {prototype: TParser7}, TParser8: {prototype: TParser8}, TParser9: {prototype: TParser9}, TOutput: {prototype: TOutput}, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser3> | null, parser4: Kusto.Language.Parsing.Parser$2<TInput,TParser4> | null, parser5: Kusto.Language.Parsing.Parser$2<TInput,TParser5> | null, parser6: Kusto.Language.Parsing.Parser$2<TInput,TParser6> | null, parser7: Kusto.Language.Parsing.Parser$2<TInput,TParser7> | null, parser8: Kusto.Language.Parsing.Parser$2<TInput,TParser8> | null, parser9: Kusto.Language.Parsing.Parser$2<TInput,TParser9> | null, producer: {(arg1: TParser1, arg2: TParser2, arg3: TParser3, arg4: TParser4, arg5: TParser5, arg6: TParser6, arg7: TParser7, arg8: TParser8, arg9: TParser9): TOutput} | null): Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
            /**
             * A parser that takes only the 'left' side parser's value and converts it into a new value.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TLeft       
             * @param   {Function}                                        TOutput     
             * @param   {Kusto.Language.Parsing.Parsers$1.LeftValue$1}    left        
             * @param   {System.Func}                                     producer
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            Rule$9<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, left: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>, producer: {(arg: TLeft): TOutput} | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that combines the 'left' side parser's value with the values from a sequence of parsers into a new value.
             This parser fails if any of the parsers in the sequence fail.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TLeft       
             * @param   {Function}                                        TParser1    
             * @param   {Function}                                        TOutput     
             * @param   {Kusto.Language.Parsing.Parsers$1.LeftValue$1}    left        
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser1     
             * @param   {System.Func}                                     producer
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            Rule$10<TLeft, TParser1, TOutput>(TLeft: {prototype: TLeft}, TParser1: {prototype: TParser1}, TOutput: {prototype: TOutput}, left: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, producer: {(arg1: TLeft, arg2: TParser1): TOutput} | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that combines the 'left' side parser's value with the values from a sequence of parsers into a new value.
             This parser fails if any of the parsers in the sequence fail.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TLeft       
             * @param   {Function}                                        TParser1    
             * @param   {Function}                                        TParser2    
             * @param   {Function}                                        TOutput     
             * @param   {Kusto.Language.Parsing.Parsers$1.LeftValue$1}    left        
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser2     
             * @param   {System.Func}                                     producer
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            Rule$11<TLeft, TParser1, TParser2, TOutput>(TLeft: {prototype: TLeft}, TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TOutput: {prototype: TOutput}, left: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, producer: {(arg1: TLeft, arg2: TParser1, arg3: TParser2): TOutput} | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that combines the 'left' side parser's value with the values from a sequence of parsers into a new value.
             This parser fails if any of the parsers in the sequence fail.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                                        TLeft       
             * @param   {Function}                                        TParser1    
             * @param   {Function}                                        TParser2    
             * @param   {Function}                                        TParser3    
             * @param   {Function}                                        TOutput     
             * @param   {Kusto.Language.Parsing.Parsers$1.LeftValue$1}    left        
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser1     
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser2     
             * @param   {Kusto.Language.Parsing.Parser$2}                 parser3     
             * @param   {System.Func}                                     producer
             * @return  {Kusto.Language.Parsing.RightParser$2}
             */
            Rule$12<TLeft, TParser1, TParser2, TParser3, TOutput>(TLeft: {prototype: TLeft}, TParser1: {prototype: TParser1}, TParser2: {prototype: TParser2}, TParser3: {prototype: TParser3}, TOutput: {prototype: TOutput}, left: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>, parser1: Kusto.Language.Parsing.Parser$2<TInput,TParser1> | null, parser2: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, parser3: Kusto.Language.Parsing.Parser$2<TInput,TParser2> | null, producer: {(arg1: TLeft, arg2: TParser1, arg3: TParser2, arg4: TParser3): TOutput} | null): Kusto.Language.Parsing.RightParser$2<TInput,TOutput>;
            /**
             * A parser that parsers a sequence of values into the output.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Array.<Kusto.Language.Parsing.Parser$1>}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Sequence(parsers: Kusto.Language.Parsing.Parser$1<TInput>[] | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that parsers a sequence of values into the output.
             If any parser in the sequence fails, then this parser fails.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {System.Collections.Generic.IReadOnlyList$1}    parsers
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            Sequence$1(parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<TInput>> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that converts all the successfully scanned input characters into a single output string.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Text(pattern: Kusto.Language.Parsing.Parser$1<number> | null): Kusto.Language.Parsing.Parser$2<number,string> | null;
            /**
             * A parser that consumes the matching text characters and produces the same text string.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {string}                             text
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            Text$1(text: string | null): Kusto.Language.Parsing.Parser$2<number,string> | null;
            /**
             * A parser that converts all the successfully scanned input characters into a single output string and its starting offset.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    pattern
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            TextAndOffset(pattern: Kusto.Language.Parsing.Parser$1<number> | null): Kusto.Language.Parsing.Parser$2<number,Kusto.Language.Parsing.OffsetValue$1<string>> | null;
            /**
             * A parser that combines zero or more parsed values into a single value.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Function}                           TParser      
             * @param   {Function}                           TProducer    
             * @param   {Kusto.Language.Parsing.Parser$2}    parser       
             * @param   {System.Func}                        producer
             * @return  {Kusto.Language.Parsing.Parser$2}
             */
            ZeroOrMore$1<TParser, TProducer>(TParser: {prototype: TParser}, TProducer: {prototype: TProducer}, parser: Kusto.Language.Parsing.Parser$2<TInput,TParser> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TParser>): TProducer} | null): Kusto.Language.Parsing.Parser$2<TInput,TProducer> | null;
            /**
             * A parser that parses zero or more values from the specified parser.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            ZeroOrMore(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * A parser that parses zero or one value from the specified parser.
             *
             * @static
             * @public
             * @this Kusto.Language.Parsing.Parsers$1
             * @memberof Kusto.Language.Parsing.Parsers$1
             * @param   {Kusto.Language.Parsing.Parser$1}    parser
             * @return  {Kusto.Language.Parsing.Parser$1}
             */
            ZeroOrOne(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        }
    }
    var Parsers$1: Parsers$1Func;
    module Parsers$1 {
        interface LeftValue$1<TInput,TLeft> {
            $clone(to: Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>): Kusto.Language.Parsing.Parsers$1.LeftValue$1<TInput,TLeft>;
        }
        interface LeftValue$1Func extends Function {
            <TInput, TLeft>($TInput: Bridge.TypeRef<TInput>, $TLeft: Bridge.TypeRef<TLeft>): {
                prototype: LeftValue$1<TInput,TLeft>;
                new (): LeftValue$1<TInput,TLeft>;
            }
        }

        interface ElementProducer$2<TInput,TElement,TProducer> {
        }
        interface ElementProducer$2Func extends Function {
            <TInput, TElement, TProducer>($TInput: Bridge.TypeRef<TInput>, $TElement: Bridge.TypeRef<TElement>, $TProducer: Bridge.TypeRef<TProducer>): {
                prototype: ElementProducer$2<TInput,TElement,TProducer>;
                new (): ElementProducer$2<TInput,TElement,TProducer>;
                Produce(output: System.Collections.Generic.List$1<any> | null, outputStart: number, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<TElement>): TProducer} | null): TProducer;
            }
        }

        interface ElementAndSeparatorProducer$3<TInput,TElement,TSeparator,TProducer> {
        }
        interface ElementAndSeparatorProducer$3Func extends Function {
            <TInput, TElement, TSeparator, TProducer>($TInput: Bridge.TypeRef<TInput>, $TElement: Bridge.TypeRef<TElement>, $TSeparator: Bridge.TypeRef<TSeparator>, $TProducer: Bridge.TypeRef<TProducer>): {
                prototype: ElementAndSeparatorProducer$3<TInput,TElement,TSeparator,TProducer>;
                new (): ElementAndSeparatorProducer$3<TInput,TElement,TSeparator,TProducer>;
                Produce(output: System.Collections.Generic.IReadOnlyList$1<any> | null, producer: {(arg: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>>): TProducer} | null): TProducer;
            }
        }
    }

    interface ParserExtensions {
    }
    interface ParserExtensionsFunc extends Function {
        prototype: ParserExtensions;
        new (): ParserExtensions;
        /**
         * Parses the text into the output list.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.ParserExtensions
         * @memberof Kusto.Language.Parsing.ParserExtensions
         * @param   {Kusto.Language.Parsing.Parser$1}      parser    
         * @param   {string}                               text      
         * @param   {System.Collections.Generic.List$1}    output
         * @return  {number}
         */
        Parse$1(parser: Kusto.Language.Parsing.Parser$1<number> | null, text: string | null, output: System.Collections.Generic.List$1<any> | null): number;
        /**
         * Parses the text and returns a single output value in {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.ParserExtensions
         * @memberof Kusto.Language.Parsing.ParserExtensions
         * @param   {Function}                                TOutput    
         * @param   {Kusto.Language.Parsing.Parser$2}         parser     
         * @param   {string}                                  text
         * @return  {Kusto.Language.Parsing.ParseResult$1}
         */
        Parse<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$2<number,TOutput> | null, text: string | null): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        /**
         * Returns true if the parser successfully parses the text. 
         Returns the produced value as an out parameter.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.ParserExtensions
         * @memberof Kusto.Language.Parsing.ParserExtensions
         * @param   {Function}                           TOutput    
         * @param   {Kusto.Language.Parsing.Parser$2}    parser     
         * @param   {string}                             text       
         * @param   {TOutput}                            value
         * @return  {boolean}
         */
        TryParse<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.Parser$2<number,TOutput> | null, text: string | null, value: {v: TOutput}): boolean;
    }
    var ParserExtensions: ParserExtensionsFunc;

    /**
     * A parser with result based parsing implemented over output-list based parsing.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.ListPrimaryParser$2
     * @augments Kusto.Language.Parsing.Parser$2
     */
    interface ListPrimaryParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
    }
    interface ListPrimaryParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ListPrimaryParser$2<TInput,TOutput>;
            new (): ListPrimaryParser$2<TInput,TOutput>;
        }
    }
    var ListPrimaryParser$2: ListPrimaryParser$2Func;

    interface ParseResult$1<TOutput> {
        /**
         * The number of input items consumed by the parser or a negative number if the parsing failed.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.ParseResult$1
         * @function Length
         * @type number
         */
        Length: number;
        /**
         * The single produced result of the parser.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.ParseResult$1
         * @function Value
         * @type TOutput
         */
        Value: TOutput;
        /**
         * True if the parse was successful.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.ParseResult$1
         * @function Succeeded
         * @type boolean
         */
        Succeeded: boolean;
        $clone(to: Kusto.Language.Parsing.ParseResult$1<TOutput>): Kusto.Language.Parsing.ParseResult$1<TOutput>;
    }
    interface ParseResult$1Func extends Function {
        <TOutput>($TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ParseResult$1<TOutput>;
            $ctor1: {
                new (length: number, value: TOutput): ParseResult$1<TOutput>
            };
            new (): ParseResult$1<TOutput>;
            ctor: {
                new (): ParseResult$1<TOutput>
            };
        }
    }
    var ParseResult$1: ParseResult$1Func;

    /**
     * A piece of source text that represents simple identifiers, keywords, literals or punctuation.
     {@link }'s are produced by {@link }
     *
     * @public
     * @class Kusto.Language.Parsing.LexicalToken
     */
    interface LexicalToken {
        /**
         * The kind of the token
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.LexicalToken
         * @function Kind
         * @type Kusto.Language.Syntax.SyntaxKind
         */
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The trivia (whitespace, etc) that preceeds the proper text of the token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.LexicalToken
         * @function Trivia
         * @type string
         */
        Trivia: string | null;
        /**
         * The text of the token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.LexicalToken
         * @function Text
         * @type string
         */
        Text: string | null;
        /**
         * Any diagnostics associated with the token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.LexicalToken
         * @function Diagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * The combined length of the trivia and text of the token
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.LexicalToken
         * @function Length
         * @type number
         */
        Length: number;
    }
    interface LexicalTokenFunc extends Function {
        prototype: LexicalToken;
        new (kind: Kusto.Language.Syntax.SyntaxKind, trivia: string | null, text: string | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): LexicalToken;
    }
    var LexicalToken: LexicalTokenFunc;

    interface ElementAndSeparator$2<TElement,TSeparator> {
        Element: TElement;
        Separator: TSeparator;
        $clone(to: Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>): Kusto.Language.Parsing.ElementAndSeparator$2<TElement,TSeparator>;
    }
    interface ElementAndSeparator$2Func extends Function {
        <TElement, TSeparator>($TElement: Bridge.TypeRef<TElement>, $TSeparator: Bridge.TypeRef<TSeparator>): {
            prototype: ElementAndSeparator$2<TElement,TSeparator>;
            $ctor1: {
                new (element: TElement, separator: TSeparator): ElementAndSeparator$2<TElement,TSeparator>
            };
            new (): ElementAndSeparator$2<TElement,TSeparator>;
            ctor: {
                new (): ElementAndSeparator$2<TElement,TSeparator>
            };
        }
    }
    var ElementAndSeparator$2: ElementAndSeparator$2Func;

    /**
     * Parsers for the Kusto directive grammar.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.DirectiveGrammar
     */
    interface DirectiveGrammar {
    }
    interface DirectiveGrammarFunc extends Function {
        prototype: DirectiveGrammar;
        new (): DirectiveGrammar;
        DirectiveBlock: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.DirectiveBlock> | null;
    }
    var DirectiveGrammar: DirectiveGrammarFunc;

    interface ParserVisitor$1<TInput> {
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null): void;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null): void;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null): void;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null): void;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null): void;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null): void;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null): void;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null): void;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null): void;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null): void;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null): void;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null): void;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null): void;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null): void;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null): void;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null): void;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null): void;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null): void;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null): void;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null): void;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null): void;
    }
    interface ParserVisitor$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: ParserVisitor$1<TInput>;
            new (): ParserVisitor$1<TInput>;
        }
    }
    var ParserVisitor$1: ParserVisitor$1Func;

    /**
     * Builds a textual representation of a parser's grammar.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.Describer
     */
    interface Describer {
    }
    interface DescriberFunc extends Function {
        prototype: Describer;
        Writer$1: Kusto.Language.Parsing.Describer.Writer$1Func;
        new (): Describer;
        /**
         * Returns a textual representation of a parser's grammar.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.Describer
         * @memberof Kusto.Language.Parsing.Describer
         * @param   {Function}                           TInput          
         * @param   {Kusto.Language.Parsing.Parser$1}    parser          
         * @param   {boolean}                            showRequired
         * @return  {string}
         */
        Describe<TInput>(TInput: {prototype: TInput}, parser: Kusto.Language.Parsing.Parser$1<TInput> | null, showRequired?: boolean): string | null;
    }
    var Describer: DescriberFunc;
    module Describer {
        interface Writer$1<TInput> extends Kusto.Language.Parsing.ParserVisitor$1<TInput> {
            toString(): string | null;
            Visit(parser: Kusto.Language.Parsing.Parser$1<TInput> | null): void;
            VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null): void;
            VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null): void;
            VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null): void;
            VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null): void;
            VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null): void;
            VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null): void;
            VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null): void;
            VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null): void;
            VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null): void;
            VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null): void;
            VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null): void;
            VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null): void;
            VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null): void;
            VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null): void;
            VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null): void;
            VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null): void;
            VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null): void;
            VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null): void;
            VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null): void;
            VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null): void;
            VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null): void;
        }
        interface Writer$1Func extends Function {
            <TInput>($TInput: Bridge.TypeRef<TInput>): {
                prototype: Writer$1<TInput>;
                new (showRequired: boolean): Writer$1<TInput>;
            }
        }
    }

    /**
     * A predifined set of common character parsers that produce no output.
     These are typically used to do look-ahead scanning.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.CharScanners
     */
    interface CharScanners {
    }
    interface CharScannersFunc extends Function {
        prototype: CharScanners;
        new (): CharScanners;
        /**
         * A parser that matches a single letter.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.CharScanners
         * @type Kusto.Language.Parsing.Parser$1
         */
        Letter: Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a single digit.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.CharScanners
         * @type Kusto.Language.Parsing.Parser$1
         */
        Digit: Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a single hexadecimal digit.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.CharScanners
         * @type Kusto.Language.Parsing.Parser$1
         */
        HexDigit: Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a single whitespace character.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.CharScanners
         * @type Kusto.Language.Parsing.Parser$1
         */
        Whitespace: Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a line break.
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.CharScanners
         * @type Kusto.Language.Parsing.Parser$1
         */
        LineBreak: Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a sequence of text characters.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.CharScanners
         * @memberof Kusto.Language.Parsing.CharScanners
         * @param   {string}                             text          
         * @param   {boolean}                            ignoreCase
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        Chars(text: string | null, ignoreCase?: boolean): Kusto.Language.Parsing.Parser$1<number> | null;
        /**
         * A parser that matches a single character.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.CharScanners
         * @memberof Kusto.Language.Parsing.CharScanners
         * @param   {number}                             ch            
         * @param   {boolean}                            ignoreCase
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        Char(ch: number, ignoreCase?: boolean): Kusto.Language.Parsing.Parser$1<number> | null;
    }
    var CharScanners: CharScannersFunc;

    /**
     * An abstraction over a sequence of input items.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.Source$1
     */
    interface Source$1<T> {
        /**
         * Gets the nth item from the current position in the source.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Source$1
         * @memberof Kusto.Language.Parsing.Source$1
         * @param   {number}    n
         * @return  {T}
         */
        Peek(n?: number): T;
        /**
         * Returns true if the position is beyond the last element.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Source$1
         * @memberof Kusto.Language.Parsing.Source$1
         * @param   {number}     n
         * @return  {boolean}
         */
        IsEnd(n?: number): boolean;
        /**
         * Advances the current position in the source.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Source$1
         * @memberof Kusto.Language.Parsing.Source$1
         * @param   {number}    n
         * @return  {void}
         */
        Eat(n?: number): void;
    }
    interface Source$1Func extends Function {
        <T>($T: Bridge.TypeRef<T>): {
            prototype: Source$1<T>;
            new (): Source$1<T>;
        }
    }
    var Source$1: Source$1Func;

    /**
     * Parsers for the Kusto command grammar.
     *
     * @public
     * @class Kusto.Language.Parsing.CommandGrammar
     */
    interface CommandGrammar {
        /**
         * The entry point grammar for commands
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.CommandGrammar
         * @function CommandBlock
         * @type Kusto.Language.Parsing.Parser$2
         */
        CommandBlock: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.CommandBlock> | null;
        /**
         * Creates a new {@link } given the {@link }
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.CommandGrammar
         * @memberof Kusto.Language.Parsing.CommandGrammar
         * @param   {Kusto.Language.GlobalState}         globals
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        /**
         * Derived command parser's override this method to create the set of individual command parsers.
         *
         * @instance
         * @this Kusto.Language.Parsing.CommandGrammar
         * @memberof Kusto.Language.Parsing.CommandGrammar
         * @param   {Kusto.Language.Parsing.PredefinedRuleParsers}    rules
         * @return  {Array.<Kusto.Language.Parsing.Parser$2>}
         */
    }
    interface CommandGrammarFunc extends Function {
        prototype: CommandGrammar;
        RecentGrammar: Kusto.Language.Parsing.CommandGrammar.RecentGrammarFunc;
        new (globals: Kusto.Language.GlobalState | null): CommandGrammar;
        /**
         * Gets or creates the {@link } corresponding to the {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.CommandGrammar
         * @memberof Kusto.Language.Parsing.CommandGrammar
         * @param   {Kusto.Language.GlobalState}               globals
         * @return  {Kusto.Language.Parsing.CommandGrammar}
         */
        From(globals: Kusto.Language.GlobalState | null): Kusto.Language.Parsing.CommandGrammar | null;
        /**
         * Creates the correct kind of command grammar given the global state.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.CommandGrammar
         * @memberof Kusto.Language.Parsing.CommandGrammar
         * @param   {Kusto.Language.GlobalState}               globals
         * @return  {Kusto.Language.Parsing.CommandGrammar}
         */
        CreateCommandGrammar(globals: Kusto.Language.GlobalState | null): Kusto.Language.Parsing.CommandGrammar | null;
    }
    var CommandGrammar: CommandGrammarFunc;
    module CommandGrammar {
        interface RecentGrammar {
            ServerKind: string | null;
            Grammar: Kusto.Language.Parsing.CommandGrammar | null;
        }
        interface RecentGrammarFunc extends Function {
            prototype: RecentGrammar;
            new (serverKind: string | null, grammar: Kusto.Language.Parsing.CommandGrammar | null): RecentGrammar;
        }
    }

    /**
     * A parser combinator that can scan, search and parse input.
     When parsing, may produce zero or more output values.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.Parser$1
     */
    interface Parser$1<TInput> {
        /**
         * The name of the parser.
         Most parsers have no name.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.Parser$1
         * @function Tag
         * @type string
         */
        Tag: string | null;
        /**
         * Annotations on the parser.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.Parser$1
         * @function Annotations
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Annotations: System.Collections.Generic.IReadOnlyList$1<any> | null;
        /**
         * A description of the parser.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.Parser$1
         * @function Description
         * @type string
         */
        Description: string | null;
        /**
         * True if the parser is hidden from searching.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Parsing.Parser$1
         * @function IsHidden
         * @type boolean
         */
        IsHidden: boolean;
        /**
         * True if the parser can succeed with no input consumed.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.Parser$1
         * @function IsOptional
         * @type boolean
         */
        IsOptional: boolean;
        /**
         * Creates a copy of this {@link } with the tag specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {string}                             tag
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        WithTag(tag: string | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        /**
         * Creates a copy of this {@link } with the annotations specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {System.Collections.Generic.IEnumerable$1}    annotations
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        WithAnnotations(annotations: System.Collections.Generic.IEnumerable$1<any> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        /**
         * Creates a copy of this {@link } with the IsHidden property specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {boolean}                            isHidden
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        WithIsHidden(isHidden: boolean): Kusto.Language.Parsing.Parser$1<TInput> | null;
        /**
         * Creates a copy of the {@link } that is hidden from searching.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        Hide(): Kusto.Language.Parsing.Parser$1<TInput> | null;
        /**
         * Create a shallow copy of this parser
         *
         * @instance
         * @abstract
         * @protected
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @return  {Kusto.Language.Parsing.Parser$1}
         */
        /**
         * Invokes the corresponding {@link } visit method.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {Kusto.Language.Parsing.ParserVisitor$1}    visitor
         * @return  {void}
         */
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        /**
         * Invokes the corresponding {@link } visit method.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {Function}                                  TResult    
         * @param   {Kusto.Language.Parsing.ParserVisitor$2}    visitor
         * @return  {TResult}
         */
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        /**
         * Invokes the corresponding {@link } visit method.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {Function}                                  TArg       
         * @param   {Function}                                  TResult    
         * @param   {Kusto.Language.Parsing.ParserVisitor$3}    visitor    
         * @param   {TArg}                                      arg
         * @return  {TResult}
         */
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        /**
         * Parses input source items and produces zero or more output items.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {Kusto.Language.Parsing.Source$1}      input          
         * @param   {number}                               inputStart     
         * @param   {System.Collections.Generic.List$1}    output         
         * @param   {number}                               outputStart
         * @return  {number}
         */
        Parse(input: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        /**
         * Returns the number of source items that are successfully matched by this parser, or a negative number indicating failure.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Parsing.Parser$1
         * @memberof Kusto.Language.Parsing.Parser$1
         * @param   {Kusto.Language.Parsing.Source$1}    input         
         * @param   {number}                             inputStart
         * @return  {number}
         */
        Scan(input: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number): number;
    }
    interface Parser$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: Parser$1<TInput>;
            new (): Parser$1<TInput>;
        }
    }
    var Parser$1: Parser$1Func;

    enum ApplyKind {
        One = 0,
        ZeroOrOne = 1,
        ZeroOrMore = 2
    }

    enum AllowedNameKind {
        Any = 0,
        Known = 1,
        Specific = 2
    }

    interface ParserVisitor$3<TInput,TArg,TResult> {
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null, arg: TArg): TResult;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null, arg: TArg): TResult;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null, arg: TArg): TResult;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null, arg: TArg): TResult;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null, arg: TArg): TResult;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null, arg: TArg): TResult;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null, arg: TArg): TResult;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null, arg: TArg): TResult;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null, arg: TArg): TResult;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null, arg: TArg): TResult;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null, arg: TArg): TResult;
    }
    interface ParserVisitor$3Func extends Function {
        <TInput, TArg, TResult>($TInput: Bridge.TypeRef<TInput>, $TArg: Bridge.TypeRef<TArg>, $TResult: Bridge.TypeRef<TResult>): {
            prototype: ParserVisitor$3<TInput,TArg,TResult>;
            new (): ParserVisitor$3<TInput,TArg,TResult>;
        }
    }
    var ParserVisitor$3: ParserVisitor$3Func;

    /**
     * A parsed value and its source offset.
     *
     * @public
     * @class Kusto.Language.Parsing.OffsetValue$1
     */
    interface OffsetValue$1<TValue> {
        /**
         * The text offset of the value in the source.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.OffsetValue$1
         * @type number
         */
        Offset: number;
        /**
         * The value located at the offset.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.OffsetValue$1
         * @type TValue
         */
        Value: TValue;
        getHashCode(): number;
        equals(o: Kusto.Language.Parsing.OffsetValue$1<TValue>): boolean;
        $clone(to: Kusto.Language.Parsing.OffsetValue$1<TValue>): Kusto.Language.Parsing.OffsetValue$1<TValue>;
    }
    interface OffsetValue$1Func extends Function {
        <TValue>($TValue: Bridge.TypeRef<TValue>): {
            prototype: OffsetValue$1<TValue>;
            /**
             * Constructs a new {@link }
             *
             * @instance
             * @public
             * @this Kusto.Language.Parsing.OffsetValue$1
             * @memberof Kusto.Language.Parsing.OffsetValue$1
             * @param   {number}    offset    The text offset of the value in the source.
             * @param   {TValue}    value     The value located at the offset.
             * @return  {void}
             */
            $ctor1: {
                new (offset: number, value: TValue): OffsetValue$1<TValue>
            };
            new (): OffsetValue$1<TValue>;
            ctor: {
                new (): OffsetValue$1<TValue>
            };
        }
    }
    var OffsetValue$1: OffsetValue$1Func;

    interface ScannerExtensions {
    }
    interface ScannerExtensionsFunc extends Function {
        prototype: ScannerExtensions;
        ReuseableTextSource: Kusto.Language.Parsing.ScannerExtensions.ReuseableTextSourceFunc;
        new (): ScannerExtensions;
        /**
         * Determines if the scanner matches the specified text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.ScannerExtensions
         * @memberof Kusto.Language.Parsing.ScannerExtensions
         * @param   {Kusto.Language.Parsing.Parser$1}    scanner    
         * @param   {string}                             text
         * @return  {boolean}
         */
        Matches(scanner: Kusto.Language.Parsing.Parser$1<number> | null, text: string | null): boolean;
        /**
         * Determines if the scanner matches the specified text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.ScannerExtensions
         * @memberof Kusto.Language.Parsing.ScannerExtensions
         * @param   {Kusto.Language.Parsing.Parser$1}    scanner    
         * @param   {string}                             text       
         * @param   {number}                             offset     
         * @param   {number}                             length
         * @return  {boolean}
         */
        Matches$1(scanner: Kusto.Language.Parsing.Parser$1<number> | null, text: string | null, offset: number, length: number): boolean;
    }
    var ScannerExtensions: ScannerExtensionsFunc;
    module ScannerExtensions {
        /**
         * A source of text for syntax parsing
         *
         * @private
         * @class Kusto.Language.Parsing.ScannerExtensions.ReuseableTextSource
         * @augments Kusto.Language.Parsing.Source$1
         */
        interface ReuseableTextSource extends Kusto.Language.Parsing.Source$1<number> {
            Init$1(source: string | null, offset: number, length: number): void;
            Init(source: string | null): void;
            Clear(): void;
            Peek(n?: number): number;
            IsEnd(n?: number): boolean;
            /**
             * Eat the specified number of characters from the input.
             *
             * @instance
             * @public
             * @override
             * @this Kusto.Language.Parsing.ScannerExtensions.ReuseableTextSource
             * @memberof Kusto.Language.Parsing.ScannerExtensions.ReuseableTextSource
             * @param   {number}    n
             * @return  {void}
             */
            Eat(n: number): void;
        }
        interface ReuseableTextSourceFunc extends Function {
            prototype: ReuseableTextSource;
            new (): ReuseableTextSource;
        }
    }

    interface StackSafeScanner$1<TInput> extends Kusto.Language.Parsing.ParserVisitor$2<TInput,Kusto.Language.Parsing.Parser$1<TInput>> {
        Initialize(source: Kusto.Language.Parsing.Source$1<TInput> | null): void;
        Clear(): void;
        /**
         * Parse using a state machine, does not use the call stack.
         *
         * @instance
         * @public
         * @this Kusto.Language.Parsing.StackSafeScanner$1
         * @memberof Kusto.Language.Parsing.StackSafeScanner$1
         * @param   {Kusto.Language.Parsing.Parser$1}    parser    
         * @param   {number}                             start
         * @return  {number}
         */
        Scan(parser: Kusto.Language.Parsing.Parser$1<TInput> | null, start: number): number;
        VisitApply<TLeft, TOutput>(TLeft: {prototype: TLeft}, TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ApplyParser$3<TInput,TLeft,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitBest(parser: Kusto.Language.Parsing.BestParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitBest$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.BestParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitConvert<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ConvertParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFails(parser: Kusto.Language.Parsing.FailsParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFirst$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.FirstParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitFirst(parser: Kusto.Language.Parsing.FirstParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitForward<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ForwardParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitIf$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.IfParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitIf(parser: Kusto.Language.Parsing.IfParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMap<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MapParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMatch(parser: Kusto.Language.Parsing.MatchParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitMatch$1<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.MatchParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitNot(parser: Kusto.Language.Parsing.NotParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitOneOrMore(parser: Kusto.Language.Parsing.OneOrMoreParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitOptional<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.OptionalParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitProduce<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.ProduceParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitRequired<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RequiredParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitRule<TOutput>(TOutput: {prototype: TOutput}, parser: Kusto.Language.Parsing.RuleParser$2<TInput,TOutput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitSequence(parser: Kusto.Language.Parsing.SequenceParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
        VisitZeroOrMore(parser: Kusto.Language.Parsing.ZeroOrMoreParser$1<TInput> | null): Kusto.Language.Parsing.Parser$1<TInput> | null;
    }
    interface StackSafeScanner$1Func extends Function {
        <TInput>($TInput: Bridge.TypeRef<TInput>): {
            prototype: StackSafeScanner$1<TInput>;
            ScanState: Kusto.Language.Parsing.StackSafeScanner$1.ScanStateFunc;
            new (source: Kusto.Language.Parsing.Source$1<TInput> | null): StackSafeScanner$1<TInput>;
        }
    }
    var StackSafeScanner$1: StackSafeScanner$1Func;
    module StackSafeScanner$1 {
        interface ScanState<TInput> {
            /**
             * The accumulated input length consumed by this parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @type number
             */
            InputLength: number;
            /**
             * The parser execution state
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @type number
             */
            State: number;
            /**
             * The result of the last sub-parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @type number
             */
            LastResult: number;
            /**
             * The result length of the best failed parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @type number
             */
            BestFailedResult: number;
            /**
             * The result length of the best successful parser
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @type number
             */
            BestSuccessResult: number;
            Parser: Kusto.Language.Parsing.Parser$1<TInput> | null;
            /**
             * The input start
             *
             * @instance
             * @public
             * @memberof Kusto.Language.Parsing.StackSafeScanner$1.ScanState
             * @function InputStart
             * @type number
             */
            InputStart: number;
            Init(parser: Kusto.Language.Parsing.Parser$1<TInput> | null, inputStart: number): void;
        }
        interface ScanStateFunc extends Function {
            <TInput>($TInput: Bridge.TypeRef<TInput>): {
                prototype: ScanState<TInput>;
                new (): ScanState<TInput>;
            }
        }
    }

    interface RequiredParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        Producer: {(): TOutput} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface RequiredParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: RequiredParser$2<TInput,TOutput>;
            new (parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, producer: {(): TOutput} | null): RequiredParser$2<TInput,TOutput>;
        }
    }
    var RequiredParser$2: RequiredParser$2Func;

    interface OptionalParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        Producer: {(): TOutput} | null;
        IsOptional: boolean;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface OptionalParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: OptionalParser$2<TInput,TOutput>;
            new (parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null, producer: {(): TOutput} | null): OptionalParser$2<TInput,TOutput>;
        }
    }
    var OptionalParser$2: OptionalParser$2Func;

    interface MatchParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null;
        Producer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start?: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
    }
    interface MatchParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: MatchParser$2<TInput,TOutput>;
            ctor: {
                new (consumer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number): number} | null, producer: {(source: Kusto.Language.Parsing.Source$1<TInput>, start: number, length: number): TOutput} | null): MatchParser$2<TInput,TOutput>
            };
            $ctor1: {
                new (predicate: {(arg: TInput): boolean} | null, producer: {(arg: TInput): TOutput} | null): MatchParser$2<TInput,TOutput>
            };
        }
    }
    var MatchParser$2: MatchParser$2Func;

    interface IfParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Test: Kusto.Language.Parsing.Parser$1<TInput> | null;
        Parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface IfParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: IfParser$2<TInput,TOutput>;
            new (test: Kusto.Language.Parsing.Parser$1<TInput> | null, parser: Kusto.Language.Parsing.Parser$2<TInput,TOutput> | null): IfParser$2<TInput,TOutput>;
        }
    }
    var IfParser$2: IfParser$2Func;

    /**
     * Parser and Scanners for working with Kusto syntax.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.SyntaxParsers
     */
    interface SyntaxParsers {
    }
    interface SyntaxParsersFunc extends Function {
        prototype: SyntaxParsers;
        new (): SyntaxParsers;
        /**
         * A parser that consumes the next {@link }, producing the corresponding {@link }.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @type Kusto.Language.Parsing.Parser$2
         */
        AnyToken: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } as long as it does not have the kind {@link }, producing the corresponding {@link }.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @type Kusto.Language.Parsing.Parser$2
         */
        AnyTokenButEnd: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes only the end of text token.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @type Kusto.Language.Parsing.Parser$1
         */
        EndOfText: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null;
        /**
         * Determines if a typical comma separated list has ended
         *
         * @static
         * @public
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @type Kusto.Language.Parsing.Parser$1
         */
        EndOfCommaList: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null;
        /**
         * Creates a missing {@link } for a token that was expected to have the specified {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}     kind          
         * @param   {Kusto.Language.Diagnostic}            diagnostic
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        CreateMissingToken(kind: Kusto.Language.Syntax.SyntaxKind, diagnostic?: Kusto.Language.Diagnostic | null): Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * Creates a missing {@link } for a token that was expected to have the specified {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    kinds
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        CreateMissingToken$1(kinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null): Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * Creates a missing {@link } for a token that was expected to have the specified text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                               text          
         * @param   {Kusto.Language.Diagnostic}            diagnostic
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        CreateMissingToken$3(text: string | null, diagnostic?: Kusto.Language.Diagnostic | null): Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * Creates a missing {@link } for a token that was expected to have one of the specified texts.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    texts
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        CreateMissingToken$2(texts: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.Syntax.SyntaxToken | null;
        CreateMissingEToken$1(text: string | null): Kusto.Language.Syntax.SyntaxElement | null;
        CreateMissingEToken(texts: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * Gets the default tag to assign a token parser, based on the token's text.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}    text
         * @return  {string}
         */
        /**
         * Gets the default tag to assign a token parser, based on the token's kind.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}    kind
         * @return  {string}
         */
        /**
         * A parser that consumes the next next {@link } if it has the specified {@link }, producing a corresponding {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}            kind        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token$1(kind: Kusto.Language.Syntax.SyntaxKind, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority, ctext?: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next next {@link } if it has the specified {@link }, producing a corresponding {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}        kind    
         * @param   {Kusto.Language.Editor.CompletionItem}    item
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token(kind: Kusto.Language.Syntax.SyntaxKind, item: Kusto.Language.Editor.CompletionItem | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next next {@link } if it has one of the specified {@link }s, producing a corresponding {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    kinds       
         * @param   {?Kusto.Language.Editor.CompletionKind}         ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}      priority
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token$2(kinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                      text        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token$5(text: string | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority, ctext?: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                  text    
         * @param   {Kusto.Language.Editor.CompletionItem}    item
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token$4(text: string | null, item: Kusto.Language.Editor.CompletionItem | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has one of the specified texts, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    texts       
         * @param   {?Kusto.Language.Editor.CompletionKind}         ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}      priority
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Token$3(texts: System.Collections.Generic.IReadOnlyList$1<string> | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * Creates a new version of the parser with the ComplationItem annotation set.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                        TElement    
         * @param   {Kusto.Language.Parsing.Parser$2}                 parser      
         * @param   {Array.<Kusto.Language.Editor.CompletionItem>}    items
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        WithCompletion<TElement>(TElement: {prototype: TElement}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, items: Kusto.Language.Editor.CompletionItem[] | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null;
        /**
         * Creates a new version of the parser with the CompletionHint annotation set.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                TElement    
         * @param   {Kusto.Language.Parsing.Parser$2}         parser      
         * @param   {Kusto.Language.Editor.CompletionHint}    hint
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        WithCompletionHint<TElement>(TElement: {prototype: TElement}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, hint: Kusto.Language.Editor.CompletionHint): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null;
        /**
         * Matches one or more lexical tokens to the corresponding text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Source$1}    source    
         * @param   {number}                             start     
         * @param   {string}                             text
         * @return  {number}
         */
        MatchesText(source: Kusto.Language.Parsing.Source$1<Kusto.Language.Parsing.LexicalToken> | null, start: number, text: string | null): number;
        /**
         * Create a {@link } from one or more {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Source$1}      source    
         * @param   {number}                               start     
         * @param   {number}                               length    
         * @param   {string}                               text
         * @return  {Kusto.Language.Syntax.SyntaxToken}
         */
        ProduceSyntaxToken(source: Kusto.Language.Parsing.Source$1<Kusto.Language.Parsing.LexicalToken> | null, start: number, length: number, text: string | null): Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) that combined has the specified text, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                             text
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        MatchText(text: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                   text     
         * @param   {?Kusto.Language.Editor.CompletionKind}    ckind
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        EToken(text: string | null, ckind?: Kusto.Language.Editor.CompletionKind | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has one of the specified texts, producing a single {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Array.<string>}                     texts
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        EToken$1(texts: string[] | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a single {@link }.
         It does not show up in intellisense completion lists.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                             text
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        HiddenToken$2(text: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next next {@link } if it has the specified {@link }, producing a corresponding {@link }.
         It does not show up in intellisense completion lists.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}    tokenKind
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        HiddenToken(tokenKind: Kusto.Language.Syntax.SyntaxKind): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has one of the specified texts, producing a single {@link }.
         It does not show up in intellisense completion lists.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    texts
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        HiddenToken$1(texts: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } if it has the specified {@link }, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}            kind        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken$1(kind: Kusto.Language.Syntax.SyntaxKind, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority, ctext?: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } if it has the specified {@link }, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}        kind    
         * @param   {Kusto.Language.Editor.CompletionItem}    item
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken(kind: Kusto.Language.Syntax.SyntaxKind, item: Kusto.Language.Editor.CompletionItem | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } if it has one of the specified {@link }, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    kinds       
         * @param   {?Kusto.Language.Editor.CompletionKind}         ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}      priority
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken$2(kinds: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxKind> | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                      text        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken$5(text: string | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority, ctext?: string | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                  text    
         * @param   {Kusto.Language.Editor.CompletionItem}    item
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken$4(text: string | null, item: Kusto.Language.Editor.CompletionItem | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has one of the specified texts, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    texts       
         * @param   {?Kusto.Language.Editor.CompletionKind}         ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}      priority
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredToken$3(texts: System.Collections.Generic.IReadOnlyList$1<string> | null, ckind?: Kusto.Language.Editor.CompletionKind | null, priority?: Kusto.Language.Editor.CompletionPriority): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxToken> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has the specified text, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                   text     
         * @param   {?Kusto.Language.Editor.CompletionKind}    ckind
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredEToken(text: string | null, ckind?: Kusto.Language.Editor.CompletionKind | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * A parser that consumes the next {@link } (or series of adjacent tokens) if it has one of the specified texts, producing a corresponding {@link } or an equivalent missing token otherwise.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Array.<string>}                     texts
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        RequiredEToken$1(texts: string[] | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Gets the default {@link } for a token with the specified {@link }.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Syntax.SyntaxKind}            kind        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Editor.CompletionItem}
         */
        /**
         * Gets the default {@link } for a token with the specified text.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                      text        
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Editor.CompletionItem}
         */
        /**
         * Gets the default {@link } for a token with the specified text.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                      text        
         * @param   {Kusto.Language.Editor.CompletionKind}        ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority    
         * @param   {string}                                      ctext
         * @return  {Kusto.Language.Editor.CompletionItem}
         */
        /**
         * Gets the default {@link } for tokens with any of the specified {@link }.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IEnumerable$1}    kinds       
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        /**
         * Gets the default {@link } for tokens with any of the specified texts.
         *
         * @static
         * @private
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IEnumerable$1}    texts       
         * @param   {?Kusto.Language.Editor.CompletionKind}       ckind       
         * @param   {Kusto.Language.Editor.CompletionPriority}    priority
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        /**
         * A parser that parses a {@link } of elements.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TElement          
         * @param   {Kusto.Language.Parsing.Parser$2}    elementParser     
         * @param   {TElement}                           missingElement    
         * @param   {boolean}                            oneOrMore
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        List<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement?: TElement | null, oneOrMore?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<TElement>> | null;
        /**
         * A parser that parses a {@link } of elements.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TElement          
         * @param   {Kusto.Language.Parsing.Parser$2}    elementParser     
         * @param   {System.Func}                        missingElement    
         * @param   {boolean}                            oneOrMore
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        List$1<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement: {(): TElement} | null, oneOrMore?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<TElement>> | null;
        /**
         * A parser that parses a {@link } of {@link }'s
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                            TElement                  
         * @param   {Kusto.Language.Parsing.Parser$2}     primaryElementParser      
         * @param   {Kusto.Language.Syntax.SyntaxKind}    separatorKind             
         * @param   {TElement}                            missingElement            
         * @param   {Kusto.Language.Parsing.Parser$1}     endOfList                 
         * @param   {boolean}                             oneOrMore                 
         * @param   {boolean}                             allowTrailingSeparator
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        SeparatedList<TElement>(TElement: {prototype: TElement}, primaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, separatorKind: Kusto.Language.Syntax.SyntaxKind, missingElement: TElement | null, endOfList?: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, oneOrMore?: boolean, allowTrailingSeparator?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a {@link } of {@link }'s
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                            TElement                  
         * @param   {Kusto.Language.Parsing.Parser$2}     primaryElementParser      
         * @param   {Kusto.Language.Syntax.SyntaxKind}    separatorKind             
         * @param   {System.Func}                         missingElement            
         * @param   {Kusto.Language.Parsing.Parser$1}     endOfList                 
         * @param   {boolean}                             oneOrMore                 
         * @param   {boolean}                             allowTrailingSeparator
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        SeparatedList$3<TElement>(TElement: {prototype: TElement}, primaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, separatorKind: Kusto.Language.Syntax.SyntaxKind, missingElement: {(): TElement} | null, endOfList?: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, oneOrMore?: boolean, allowTrailingSeparator?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                            TElement                  
         * @param   {Kusto.Language.Parsing.Parser$2}     primaryElementParser      
         * @param   {Kusto.Language.Syntax.SyntaxKind}    separatorKind             
         * @param   {Kusto.Language.Parsing.Parser$2}     secondaryElementParser    
         * @param   {TElement}                            missingElement            
         * @param   {Kusto.Language.Parsing.Parser$1}     endOfList                 
         * @param   {boolean}                             oneOrMore                 
         * @param   {boolean}                             allowTrailingSeparator
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        SeparatedList$1<TElement>(TElement: {prototype: TElement}, primaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, separatorKind: Kusto.Language.Syntax.SyntaxKind, secondaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement: TElement | null, endOfList?: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, oneOrMore?: boolean, allowTrailingSeparator?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                            TElement                  
         * @param   {Kusto.Language.Parsing.Parser$2}     primaryElementParser      
         * @param   {Kusto.Language.Syntax.SyntaxKind}    separatorKind             
         * @param   {Kusto.Language.Parsing.Parser$2}     secondaryElementParser    
         * @param   {System.Func}                         missingElement            
         * @param   {Kusto.Language.Parsing.Parser$1}     endOfList                 
         * @param   {boolean}                             oneOrMore                 
         * @param   {boolean}                             allowTrailingSeparator
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        SeparatedList$2<TElement>(TElement: {prototype: TElement}, primaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, separatorKind: Kusto.Language.Syntax.SyntaxKind, secondaryElementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement: {(): TElement} | null, endOfList?: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, oneOrMore?: boolean, allowTrailingSeparator?: boolean): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a typical comma separated {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                    TElement              
         * @param   {Kusto.Language.Parsing.Parser$2}             elementParser         
         * @param   {TElement}                                    missingElement        
         * @param   {boolean}                                     oneOrMore             
         * @param   {boolean}                                     allowTrailingComma    
         * @param   {System.Collections.Generic.IEnumerable$1}    endKinds
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        CommaList<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement: TElement | null, oneOrMore?: boolean, allowTrailingComma?: boolean, endKinds?: System.Collections.Generic.IEnumerable$1<Kusto.Language.Syntax.SyntaxKind> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a typical comma separated {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                    TElement              
         * @param   {Kusto.Language.Parsing.Parser$2}             elementParser         
         * @param   {System.Func}                                 missingElement        
         * @param   {boolean}                                     oneOrMore             
         * @param   {boolean}                                     allowTrailingComma    
         * @param   {System.Collections.Generic.IEnumerable$1}    endKinds
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        CommaList$1<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement?: {(): TElement} | null, oneOrMore?: boolean, allowTrailingComma?: boolean, endKinds?: System.Collections.Generic.IEnumerable$1<Kusto.Language.Syntax.SyntaxKind> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a typical comma separated {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TElement          
         * @param   {Kusto.Language.Parsing.Parser$2}    elementParser     
         * @param   {TElement}                           missingElement
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        OneOrMoreCommaList<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement: TElement | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * A parser that parses a typical comma separated {@link } of {@link }'s.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TElement          
         * @param   {Kusto.Language.Parsing.Parser$2}    elementParser     
         * @param   {System.Func}                        missingElement
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        OneOrMoreCommaList$1<TElement>(TElement: {prototype: TElement}, elementParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TElement> | null, missingElement?: {(): TElement} | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>>> | null;
        /**
         * Constructs a SyntaxList&lt;SeparatedElement&lt;TElement&gt;&gt; from a list of items and separators.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                       TElement    
         * @param   {Array.<Kusto.Language.Syntax.SyntaxElement>}    elements
         * @return  {Kusto.Language.Syntax.SyntaxList$1}
         */
        MakeSeparatedList<TElement>(TElement: {prototype: TElement}, elements: Kusto.Language.Syntax.SyntaxElement[] | null): Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>> | null;
        /**
         * Constructs a SyntaxList&lt;SeparatedElement&lt;TElement&gt;&gt; from a list of items and separators.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                      TElement    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    elements
         * @return  {Kusto.Language.Syntax.SyntaxList$1}
         */
        MakeSeparatedList$1<TElement>(TElement: {prototype: TElement}, elements: System.Collections.Generic.IReadOnlyList$1<any> | null): Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<TElement>> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {System.Collections.Generic.IReadOnlyList$1}    parsers    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$9(parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken>> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}                  parser    
         * @param   {Kusto.Language.Syntax.CustomElementDescriptor}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$8(parser: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: Kusto.Language.Syntax.CustomElementDescriptor | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$7(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$6(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$5(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser5    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$4(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser5: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser5    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser6    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$3(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser5: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser6: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser5    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser6    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser7    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$2(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser5: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser6: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser7: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser5    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser6    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser7    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser8    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom$1(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser5: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser6: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser7: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser8: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        /**
         * Constructs a {@link } parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}               parser1    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser2    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser3    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser4    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser5    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser6    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser7    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser8    
         * @param   {Kusto.Language.Parsing.Parser$1}               parser9    
         * @param   {System.Collections.Generic.IReadOnlyList$1}    shape
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Custom(parser1: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser2: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser3: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser4: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser5: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser6: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser7: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser8: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, parser9: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, shape?: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null;
        GetDefaultShape(count: number): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null;
        /**
         * Constructs a {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                                           name          
         * @param   {Kusto.Language.Editor.CompletionHint}             hint          
         * @param   {boolean}                                          isOptional
         * @return  {Kusto.Language.Syntax.CustomElementDescriptor}
         */
        CD$1(name: string | null, hint?: Kusto.Language.Editor.CompletionHint, isOptional?: boolean): Kusto.Language.Syntax.CustomElementDescriptor | null;
        /**
         * Constructs a {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Editor.CompletionHint}             hint          
         * @param   {boolean}                                          isOptional
         * @return  {Kusto.Language.Syntax.CustomElementDescriptor}
         */
        CD(hint?: Kusto.Language.Editor.CompletionHint, isOptional?: boolean): Kusto.Language.Syntax.CustomElementDescriptor | null;
        /**
         * Constructs a custom command parser.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {string}                             commandName      
         * @param   {Kusto.Language.Parsing.Parser$2}    contentParser
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Command(commandName: string | null, contentParser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.SyntaxElement> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,Kusto.Language.Syntax.Command> | null;
        /**
         * Repeatedly parses all matching items.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                    TParser                  
         * @param   {Kusto.Language.Parsing.Parser$2}             parser                   
         * @param   {string}                                      text                     
         * @param   {boolean}                                     alwaysProduceEndToken
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        ParseAll$1<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, text: string | null, alwaysProduceEndToken?: boolean): System.Collections.Generic.IEnumerable$1<TParser> | null;
        /**
         * Repeatedly parses all matching items.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                       TParser    
         * @param   {Kusto.Language.Parsing.Parser$2}                parser     
         * @param   {Array.<Kusto.Language.Parsing.LexicalToken>}    tokens
         * @return  {System.Collections.Generic.IEnumerable$1}
         */
        ParseAll<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, tokens: Kusto.Language.Parsing.LexicalToken[] | null): System.Collections.Generic.IEnumerable$1<TParser> | null;
        /**
         * Parses the first matching item.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TParser             
         * @param   {Kusto.Language.Parsing.Parser$2}    parser              
         * @param   {string}                             text                
         * @param   {boolean}                            alwaysProduceEOF
         * @return  {TParser}
         */
        ParseFirst<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, text: string | null, alwaysProduceEOF?: boolean): TParser;
        /**
         * Parses the first matching item.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                       TParser    
         * @param   {Kusto.Language.Parsing.Parser$2}                parser     
         * @param   {Array.<Kusto.Language.Parsing.LexicalToken>}    tokens
         * @return  {TParser}
         */
        ParseFirst$1<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, tokens: Kusto.Language.Parsing.LexicalToken[] | null): TParser;
        /**
         * Scans the first matching item.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Kusto.Language.Parsing.Parser$1}    parser              
         * @param   {string}                             text                
         * @param   {boolean}                            alwaysProduceEOF
         * @return  {number}
         */
        ScanFirst(parser: Kusto.Language.Parsing.Parser$1<Kusto.Language.Parsing.LexicalToken> | null, text: string | null, alwaysProduceEOF?: boolean): number;
        /**
         * Adds examples of completions as annotations onto this grammar rule.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                                      TParser    
         * @param   {Kusto.Language.Parsing.Parser$2}               parser     
         * @param   {System.Collections.Generic.IReadOnlyList$1}    values
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Examples<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, values: System.Collections.Generic.IReadOnlyList$1<string> | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null;
        /**
         * Adds examples of completions as annotations onto this grammar rule.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.SyntaxParsers
         * @memberof Kusto.Language.Parsing.SyntaxParsers
         * @param   {Function}                           TParser    
         * @param   {Kusto.Language.Parsing.Parser$2}    parser     
         * @param   {Array.<string>}                     values
         * @return  {Kusto.Language.Parsing.Parser$2}
         */
        Examples$1<TParser>(TParser: {prototype: TParser}, parser: Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null, values: string[] | null): Kusto.Language.Parsing.Parser$2<Kusto.Language.Parsing.LexicalToken,TParser> | null;
    }
    var SyntaxParsers: SyntaxParsersFunc;

    interface FirstParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$2<TInput,TOutput>> | null;
        Accept$2(visitor: Kusto.Language.Parsing.ParserVisitor$1<TInput> | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$2<TInput,TResult> | null): TResult;
        Accept$1<TArg, TResult>(TArg: {prototype: TArg}, TResult: {prototype: TResult}, visitor: Kusto.Language.Parsing.ParserVisitor$3<TInput,TArg,TResult> | null, arg: TArg): TResult;
        Parse$1(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): Kusto.Language.Parsing.ParseResult$1<TOutput>;
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
        Scan(source: Kusto.Language.Parsing.Source$1<TInput> | null, start: number): number;
    }
    interface FirstParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: FirstParser$2<TInput,TOutput>;
            new (parsers: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Parsing.Parser$2<TInput,TOutput>> | null): FirstParser$2<TInput,TOutput>;
        }
    }
    var FirstParser$2: FirstParser$2Func;

    /**
     * A parser with output list based parsing implemented over result based parsing.
     These parsers should *not* wrap other parsers.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.ResultPrimaryParser$2
     * @augments Kusto.Language.Parsing.Parser$2
     */
    interface ResultPrimaryParser$2<TInput,TOutput> extends Kusto.Language.Parsing.Parser$2<TInput,TOutput> {
        Parse(source: Kusto.Language.Parsing.Source$1<TInput> | null, inputStart: number, output: System.Collections.Generic.List$1<any> | null, outputStart: number): number;
    }
    interface ResultPrimaryParser$2Func extends Function {
        <TInput, TOutput>($TInput: Bridge.TypeRef<TInput>, $TOutput: Bridge.TypeRef<TOutput>): {
            prototype: ResultPrimaryParser$2<TInput,TOutput>;
            new (): ResultPrimaryParser$2<TInput,TOutput>;
        }
    }
    var ResultPrimaryParser$2: ResultPrimaryParser$2Func;

    /**
     * Parses {@link } for Kusto query language
     *
     * @public
     * @class Kusto.Language.Parsing.TokenParser
     */
    interface TokenParser {
        /**
         * Parses the token at the starting offset in the text.
         *
         * @instance
         * @private
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}                                 text                     
         * @param   {number}                                 start                    
         * @param   {boolean}                                alwaysProduceEndToken
         * @return  {Kusto.Language.Parsing.LexicalToken}
         */
        ParseTrivia(text: string | null, start: number): string | null;
    }
    interface TokenParserFunc extends Function {
        prototype: TokenParser;
        TokenInfo: Kusto.Language.Parsing.TokenParser.TokenInfoFunc;
        /**
         * Parses the token at the starting position in the text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}                                 text                     
         * @param   {number}                                 start                    
         * @param   {boolean}                                alwaysProduceEndToken
         * @return  {Kusto.Language.Parsing.LexicalToken}
         */
        ParseToken(text: string | null, start?: number, alwaysProduceEndToken?: boolean): Kusto.Language.Parsing.LexicalToken | null;
        /**
         * Parses all the tokens in the text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}                                         text                     
         * @param   {boolean}                                        alwaysProduceEndToken
         * @return  {Array.<Kusto.Language.Parsing.LexicalToken>}
         */
        ParseTokens(text: string | null, alwaysProduceEndToken?: boolean): Kusto.Language.Parsing.LexicalToken[] | null;
        /**
         * Parses all the tokens in the text.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}                               text                     
         * @param   {System.Collections.Generic.List$1}    tokens                   
         * @param   {boolean}                              alwaysProduceEndToken
         * @return  {void}
         */
        ParseTokens$1(text: string | null, tokens: System.Collections.Generic.List$1<Kusto.Language.Parsing.LexicalToken> | null, alwaysProduceEndToken?: boolean): void;
        ScanTrivia(text: string | null, start: number): number;
        ScanComment(text: string | null, start: number): number;
        /**
         * Returns the number of characters in the identifier or -1 if there is no
         identitifer at the starting position.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        ScanIdentifier(text: string | null, start?: number): number;
        /**
         * Returns the number of characters that are part of the string literal, or -1 if the text
         at the starting position is not a string literal.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        ScanStringLiteral(text: string | null, start?: number): number;
        /**
         * Returns the number of characters in the client parameter of -1 if
         there is not client parameter at the starting position.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TokenParser
         * @memberof Kusto.Language.Parsing.TokenParser
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        ScanClientParameter(text: string | null, start?: number): number;
    }
    var TokenParser: TokenParserFunc;
    module TokenParser {
        interface TokenInfo {
            Kind: Kusto.Language.Syntax.SyntaxKind;
            Text: string | null;
            ZeroTriviaToken: Kusto.Language.Parsing.LexicalToken | null;
            SingleWhitespaceToken: Kusto.Language.Parsing.LexicalToken | null;
            GetToken(trivia: string | null): Kusto.Language.Parsing.LexicalToken | null;
        }
        interface TokenInfoFunc extends Function {
            prototype: TokenInfo;
            new (kind: Kusto.Language.Syntax.SyntaxKind): TokenInfo;
        }
    }

    /**
     * Facts about text.
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Parsing.TextFacts
     */
    interface TextFacts {
    }
    interface TextFactsFunc extends Function {
        prototype: TextFacts;
        new (): TextFacts;
        IsWhitespace(ch: number): boolean;
        IsWhitespaceOnly(text: string | null): boolean;
        IsWhitespaceOnly$1(text: string | null, start: number, length: number): boolean;
        IsLineBreakStart(ch: number): boolean;
        GetLineBreakLength(text: string | null, position: number): number;
        HasLineBreaks(text: string | null): boolean;
        /**
         * Gets the index of the start of the next line break or -1.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        GetNextLineBreakStart(text: string | null, start: number): number;
        /**
         * Gets the index of the end of the next line break or -1
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        GetNextLineBreakEnd(text: string | null, start: number): number;
        /**
         * Gets the index of the start of the first line break or -1
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text
         * @return  {number}
         */
        GetFirstLineBreakStart(text: string | null): number;
        /**
         * Gets the index of the end of hte first line break or -1
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text
         * @return  {number}
         */
        GetFirstLineBreakEnd(text: string | null): number;
        /**
         * Gets the index of the start of the last line break or -1
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        GetLastLineBreakStart(text: string | null, start?: number): number;
        /**
         * Gets the index of the start of the last line break or -1
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        GetLastLineBreakEnd(text: string | null, start?: number): number;
        /**
         * Returns true if the line is empty or whitespace.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}     text         
         * @param   {number}     lineStart
         * @return  {boolean}
         */
        IsBlankLine(text: string | null, lineStart: number): boolean;
        /**
         * Gets the line length (including line break characters)
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}     text                
         * @param   {number}     lineStart           
         * @param   {boolean}    includeLineBreak
         * @return  {number}
         */
        GetLineLength(text: string | null, lineStart: number, includeLineBreak?: boolean): number;
        /**
         * Gets the index of the start of the next line or -1;
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text     
         * @param   {number}    start
         * @return  {number}
         */
        GetNextLineStart(text: string | null, start: number): number;
        IsLetter(ch: number): boolean;
        IsDigit(ch: number): boolean;
        IsLetterOrDigit(ch: number): boolean;
        IsHexDigit(ch: number): boolean;
        /**
         * Gets the starting offset of all the lines.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}                               text          
         * @param   {System.Collections.Generic.List$1}    lineStarts
         * @return  {void}
         */
        GetLineStarts(text: string | null, lineStarts: System.Collections.Generic.List$1<number> | null): void;
        /**
         * Gets the starting position of the 1-based line number.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}          text         
         * @param   {number}          line         
         * @param   {System.Int32}    lineStart
         * @return  {boolean}
         */
        TryGetLineStart(text: string | null, line: number, lineStart: {v: number}): boolean;
        /**
         * Gets the 1-based line and lineOffset for a position.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}          text          
         * @param   {number}          position      
         * @param   {System.Int32}    line          
         * @param   {System.Int32}    lineOffset
         * @return  {boolean}
         */
        TryGetLineAndOffset$1(text: string | null, position: number, line: {v: number}, lineOffset: {v: number}): boolean;
        /**
         * Gets the 1-based line and lineOffset for a position.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {System.Collections.Generic.List$1}    lineStarts    
         * @param   {number}                               position      
         * @param   {System.Int32}                         line          
         * @param   {System.Int32}                         lineOffset
         * @return  {boolean}
         */
        TryGetLineAndOffset(lineStarts: System.Collections.Generic.List$1<number> | null, position: number, line: {v: number}, lineOffset: {v: number}): boolean;
        /**
         * Gets the position corresponding to the 1-based line and lineOffset.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}          text          
         * @param   {number}          line          
         * @param   {number}          lineOffset    
         * @param   {System.Int32}    position
         * @return  {boolean}
         */
        TryGetPosition$1(text: string | null, line: number, lineOffset: number, position: {v: number}): boolean;
        /**
         * Gets the position corresponding to the 1-based line and lineOffset.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {System.Collections.Generic.IReadOnlyList$1}    lineStarts    
         * @param   {number}                                        line          
         * @param   {number}                                        lineOffset    
         * @param   {System.Int32}                                  position
         * @return  {boolean}
         */
        TryGetPosition(lineStarts: System.Collections.Generic.IReadOnlyList$1<number> | null, line: number, lineOffset: number, position: {v: number}): boolean;
        /**
         * Trims the whitespace off the end of the text range.
         Returns the new length with the whitespace removed.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text
         * @return  {number}
         */
        TrimEnd(text: string | null): number;
        /**
         * Trims the whitespace off the end of the text range.
         Returns the new length with the whitespace removed.
         *
         * @static
         * @public
         * @this Kusto.Language.Parsing.TextFacts
         * @memberof Kusto.Language.Parsing.TextFacts
         * @param   {string}    text      
         * @param   {number}    start     
         * @param   {number}    length
         * @return  {number}
         */
        TrimEnd$1(text: string | null, start: number, length: number): number;
    }
    var TextFacts: TextFactsFunc;

}

    /**
     * @memberof Kusto.Language.Symbols
     * @callback Kusto.Language.Symbols.CustomReturnType
     * @param   {Kusto.Language.Symbols.TableSymbol}            table        
     * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments    
     * @param   {Kusto.Language.Symbols.Signature}              signature
     * @return  {Kusto.Language.Symbols.TypeSymbol}
     */

    /**
     * @memberof Kusto.Language.Symbols
     * @callback Kusto.Language.Symbols.ParameterLayoutBuilder
     * @param   {Kusto.Language.Symbols.Signature}              signature             
     * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
     * @param   {System.Collections.Generic.List$1}             argumentParameters
     * @return  {void}
     */

declare namespace Kusto.Language.Symbols {
    /** @namespace Kusto.Language.Symbols */

    /**
     * A symbol for a tuple of one or more name/value pairs.
     *
     * @public
     * @class Kusto.Language.Symbols.TupleSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface TupleSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Columns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        RelatedTable: Kusto.Language.Symbols.TableSymbol | null;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        WithColumns(columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null): Kusto.Language.Symbols.TupleSymbol | null;
    }
    interface TupleSymbolFunc extends Function {
        prototype: TupleSymbol;
        $ctor1: {
            new (columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null, relatedTable: Kusto.Language.Symbols.TableSymbol | null): TupleSymbol
        };
        ctor: {
            new (columns: Kusto.Language.Symbols.ColumnSymbol[] | null): TupleSymbol
        };
    }
    var TupleSymbol: TupleSymbolFunc;

    /**
     * A symbol representing a non-type.
     *
     * @public
     * @class Kusto.Language.Symbols.VoidSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface VoidSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface VoidSymbolFunc extends Function {
        prototype: VoidSymbol;
        Instance: Kusto.Language.Symbols.VoidSymbol | null;
    }
    var VoidSymbol: VoidSymbolFunc;

    /**
     * A symbol representing a cluster.
     *
     * @public
     * @class Kusto.Language.Symbols.ClusterSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface ClusterSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Databases: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.DatabaseSymbol> | null;
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        /**
         * If true, then the definition of the cluster is not fully known.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @function IsOpen
         * @type boolean
         */
        IsOpen: boolean;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * Gets the database with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {string}                                   databaseName
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        GetDatabase(databaseName: string | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Creates a new {@link } with the specified list of databases.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {System.Collections.Generic.IEnumerable$1}    databases
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        WithDatabases(databases: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.DatabaseSymbol> | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Creates a new {@link } with the specified database added.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    database
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        AddDatabase(database: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Creates a new {@link } with existing database replaced with the new database.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    existingDatabase    
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    newDatabase
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        UpdateDatabase(existingDatabase: Kusto.Language.Symbols.DatabaseSymbol | null, newDatabase: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Creates a new {@link } with database added or replacing an existing database with the same name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    newDatabase
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        AddOrUpdateDatabase(newDatabase: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Creates a new {@link } with the specified database removed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {Kusto.Language.Symbols.DatabaseSymbol}    symbolToRemove
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        RemoveDatabase(symbolToRemove: Kusto.Language.Symbols.DatabaseSymbol | null): Kusto.Language.Symbols.ClusterSymbol | null;
        /**
         * Creates a new {@link } with the specified databases removed.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {System.Collections.Generic.IEnumerable$1}    symbolsToRemove
         * @return  {Kusto.Language.Symbols.ClusterSymbol}
         */
        RemoveDatabases(symbolsToRemove: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.DatabaseSymbol> | null): Kusto.Language.Symbols.ClusterSymbol | null;
    }
    interface ClusterSymbolFunc extends Function {
        prototype: ClusterSymbol;
        /**
         * Creates a new instance of a {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {string}                                      name         
         * @param   {System.Collections.Generic.IEnumerable$1}    databases    
         * @param   {boolean}                                     isOpen
         * @return  {void}
         */
        $ctor1: {
            new (name: string | null, databases: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.DatabaseSymbol> | null, isOpen: boolean): ClusterSymbol
        };
        /**
         * Creates a new instance of a {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ClusterSymbol
         * @memberof Kusto.Language.Symbols.ClusterSymbol
         * @param   {string}                                           name         
         * @param   {Array.<Kusto.Language.Symbols.DatabaseSymbol>}    databases
         * @return  {void}
         */
        ctor: {
            new (name: string | null, databases: Kusto.Language.Symbols.DatabaseSymbol[] | null): ClusterSymbol
        };
        Unknown: Kusto.Language.Symbols.ClusterSymbol | null;
    }
    var ClusterSymbol: ClusterSymbolFunc;

    /**
     * A symbol representing a database.
     *
     * @public
     * @class Kusto.Language.Symbols.DatabaseSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface DatabaseSymbol extends Kusto.Language.Symbols.TypeSymbol {
        /**
         * If true, then the definition of the database is not fully known.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function IsOpen
         * @type boolean
         */
        IsOpen: boolean;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * All the symbols contained by this symbol.
         *
         * @instance
         * @public
         * @override
         * @readonly
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function Members
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        /**
         * The tables contained by the database.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function Tables
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Tables: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TableSymbol> | null;
        /**
         * The external tables accessible from the database.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function ExternalTables
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        ExternalTables: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TableSymbol> | null;
        /**
         * The materialized views accessible from the database.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function MaterializedViews
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        MaterializedViews: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.MaterializedViewSymbol> | null;
        /**
         * The functions contained by the database.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @function Functions
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Functions: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.FunctionSymbol> | null;
        /**
         * Gets the member with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                           name
         * @return  {Kusto.Language.Symbols.Symbol}
         */
        GetMember(name: string | null): Kusto.Language.Symbols.Symbol | null;
        /**
         * Gets the table with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                name
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        GetTable(name: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets the table, external table or materialized view with the specified name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                name
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        GetAnyTable(name: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets the external table with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                name
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        GetExternalTable(name: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets the materialized view with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                           name
         * @return  {Kusto.Language.Symbols.MaterializedViewSymbol}
         */
        GetMaterializedView(name: string | null): Kusto.Language.Symbols.MaterializedViewSymbol | null;
        /**
         * Gets the function with the specified name or returns null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                   name
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        GetFunction(name: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        WithMembers(members: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Creates a new database that includes the additional symbols (tables and functions).
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {System.Collections.Generic.IEnumerable$1}    symbols
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        AddMembers$1(symbols: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Creates a new database that includes the additional symbols (tables and functions).
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {Array.<Kusto.Language.Symbols.Symbol>}    symbols
         * @return  {Kusto.Language.Symbols.DatabaseSymbol}
         */
        AddMembers(symbols: Kusto.Language.Symbols.Symbol[] | null): Kusto.Language.Symbols.DatabaseSymbol | null;
        /**
         * Returns true if the symbol is contained by the database.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {Kusto.Language.Symbols.Symbol}    symbol
         * @return  {boolean}
         */
        Contains(symbol: Kusto.Language.Symbols.Symbol | null): boolean;
    }
    interface DatabaseSymbolFunc extends Function {
        prototype: DatabaseSymbol;
        /**
         * Creates a new instance of a {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                      name       
         * @param   {System.Collections.Generic.IEnumerable$1}    members    
         * @param   {boolean}                                     isOpen
         * @return  {void}
         */
        $ctor1: {
            new (name: string | null, members: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null, isOpen: boolean): DatabaseSymbol
        };
        /**
         * Creates a new instance of a {@link }.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.DatabaseSymbol
         * @memberof Kusto.Language.Symbols.DatabaseSymbol
         * @param   {string}                                   name       
         * @param   {Array.<Kusto.Language.Symbols.Symbol>}    members
         * @return  {void}
         */
        ctor: {
            new (name: string | null, members: Kusto.Language.Symbols.Symbol[] | null): DatabaseSymbol
        };
        Unknown: Kusto.Language.Symbols.DatabaseSymbol | null;
    }
    var DatabaseSymbol: DatabaseSymbolFunc;

    /**
     * A symbol for scalar types: long, real, string, bool, etc.
     *
     * @public
     * @class Kusto.Language.Symbols.ScalarSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface ScalarSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Aliases: System.Collections.Generic.IReadOnlyList$1<string> | null;
        Flags: Kusto.Language.Symbols.ScalarFlags;
        /**
         * The set of scalar types that this type is considered wider than.
         Narrower symbols can be implicitly converted to wider symbols.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.ScalarSymbol
         * @function WiderThan
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        WiderThan: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ScalarSymbol> | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        IsInteger: boolean;
        IsNumeric: boolean;
        IsInterval: boolean;
        IsSummable: boolean;
        IsOrderable: boolean;
        /**
         * True if this symbol is wider than the specified symbol.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ScalarSymbol
         * @memberof Kusto.Language.Symbols.ScalarSymbol
         * @param   {Kusto.Language.Symbols.ScalarSymbol}    scalar
         * @return  {boolean}
         */
        IsWiderThan(scalar: Kusto.Language.Symbols.ScalarSymbol | null): boolean;
    }
    interface ScalarSymbolFunc extends Function {
        prototype: ScalarSymbol;
        new (name: string | null, aliases: string[] | null, flags: Kusto.Language.Symbols.ScalarFlags, widerThan: Kusto.Language.Symbols.ScalarSymbol[] | null): ScalarSymbol;
        /**
         * Gets the {@link } for the type name.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.ScalarSymbol
         * @memberof Kusto.Language.Symbols.ScalarSymbol
         * @param   {string}                                 typeName
         * @return  {Kusto.Language.Symbols.ScalarSymbol}
         */
        From(typeName: string | null): Kusto.Language.Symbols.ScalarSymbol | null;
    }
    var ScalarSymbol: ScalarSymbolFunc;

    /**
     * A symbol representing an unknown type due to a semantic error.
     *
     * @public
     * @class Kusto.Language.Symbols.ErrorSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface ErrorSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        IsError: boolean;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface ErrorSymbolFunc extends Function {
        prototype: ErrorSymbol;
        Instance: Kusto.Language.Symbols.ErrorSymbol | null;
    }
    var ErrorSymbol: ErrorSymbolFunc;

    interface RepeatingParameterLayout extends Kusto.Language.Symbols.ParameterLayout {
        GetArgumentParameters$1(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetArgumentParameters(signature: Kusto.Language.Symbols.Signature | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetNextPossibleParameters(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, possibleParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
    }
    interface RepeatingParameterLayoutFunc extends Function {
        prototype: RepeatingParameterLayout;
        new (allowSkippingOptionalParameters: boolean): RepeatingParameterLayout;
    }
    var RepeatingParameterLayout: RepeatingParameterLayoutFunc;

    /**
     * A symbol for a variable declaration.
     Typically from a let statement.
     *
     * @public
     * @class Kusto.Language.Symbols.VariableSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface VariableSymbol extends Kusto.Language.Symbols.Symbol {
        /**
         * The type of the variable.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.VariableSymbol
         * @function Type
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        Type: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * True if the variable should be considered a constant.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.VariableSymbol
         * @function IsConstant
         * @type boolean
         */
        IsConstant: boolean;
        /**
         * The known constant value (or null if unknown).
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.VariableSymbol
         * @function ConstantValue
         * @type System.Object
         */
        ConstantValue: any | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface VariableSymbolFunc extends Function {
        prototype: VariableSymbol;
        /**
         * Creates a new instance of a {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.VariableSymbol
         * @memberof Kusto.Language.Symbols.VariableSymbol
         * @param   {string}                               name             
         * @param   {Kusto.Language.Symbols.TypeSymbol}    type             
         * @param   {boolean}                              isConstant       
         * @param   {System.Object}                        constantValue
         * @return  {void}
         */
        new (name: string | null, type: Kusto.Language.Symbols.TypeSymbol | null, isConstant: boolean, constantValue: any | null): VariableSymbol;
    }
    var VariableSymbol: VariableSymbolFunc;

    /**
     * A symbol for a declared function's parameter
     *
     * @public
     * @class Kusto.Language.Symbols.ParameterSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface ParameterSymbol extends Kusto.Language.Symbols.Symbol {
        Type: Kusto.Language.Symbols.TypeSymbol | null;
        Description: string | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface ParameterSymbolFunc extends Function {
        prototype: ParameterSymbol;
        new (name: string | null, type: Kusto.Language.Symbols.TypeSymbol | null, description: string | null): ParameterSymbol;
    }
    var ParameterSymbol: ParameterSymbolFunc;

    /**
     * A symbol for a query options (assigned via set statement)
     *
     * @public
     * @class Kusto.Language.Symbols.OptionSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface OptionSymbol extends Kusto.Language.Symbols.Symbol {
        Description: string | null;
        Types: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ScalarSymbol> | null;
        Examples: System.Collections.Generic.IReadOnlyList$1<string> | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface OptionSymbolFunc extends Function {
        prototype: OptionSymbol;
        $ctor1: {
            new (name: string | null, description: string | null, types: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ScalarSymbol> | null, examples: System.Collections.Generic.IReadOnlyList$1<string> | null): OptionSymbol
        };
        ctor: {
            new (name: string | null, description: string | null, type: Kusto.Language.Symbols.ScalarSymbol | null, examples: System.Collections.Generic.IReadOnlyList$1<string> | null): OptionSymbol
        };
    }
    var OptionSymbol: OptionSymbolFunc;

    /**
     * A symbol representing a scalar operator.
     *
     * @public
     * @class Kusto.Language.Symbols.OperatorSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface OperatorSymbol extends Kusto.Language.Symbols.Symbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        OperatorKind: Kusto.Language.Symbols.OperatorKind;
        Result: Kusto.Language.Symbols.TypeSymbol | null;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        Signatures: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Signature> | null;
    }
    interface OperatorSymbolFunc extends Function {
        prototype: OperatorSymbol;
        $ctor2: {
            new (kind: Kusto.Language.Symbols.OperatorKind, signatures: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Signature> | null): OperatorSymbol
        };
        ctor: {
            new (kind: Kusto.Language.Symbols.OperatorKind, signatures: Kusto.Language.Symbols.Signature[] | null): OperatorSymbol
        };
        $ctor1: {
            new (kind: Kusto.Language.Symbols.OperatorKind, result: Kusto.Language.Symbols.TypeSymbol | null): OperatorSymbol
        };
    }
    var OperatorSymbol: OperatorSymbolFunc;

    interface NonRepeatingParameterLayout extends Kusto.Language.Symbols.ParameterLayout {
        GetArgumentParameters$1(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetArgumentParameters(signature: Kusto.Language.Symbols.Signature | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetNextPossibleParameters(signature: Kusto.Language.Symbols.Signature | null, existingArguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, possibleParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
    }
    interface NonRepeatingParameterLayoutFunc extends Function {
        prototype: NonRepeatingParameterLayout;
        new (): NonRepeatingParameterLayout;
    }
    var NonRepeatingParameterLayout: NonRepeatingParameterLayoutFunc;

    interface EmptyScope extends Kusto.Language.Symbols.Scope {
        GetSymbols$1(name: string | null, match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null): void;
    }
    interface EmptyScopeFunc extends Function {
        prototype: EmptyScope;
        new (): EmptyScope;
        Instance: Kusto.Language.Symbols.EmptyScope | null;
    }
    var EmptyScope: EmptyScopeFunc;

    interface CustomParameterLayout extends Kusto.Language.Symbols.ParameterLayout {
        GetArgumentParameters$1(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
    }
    interface CustomParameterLayoutFunc extends Function {
        prototype: CustomParameterLayout;
        new (builder: {(signature: Kusto.Language.Symbols.Signature, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter>): void} | null): CustomParameterLayout;
    }
    var CustomParameterLayout: CustomParameterLayoutFunc;

    interface CommandSymbol extends Kusto.Language.Symbols.Symbol {
        /**
         * The language declaration of the result schema: (col:type, ...)
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.CommandSymbol
         * @function ResultSchema
         * @type string
         */
        ResultSchema: string | null;
        /**
         * The {@link } describing the result schema.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.CommandSymbol
         * @function ResultType
         * @type Kusto.Language.Symbols.TableSymbol
         */
        ResultType: Kusto.Language.Symbols.TableSymbol | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
    }
    interface CommandSymbolFunc extends Function {
        prototype: CommandSymbol;
        new (name: string | null, resultSchema: string | null): CommandSymbol;
    }
    var CommandSymbol: CommandSymbolFunc;

    /**
     * A symbol representing a column.
     *
     * @public
     * @class Kusto.Language.Symbols.ColumnSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface ColumnSymbol extends Kusto.Language.Symbols.Symbol {
        /**
         * The type of the column.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @function Type
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        Type: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * The description of the column.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @function Description
         * @type string
         */
        Description: string | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * Returns a {@link } with the name specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ColumnSymbol
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @param   {string}                                 name
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        WithName(name: string | null): Kusto.Language.Symbols.ColumnSymbol | null;
        /**
         * Returns a {@link } with the type specified.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ColumnSymbol
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @param   {Kusto.Language.Symbols.TypeSymbol}      type
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        WithType(type: Kusto.Language.Symbols.TypeSymbol | null): Kusto.Language.Symbols.ColumnSymbol | null;
        /**
         * Returns a {@link } with the specified description.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ColumnSymbol
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @param   {string}                                 description
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        WithDescription(description: string | null): Kusto.Language.Symbols.ColumnSymbol | null;
    }
    interface ColumnSymbolFunc extends Function {
        prototype: ColumnSymbol;
        new (name: string | null, type: Kusto.Language.Symbols.TypeSymbol | null, description: string | null): ColumnSymbol;
        /**
         * Combines multiple sets of columns into a single set of columns.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.ColumnSymbol
         * @memberof Kusto.Language.Symbols.ColumnSymbol
         * @param   {Kusto.Language.Symbols.CombineKind}            kind          
         * @param   {System.Collections.Generic.IEnumerable$1}      columnSets
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        Combine(kind: Kusto.Language.Symbols.CombineKind, columnSets: System.Collections.Generic.IEnumerable$1<System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol>> | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        Combine$1(kind: Kusto.Language.Symbols.CombineKind, columnSets: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol>[] | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
    }
    var ColumnSymbol: ColumnSymbolFunc;

    /**
     * A symbol corresponding to a group of symbols.
     This symbol occurs when a name reference is ambigous.
     *
     * @public
     * @class Kusto.Language.Symbols.GroupSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface GroupSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface GroupSymbolFunc extends Function {
        prototype: GroupSymbol;
        $ctor1: {
            new (symbols: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Symbol> | null): GroupSymbol
        };
        ctor: {
            new (symbols: Kusto.Language.Symbols.Symbol[] | null): GroupSymbol
        };
    }
    var GroupSymbol: GroupSymbolFunc;

    /**
     * A symbol representing a table
     *
     * @public
     * @class Kusto.Language.Symbols.TableSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface TableSymbol extends Kusto.Language.Symbols.TypeSymbol {
        /**
         * The columns of the table.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function Columns
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Columns: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ColumnSymbol> | null;
        /**
         * The description of the table.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function Description
         * @type string
         */
        Description: string | null;
        Kind: Kusto.Language.Symbols.SymbolKind;
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * True if the table is sorted.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function IsSorted
         * @type boolean
         */
        IsSorted: boolean;
        /**
         * True if the table is serialized.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function IsSerialized
         * @type boolean
         */
        IsSerialized: boolean;
        /**
         * True if the table is open.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function IsOpen
         * @type boolean
         */
        IsOpen: boolean;
        /**
         * True if the table is external.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function IsExternal
         * @type boolean
         */
        IsExternal: boolean;
        /**
         * True if the table is a materialized view.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @function IsMaterializedView
         * @type boolean
         */
        IsMaterializedView: boolean;
        /**
         * Returns a version of this {@link } with the specified name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {string}                                name
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithName(name: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified description.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {string}                                description
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithDescripton(description: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified columns.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {System.Collections.Generic.IEnumerable$1}    columns
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithColumns$1(columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified columns.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {Array.<Kusto.Language.Symbols.ColumnSymbol>}    columns
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithColumns(columns: Kusto.Language.Symbols.ColumnSymbol[] | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with additional columns.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {System.Collections.Generic.IEnumerable$1}    columns
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        AddColumns$1(columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with additional columns.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {Array.<Kusto.Language.Symbols.ColumnSymbol>}    columns
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        AddColumns(columns: Kusto.Language.Symbols.ColumnSymbol[] | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified state.
         *
         * @instance
         * @private
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {number}                                newState
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        /**
         * Returns a version of this {@link } with the specified {@link } property.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {boolean}                               isSerialized
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithIsSerialized(isSerialized: boolean): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified {@link } property.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {boolean}                               isSorted
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithIsSorted(isSorted: boolean): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified {@link } property.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {boolean}                               isOpen
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithIsOpen(isOpen: boolean): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified {@link } property.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {boolean}                               isExternal
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithIsExternal(isExternal: boolean): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the specified {@link } property.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {boolean}                               isMaterializedView
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithIsMaterializedView(isMaterializedView: boolean): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Returns a version of this {@link } with the same inheritable state properties as the specified table;
         IsSerialized, IsSorted, and IsOpen.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {Kusto.Language.Symbols.TableSymbol}    table
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        WithInheritableProperties(table: Kusto.Language.Symbols.TableSymbol | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets the column with the specified name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {string}                                 name
         * @return  {Kusto.Language.Symbols.ColumnSymbol}
         */
        GetColumn(name: string | null): Kusto.Language.Symbols.ColumnSymbol | null;
        /**
         * Gets the {@link } with the specified name.
         Returns true if the column is found, or false if there is no column with the specified name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {string}                                 name      
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
         * @return  {boolean}
         */
        TryGetColumn(name: string | null, column: {v: Kusto.Language.Symbols.ColumnSymbol | null}): boolean;
        GetMembers$1(name: string | null, match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null, ignoreCase?: boolean): void;
    }
    interface TableSymbolFunc extends Function {
        prototype: TableSymbol;
        TableState: TableSymbol.TableStateFunc;
        $ctor5: {
            new (name: string | null, columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null, description: string | null): TableSymbol
        };
        $ctor6: {
            new (name: string | null, schema: string | null, description: string | null): TableSymbol
        };
        $ctor3: {
            new (name: string | null, columns: Kusto.Language.Symbols.ColumnSymbol[] | null): TableSymbol
        };
        $ctor2: {
            new (columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null): TableSymbol
        };
        ctor: {
            new (columns: Kusto.Language.Symbols.ColumnSymbol[] | null): TableSymbol
        };
        /**
         * An empty table.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @type Kusto.Language.Symbols.TableSymbol
         */
        Empty: Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Gets a {@link } for the schema: (name:type, ...)
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {string}                                schema
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        From(schema: string | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Combine the columns of multiple tables into a new table.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {Kusto.Language.Symbols.CombineKind}          kind      
         * @param   {System.Collections.Generic.IEnumerable$1}    tables
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        Combine$1(kind: Kusto.Language.Symbols.CombineKind, tables: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.TableSymbol> | null): Kusto.Language.Symbols.TableSymbol | null;
        /**
         * Combine the columns of multiple tables into a new table.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableSymbol
         * @memberof Kusto.Language.Symbols.TableSymbol
         * @param   {Kusto.Language.Symbols.CombineKind}            kind      
         * @param   {Array.<Kusto.Language.Symbols.TableSymbol>}    tables
         * @return  {Kusto.Language.Symbols.TableSymbol}
         */
        Combine(kind: Kusto.Language.Symbols.CombineKind, tables: Kusto.Language.Symbols.TableSymbol[] | null): Kusto.Language.Symbols.TableSymbol | null;
    }
    var TableSymbol: TableSymbolFunc;
    module TableSymbol {
        interface TableState {
        }
        interface TableStateFunc extends Function {
            prototype: TableState;
            None: number;
            Serialized: number;
            Sorted: number;
            Open: number;
            External: number;
            MaterializedView: number;
        }
    }

    /**
     * The symbol for a pattern.
     *
     * @public
     * @class Kusto.Language.Symbols.PatternSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface PatternSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        Parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null;
        PathParameter: Kusto.Language.Symbols.Parameter | null;
        Signatures: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.PatternSignature> | null;
        Tabularity: Kusto.Language.Symbols.Tabularity;
    }
    interface PatternSymbolFunc extends Function {
        prototype: PatternSymbol;
        $ctor1: {
            new (name: string | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, pathParameter: Kusto.Language.Symbols.Parameter | null, signatures: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.PatternSignature> | null): PatternSymbol
        };
        ctor: {
            new (name: string | null): PatternSymbol
        };
    }
    var PatternSymbol: PatternSymbolFunc;

    /**
     * A base class for symbols that are types.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Symbols.TypeSymbol
     * @augments Kusto.Language.Symbols.Symbol
     */
    interface TypeSymbol extends Kusto.Language.Symbols.Symbol {
    }
    interface TypeSymbolFunc extends Function {
        prototype: TypeSymbol;
    }
    var TypeSymbol: TypeSymbolFunc;

    /**
     * The symbol for a function.
     *
     * @public
     * @class Kusto.Language.Symbols.FunctionSymbol
     * @augments Kusto.Language.Symbols.TypeSymbol
     */
    interface FunctionSymbol extends Kusto.Language.Symbols.TypeSymbol {
        Kind: Kusto.Language.Symbols.SymbolKind;
        /**
         * A function can have one or more signatures.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function Signatures
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Signatures: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Signature> | null;
        /**
         * The description of the function.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function Description
         * @type string
         */
        Description: string | null;
        /**
         * How the name of the result of this function is determined.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function ResultNameKind
         * @type Kusto.Language.Symbols.ResultNameKind
         */
        ResultNameKind: Kusto.Language.Symbols.ResultNameKind;
        /**
         * The prefix to column names generated by this function.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function ResultNamePrefix
         * @type string
         */
        ResultNamePrefix: string | null;
        /**
         * This function is considered a constant if all its arguments are constants.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function IsConstantFoldable
         * @type boolean
         */
        IsConstantFoldable: boolean;
        /**
         * The name of an alternative function to use instead of this function
         if this function is obsolete/deprecated.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function Alternative
         * @type string
         */
        Alternative: string | null;
        /**
         * True if this function is considered obsolete/deprecated.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function IsObsolete
         * @type boolean
         */
        IsObsolete: boolean;
        /**
         * If true, the symbol is hidden from Intellisense.
         *
         * @instance
         * @public
         * @override
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function IsHidden
         * @type boolean
         */
        IsHidden: boolean;
        /**
         * The tabularity of the function.
         *
         * @instance
         * @public
         * @override
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function Tabularity
         * @type Kusto.Language.Symbols.Tabularity
         */
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * The minimum number of arguments that this function requires.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function MinArgumentCount
         * @type number
         */
        MinArgumentCount: number;
        /**
         * The maximum number of arguments this function can take.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @function MaxArgumentCount
         * @type number
         */
        MaxArgumentCount: number;
        /**
         * Constructs a new {@link } if one of the arguments differs from the 
         existing corresponding property value, or returns this instance if there are no differences.
         *
         * @instance
         * @private
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {Kusto.Language.Utils.Optional$1}          name                  
         * @param   {Kusto.Language.Utils.Optional$1}          signatures            
         * @param   {Kusto.Language.Utils.Optional$1}          isHidden              
         * @param   {Kusto.Language.Utils.Optional$1}          isConstantFoldable    
         * @param   {Kusto.Language.Utils.Optional$1}          resultNameKind        
         * @param   {Kusto.Language.Utils.Optional$1}          resultNamePrefix      
         * @param   {Kusto.Language.Utils.Optional$1}          description           
         * @param   {Kusto.Language.Utils.Optional$1}          alternative
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        /**
         * Creates a new {@link } that is hidden from completion lists.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        Hide(): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {boolean}                                  isHidden
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithIsHidden(isHidden: boolean): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } that is a constant if all its arguments are constant.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        ConstantFoldable(): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {boolean}                                  isConstantFoldable
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithIsConstantFoldable(isConstantFoldable: boolean): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {string}                                   resultNamePrefix
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithResultNamePrefix(resultNamePrefix: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {Kusto.Language.Symbols.ResultNameKind}    kind
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithResultNameKind(kind: Kusto.Language.Symbols.ResultNameKind): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {string}                                   description
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithDescription(description: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } that is considered obsolete/deprecated.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {string}                                   alternative
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        Obsolete(alternative: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Creates a new {@link } with the {@link } property set to the specified value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {boolean}                                  isObsolete     
         * @param   {string}                                   alternative
         * @return  {Kusto.Language.Symbols.FunctionSymbol}
         */
        WithIsObsolete(isObsolete: boolean, alternative?: string | null): Kusto.Language.Symbols.FunctionSymbol | null;
        /**
         * Gets the return type for the function as best as can be determined without specific call site arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {Kusto.Language.GlobalState}           globals
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetReturnType(globals: Kusto.Language.GlobalState | null): Kusto.Language.Symbols.TypeSymbol | null;
        GetDisplay$1(verbose: boolean): string | null;
        /**
         * Gets the {@link } associated with this {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.FunctionSymbol
         * @memberof Kusto.Language.Symbols.FunctionSymbol
         * @param   {Kusto.Language.GlobalState}                  globals    
         * @param   {Kusto.Language.Symbols.FunctionBodyFacts}    facts
         * @return  {boolean}
         */
        TryGetFunctionBodyFacts(globals: Kusto.Language.GlobalState | null, facts: {v: Kusto.Language.Symbols.FunctionBodyFacts | null}): boolean;
    }
    interface FunctionSymbolFunc extends Function {
        prototype: FunctionSymbol;
        $ctor12: {
            new (name: string | null, signatures: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.Signature> | null, description: string | null): FunctionSymbol
        };
        $ctor6: {
            new (name: string | null, signatures: Kusto.Language.Symbols.Signature[] | null): FunctionSymbol
        };
        $ctor8: {
            new (name: string | null, returnType: Kusto.Language.Symbols.TypeSymbol | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, description: string | null): FunctionSymbol
        };
        $ctor7: {
            new (name: string | null, returnType: Kusto.Language.Symbols.TypeSymbol | null, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor5: {
            new (name: string | null, returnTypeKind: Kusto.Language.Symbols.ReturnTypeKind, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): FunctionSymbol
        };
        $ctor4: {
            new (name: string | null, returnTypeKind: Kusto.Language.Symbols.ReturnTypeKind, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor1: {
            new (name: string | null, customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, signature: Kusto.Language.Symbols.Signature): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): FunctionSymbol
        };
        ctor: {
            new (name: string | null, customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, signature: Kusto.Language.Symbols.Signature): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor3: {
            new (name: string | null, customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): FunctionSymbol
        };
        $ctor2: {
            new (name: string | null, customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor15: {
            new (name: string | null, body: string | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, description: string | null): FunctionSymbol
        };
        $ctor14: {
            new (name: string | null, body: string | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor16: {
            new (name: string | null, body: string | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null, description: string | null): FunctionSymbol
        };
        $ctor13: {
            new (name: string | null, body: string | null, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
        $ctor17: {
            new (name: string | null, parameterList: string | null, body: string | null, description: string | null): FunctionSymbol
        };
        $ctor10: {
            new (name: string | null, declaration: Kusto.Language.Syntax.FunctionBody | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): FunctionSymbol
        };
        $ctor9: {
            new (name: string | null, declaration: Kusto.Language.Syntax.FunctionBody | null, parameters: Kusto.Language.Symbols.Parameter[] | null): FunctionSymbol
        };
    }
    var FunctionSymbol: FunctionSymbolFunc;

    interface BlockRepeatingParameterLayout extends Kusto.Language.Symbols.ParameterLayout {
        GetArgumentParameters$1(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetArgumentParameters(signature: Kusto.Language.Symbols.Signature | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        GetNextPossibleParameters(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, possibleParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        IsValidArgumentCount(signature: Kusto.Language.Symbols.Signature | null, argumentCount: number): boolean;
    }
    interface BlockRepeatingParameterLayoutFunc extends Function {
        prototype: BlockRepeatingParameterLayout;
        new (): BlockRepeatingParameterLayout;
    }
    var BlockRepeatingParameterLayout: BlockRepeatingParameterLayoutFunc;

    interface TableStateExtensions {
    }
    interface TableStateExtensionsFunc extends Function {
        prototype: TableStateExtensions;
        new (): TableStateExtensions;
        Has(state: Kusto.Language.Symbols.TableState, test: Kusto.Language.Symbols.TableState): boolean;
        With(state: Kusto.Language.Symbols.TableState, stateToAdd: Kusto.Language.Symbols.TableState): Kusto.Language.Symbols.TableState;
        Without(state: Kusto.Language.Symbols.TableState, stateToRemove: Kusto.Language.Symbols.TableState): Kusto.Language.Symbols.TableState;
        /**
         * The table is new, but inherits any global state from the current state.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableStateExtensions
         * @memberof Kusto.Language.Symbols.TableStateExtensions
         * @param   {Kusto.Language.Symbols.TableState}    state
         * @return  {Kusto.Language.Symbols.TableState}
         */
        New(state: Kusto.Language.Symbols.TableState): Kusto.Language.Symbols.TableState;
        /**
         * The table is open, and may have more columns than specified.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableStateExtensions
         * @memberof Kusto.Language.Symbols.TableStateExtensions
         * @param   {Kusto.Language.Symbols.TableState}    state
         * @return  {Kusto.Language.Symbols.TableState}
         */
        Open(state: Kusto.Language.Symbols.TableState): Kusto.Language.Symbols.TableState;
        /**
         * The table is not sorted.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.TableStateExtensions
         * @memberof Kusto.Language.Symbols.TableStateExtensions
         * @param   {Kusto.Language.Symbols.TableState}    state
         * @return  {Kusto.Language.Symbols.TableState}
         */
        Unsorted(state: Kusto.Language.Symbols.TableState): Kusto.Language.Symbols.TableState;
    }
    var TableStateExtensions: TableStateExtensionsFunc;

    enum CombineKind {
        UnifySameNameAndType = 0,
        UnifySameName = 1,
        UniqueNames = 2
    }

    /**
     * Useful facts about the function body identified during analysis.
     *
     * @public
     * @class Kusto.Language.Symbols.FunctionBodyFacts
     */
    interface FunctionBodyFacts {
        /**
         * The return type of the function body when it is not dependent on arguments.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function NonVariableComputedReturnType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        NonVariableComputedReturnType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * True if the function body had syntax or semantic errors.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasErrors
         * @type boolean
         */
        HasErrors: boolean;
        /**
         * True if the function has a variable return type (it is dependent on argument values or call site)
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasVariableReturnType
         * @type boolean
         */
        HasVariableReturnType: boolean;
        /**
         * True if the function body has a call to the cluster method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasClusterCall
         * @type boolean
         */
        HasClusterCall: boolean;
        /**
         * True if the function body has a call to the database method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasDatabaseCall
         * @type boolean
         */
        HasDatabaseCall: boolean;
        /**
         * True if the function body has a call to the unqualified table method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasUnqualifiedTableCall
         * @type boolean
         */
        HasUnqualifiedTableCall: boolean;
        /**
         * True if the function body has a call to the qualified database().table method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasQualifiedTableCall
         * @type boolean
         */
        HasQualifiedTableCall: boolean;
        /**
         * True if the function body has a call to the externaltable method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasExternalTableCall
         * @type boolean
         */
        HasExternalTableCall: boolean;
        /**
         * True if the function body has a call to the materializedview method, or a function invoked within it does
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function HasMaterializedViewCall
         * @type boolean
         */
        HasMaterializedViewCall: boolean;
        /**
         * True if the function body has any interesting aspects.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.FunctionBodyFacts
         * @function IsInteresting
         * @type boolean
         */
        IsInteresting: boolean;
    }
    interface FunctionBodyFactsFunc extends Function {
        prototype: FunctionBodyFacts;
    }
    var FunctionBodyFacts: FunctionBodyFactsFunc;

    enum FunctionBodyFlags {
        None = 0,
        Cluster = 1,
        Database = 2,
        UnqualifiedTable = 4,
        QualifiedTable = 8,
        ExternalTable = 16,
        VariableReturn = 32,
        MaterializedView = 64
    }

    enum MaterializedViewKind {
        Unknown = 0,
        Downsampling = 1,
        Other = 2
    }

    /**
     * The kind of operator for a {@link }
     *
     * @public
     * @class Kusto.Language.Symbols.OperatorKind
     */
    enum OperatorKind {
        None = 0,
        UnaryMinus = 1,
        UnaryPlus = 2,
        Add = 3,
        Subtract = 4,
        Multiply = 5,
        Divide = 6,
        Modulo = 7,
        EqualTilde = 8,
        BangTilde = 9,
        Has = 10,
        HasCs = 11,
        NotHas = 12,
        NotHasCs = 13,
        HasPrefix = 14,
        HasPrefixCs = 15,
        NotHasPrefix = 16,
        NotHasPrefixCs = 17,
        HasSuffix = 18,
        HasSuffixCs = 19,
        NotHasSuffix = 20,
        NotHasSuffixCs = 21,
        Like = 22,
        LikeCs = 23,
        NotLike = 24,
        NotLikeCs = 25,
        Contains = 26,
        ContainsCs = 27,
        NotContains = 28,
        NotContainsCs = 29,
        StartsWith = 30,
        StartsWithCs = 31,
        NotStartsWith = 32,
        NotStartsWithCs = 33,
        EndsWith = 34,
        EndsWithCs = 35,
        NotEndsWith = 36,
        NotEndsWithCs = 37,
        MatchRegex = 38,
        Search = 39,
        LessThan = 40,
        LessThanOrEqual = 41,
        GreaterThan = 42,
        GreaterThanOrEqual = 43,
        Equal = 44,
        NotEqual = 45,
        And = 46,
        Or = 47,
        In = 48,
        InCs = 49,
        NotIn = 50,
        NotInCs = 51,
        Between = 52,
        NotBetween = 53,
        HasAny = 54,
        HasAll = 55
    }

    /**
     * A parameter declaration for a {@link }.
     *
     * @public
     * @class Kusto.Language.Symbols.Parameter
     */
    interface Parameter {
        /**
         * The name of the parameter.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function Name
         * @type string
         */
        Name: string | null;
        /**
         * The kind of parameter.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function TypeKind
         * @type Kusto.Language.Symbols.ParameterTypeKind
         */
        TypeKind: Kusto.Language.Symbols.ParameterTypeKind;
        /**
         * The possible declared types of the parameter.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function DeclaredTypes
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        DeclaredTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null;
        /**
         * The kind of argument this parameter is constrained to.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function ArgumentKind
         * @type Kusto.Language.Symbols.ArgumentKind
         */
        ArgumentKind: Kusto.Language.Symbols.ArgumentKind;
        /**
         * The minimum number of times the parameter can occur in the signature.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function MinOccurring
         * @type number
         */
        MinOccurring: number;
        /**
         * The maximum number of times the parameter can occur in the signature.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function MaxOccurring
         * @type number
         */
        MaxOccurring: number;
        /**
         * True if the parameter is optional.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Parameter
         * @function IsOptional
         * @type boolean
         */
        IsOptional: boolean;
        /**
         * True if the parameter can be repeated.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Parameter
         * @function IsRepeatable
         * @type boolean
         */
        IsRepeatable: boolean;
        /**
         * The specific values that this parameter is constrained to.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function Values
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Values: System.Collections.Generic.IReadOnlyList$1<any> | null;
        /**
         * Completion list examples.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function Examples
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Examples: System.Collections.Generic.IReadOnlyList$1<string> | null;
        /**
         * If true, then text values (string literal or tokens) must be matched case sensitive.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function IsCaseSensitive
         * @type boolean
         */
        IsCaseSensitive: boolean;
        /**
         * The string literal that can be used to indicate use of the default value.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function DefaultValueIndicator
         * @type string
         */
        DefaultValueIndicator: string | null;
        /**
         * The default value specified for user defined functions.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function DefaultValue
         * @type Kusto.Language.Syntax.Expression
         */
        DefaultValue: Kusto.Language.Syntax.Expression | null;
        /**
         * The descripton of the parameter.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Parameter
         * @function Description
         * @type string
         */
        Description: string | null;
        /**
         * True if the type of the parameter is dependant on arguments.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Parameter
         * @function TypeDependsOnArguments
         * @type boolean
         */
        TypeDependsOnArguments: boolean;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        IsScalar: boolean;
        IsTabular: boolean;
        TypeDisplay: string | null;
        Display: string | null;
    }
    interface ParameterFunc extends Function {
        prototype: Parameter;
        ctor: {
            new (name: string | null, typeKind: Kusto.Language.Symbols.ParameterTypeKind, argumentKind: Kusto.Language.Symbols.ArgumentKind, values: System.Collections.Generic.IReadOnlyList$1<any> | null, examples: System.Collections.Generic.IReadOnlyList$1<string> | null, isCaseSensitive: boolean, defaultValueIndicator: string | null, minOccurring: number, maxOccurring: number, defaultValue: Kusto.Language.Syntax.Expression | null, description: string | null): Parameter
        };
        $ctor3: {
            new (name: string | null, type: Kusto.Language.Symbols.TypeSymbol | null, argumentKind: Kusto.Language.Symbols.ArgumentKind, values: System.Collections.Generic.IReadOnlyList$1<any> | null, examples: System.Collections.Generic.IReadOnlyList$1<string> | null, isCaseSensitive: boolean, defaultValueIndicator: string | null, minOccurring: number, maxOccurring: number, defaultValue: Kusto.Language.Syntax.Expression | null, description: string | null): Parameter
        };
        $ctor4: {
            new (name: string | null, types: Kusto.Language.Symbols.TypeSymbol[] | null, argumentKind: Kusto.Language.Symbols.ArgumentKind, values: System.Collections.Generic.IReadOnlyList$1<any> | null, examples: System.Collections.Generic.IReadOnlyList$1<string> | null, isCaseSensitive: boolean, defaultValueIndicator: string | null, minOccurring: number, maxOccurring: number, defaultValue: Kusto.Language.Syntax.Expression | null, description: string | null): Parameter
        };
        $ctor2: {
            new (name: string | null, type: Kusto.Language.Symbols.TypeSymbol | null): Parameter
        };
        /**
         * Convert a {@link } into a {@link } instance.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Symbols.ParameterSymbol}    parameter       
         * @param   {boolean}                                   isOptional      
         * @param   {Kusto.Language.Syntax.Expression}          defaultValue
         * @return  {Kusto.Language.Symbols.Parameter}
         */
        From(parameter: Kusto.Language.Symbols.ParameterSymbol | null, isOptional?: boolean, defaultValue?: Kusto.Language.Syntax.Expression | null): Kusto.Language.Symbols.Parameter | null;
        /**
         * Convert a parsed {@link } syntax into a {@link }.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Syntax.FunctionParameter}    declaration
         * @return  {Kusto.Language.Symbols.Parameter}
         */
        From$1(declaration: Kusto.Language.Syntax.FunctionParameter | null): Kusto.Language.Symbols.Parameter | null;
        /**
         * Convert parsed {@link } syntax into a list of {@link }
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Syntax.FunctionParameters}      declaration
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        From$2(declaration: Kusto.Language.Syntax.FunctionParameters | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null;
        /**
         * Parse the parameter list of a function declaration
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {string}                                        parameters
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        ParseList(parameters: string | null): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null;
        /**
         * Gets the text of the parameter as it would appear in a function declaration.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Symbols.Parameter}    parameter
         * @return  {string}
         */
        GetDeclaration(parameter: Kusto.Language.Symbols.Parameter | null): string | null;
        /**
         * Gets the text of a parameter list of a function declaration for the specified parameters.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {System.Collections.Generic.IReadOnlyList$1}    parameters
         * @return  {string}
         */
        GetParameterListDeclaration(parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): string | null;
        /**
         * Gets the text of a table schema as it would appear as a type of a parameter in a function declaration.
         *
         * @static
         * @private
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Symbols.TableSymbol}    table
         * @return  {string}
         */
        /**
         * Gets the text of a column as it would appear in the table type of a parameter of a function declaration.
         *
         * @static
         * @private
         * @this Kusto.Language.Symbols.Parameter
         * @memberof Kusto.Language.Symbols.Parameter
         * @param   {Kusto.Language.Symbols.ColumnSymbol}    column
         * @return  {string}
         */
    }
    var Parameter: ParameterFunc;

    /**
     * The known set of {@link }'s
     *
     * @static
     * @abstract
     * @public
     * @class Kusto.Language.Symbols.ParameterLayouts
     */
    interface ParameterLayouts {
    }
    interface ParameterLayoutsFunc extends Function {
        prototype: ParameterLayouts;
        new (): ParameterLayouts;
        /**
         * Does not allow parameters to repeat.
          Optional parameters (minOccurring=0) cannot be skipped.
          Named arguments allowed.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ParameterLayouts
         * @type Kusto.Language.Symbols.ParameterLayout
         */
        Fixed: Kusto.Language.Symbols.ParameterLayout | null;
        /**
         * Allows for individual repeating parameters, transitioning based on type matching.
         Optional parameters (minOccurring=0) cannot be skipped.
         Named argument not allowed.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ParameterLayouts
         * @type Kusto.Language.Symbols.ParameterLayout
         */
        Repeating: Kusto.Language.Symbols.ParameterLayout | null;
        /**
         * Allows for individual repeating parameters, transitioning based on type matching.
         Optional parameters (minOccurring=0) may be skipped.
         Named arguments not allowed.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ParameterLayouts
         * @type Kusto.Language.Symbols.ParameterLayout
         */
        RepeatingSkipping: Kusto.Language.Symbols.ParameterLayout | null;
        /**
         * Allows for a single group of parameters to repeat together.
         Optional parameters (minOccurring=0) cannot be skipped and cannot be part of the repeating block.
         Named arguments not allowed.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ParameterLayouts
         * @type Kusto.Language.Symbols.ParameterLayout
         */
        BlockRepeating: Kusto.Language.Symbols.ParameterLayout | null;
        /**
         * A custom layout supplied by a builder function.
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.ParameterLayouts
         * @memberof Kusto.Language.Symbols.ParameterLayouts
         * @param   {Kusto.Language.Symbols.ParameterLayoutBuilder}    builder
         * @return  {Kusto.Language.Symbols.ParameterLayout}
         */
        Custom(builder: {(signature: Kusto.Language.Symbols.Signature, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter>): void} | null): Kusto.Language.Symbols.ParameterLayout | null;
    }
    var ParameterLayouts: ParameterLayoutsFunc;

    /**
     * The kind of parameter type constraint specified in a {@link }
     *
     * @public
     * @class Kusto.Language.Symbols.ParameterTypeKind
     */
    enum ParameterTypeKind {
        Declared = 0,
        Scalar = 1,
        Tabular = 2,
        Database = 3,
        Cluster = 4,
        Integer = 5,
        RealOrDecimal = 6,
        StringOrDynamic = 7,
        Number = 8,
        NumberOrBool = 9,
        Summable = 10,
        Orderable = 11,
        NotRealOrBool = 12,
        NotDynamic = 13,
        NotBool = 14,
        Parameter0 = 15,
        Parameter1 = 16,
        Parameter2 = 17,
        CommonScalar = 18,
        CommonNumber = 19,
        CommonSummable = 20,
        CommonOrderable = 21,
        CommonScalarOrDynamic = 22,
        IntegerOrDynamic = 23
    }

    interface PatternSignature {
        Symbol: Kusto.Language.Symbols.PatternSymbol | null;
        ArgumentValues: System.Collections.Generic.IReadOnlyList$1<string> | null;
        PathValue: string | null;
        Signature: Kusto.Language.Symbols.Signature | null;
    }
    interface PatternSignatureFunc extends Function {
        prototype: PatternSignature;
        $ctor1: {
            new (argumentValues: System.Collections.Generic.IReadOnlyList$1<string> | null, pathValue: string | null, body: string | null): PatternSignature
        };
        ctor: {
            new (argumentValues: System.Collections.Generic.IReadOnlyList$1<string> | null, pathValue: string | null, body: Kusto.Language.Syntax.FunctionBody | null): PatternSignature
        };
    }
    var PatternSignature: PatternSignatureFunc;

    enum ResultNameKind {
        None = 0,
        NameAndFirstArgument = 1,
        NameAndOnlyArgument = 2,
        PrefixAndFirstArgument = 3,
        PrefixAndOnlyArgument = 4,
        FirstArgumentValueIfColumn = 5,
        PrefixOnly = 6,
        FirstArgument = 7,
        OnlyArgument = 8,
        Default
    }

    /**
     * The kind of return type specified in a {@link }
     *
     * @public
     * @class Kusto.Language.Symbols.ReturnTypeKind
     */
    enum ReturnTypeKind {
        Declared = 0,
        Computed = 1,
        Custom = 2,
        Parameter0 = 3,
        Parameter1 = 4,
        Parameter2 = 5,
        ParameterN = 6,
        ParameterNLiteral = 7,
        Parameter0Promoted = 8,
        Parameter0Cluster = 9,
        Parameter0Database = 10,
        Parameter0Table = 11,
        Parameter0ExternalTable = 12,
        Common = 13,
        Widest = 14,
        Parameter0MaterializedView = 15
    }

    enum ScalarFlags {
        None = 0,
        Integer = 1,
        Numeric = 2,
        Interval = 4,
        Summable = 8,
        Orderable = 16,
        All = 31
    }

    interface ScalarTypes {
    }
    interface ScalarTypesFunc extends Function {
        prototype: ScalarTypes;
        new (): ScalarTypes;
        Bool: Kusto.Language.Symbols.ScalarSymbol | null;
        Int: Kusto.Language.Symbols.ScalarSymbol | null;
        Long: Kusto.Language.Symbols.ScalarSymbol | null;
        Real: Kusto.Language.Symbols.ScalarSymbol | null;
        Decimal: Kusto.Language.Symbols.ScalarSymbol | null;
        DateTime: Kusto.Language.Symbols.ScalarSymbol | null;
        TimeSpan: Kusto.Language.Symbols.ScalarSymbol | null;
        Guid: Kusto.Language.Symbols.ScalarSymbol | null;
        Type: Kusto.Language.Symbols.ScalarSymbol | null;
        Dynamic: Kusto.Language.Symbols.ScalarSymbol | null;
        String: Kusto.Language.Symbols.ScalarSymbol | null;
        /**
         * This is not actually a scalar type, but is used when a column has an unknown type.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ScalarTypes
         * @type Kusto.Language.Symbols.ScalarSymbol
         */
        Unknown: Kusto.Language.Symbols.ScalarSymbol | null;
        /**
         * All known scalar symbols
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.ScalarTypes
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        All: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.ScalarSymbol> | null;
        GetSymbol(typeName: string | null): Kusto.Language.Symbols.ScalarSymbol | null;
    }
    var ScalarTypes: ScalarTypesFunc;

    /**
     * The parameter constraints and return type rules of a function or operator symbol.
     *
     * @public
     * @class Kusto.Language.Symbols.Signature
     */
    interface Signature {
        /**
         * The symbol this is a signature for.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function Symbol
         * @type Kusto.Language.Symbols.Symbol
         */
        Symbol: Kusto.Language.Symbols.Symbol | null;
        /**
         * The approach by which the return type is determined.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function ReturnKind
         * @type Kusto.Language.Symbols.ReturnTypeKind
         */
        ReturnKind: Kusto.Language.Symbols.ReturnTypeKind;
        /**
         * The declared parameters.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function Parameters
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null;
        /**
         * The minimum number of arguments an invocation of this signature can have.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function MinArgumentCount
         * @type number
         */
        MinArgumentCount: number;
        /**
         * The maximum number of arguments an invocation of this signature can have.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function MaxArgumentCount
         * @type number
         */
        MaxArgumentCount: number;
        /**
         * The declaration of the body of the function in source.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function Declaration
         * @type Kusto.Language.Syntax.FunctionBody
         */
        Declaration: Kusto.Language.Syntax.FunctionBody | null;
        /**
         * A custom function that evaluates the return type of this signature.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function CustomReturnType
         * @type Kusto.Language.Symbols.CustomReturnType
         */
        CustomReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, signature: Kusto.Language.Symbols.Signature): Kusto.Language.Symbols.TypeSymbol} | null;
        /**
         * The rule that describes how parameters are associated with arguments
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function Layout
         * @type Kusto.Language.Symbols.ParameterLayout
         */
        Layout: Kusto.Language.Symbols.ParameterLayout | null;
        /**
         * If true, this signature is hidden from intellisense
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function IsHidden
         * @type boolean
         */
        IsHidden: boolean;
        /**
         * If true, this signature can have a variable number of arguments.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function HasRepeatableParameters
         * @type boolean
         */
        HasRepeatableParameters: boolean;
        /**
         * If true, this signature has optional parameters.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function HasOptionalParameters
         * @type boolean
         */
        HasOptionalParameters: boolean;
        /**
         * If true, this signature has parameters that are expected to be aggregates.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Signature
         * @function HasAggregateParameters
         * @type boolean
         */
        HasAggregateParameters: boolean;
        /**
         * The body of the function, if declared within the query or database.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Signature
         * @function Body
         * @type string
         */
        Body: string | null;
        /**
         * The return type if specified as part of the signature.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Signature
         * @function DeclaredReturnType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        DeclaredReturnType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * True if the function allows named arguments
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Signature
         * @function AllowsNamedArguments
         * @type boolean
         */
        AllowsNamedArguments: boolean;
        Tabularity: Kusto.Language.Symbols.Tabularity;
        IsScalar: boolean;
        IsTabular: boolean;
        ReturnTypeDisplay: string | null;
        Display: string | null;
        /**
         * Creates a new {@link } just like this one, but with a custom function that 
         builds a list of parameter associated with each argument.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.Symbols.ParameterLayoutBuilder}    customBuilder
         * @return  {Kusto.Language.Symbols.Signature}
         */
        WithLayout$1(customBuilder: {(signature: Kusto.Language.Symbols.Signature, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter>): void} | null): Kusto.Language.Symbols.Signature | null;
        /**
         * Creates a new {@link } just like this one, but with a custom function that 
         builds a list of parameter associated with each argument.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.Symbols.ParameterLayout}    layout
         * @return  {Kusto.Language.Symbols.Signature}
         */
        WithLayout(layout: Kusto.Language.Symbols.ParameterLayout | null): Kusto.Language.Symbols.Signature | null;
        /**
         * Creates a {@link } just like this one, but is hidden from intellisense.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @return  {Kusto.Language.Symbols.Signature}
         */
        Hide(): Kusto.Language.Symbols.Signature | null;
        /**
         * Gets the parameter given the parameter name.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {string}                              name
         * @return  {Kusto.Language.Symbols.Parameter}
         */
        GetParameter(name: string | null): Kusto.Language.Symbols.Parameter | null;
        /**
         * Builds a list of parameters as associated with the specified arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments
         * @return  {System.Collections.Generic.List$1}
         */
        GetArgumentParameters($arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null): System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null;
        /**
         * Builds a list of parameters associated with the specified arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.List$1}             argumentParameters
         * @return  {void}
         */
        GetArgumentParameters$2($arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        /**
         * Builds a list of parameters associated with the specified argument types.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes         
         * @param   {System.Collections.Generic.List$1}             argumentParameters
         * @return  {void}
         */
        GetArgumentParameters$1(argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        /**
         * Gets the set of possible parameters that could occur after the specified arguments
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.List$1}             possibleParameters
         * @return  {void}
         */
        GetNextPossibleParameters($arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, possibleParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        /**
         * True if the argument count represents a valid number of arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {number}     argumentCount
         * @return  {boolean}
         */
        IsValidArgumentCount(argumentCount: number): boolean;
        /**
         * Gets the return type for the function as best as can be determined without specific call site arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.GlobalState}           globals    The {@link } in context for any computations made in determining the return type.
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetReturnType(globals: Kusto.Language.GlobalState | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the return type for the function as best as can be determined with a set of hypothetical argument types.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.GlobalState}                    globals          The {@link } in context for any computations made in determining the return type.
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes    A list of types for hypothetical arguments.
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetReturnType$1(globals: Kusto.Language.GlobalState | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Gets the return type for the function as best as can be determined with a set of hypothetical argument types
         and corresponding their parameters.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.GlobalState}                    globals               The {@link } in context for any computations made in determining the return type.
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes         A list of types for hypothetical arguments.
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentParameters    A list of the parameters associated with each hypothetical argument.
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetReturnType$2(globals: Kusto.Language.GlobalState | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * Determines the tabularity of signatures with computed return types.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.GlobalState}    globals    The {@link } in context for any computations made in determining the tabularity.
         * @return  {void}
         */
        ComputeTabularity(globals: Kusto.Language.GlobalState | null): void;
        /**
         * Determine's the tabularity of this function signature from the syntax of the body.
         *
         * @instance
         * @private
         * @this Kusto.Language.Symbols.Signature
         * @memberof Kusto.Language.Symbols.Signature
         * @param   {Kusto.Language.GlobalState}           globals
         * @return  {Kusto.Language.Symbols.Tabularity}
         */
    }
    interface SignatureFunc extends Function {
        prototype: Signature;
        $ctor6: {
            new (returnKind: Kusto.Language.Symbols.ReturnTypeKind, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        $ctor4: {
            new (returnKind: Kusto.Language.Symbols.ReturnTypeKind, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        $ctor8: {
            new (returnType: Kusto.Language.Symbols.TypeSymbol | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        $ctor7: {
            new (returnType: Kusto.Language.Symbols.TypeSymbol | null, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        $ctor1: {
            new (customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, signature: Kusto.Language.Symbols.Signature): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        ctor: {
            new (customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>, signature: Kusto.Language.Symbols.Signature): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        $ctor3: {
            new (customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        $ctor2: {
            new (customReturnType: {(table: Kusto.Language.Symbols.TableSymbol, arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression>): Kusto.Language.Symbols.TypeSymbol} | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        $ctor12: {
            new (body: string | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        $ctor11: {
            new (body: string | null, tabularity: Kusto.Language.Symbols.Tabularity, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        $ctor10: {
            new (declaration: Kusto.Language.Syntax.FunctionBody | null, parameters: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Parameter> | null): Signature
        };
        $ctor9: {
            new (declaration: Kusto.Language.Syntax.FunctionBody | null, parameters: Kusto.Language.Symbols.Parameter[] | null): Signature
        };
        /**
         * A parameter used to associate with an argument when no declared parameter matches.
         *
         * @static
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Signature
         * @type Kusto.Language.Symbols.Parameter
         */
        UnknownParameter: Kusto.Language.Symbols.Parameter | null;
    }
    var Signature: SignatureFunc;

    enum SymbolKind {
        None = 0,
        Scalar = 1,
        Variable = 2,
        Function = 3,
        Parameter = 4,
        Pattern = 5,
        Tuple = 6,
        Column = 7,
        Table = 8,
        Database = 9,
        Cluster = 10,
        Operator = 11,
        Group = 12,
        Void = 13,
        Error = 14,
        Command = 15,
        MaterializedView = 16,
        Option = 17,
        QueryOperatorParameter = 18
    }

    enum SymbolMatch {
        None = 0,
        Column = 1,
        Table = 2,
        ExternalTable = 4,
        Function = 8,
        Local = 16,
        Database = 32,
        Cluster = 64,
        Scalar = 128,
        Tabular = 256,
        MaterializedView = 512,
        Option = 1024,
        Any = 1019,
        Default = 923
    }

    enum Tabularity {
        None = 0,
        Scalar = 1,
        Tabular = 2,
        Unknown = 3,
        Unspecified = 4
    }

    interface Scope {
        /**
         * Gets all the symbols in the scope with the specified kind.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Scope
         * @memberof Kusto.Language.Symbols.Scope
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
         * @param   {System.Collections.Generic.List$1}     symbols
         * @return  {void}
         */
        GetSymbols(match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null): void;
        /**
         * Gets all symbols in the scope with the specified name and kind.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Symbols.Scope
         * @memberof Kusto.Language.Symbols.Scope
         * @param   {string}                                name       
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match      
         * @param   {System.Collections.Generic.List$1}     symbols
         * @return  {void}
         */
        GetSymbols$1(name: string | null, match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null): void;
    }
    interface ScopeFunc extends Function {
        prototype: Scope;
        new (): Scope;
    }
    var Scope: ScopeFunc;

    interface SymbolMatchExtensions {
    }
    interface SymbolMatchExtensionsFunc extends Function {
        prototype: SymbolMatchExtensions;
        new (): SymbolMatchExtensions;
        Matches$1(symbol: Kusto.Language.Symbols.Symbol | null, name: string | null, match: Kusto.Language.Symbols.SymbolMatch, ignoreCase?: boolean): boolean;
        Matches(symbol: Kusto.Language.Symbols.Symbol | null, match: Kusto.Language.Symbols.SymbolMatch): boolean;
    }
    var SymbolMatchExtensions: SymbolMatchExtensionsFunc;

    /**
     * The state of a {@link }
     *
     * @public
     * @class Kusto.Language.Symbols.TableState
     */
    enum TableState {
        None = 0,
        Serialized = 1,
        Sorted = 2,
        Open = 4
    }

    /**
     * The argument kind expected for a {@link }
     *
     * @public
     * @class Kusto.Language.Symbols.ArgumentKind
     */
    enum ArgumentKind {
        Expression = 0,
        StarOnly = 1,
        StarAllowed = 2,
        Aggregate = 3,
        Column = 4,
        Literal = 5,
        LiteralNotEmpty = 6,
        Constant = 7
    }

    interface Symbol {
        /**
         * The name of the symbol.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Symbols.Symbol
         * @function Name
         * @type string
         */
        Name: string | null;
        /**
         * The {@link } of the symbol.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function Kind
         * @type Kusto.Language.Symbols.SymbolKind
         */
        Kind: Kusto.Language.Symbols.SymbolKind;
        /**
         * If true, the symbol is hidden from Intellisense.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function IsHidden
         * @type boolean
         */
        IsHidden: boolean;
        /**
         * True if the symbol is an error symbol.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function IsError
         * @type boolean
         */
        IsError: boolean;
        /**
         * Identifies whether the symbol is scalar or tabular.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function Tabularity
         * @type Kusto.Language.Symbols.Tabularity
         */
        Tabularity: Kusto.Language.Symbols.Tabularity;
        /**
         * True if the symbol is scalar or unknown.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function IsScalar
         * @type boolean
         */
        IsScalar: boolean;
        /**
         * True if the symbol is tabular or unknown.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function IsTabular
         * @type boolean
         */
        IsTabular: boolean;
        /**
         * A description of the symbol.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function Display
         * @type string
         */
        Display: string | null;
        /**
         * All the symbols contained by this symbol.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Symbols.Symbol
         * @function Members
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        Members: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.Symbol> | null;
        /**
         * Gets all the matching members.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Symbol
         * @memberof Kusto.Language.Symbols.Symbol
         * @param   {string}                                name          
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match         
         * @param   {System.Collections.Generic.List$1}     symbols       
         * @param   {boolean}                               ignoreCase
         * @return  {void}
         */
        GetMembers$1(name: string | null, match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null, ignoreCase?: boolean): void;
        /**
         * Gets all the matching members.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Symbol
         * @memberof Kusto.Language.Symbols.Symbol
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match         
         * @param   {System.Collections.Generic.List$1}     symbols       
         * @param   {boolean}                               ignoreCase
         * @return  {void}
         */
        GetMembers(match: Kusto.Language.Symbols.SymbolMatch, symbols: System.Collections.Generic.List$1<Kusto.Language.Symbols.Symbol> | null, ignoreCase?: boolean): void;
        /**
         * Returns the first member that matches or null.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.Symbol
         * @memberof Kusto.Language.Symbols.Symbol
         * @param   {string}                                name          
         * @param   {Kusto.Language.Symbols.SymbolMatch}    match         
         * @param   {boolean}                               ignoreCase
         * @return  {Kusto.Language.Symbols.Symbol}
         */
        GetFirstMember(name: string | null, match?: Kusto.Language.Symbols.SymbolMatch, ignoreCase?: boolean): Kusto.Language.Symbols.Symbol | null;
    }
    interface SymbolFunc extends Function {
        prototype: Symbol;
        /**
         * Determines the result type of an expression that references the specified symbol
         *
         * @static
         * @public
         * @this Kusto.Language.Symbols.Symbol
         * @memberof Kusto.Language.Symbols.Symbol
         * @param   {Kusto.Language.Symbols.Symbol}        symbol
         * @return  {Kusto.Language.Symbols.TypeSymbol}
         */
        GetExpressionResultType(symbol: Kusto.Language.Symbols.Symbol | null): Kusto.Language.Symbols.TypeSymbol | null;
    }
    var Symbol: SymbolFunc;

    interface MaterializedViewSymbol extends Kusto.Language.Symbols.TableSymbol {
        MaterializedViewQuery: string | null;
        MaterializedViewKind: Kusto.Language.Symbols.MaterializedViewKind;
    }
    interface MaterializedViewSymbolFunc extends Function {
        prototype: MaterializedViewSymbol;
        new (name: string | null, columns: System.Collections.Generic.IEnumerable$1<Kusto.Language.Symbols.ColumnSymbol> | null, mvQuery: string | null, description: string | null): MaterializedViewSymbol;
    }
    var MaterializedViewSymbol: MaterializedViewSymbolFunc;

    interface ParameterLayout {
        /**
         * Gets the parameters corresponding to the set of argument types for the specified signature.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ParameterLayout
         * @memberof Kusto.Language.Symbols.ParameterLayout
         * @param   {Kusto.Language.Symbols.Signature}              signature             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    argumentTypes         
         * @param   {System.Collections.Generic.List$1}             argumentParameters
         * @return  {void}
         */
        GetArgumentParameters(signature: Kusto.Language.Symbols.Signature | null, argumentTypes: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Symbols.TypeSymbol> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        /**
         * Gets the set of possible parameters for an argument that would follow after the specified set of existing arguments.
         *
         * @instance
         * @public
         * @this Kusto.Language.Symbols.ParameterLayout
         * @memberof Kusto.Language.Symbols.ParameterLayout
         * @param   {Kusto.Language.Symbols.Signature}              signature             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.List$1}             possibleParameters
         * @return  {void}
         */
        GetNextPossibleParameters(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, possibleParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
        IsValidArgumentCount(signature: Kusto.Language.Symbols.Signature | null, argumentCount: number): boolean;
        /**
         * Gets the parameters that correspond to the set of arguments for the specified signature.
         *
         * @instance
         * @abstract
         * @public
         * @this Kusto.Language.Symbols.ParameterLayout
         * @memberof Kusto.Language.Symbols.ParameterLayout
         * @param   {Kusto.Language.Symbols.Signature}              signature             
         * @param   {System.Collections.Generic.IReadOnlyList$1}    arguments             
         * @param   {System.Collections.Generic.List$1}             argumentParameters
         * @return  {void}
         */
        GetArgumentParameters$1(signature: Kusto.Language.Symbols.Signature | null, $arguments: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.Expression> | null, argumentParameters: System.Collections.Generic.List$1<Kusto.Language.Symbols.Parameter> | null): void;
    }
    interface ParameterLayoutFunc extends Function {
        prototype: ParameterLayout;
        new (): ParameterLayout;
    }
    var ParameterLayout: ParameterLayoutFunc;

}

declare namespace Kusto.Language.Syntax {
    /** @namespace Kusto.Language.Syntax */

    /**
     * A node in the Kusto syntax that represents the toscalar operation.
     *
     * @public
     * @class Kusto.Language.Syntax.ToScalarExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface ToScalarExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ToScalar: Kusto.Language.Syntax.SyntaxToken | null;
        KindParameter: Kusto.Language.Syntax.NamedParameter | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ToScalarExpressionFunc extends Function {
        prototype: ToScalarExpression;
    }
    var ToScalarExpression: ToScalarExpressionFunc;

    interface TopNestedWithOthersClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OthersKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Equal: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopNestedWithOthersClauseFunc extends Function {
        prototype: TopNestedWithOthersClause;
    }
    var TopNestedWithOthersClause: TopNestedWithOthersClauseFunc;

    interface TopNestedClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        TopNestedKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        OfKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OfExpression: Kusto.Language.Syntax.Expression | null;
        WithOthersClause: Kusto.Language.Syntax.TopNestedWithOthersClause | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ByExpression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopNestedClauseFunc extends Function {
        prototype: TopNestedClause;
    }
    var TopNestedClause: TopNestedClauseFunc;

    interface TopHittersByClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopHittersByClauseFunc extends Function {
        prototype: TopHittersByClause;
    }
    var TopHittersByClause: TopHittersByClauseFunc;

    /**
     * A node in the kusto syntax that represents a single identifier name.
     *
     * @public
     * @class Kusto.Language.Syntax.TokenName
     * @augments Kusto.Language.Syntax.Name
     */
    interface TokenName extends Kusto.Language.Syntax.Name {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The token that is the name.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.TokenName
         * @function Name
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Name: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        SimpleName: string | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TokenNameFunc extends Function {
        prototype: TokenName;
    }
    var TokenName: TokenNameFunc;

    /**
     * A list of {@link }'s.
     *
     * @public
     * @class Kusto.Language.Syntax.SyntaxList$1
     * @augments Kusto.Language.Syntax.SyntaxList
     * @implements  System.Collections.Generic.IReadOnlyList$1
     */
    interface SyntaxList$1<TElement> extends Kusto.Language.Syntax.SyntaxList,System.Collections.Generic.IReadOnlyList$1<TElement> {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ElementType: System.Type | null;
        /**
         * Gets the element at the index.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxList$1
         * @memberof Kusto.Language.Syntax.SyntaxList$1
         * @param   {number}      index
         * @return  {TElement}
         */
        getItem$1(index: number): TElement;
        GetEnumerator$1(): System.Collections.Generic.IEnumerator$1<TElement> | null;
        /**
         * Creates a copy of this {@link }
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxList$1
         * @memberof Kusto.Language.Syntax.SyntaxList$1
         * @param   {boolean}                               includeDiagnostics
         * @return  {Kusto.Language.Syntax.SyntaxList$1}
         */
        Clone$2(includeDiagnostics?: boolean): Kusto.Language.Syntax.SyntaxList$1<TElement> | null;
    }
    interface SyntaxList$1Func extends Function {
        <TElement>($TElement: Bridge.TypeRef<TElement>): {
            prototype: SyntaxList$1<TElement>;
            $ctor1: {
                new (elements: System.Collections.Generic.IEnumerable$1<TElement> | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): SyntaxList$1<TElement>
            };
            ctor: {
                new (elements: TElement[] | null): SyntaxList$1<TElement>
            };
            Empty(): Kusto.Language.Syntax.SyntaxList$1<TElement> | null;
        }
    }
    var SyntaxList$1: SyntaxList$1Func;

    /**
     * A node in the kusto syntax that represents an expression comprised of a single token.
     *
     * @public
     * @class Kusto.Language.Syntax.StarExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface StarExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.StarExpression
         * @function AsteriskToken
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        AsteriskToken: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface StarExpressionFunc extends Function {
        prototype: StarExpression;
    }
    var StarExpression: StarExpressionFunc;

    interface SetOptionStatement extends Kusto.Language.Syntax.Statement {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SetKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        ValueClause: Kusto.Language.Syntax.OptionValueClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SetOptionStatementFunc extends Function {
        prototype: SetOptionStatement;
    }
    var SetOptionStatement: SetOptionStatementFunc;

    /**
     * An element in a list with an optional separator token.
     *
     * @public
     * @class Kusto.Language.Syntax.SeparatedElement$1
     * @augments Kusto.Language.Syntax.SeparatedElement
     */
    interface SeparatedElement$1<TElement> extends Kusto.Language.Syntax.SeparatedElement {
        /**
         * The element in a list
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SeparatedElement$1
         * @function Element$1
         * @type TElement
         */
        Element$1: TElement | null;
    }
    interface SeparatedElement$1Func extends Function {
        <TElement>($TElement: Bridge.TypeRef<TElement>): {
            prototype: SeparatedElement$1<TElement>;
            new (element: TElement | null, separator: Kusto.Language.Syntax.SyntaxToken | null): SeparatedElement$1<TElement>;
            Empty(): Kusto.Language.Syntax.SeparatedElement$1<TElement> | null;
        }
    }
    var SeparatedElement$1: SeparatedElement$1Func;

    interface RestrictStatement extends Kusto.Language.Syntax.Statement {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        RestrictKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        AccessKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ToKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface RestrictStatementFunc extends Function {
        prototype: RestrictStatement;
    }
    var RestrictStatement: RestrictStatementFunc;

    interface RenderWithClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Properties: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.NamedParameter>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface RenderWithClauseFunc extends Function {
        prototype: RenderWithClause;
    }
    var RenderWithClause: RenderWithClauseFunc;

    /**
     * A node in the kusto syntax that represents a has_all expression.
     *
     * @public
     * @class Kusto.Language.Syntax.HasAllExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface HasAllExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The left side expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAllExpression
         * @function Left
         * @type Kusto.Language.Syntax.Expression
         */
        Left: Kusto.Language.Syntax.Expression | null;
        /**
         * The has_all keyword.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAllExpression
         * @function Operator
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Operator: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The list of expressions.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAllExpression
         * @function Right
         * @type Kusto.Language.Syntax.ExpressionList
         */
        Right: Kusto.Language.Syntax.ExpressionList | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface HasAllExpressionFunc extends Function {
        prototype: HasAllExpression;
    }
    var HasAllExpression: HasAllExpressionFunc;

    /**
     * A node in the kusto syntax that represents a has_any expression.
     *
     * @public
     * @class Kusto.Language.Syntax.HasAnyExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface HasAnyExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The left side expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAnyExpression
         * @function Left
         * @type Kusto.Language.Syntax.Expression
         */
        Left: Kusto.Language.Syntax.Expression | null;
        /**
         * The has_any keyword.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAnyExpression
         * @function Operator
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Operator: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The list of expressions.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.HasAnyExpression
         * @function Right
         * @type Kusto.Language.Syntax.ExpressionList
         */
        Right: Kusto.Language.Syntax.ExpressionList | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface HasAnyExpressionFunc extends Function {
        prototype: HasAnyExpression;
    }
    var HasAnyExpression: HasAnyExpressionFunc;

    /**
     * A node in the kusto syntax that represents an in expression.
     *
     * @public
     * @class Kusto.Language.Syntax.InExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface InExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The left side expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.InExpression
         * @function Left
         * @type Kusto.Language.Syntax.Expression
         */
        Left: Kusto.Language.Syntax.Expression | null;
        /**
         * The in or !in keyword.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.InExpression
         * @function Operator
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Operator: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The list of expressions.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.InExpression
         * @function Right
         * @type Kusto.Language.Syntax.ExpressionList
         */
        Right: Kusto.Language.Syntax.ExpressionList | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface InExpressionFunc extends Function {
        prototype: InExpression;
    }
    var InExpression: InExpressionFunc;

    interface SummarizeByClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        BinClause: Kusto.Language.Syntax.NamedExpression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SummarizeByClauseFunc extends Function {
        prototype: SummarizeByClause;
    }
    var SummarizeByClause: SummarizeByClauseFunc;

    interface PartitionOperand extends Kusto.Language.Syntax.Expression {
    }
    interface PartitionOperandFunc extends Function {
        prototype: PartitionOperand;
    }
    var PartitionOperand: PartitionOperandFunc;

    /**
     * A node in the Kusto syntax that represents the totable operation.
     *
     * @public
     * @class Kusto.Language.Syntax.ToTableExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface ToTableExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ToTable: Kusto.Language.Syntax.SyntaxToken | null;
        KindParameter: Kusto.Language.Syntax.NamedParameter | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ToTableExpressionFunc extends Function {
        prototype: ToTableExpression;
    }
    var ToTableExpression: ToTableExpressionFunc;

    interface JoinConditionClause extends Kusto.Language.Syntax.Clause {
    }
    interface JoinConditionClauseFunc extends Function {
        prototype: JoinConditionClause;
    }
    var JoinConditionClause: JoinConditionClauseFunc;

    interface PatternStatement extends Kusto.Language.Syntax.Statement {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DeclareKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        PatternKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        Pattern: Kusto.Language.Syntax.PatternDeclaration | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PatternStatementFunc extends Function {
        prototype: PatternStatement;
    }
    var PatternStatement: PatternStatementFunc;

    interface PatternDeclaration extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.NameAndTypeDeclaration>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        PathParameter: Kusto.Language.Syntax.PatternPathParameter | null;
        OpenBrace: Kusto.Language.Syntax.SyntaxToken | null;
        Patterns: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.PatternMatch> | null;
        CloseBrace: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PatternDeclarationFunc extends Function {
        prototype: PatternDeclaration;
    }
    var PatternDeclaration: PatternDeclarationFunc;

    interface MvApplyRowLimitClause extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        LimitKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        RowLimit: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvApplyRowLimitClauseFunc extends Function {
        prototype: MvApplyRowLimitClause;
    }
    var MvApplyRowLimitClause: MvApplyRowLimitClauseFunc;

    interface MvApplySubqueryExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvApplySubqueryExpressionFunc extends Function {
        prototype: MvApplySubqueryExpression;
    }
    var MvApplySubqueryExpression: MvApplySubqueryExpressionFunc;

    interface MvExpandExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        ToTypeOf: Kusto.Language.Syntax.ToTypeOfClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvExpandExpressionFunc extends Function {
        prototype: MvExpandExpression;
    }
    var MvExpandExpression: MvExpandExpressionFunc;

    interface MvExpandRowLimitClause extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        LimitKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        RowLimit: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvExpandRowLimitClauseFunc extends Function {
        prototype: MvExpandRowLimitClause;
    }
    var MvExpandRowLimitClause: MvExpandRowLimitClauseFunc;

    interface NameAndTypeDeclaration extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        Colon: Kusto.Language.Syntax.SyntaxToken | null;
        Type: Kusto.Language.Syntax.TypeExpression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface NameAndTypeDeclarationFunc extends Function {
        prototype: NameAndTypeDeclaration;
    }
    var NameAndTypeDeclaration: NameAndTypeDeclarationFunc;

    /**
     * A node in the Kusto syntax that represents a name declaration.
     *
     * @public
     * @class Kusto.Language.Syntax.NameDeclaration
     * @augments Kusto.Language.Syntax.Expression
     */
    interface NameDeclaration extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The table name
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.NameDeclaration
         * @function Name
         * @type Kusto.Language.Syntax.Name
         */
        Name: Kusto.Language.Syntax.Name | null;
        ChildCount: number;
        SimpleName: string | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface NameDeclarationFunc extends Function {
        prototype: NameDeclaration;
        $ctor1: {
            new (nameToken: Kusto.Language.Syntax.SyntaxToken | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): NameDeclaration
        };
    }
    var NameDeclaration: NameDeclarationFunc;

    interface NameEqualsClause extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface NameEqualsClauseFunc extends Function {
        prototype: NameEqualsClause;
    }
    var NameEqualsClause: NameEqualsClauseFunc;

    /**
     * A node in the Kusto syntax that represents a name reference.
     *
     * @public
     * @class Kusto.Language.Syntax.NameReference
     * @augments Kusto.Language.Syntax.Expression
     */
    interface NameReference extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The table name
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.NameReference
         * @function Name
         * @type Kusto.Language.Syntax.Name
         */
        Name: Kusto.Language.Syntax.Name | null;
        Match: Kusto.Language.Symbols.SymbolMatch;
        ChildCount: number;
        SimpleName: string | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface NameReferenceFunc extends Function {
        prototype: NameReference;
        $ctor1: {
            new (name: Kusto.Language.Syntax.Name | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): NameReference
        };
        $ctor2: {
            new (nameToken: Kusto.Language.Syntax.SyntaxToken | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): NameReference
        };
    }
    var NameReference: NameReferenceFunc;

    interface NameReferenceList extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Names: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.NameReference>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface NameReferenceListFunc extends Function {
        prototype: NameReferenceList;
    }
    var NameReferenceList: NameReferenceListFunc;

    interface OptionValueClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Equal: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface OptionValueClauseFunc extends Function {
        prototype: OptionValueClause;
    }
    var OptionValueClause: OptionValueClauseFunc;

    interface OrderedExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        Ordering: Kusto.Language.Syntax.OrderingClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface OrderedExpressionFunc extends Function {
        prototype: OrderedExpression;
    }
    var OrderedExpression: OrderedExpressionFunc;

    interface PackExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        PackKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        AsteriskToken: Kusto.Language.Syntax.SyntaxToken | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PackExpressionFunc extends Function {
        prototype: PackExpression;
    }
    var PackExpression: PackExpressionFunc;

    /**
     * A node in the kusto syntax that represents a parenthesized expression.
     *
     * @public
     * @class Kusto.Language.Syntax.ParenthesizedExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface ParenthesizedExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The open parenthesis token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ParenthesizedExpression
         * @function OpenParen
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The parenthesized expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ParenthesizedExpression
         * @function Expression
         * @type Kusto.Language.Syntax.Expression
         */
        Expression: Kusto.Language.Syntax.Expression | null;
        /**
         * The close parenthesis token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ParenthesizedExpression
         * @function CloseParen
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ParenthesizedExpressionFunc extends Function {
        prototype: ParenthesizedExpression;
    }
    var ParenthesizedExpression: ParenthesizedExpressionFunc;

    interface PipeExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        Bar: Kusto.Language.Syntax.SyntaxToken | null;
        Operator: Kusto.Language.Syntax.QueryOperator | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PipeExpressionFunc extends Function {
        prototype: PipeExpression;
    }
    var PipeExpression: PipeExpressionFunc;

    interface PathExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        Dot: Kusto.Language.Syntax.SyntaxToken | null;
        Selector: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PathExpressionFunc extends Function {
        prototype: PathExpression;
    }
    var PathExpression: PathExpressionFunc;

    /**
     * A node in the kusto syntax that represents a prefix unary expression.
     *
     * @public
     * @class Kusto.Language.Syntax.PrefixUnaryExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface PrefixUnaryExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The operator token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.PrefixUnaryExpression
         * @function Operator
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Operator: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.PrefixUnaryExpression
         * @function Expression
         * @type Kusto.Language.Syntax.Expression
         */
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PrefixUnaryExpressionFunc extends Function {
        prototype: PrefixUnaryExpression;
    }
    var PrefixUnaryExpression: PrefixUnaryExpressionFunc;

    interface QueryParametersStatement extends Kusto.Language.Syntax.Statement {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DeclareKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        QueryParametersKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.FunctionParameter>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface QueryParametersStatementFunc extends Function {
        prototype: QueryParametersStatement;
    }
    var QueryParametersStatement: QueryParametersStatementFunc;

    /**
     * A node in the Kusto syntax that represents a json expression
     *
     * @abstract
     * @public
     * @class Kusto.Language.Syntax.JsonExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface JsonExpression extends Kusto.Language.Syntax.Expression {
    }
    interface JsonExpressionFunc extends Function {
        prototype: JsonExpression;
    }
    var JsonExpression: JsonExpressionFunc;

    interface LetStatement extends Kusto.Language.Syntax.Statement {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        LetKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        Equal: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface LetStatementFunc extends Function {
        prototype: LetStatement;
    }
    var LetStatement: LetStatementFunc;

    /**
     * A node in the kusto syntax that represents a literal expression.
     *
     * @public
     * @class Kusto.Language.Syntax.LiteralExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface LiteralExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The token with the literal value.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.LiteralExpression
         * @function Token
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Token: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        IsLiteral: boolean;
        LiteralValue: any | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface LiteralExpressionFunc extends Function {
        prototype: LiteralExpression;
    }
    var LiteralExpression: LiteralExpressionFunc;

    interface MakeSeriesByClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesByClauseFunc extends Function {
        prototype: MakeSeriesByClause;
    }
    var MakeSeriesByClause: MakeSeriesByClauseFunc;

    interface MakeSeriesExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        DefaultExpression: Kusto.Language.Syntax.DefaultExpressionClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesExpressionFunc extends Function {
        prototype: MakeSeriesExpression;
    }
    var MakeSeriesExpression: MakeSeriesExpressionFunc;

    interface MakeSeriesFromClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        FromKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesFromClauseFunc extends Function {
        prototype: MakeSeriesFromClause;
    }
    var MakeSeriesFromClause: MakeSeriesFromClauseFunc;

    interface MakeSeriesRangeClause extends Kusto.Language.Syntax.Clause {
    }
    interface MakeSeriesRangeClauseFunc extends Function {
        prototype: MakeSeriesRangeClause;
    }
    var MakeSeriesRangeClause: MakeSeriesRangeClauseFunc;

    interface MakeSeriesOnClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OnKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesOnClauseFunc extends Function {
        prototype: MakeSeriesOnClause;
    }
    var MakeSeriesOnClause: MakeSeriesOnClauseFunc;

    interface MakeSeriesStepClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        StepKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesStepClauseFunc extends Function {
        prototype: MakeSeriesStepClause;
    }
    var MakeSeriesStepClause: MakeSeriesStepClauseFunc;

    interface MakeSeriesToClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ToKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesToClauseFunc extends Function {
        prototype: MakeSeriesToClause;
    }
    var MakeSeriesToClause: MakeSeriesToClauseFunc;

    /**
     * A node in the Kusto syntax that represents the materilized-view-combine expression.
     *
     * @public
     * @class Kusto.Language.Syntax.MaterializedViewCombineExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface MaterializedViewCombineExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MaterializedViewCombineKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ViewName: Kusto.Language.Syntax.MaterializedViewCombineNameClause | null;
        BaseClause: Kusto.Language.Syntax.MaterializedViewCombineClause | null;
        DeltaClause: Kusto.Language.Syntax.MaterializedViewCombineClause | null;
        AggregationsClause: Kusto.Language.Syntax.MaterializedViewCombineClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MaterializedViewCombineExpressionFunc extends Function {
        prototype: MaterializedViewCombineExpression;
    }
    var MaterializedViewCombineExpression: MaterializedViewCombineExpressionFunc;

    interface MaterializeExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MaterializeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MaterializeExpressionFunc extends Function {
        prototype: MaterializeExpression;
    }
    var MaterializeExpression: MaterializeExpressionFunc;

    interface MvApplyContextIdClause extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        IdKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Id: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvApplyContextIdClauseFunc extends Function {
        prototype: MvApplyContextIdClause;
    }
    var MvApplyContextIdClause: MvApplyContextIdClauseFunc;

    interface MvApplyExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Expression: Kusto.Language.Syntax.Expression | null;
        ToTypeOf: Kusto.Language.Syntax.ToTypeOfClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvApplyExpressionFunc extends Function {
        prototype: MvApplyExpression;
    }
    var MvApplyExpression: MvApplyExpressionFunc;

    interface ReduceByWithClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.NamedParameter>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ReduceByWithClauseFunc extends Function {
        prototype: ReduceByWithClause;
    }
    var ReduceByWithClause: ReduceByWithClauseFunc;

    interface TypeExpression extends Kusto.Language.Syntax.Expression {
    }
    interface TypeExpressionFunc extends Function {
        prototype: TypeExpression;
    }
    var TypeExpression: TypeExpressionFunc;

    interface TypedColumnReference extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Column: Kusto.Language.Syntax.NameReference | null;
        ColonToken: Kusto.Language.Syntax.SyntaxToken | null;
        Type: Kusto.Language.Syntax.TypeExpression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TypedColumnReferenceFunc extends Function {
        prototype: TypedColumnReference;
    }
    var TypedColumnReference: TypedColumnReferenceFunc;

    interface MakeSeriesInRangeClause extends Kusto.Language.Syntax.MakeSeriesRangeClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        InKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        RangeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Arguments: Kusto.Language.Syntax.ExpressionList | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesInRangeClauseFunc extends Function {
        prototype: MakeSeriesInRangeClause;
    }
    var MakeSeriesInRangeClause: MakeSeriesInRangeClauseFunc;

    interface WildcardedName extends Kusto.Language.Syntax.Name {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Pattern: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        SimpleName: string | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface WildcardedNameFunc extends Function {
        prototype: WildcardedName;
    }
    var WildcardedName: WildcardedNameFunc;

    interface ParseOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ParseKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Patterns: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SyntaxNode> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ParseOperatorFunc extends Function {
        prototype: ParseOperator;
    }
    var ParseOperator: ParseOperatorFunc;

    interface ParseWhereOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ParseKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Patterns: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SyntaxNode> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ParseWhereOperatorFunc extends Function {
        prototype: ParseWhereOperator;
    }
    var ParseWhereOperator: ParseWhereOperatorFunc;

    interface PartitionOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        PartitionKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ByExpression: Kusto.Language.Syntax.Expression | null;
        Operand: Kusto.Language.Syntax.PartitionOperand | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PartitionOperatorFunc extends Function {
        prototype: PartitionOperator;
    }
    var PartitionOperator: PartitionOperatorFunc;

    interface PartitionQuery extends Kusto.Language.Syntax.PartitionOperand {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenBrace: Kusto.Language.Syntax.SyntaxToken | null;
        Query: Kusto.Language.Syntax.Expression | null;
        CloseBrace: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PartitionQueryFunc extends Function {
        prototype: PartitionQuery;
    }
    var PartitionQuery: PartitionQueryFunc;

    interface PartitionSubquery extends Kusto.Language.Syntax.PartitionOperand {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Scope: Kusto.Language.Syntax.PartitionScope | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Subquery: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PartitionSubqueryFunc extends Function {
        prototype: PartitionSubquery;
    }
    var PartitionSubquery: PartitionSubqueryFunc;

    interface PrimitiveTypeExpression extends Kusto.Language.Syntax.TypeExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Type: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PrimitiveTypeExpressionFunc extends Function {
        prototype: PrimitiveTypeExpression;
    }
    var PrimitiveTypeExpression: PrimitiveTypeExpressionFunc;

    interface PrintOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        PrintKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PrintOperatorFunc extends Function {
        prototype: PrintOperator;
    }
    var PrintOperator: PrintOperatorFunc;

    interface ProjectAwayOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectAwayKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ProjectAwayOperatorFunc extends Function {
        prototype: ProjectAwayOperator;
    }
    var ProjectAwayOperator: ProjectAwayOperatorFunc;

    interface ProjectKeepOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectKeepKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ProjectKeepOperatorFunc extends Function {
        prototype: ProjectKeepOperator;
    }
    var ProjectKeepOperator: ProjectKeepOperatorFunc;

    interface ProjectOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ProjectOperatorFunc extends Function {
        prototype: ProjectOperator;
    }
    var ProjectOperator: ProjectOperatorFunc;

    interface ProjectRenameOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectRenameKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ProjectRenameOperatorFunc extends Function {
        prototype: ProjectRenameOperator;
    }
    var ProjectRenameOperator: ProjectRenameOperatorFunc;

    interface ProjectReorderOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectReorderKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ProjectReorderOperatorFunc extends Function {
        prototype: ProjectReorderOperator;
    }
    var ProjectReorderOperator: ProjectReorderOperatorFunc;

    interface RangeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        RangeToken: Kusto.Language.Syntax.SyntaxToken | null;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        FromToken: Kusto.Language.Syntax.SyntaxToken | null;
        From: Kusto.Language.Syntax.Expression | null;
        ToToken: Kusto.Language.Syntax.SyntaxToken | null;
        To: Kusto.Language.Syntax.Expression | null;
        StepToken: Kusto.Language.Syntax.SyntaxToken | null;
        Step: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface RangeOperatorFunc extends Function {
        prototype: RangeOperator;
    }
    var RangeOperator: RangeOperatorFunc;

    interface MvExpandOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MvExpandKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.MvExpandExpression>> | null;
        RowLimitClause: Kusto.Language.Syntax.MvExpandRowLimitClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvExpandOperatorFunc extends Function {
        prototype: MvExpandOperator;
    }
    var MvExpandOperator: MvExpandOperatorFunc;

    interface ReduceByOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ReduceKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        With: Kusto.Language.Syntax.ReduceByWithClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ReduceByOperatorFunc extends Function {
        prototype: ReduceByOperator;
    }
    var ReduceByOperator: ReduceByOperatorFunc;

    interface SampleDistinctOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SampleDistinctKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        OfKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OfExpression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SampleDistinctOperatorFunc extends Function {
        prototype: SampleDistinctOperator;
    }
    var SampleDistinctOperator: SampleDistinctOperatorFunc;

    interface SampleOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SampleKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SampleOperatorFunc extends Function {
        prototype: SampleOperator;
    }
    var SampleOperator: SampleOperatorFunc;

    interface ScanOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ScanKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        OrderByClause: Kusto.Language.Syntax.ScanOrderByClause | null;
        PartitionByClause: Kusto.Language.Syntax.ScanPartitionByClause | null;
        DeclareClause: Kusto.Language.Syntax.ScanDeclareClause | null;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParenToken: Kusto.Language.Syntax.SyntaxToken | null;
        Steps: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.ScanStep> | null;
        CloseParenToken: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ScanOperatorFunc extends Function {
        prototype: ScanOperator;
    }
    var ScanOperator: ScanOperatorFunc;

    interface SchemaTypeExpression extends Kusto.Language.Syntax.TypeExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Columns: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SchemaTypeExpressionFunc extends Function {
        prototype: SchemaTypeExpression;
    }
    var SchemaTypeExpression: SchemaTypeExpressionFunc;

    interface SearchOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SearchKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        DataScope: Kusto.Language.Syntax.DataScopeClause | null;
        InClause: Kusto.Language.Syntax.FindInClause | null;
        Condition: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SearchOperatorFunc extends Function {
        prototype: SearchOperator;
    }
    var SearchOperator: SearchOperatorFunc;

    interface SerializeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SerializeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SerializeOperatorFunc extends Function {
        prototype: SerializeOperator;
    }
    var SerializeOperator: SerializeOperatorFunc;

    /**
     * A node in the kusto syntax that represents a named expression.
     *
     * @public
     * @class Kusto.Language.Syntax.SimpleNamedExpression
     * @augments Kusto.Language.Syntax.NamedExpression
     */
    interface SimpleNamedExpression extends Kusto.Language.Syntax.NamedExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The name of the expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SimpleNamedExpression
         * @function Name
         * @type Kusto.Language.Syntax.NameDeclaration
         */
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        /**
         * The equal token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SimpleNamedExpression
         * @function EqualToken
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The named expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SimpleNamedExpression
         * @function Expression
         * @type Kusto.Language.Syntax.Expression
         */
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SimpleNamedExpressionFunc extends Function {
        prototype: SimpleNamedExpression;
    }
    var SimpleNamedExpression: SimpleNamedExpressionFunc;

    interface SortOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Keyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SortOperatorFunc extends Function {
        prototype: SortOperator;
    }
    var SortOperator: SortOperatorFunc;

    interface SummarizeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        SummarizeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Aggregates: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ByClause: Kusto.Language.Syntax.SummarizeByClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface SummarizeOperatorFunc extends Function {
        prototype: SummarizeOperator;
    }
    var SummarizeOperator: SummarizeOperatorFunc;

    interface TakeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Keyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TakeOperatorFunc extends Function {
        prototype: TakeOperator;
    }
    var TakeOperator: TakeOperatorFunc;

    interface TopHittersOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        TopHittersKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        OfKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OfExpression: Kusto.Language.Syntax.Expression | null;
        ByClause: Kusto.Language.Syntax.TopHittersByClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopHittersOperatorFunc extends Function {
        prototype: TopHittersOperator;
    }
    var TopHittersOperator: TopHittersOperatorFunc;

    interface TopNestedOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Clauses: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.TopNestedClause>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopNestedOperatorFunc extends Function {
        prototype: TopNestedOperator;
    }
    var TopNestedOperator: TopNestedOperatorFunc;

    interface TopOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        TopKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ByExpression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TopOperatorFunc extends Function {
        prototype: TopOperator;
    }
    var TopOperator: TopOperatorFunc;

    interface RenderOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        RenderKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ChartType: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        WithClause: Kusto.Language.Syntax.RenderWithClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface RenderOperatorFunc extends Function {
        prototype: RenderOperator;
    }
    var RenderOperator: RenderOperatorFunc;

    /**
     * A node in the Kusto syntax that represents a typeof expression
     *
     * @public
     * @class Kusto.Language.Syntax.TypeOfLiteralExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface TypeOfLiteralExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        TypeOfKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Types: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        IsLiteral: boolean;
        LiteralValue: any | null;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface TypeOfLiteralExpressionFunc extends Function {
        prototype: TypeOfLiteralExpression;
    }
    var TypeOfLiteralExpression: TypeOfLiteralExpressionFunc;

    interface MvApplyOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MvApplyKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.MvApplyExpression>> | null;
        RowLimitClause: Kusto.Language.Syntax.MvApplyRowLimitClause | null;
        ContextIdClause: Kusto.Language.Syntax.MvApplyContextIdClause | null;
        OnKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Subquery: Kusto.Language.Syntax.MvApplySubqueryExpression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MvApplyOperatorFunc extends Function {
        prototype: MvApplyOperator;
    }
    var MvApplyOperator: MvApplyOperatorFunc;

    interface FunctionDeclaration extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ViewKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.FunctionParameters | null;
        Body: Kusto.Language.Syntax.FunctionBody | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FunctionDeclarationFunc extends Function {
        prototype: FunctionDeclaration;
    }
    var FunctionDeclaration: FunctionDeclarationFunc;

    interface AsOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        AsKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface AsOperatorFunc extends Function {
        prototype: AsOperator;
    }
    var AsOperator: AsOperatorFunc;

    interface BadCommand extends Kusto.Language.Syntax.Command {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DotToken: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface BadCommandFunc extends Function {
        prototype: BadCommand;
    }
    var BadCommand: BadCommandFunc;

    interface BadQueryOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Keyword: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface BadQueryOperatorFunc extends Function {
        prototype: BadQueryOperator;
    }
    var BadQueryOperator: BadQueryOperatorFunc;

    interface CommandWithPropertyListClause extends Kusto.Language.Syntax.CommandWithClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Properties: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.NamedParameter>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CommandWithPropertyListClauseFunc extends Function {
        prototype: CommandWithPropertyListClause;
    }
    var CommandWithPropertyListClause: CommandWithPropertyListClauseFunc;

    interface CommandWithValueClause extends Kusto.Language.Syntax.CommandWithClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Value: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CommandWithValueClauseFunc extends Function {
        prototype: CommandWithValueClause;
    }
    var CommandWithValueClause: CommandWithValueClauseFunc;

    /**
     * A node in the kusto syntax that represents a compound named expression.
     *
     * @public
     * @class Kusto.Language.Syntax.CompoundNamedExpression
     * @augments Kusto.Language.Syntax.NamedExpression
     */
    interface CompoundNamedExpression extends Kusto.Language.Syntax.NamedExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The set of names or keywords.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.CompoundNamedExpression
         * @function Names
         * @type Kusto.Language.Syntax.RenameList
         */
        Names: Kusto.Language.Syntax.RenameList | null;
        /**
         * The equal token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.CompoundNamedExpression
         * @function EqualToken
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The named expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.CompoundNamedExpression
         * @function Expression
         * @type Kusto.Language.Syntax.Expression
         */
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CompoundNamedExpressionFunc extends Function {
        prototype: CompoundNamedExpression;
    }
    var CompoundNamedExpression: CompoundNamedExpressionFunc;

    interface ConsumeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ConsumeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ConsumeOperatorFunc extends Function {
        prototype: ConsumeOperator;
    }
    var ConsumeOperator: ConsumeOperatorFunc;

    interface CountOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        CountKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        AsIdentifier: Kusto.Language.Syntax.CountAsIdentifierClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CountOperatorFunc extends Function {
        prototype: CountOperator;
    }
    var CountOperator: CountOperatorFunc;

    interface CustomCommand extends Kusto.Language.Syntax.Command {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        CommandKind: string | null;
        DotToken: Kusto.Language.Syntax.SyntaxToken | null;
        Custom: Kusto.Language.Syntax.SyntaxElement | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CustomCommandFunc extends Function {
        prototype: CustomCommand;
    }
    var CustomCommand: CustomCommandFunc;

    interface DistinctOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DistinctKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface DistinctOperatorFunc extends Function {
        prototype: DistinctOperator;
    }
    var DistinctOperator: DistinctOperatorFunc;

    interface EvaluateOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        EvaluateKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        FunctionCall: Kusto.Language.Syntax.FunctionCallExpression | null;
        Schema: Kusto.Language.Syntax.EvaluateSchemaClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface EvaluateOperatorFunc extends Function {
        prototype: EvaluateOperator;
    }
    var EvaluateOperator: EvaluateOperatorFunc;

    interface ExecuteAndCacheOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ExecuteAndCacheKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ExecuteAndCacheOperatorFunc extends Function {
        prototype: ExecuteAndCacheOperator;
    }
    var ExecuteAndCacheOperator: ExecuteAndCacheOperatorFunc;

    interface ExtendOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ExtendKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ExtendOperatorFunc extends Function {
        prototype: ExtendOperator;
    }
    var ExtendOperator: ExtendOperatorFunc;

    interface MakeSeriesOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MakeSeriesKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Aggregates: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.MakeSeriesExpression>> | null;
        OnClause: Kusto.Language.Syntax.MakeSeriesOnClause | null;
        RangeClause: Kusto.Language.Syntax.MakeSeriesRangeClause | null;
        ByClause: Kusto.Language.Syntax.MakeSeriesByClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesOperatorFunc extends Function {
        prototype: MakeSeriesOperator;
    }
    var MakeSeriesOperator: MakeSeriesOperatorFunc;

    interface FacetOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        FacetKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ByKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        WithClause: Kusto.Language.Syntax.FacetWithClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FacetOperatorFunc extends Function {
        prototype: FacetOperator;
    }
    var FacetOperator: FacetOperatorFunc;

    interface FacetWithOperatorClause extends Kusto.Language.Syntax.FacetWithClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Operator: Kusto.Language.Syntax.QueryOperator | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FacetWithOperatorClauseFunc extends Function {
        prototype: FacetWithOperatorClause;
    }
    var FacetWithOperatorClause: FacetWithOperatorClauseFunc;

    interface FilterOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Keyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Condition: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FilterOperatorFunc extends Function {
        prototype: FilterOperator;
    }
    var FilterOperator: FilterOperatorFunc;

    interface FindOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        FindKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        DataScope: Kusto.Language.Syntax.DataScopeClause | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        InClause: Kusto.Language.Syntax.FindInClause | null;
        WhereKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Condition: Kusto.Language.Syntax.Expression | null;
        Project: Kusto.Language.Syntax.FindProjectClause | null;
        ProjectAway: Kusto.Language.Syntax.FindProjectClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FindOperatorFunc extends Function {
        prototype: FindOperator;
    }
    var FindOperator: FindOperatorFunc;

    interface ForkOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ForkKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.ForkExpression> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ForkOperatorFunc extends Function {
        prototype: ForkOperator;
    }
    var ForkOperator: ForkOperatorFunc;

    interface GetSchemaOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        GetSchemaKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface GetSchemaOperatorFunc extends Function {
        prototype: GetSchemaOperator;
    }
    var GetSchemaOperator: GetSchemaOperatorFunc;

    interface InvokeOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        InvokeKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Function: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface InvokeOperatorFunc extends Function {
        prototype: InvokeOperator;
    }
    var InvokeOperator: InvokeOperatorFunc;

    interface JoinOnClause extends Kusto.Language.Syntax.JoinConditionClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OnKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JoinOnClauseFunc extends Function {
        prototype: JoinOnClause;
    }
    var JoinOnClause: JoinOnClauseFunc;

    interface JoinOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        JoinKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ConditionClause: Kusto.Language.Syntax.JoinConditionClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JoinOperatorFunc extends Function {
        prototype: JoinOperator;
    }
    var JoinOperator: JoinOperatorFunc;

    interface JoinWhereClause extends Kusto.Language.Syntax.JoinConditionClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WhereKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JoinWhereClauseFunc extends Function {
        prototype: JoinWhereClause;
    }
    var JoinWhereClause: JoinWhereClauseFunc;

    /**
     * A node in the kusto syntax that represents a JSON array expression.
     *
     * @public
     * @class Kusto.Language.Syntax.JsonArrayExpression
     * @augments Kusto.Language.Syntax.JsonExpression
     */
    interface JsonArrayExpression extends Kusto.Language.Syntax.JsonExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The open bracket token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonArrayExpression
         * @function OpenBracket
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        OpenBracket: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The list of values.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonArrayExpression
         * @function Values
         * @type Kusto.Language.Syntax.SyntaxList$1
         */
        Values: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        /**
         * The close bracket token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonArrayExpression
         * @function CloseBracket
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        CloseBracket: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JsonArrayExpressionFunc extends Function {
        prototype: JsonArrayExpression;
    }
    var JsonArrayExpression: JsonArrayExpressionFunc;

    /**
     * A node in the kusto syntax that represents a JSON object expression.
     *
     * @public
     * @class Kusto.Language.Syntax.JsonObjectExpression
     * @augments Kusto.Language.Syntax.JsonExpression
     */
    interface JsonObjectExpression extends Kusto.Language.Syntax.JsonExpression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The open brace token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonObjectExpression
         * @function OpenBrace
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        OpenBrace: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The list of name value pairs.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonObjectExpression
         * @function Pairs
         * @type Kusto.Language.Syntax.SyntaxList$1
         */
        Pairs: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.JsonPair>> | null;
        /**
         * The close brace token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonObjectExpression
         * @function CloseBrace
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        CloseBrace: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JsonObjectExpressionFunc extends Function {
        prototype: JsonObjectExpression;
    }
    var JsonObjectExpression: JsonObjectExpressionFunc;

    interface LookupOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        LookupKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        LookupClause: Kusto.Language.Syntax.JoinConditionClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface LookupOperatorFunc extends Function {
        prototype: LookupOperator;
    }
    var LookupOperator: LookupOperatorFunc;

    interface MakeSeriesFromToStepClause extends Kusto.Language.Syntax.MakeSeriesRangeClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        MakeSeriesFromClause: Kusto.Language.Syntax.MakeSeriesFromClause | null;
        MakeSeriesToClause: Kusto.Language.Syntax.MakeSeriesToClause | null;
        MakeSeriesStepClause: Kusto.Language.Syntax.MakeSeriesStepClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MakeSeriesFromToStepClauseFunc extends Function {
        prototype: MakeSeriesFromToStepClause;
    }
    var MakeSeriesFromToStepClause: MakeSeriesFromToStepClauseFunc;

    interface FacetWithExpressionClause extends Kusto.Language.Syntax.FacetWithClause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        WithKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FacetWithExpressionClauseFunc extends Function {
        prototype: FacetWithExpressionClause;
    }
    var FacetWithExpressionClause: FacetWithExpressionClauseFunc;

    /**
     * A node in the kusto syntax that represents a function call expression.
     *
     * @public
     * @class Kusto.Language.Syntax.FunctionCallExpression
     * @augments Kusto.Language.Syntax.Expression
     */
    interface FunctionCallExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The name of the function call.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.FunctionCallExpression
         * @function Name
         * @type Kusto.Language.Syntax.NameReference
         */
        Name: Kusto.Language.Syntax.NameReference | null;
        /**
         * The arguments
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.FunctionCallExpression
         * @function ArgumentList
         * @type Kusto.Language.Syntax.ExpressionList
         */
        ArgumentList: Kusto.Language.Syntax.ExpressionList | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FunctionCallExpressionFunc extends Function {
        prototype: FunctionCallExpression;
    }
    var FunctionCallExpression: FunctionCallExpressionFunc;

    interface UnknownCommand extends Kusto.Language.Syntax.Command {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DotToken: Kusto.Language.Syntax.SyntaxToken | null;
        Parts: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SyntaxToken> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface UnknownCommandFunc extends Function {
        prototype: UnknownCommand;
    }
    var UnknownCommand: UnknownCommandFunc;

    interface FindProjectClause extends Kusto.Language.Syntax.Clause {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ProjectKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Columns: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FindProjectClauseFunc extends Function {
        prototype: FindProjectClause;
    }
    var FindProjectClause: FindProjectClauseFunc;

    /**
     * A node in the Kusto syntax that represents a clause
     *
     * @abstract
     * @public
     * @class Kusto.Language.Syntax.Clause
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface Clause extends Kusto.Language.Syntax.SyntaxNode {
    }
    interface ClauseFunc extends Function {
        prototype: Clause;
    }
    var Clause: ClauseFunc;

    interface CommandBlock extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Statements: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement>> | null;
        SkippedTokens: Kusto.Language.Syntax.SkippedTokens | null;
        EndOfCommand: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CommandBlockFunc extends Function {
        prototype: CommandBlock;
    }
    var CommandBlock: CommandBlockFunc;

    /**
     * A {@link } with variable shape.
     *
     * @public
     * @class Kusto.Language.Syntax.CustomNode
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface CustomNode extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        GetCompletionHint(index: number): Kusto.Language.Editor.CompletionHint;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface CustomNodeFunc extends Function {
        prototype: CustomNode;
        $ctor2: {
            new (shape: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null, elements: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.SyntaxElement> | null, diagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null): CustomNode
        };
        $ctor1: {
            new (shape: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Syntax.CustomElementDescriptor> | null, elements: Kusto.Language.Syntax.SyntaxElement[] | null): CustomNode
        };
        ctor: {
            new (elements: Kusto.Language.Syntax.SyntaxElement[] | null): CustomNode
        };
    }
    var CustomNode: CustomNodeFunc;

    interface DefaultValueDeclaration extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Equal: Kusto.Language.Syntax.SyntaxToken | null;
        Value: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface DefaultValueDeclarationFunc extends Function {
        prototype: DefaultValueDeclaration;
    }
    var DefaultValueDeclaration: DefaultValueDeclarationFunc;

    interface DirectiveBlock extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        DirectiveToken: Kusto.Language.Syntax.SyntaxToken | null;
        SkippedTokens: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SyntaxToken> | null;
        EndOfText: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface DirectiveBlockFunc extends Function {
        prototype: DirectiveBlock;
    }
    var DirectiveBlock: DirectiveBlockFunc;

    interface EvaluateSchemaClause extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ColonKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Schema: Kusto.Language.Syntax.SchemaTypeExpression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface EvaluateSchemaClauseFunc extends Function {
        prototype: EvaluateSchemaClause;
    }
    var EvaluateSchemaClause: EvaluateSchemaClauseFunc;

    /**
     * A node in the kusto syntax that represents a parenthesized pair of expressions.
     *
     * @public
     * @class Kusto.Language.Syntax.ExpressionCouple
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface ExpressionCouple extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The open parenthesis token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ExpressionCouple
         * @function OpenParen
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The first expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ExpressionCouple
         * @function First
         * @type Kusto.Language.Syntax.Expression
         */
        First: Kusto.Language.Syntax.Expression | null;
        /**
         * The .. token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ExpressionCouple
         * @function DotDot
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        DotDot: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The second expression.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ExpressionCouple
         * @function Second
         * @type Kusto.Language.Syntax.Expression
         */
        Second: Kusto.Language.Syntax.Expression | null;
        /**
         * The close parenthesis token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.ExpressionCouple
         * @function CloseParen
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ExpressionCoupleFunc extends Function {
        prototype: ExpressionCouple;
    }
    var ExpressionCouple: ExpressionCoupleFunc;

    interface ForkExpression extends Kusto.Language.Syntax.Expression {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        NameEquals: Kusto.Language.Syntax.NameEqualsClause | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface ForkExpressionFunc extends Function {
        prototype: ForkExpression;
    }
    var ForkExpression: ForkExpressionFunc;

    interface FunctionBody extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenBrace: Kusto.Language.Syntax.SyntaxToken | null;
        Statements: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Statement>> | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        Semicolon: Kusto.Language.Syntax.SyntaxToken | null;
        CloseBrace: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FunctionBodyFunc extends Function {
        prototype: FunctionBody;
    }
    var FunctionBody: FunctionBodyFunc;

    interface FunctionParameter extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        NameAndType: Kusto.Language.Syntax.NameAndTypeDeclaration | null;
        DefaultValue: Kusto.Language.Syntax.DefaultValueDeclaration | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FunctionParameterFunc extends Function {
        prototype: FunctionParameter;
    }
    var FunctionParameter: FunctionParameterFunc;

    interface FunctionParameters extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.FunctionParameter>> | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface FunctionParametersFunc extends Function {
        prototype: FunctionParameters;
    }
    var FunctionParameters: FunctionParametersFunc;

    /**
     * A node in the kusto syntax that represents a JSON scalar expression.
     *
     * @public
     * @class Kusto.Language.Syntax.JsonPair
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface JsonPair extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * The token with the name of the JSON element.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonPair
         * @function Name
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Name: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The colon token.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonPair
         * @function Colon
         * @type Kusto.Language.Syntax.SyntaxToken
         */
        Colon: Kusto.Language.Syntax.SyntaxToken | null;
        /**
         * The value of the JSON element.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.JsonPair
         * @function Value
         * @type Kusto.Language.Syntax.Expression
         */
        Value: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface JsonPairFunc extends Function {
        prototype: JsonPair;
    }
    var JsonPair: JsonPairFunc;

    /**
     * A node in the Kusto syntax that represents the materilized-view-combine clause.
     *
     * @public
     * @class Kusto.Language.Syntax.MaterializedViewCombineClause
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface MaterializedViewCombineClause extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Keyword: Kusto.Language.Syntax.SyntaxToken | null;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MaterializedViewCombineClauseFunc extends Function {
        prototype: MaterializedViewCombineClause;
    }
    var MaterializedViewCombineClause: MaterializedViewCombineClauseFunc;

    /**
     * A node in the Kusto syntax that represents the materilized-view-combine view name part.
     *
     * @public
     * @class Kusto.Language.Syntax.MaterializedViewCombineNameClause
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface MaterializedViewCombineNameClause extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenParen: Kusto.Language.Syntax.SyntaxToken | null;
        Value: Kusto.Language.Syntax.Expression | null;
        CloseParen: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface MaterializedViewCombineNameClauseFunc extends Function {
        prototype: MaterializedViewCombineNameClause;
    }
    var MaterializedViewCombineNameClause: MaterializedViewCombineNameClauseFunc;

    interface NamedParameter extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        Name: Kusto.Language.Syntax.NameDeclaration | null;
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ExpressionHint: Kusto.Language.Editor.CompletionHint;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
        GetCompletionHint(index: number): Kusto.Language.Editor.CompletionHint;
    }
    interface NamedParameterFunc extends Function {
        prototype: NamedParameter;
    }
    var NamedParameter: NamedParameterFunc;

    interface OrderingClause extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        AscOrDescKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        NullsClause: Kusto.Language.Syntax.OrderingNullsClause | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface OrderingClauseFunc extends Function {
        prototype: OrderingClause;
    }
    var OrderingClause: OrderingClauseFunc;

    interface OrderingNullsClause extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        NullsKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        FirstOrLastKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface OrderingNullsClauseFunc extends Function {
        prototype: OrderingNullsClause;
    }
    var OrderingNullsClause: OrderingNullsClauseFunc;

    interface PartitionScope extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        InKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Expression: Kusto.Language.Syntax.Expression | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PartitionScopeFunc extends Function {
        prototype: PartitionScope;
    }
    var PartitionScope: PartitionScopeFunc;

    interface PatternMatch extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        ParameterValues: Kusto.Language.Syntax.ExpressionList | null;
        PathValue: Kusto.Language.Syntax.PatternPathValue | null;
        EqualToken: Kusto.Language.Syntax.SyntaxToken | null;
        Body: Kusto.Language.Syntax.FunctionBody | null;
        SemicolonToken: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        IsOptional(index: number): boolean;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PatternMatchFunc extends Function {
        prototype: PatternMatch;
    }
    var PatternMatch: PatternMatchFunc;

    /**
     * A node in the Kusto syntax that represents a name.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Syntax.Name
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface Name extends Kusto.Language.Syntax.SyntaxNode {
        SimpleName: string | null;
    }
    interface NameFunc extends Function {
        prototype: Name;
    }
    var Name: NameFunc;

    interface PatternPathParameter extends Kusto.Language.Syntax.SyntaxNode {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        OpenBracket: Kusto.Language.Syntax.SyntaxToken | null;
        Parameter: Kusto.Language.Syntax.NameAndTypeDeclaration | null;
        CloseBracket: Kusto.Language.Syntax.SyntaxToken | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface PatternPathParameterFunc extends Function {
        prototype: PatternPathParameter;
    }
    var PatternPathParameter: PatternPathParameterFunc;

    /**
     * A node in the Kusto syntax that represents an expression
     *
     * @abstract
     * @public
     * @class Kusto.Language.Syntax.Expression
     * @augments Kusto.Language.Syntax.SyntaxNode
     */
    interface Expression extends Kusto.Language.Syntax.SyntaxNode {
        /**
         * True if the expression is a literal.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function IsLiteral
         * @type boolean
         */
        IsLiteral: boolean;
        /**
         * The value of the literal expression.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function LiteralValue
         * @type System.Object
         */
        LiteralValue: any | null;
        /**
         * The result type of the expression.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function ResultType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        ResultType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * The unadjusted result type of the expression.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function RawResultType
         * @type Kusto.Language.Symbols.TypeSymbol
         */
        RawResultType: Kusto.Language.Symbols.TypeSymbol | null;
        /**
         * True if the expression is considered constant.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function IsConstant
         * @type boolean
         */
        IsConstant: boolean;
        /**
         * The value of the constant if it is known.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.Expression
         * @function ConstantValue
         * @type System.Object
         */
        ConstantValue: any | null;
    }
    interface ExpressionFunc extends Function {
        prototype: Expression;
    }
    var Expression: ExpressionFunc;

    interface UnionOperator extends Kusto.Language.Syntax.QueryOperator {
        Kind: Kusto.Language.Syntax.SyntaxKind;
        UnionKeyword: Kusto.Language.Syntax.SyntaxToken | null;
        Parameters: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.NamedParameter> | null;
        Expressions: Kusto.Language.Syntax.SyntaxList$1<Kusto.Language.Syntax.SeparatedElement$1<Kusto.Language.Syntax.Expression>> | null;
        ChildCount: number;
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        GetName(index: number): string | null;
        Accept$1(visitor: Kusto.Language.Syntax.SyntaxVisitor | null): void;
        Accept<TResult>(TResult: {prototype: TResult}, visitor: Kusto.Language.Syntax.SyntaxVisitor$1<TResult> | null): TResult;
    }
    interface UnionOperatorFunc extends Function {
        prototype: UnionOperator;
    }
    var UnionOperator: UnionOperatorFunc;

    interface SyntaxVisitor {
        VisitDirectiveBlock(node: Kusto.Language.Syntax.DirectiveBlock | null): void;
        VisitSkippedTokens(node: Kusto.Language.Syntax.SkippedTokens | null): void;
        VisitQueryBlock(node: Kusto.Language.Syntax.QueryBlock | null): void;
        VisitTypeOfLiteralExpression(node: Kusto.Language.Syntax.TypeOfLiteralExpression | null): void;
        VisitBadQueryOperator(node: Kusto.Language.Syntax.BadQueryOperator | null): void;
        VisitCompoundStringLiteralExpression(node: Kusto.Language.Syntax.CompoundStringLiteralExpression | null): void;
        VisitTokenName(node: Kusto.Language.Syntax.TokenName | null): void;
        VisitBracketedName(node: Kusto.Language.Syntax.BracketedName | null): void;
        VisitBracedName(node: Kusto.Language.Syntax.BracedName | null): void;
        VisitWildcardedName(node: Kusto.Language.Syntax.WildcardedName | null): void;
        VisitBracketedWildcardedName(node: Kusto.Language.Syntax.BracketedWildcardedName | null): void;
        VisitNameDeclaration(node: Kusto.Language.Syntax.NameDeclaration | null): void;
        VisitNameReference(node: Kusto.Language.Syntax.NameReference | null): void;
        VisitLiteralExpression(node: Kusto.Language.Syntax.LiteralExpression | null): void;
        VisitStarExpression(node: Kusto.Language.Syntax.StarExpression | null): void;
        VisitAtExpression(node: Kusto.Language.Syntax.AtExpression | null): void;
        VisitJsonPair(node: Kusto.Language.Syntax.JsonPair | null): void;
        VisitJsonObjectExpression(node: Kusto.Language.Syntax.JsonObjectExpression | null): void;
        VisitJsonArrayExpression(node: Kusto.Language.Syntax.JsonArrayExpression | null): void;
        VisitDynamicExpression(node: Kusto.Language.Syntax.DynamicExpression | null): void;
        VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): void;
        VisitExpressionList(node: Kusto.Language.Syntax.ExpressionList | null): void;
        VisitExpressionCouple(node: Kusto.Language.Syntax.ExpressionCouple | null): void;
        VisitPrefixUnaryExpression(node: Kusto.Language.Syntax.PrefixUnaryExpression | null): void;
        VisitBinaryExpression(node: Kusto.Language.Syntax.BinaryExpression | null): void;
        VisitInExpression(node: Kusto.Language.Syntax.InExpression | null): void;
        VisitHasAnyExpression(node: Kusto.Language.Syntax.HasAnyExpression | null): void;
        VisitHasAllExpression(node: Kusto.Language.Syntax.HasAllExpression | null): void;
        VisitBetweenExpression(node: Kusto.Language.Syntax.BetweenExpression | null): void;
        VisitFunctionCallExpression(node: Kusto.Language.Syntax.FunctionCallExpression | null): void;
        VisitToScalarExpression(node: Kusto.Language.Syntax.ToScalarExpression | null): void;
        VisitToTableExpression(node: Kusto.Language.Syntax.ToTableExpression | null): void;
        VisitMaterializedViewCombineExpression(node: Kusto.Language.Syntax.MaterializedViewCombineExpression | null): void;
        VisitMaterializedViewCombineNameClause(node: Kusto.Language.Syntax.MaterializedViewCombineNameClause | null): void;
        VisitMaterializedViewCombineClause(node: Kusto.Language.Syntax.MaterializedViewCombineClause | null): void;
        VisitSimpleNamedExpression(node: Kusto.Language.Syntax.SimpleNamedExpression | null): void;
        VisitRenameList(node: Kusto.Language.Syntax.RenameList | null): void;
        VisitCompoundNamedExpression(node: Kusto.Language.Syntax.CompoundNamedExpression | null): void;
        VisitBracketedExpression(node: Kusto.Language.Syntax.BracketedExpression | null): void;
        VisitPathExpression(node: Kusto.Language.Syntax.PathExpression | null): void;
        VisitElementExpression(node: Kusto.Language.Syntax.ElementExpression | null): void;
        VisitPipeExpression(node: Kusto.Language.Syntax.PipeExpression | null): void;
        VisitRangeOperator(node: Kusto.Language.Syntax.RangeOperator | null): void;
        VisitNamedParameter(node: Kusto.Language.Syntax.NamedParameter | null): void;
        VisitConsumeOperator(node: Kusto.Language.Syntax.ConsumeOperator | null): void;
        VisitCountOperator(node: Kusto.Language.Syntax.CountOperator | null): void;
        VisitCountAsIdentifierClause(node: Kusto.Language.Syntax.CountAsIdentifierClause | null): void;
        VisitExecuteAndCacheOperator(node: Kusto.Language.Syntax.ExecuteAndCacheOperator | null): void;
        VisitExtendOperator(node: Kusto.Language.Syntax.ExtendOperator | null): void;
        VisitFacetOperator(node: Kusto.Language.Syntax.FacetOperator | null): void;
        VisitFacetWithOperatorClause(node: Kusto.Language.Syntax.FacetWithOperatorClause | null): void;
        VisitFacetWithExpressionClause(node: Kusto.Language.Syntax.FacetWithExpressionClause | null): void;
        VisitFilterOperator(node: Kusto.Language.Syntax.FilterOperator | null): void;
        VisitGetSchemaOperator(node: Kusto.Language.Syntax.GetSchemaOperator | null): void;
        VisitFindOperator(node: Kusto.Language.Syntax.FindOperator | null): void;
        VisitDataScopeClause(node: Kusto.Language.Syntax.DataScopeClause | null): void;
        VisitTypedColumnReference(node: Kusto.Language.Syntax.TypedColumnReference | null): void;
        VisitFindInClause(node: Kusto.Language.Syntax.FindInClause | null): void;
        VisitFindProjectClause(node: Kusto.Language.Syntax.FindProjectClause | null): void;
        VisitPackExpression(node: Kusto.Language.Syntax.PackExpression | null): void;
        VisitNameAndTypeDeclaration(node: Kusto.Language.Syntax.NameAndTypeDeclaration | null): void;
        VisitPrimitiveTypeExpression(node: Kusto.Language.Syntax.PrimitiveTypeExpression | null): void;
        VisitSearchOperator(node: Kusto.Language.Syntax.SearchOperator | null): void;
        VisitForkOperator(node: Kusto.Language.Syntax.ForkOperator | null): void;
        VisitNameEqualsClause(node: Kusto.Language.Syntax.NameEqualsClause | null): void;
        VisitForkExpression(node: Kusto.Language.Syntax.ForkExpression | null): void;
        VisitMakeSeriesOperator(node: Kusto.Language.Syntax.MakeSeriesOperator | null): void;
        VisitMakeSeriesExpression(node: Kusto.Language.Syntax.MakeSeriesExpression | null): void;
        VisitDefaultExpressionClause(node: Kusto.Language.Syntax.DefaultExpressionClause | null): void;
        VisitMakeSeriesOnClause(node: Kusto.Language.Syntax.MakeSeriesOnClause | null): void;
        VisitMakeSeriesFromClause(node: Kusto.Language.Syntax.MakeSeriesFromClause | null): void;
        VisitMakeSeriesToClause(node: Kusto.Language.Syntax.MakeSeriesToClause | null): void;
        VisitMakeSeriesStepClause(node: Kusto.Language.Syntax.MakeSeriesStepClause | null): void;
        VisitMakeSeriesInRangeClause(node: Kusto.Language.Syntax.MakeSeriesInRangeClause | null): void;
        VisitMakeSeriesFromToStepClause(node: Kusto.Language.Syntax.MakeSeriesFromToStepClause | null): void;
        VisitMakeSeriesByClause(node: Kusto.Language.Syntax.MakeSeriesByClause | null): void;
        VisitMvExpandOperator(node: Kusto.Language.Syntax.MvExpandOperator | null): void;
        VisitMvExpandExpression(node: Kusto.Language.Syntax.MvExpandExpression | null): void;
        VisitMvExpandRowLimitClause(node: Kusto.Language.Syntax.MvExpandRowLimitClause | null): void;
        VisitMvApplyOperator(node: Kusto.Language.Syntax.MvApplyOperator | null): void;
        VisitMvApplyExpression(node: Kusto.Language.Syntax.MvApplyExpression | null): void;
        VisitMvApplyRowLimitClause(node: Kusto.Language.Syntax.MvApplyRowLimitClause | null): void;
        VisitMvApplyContextIdClause(node: Kusto.Language.Syntax.MvApplyContextIdClause | null): void;
        VisitMvApplySubqueryExpression(node: Kusto.Language.Syntax.MvApplySubqueryExpression | null): void;
        VisitToTypeOfClause(node: Kusto.Language.Syntax.ToTypeOfClause | null): void;
        VisitEvaluateSchemaClause(node: Kusto.Language.Syntax.EvaluateSchemaClause | null): void;
        VisitEvaluateOperator(node: Kusto.Language.Syntax.EvaluateOperator | null): void;
        VisitParseOperator(node: Kusto.Language.Syntax.ParseOperator | null): void;
        VisitParseWhereOperator(node: Kusto.Language.Syntax.ParseWhereOperator | null): void;
        VisitPartitionOperator(node: Kusto.Language.Syntax.PartitionOperator | null): void;
        VisitPartitionQuery(node: Kusto.Language.Syntax.PartitionQuery | null): void;
        VisitPartitionScope(node: Kusto.Language.Syntax.PartitionScope | null): void;
        VisitPartitionSubquery(node: Kusto.Language.Syntax.PartitionSubquery | null): void;
        VisitProjectOperator(node: Kusto.Language.Syntax.ProjectOperator | null): void;
        VisitProjectAwayOperator(node: Kusto.Language.Syntax.ProjectAwayOperator | null): void;
        VisitProjectKeepOperator(node: Kusto.Language.Syntax.ProjectKeepOperator | null): void;
        VisitProjectRenameOperator(node: Kusto.Language.Syntax.ProjectRenameOperator | null): void;
        VisitProjectReorderOperator(node: Kusto.Language.Syntax.ProjectReorderOperator | null): void;
        VisitSampleOperator(node: Kusto.Language.Syntax.SampleOperator | null): void;
        VisitSampleDistinctOperator(node: Kusto.Language.Syntax.SampleDistinctOperator | null): void;
        VisitEntityGroup(node: Kusto.Language.Syntax.EntityGroup | null): void;
        VisitReduceByOperator(node: Kusto.Language.Syntax.ReduceByOperator | null): void;
        VisitReduceByWithClause(node: Kusto.Language.Syntax.ReduceByWithClause | null): void;
        VisitSummarizeOperator(node: Kusto.Language.Syntax.SummarizeOperator | null): void;
        VisitSummarizeByClause(node: Kusto.Language.Syntax.SummarizeByClause | null): void;
        VisitDistinctOperator(node: Kusto.Language.Syntax.DistinctOperator | null): void;
        VisitTakeOperator(node: Kusto.Language.Syntax.TakeOperator | null): void;
        VisitSortOperator(node: Kusto.Language.Syntax.SortOperator | null): void;
        VisitOrderedExpression(node: Kusto.Language.Syntax.OrderedExpression | null): void;
        VisitOrderingClause(node: Kusto.Language.Syntax.OrderingClause | null): void;
        VisitOrderingNullsClause(node: Kusto.Language.Syntax.OrderingNullsClause | null): void;
        VisitTopHittersOperator(node: Kusto.Language.Syntax.TopHittersOperator | null): void;
        VisitTopHittersByClause(node: Kusto.Language.Syntax.TopHittersByClause | null): void;
        VisitTopOperator(node: Kusto.Language.Syntax.TopOperator | null): void;
        VisitTopNestedOperator(node: Kusto.Language.Syntax.TopNestedOperator | null): void;
        VisitTopNestedClause(node: Kusto.Language.Syntax.TopNestedClause | null): void;
        VisitTopNestedWithOthersClause(node: Kusto.Language.Syntax.TopNestedWithOthersClause | null): void;
        VisitUnionOperator(node: Kusto.Language.Syntax.UnionOperator | null): void;
        VisitAsOperator(node: Kusto.Language.Syntax.AsOperator | null): void;
        VisitSerializeOperator(node: Kusto.Language.Syntax.SerializeOperator | null): void;
        VisitInvokeOperator(node: Kusto.Language.Syntax.InvokeOperator | null): void;
        VisitRenderOperator(node: Kusto.Language.Syntax.RenderOperator | null): void;
        VisitNameReferenceList(node: Kusto.Language.Syntax.NameReferenceList | null): void;
        VisitRenderWithClause(node: Kusto.Language.Syntax.RenderWithClause | null): void;
        VisitPrintOperator(node: Kusto.Language.Syntax.PrintOperator | null): void;
        VisitAliasStatement(node: Kusto.Language.Syntax.AliasStatement | null): void;
        VisitLetStatement(node: Kusto.Language.Syntax.LetStatement | null): void;
        VisitFunctionDeclaration(node: Kusto.Language.Syntax.FunctionDeclaration | null): void;
        VisitFunctionParameters(node: Kusto.Language.Syntax.FunctionParameters | null): void;
        VisitFunctionParameter(node: Kusto.Language.Syntax.FunctionParameter | null): void;
        VisitDefaultValueDeclaration(node: Kusto.Language.Syntax.DefaultValueDeclaration | null): void;
        VisitFunctionBody(node: Kusto.Language.Syntax.FunctionBody | null): void;
        VisitSchemaTypeExpression(node: Kusto.Language.Syntax.SchemaTypeExpression | null): void;
        VisitExpressionStatement(node: Kusto.Language.Syntax.ExpressionStatement | null): void;
        VisitMaterializeExpression(node: Kusto.Language.Syntax.MaterializeExpression | null): void;
        VisitSetOptionStatement(node: Kusto.Language.Syntax.SetOptionStatement | null): void;
        VisitOptionValueClause(node: Kusto.Language.Syntax.OptionValueClause | null): void;
        VisitQueryParametersStatement(node: Kusto.Language.Syntax.QueryParametersStatement | null): void;
        VisitRestrictStatement(node: Kusto.Language.Syntax.RestrictStatement | null): void;
        VisitPatternStatement(node: Kusto.Language.Syntax.PatternStatement | null): void;
        VisitPatternDeclaration(node: Kusto.Language.Syntax.PatternDeclaration | null): void;
        VisitPatternPathParameter(node: Kusto.Language.Syntax.PatternPathParameter | null): void;
        VisitPatternMatch(node: Kusto.Language.Syntax.PatternMatch | null): void;
        VisitPatternPathValue(node: Kusto.Language.Syntax.PatternPathValue | null): void;
        VisitDataScopeExpression(node: Kusto.Language.Syntax.DataScopeExpression | null): void;
        VisitDataTableExpression(node: Kusto.Language.Syntax.DataTableExpression | null): void;
        VisitExternalDataExpression(node: Kusto.Language.Syntax.ExternalDataExpression | null): void;
        VisitContextualDataTableExpression(node: Kusto.Language.Syntax.ContextualDataTableExpression | null): void;
        VisitExternalDataWithClause(node: Kusto.Language.Syntax.ExternalDataWithClause | null): void;
        VisitJoinOperator(node: Kusto.Language.Syntax.JoinOperator | null): void;
        VisitLookupOperator(node: Kusto.Language.Syntax.LookupOperator | null): void;
        VisitJoinOnClause(node: Kusto.Language.Syntax.JoinOnClause | null): void;
        VisitJoinWhereClause(node: Kusto.Language.Syntax.JoinWhereClause | null): void;
        VisitScanOperator(node: Kusto.Language.Syntax.ScanOperator | null): void;
        VisitScanDeclareClause(node: Kusto.Language.Syntax.ScanDeclareClause | null): void;
        VisitScanOrderByClause(node: Kusto.Language.Syntax.ScanOrderByClause | null): void;
        VisitScanPartitionByClause(node: Kusto.Language.Syntax.ScanPartitionByClause | null): void;
        VisitScanStepOutput(node: Kusto.Language.Syntax.ScanStepOutput | null): void;
        VisitScanStep(node: Kusto.Language.Syntax.ScanStep | null): void;
        VisitScanComputationClause(node: Kusto.Language.Syntax.ScanComputationClause | null): void;
        VisitScanAssignment(node: Kusto.Language.Syntax.ScanAssignment | null): void;
        VisitCommandWithValueClause(node: Kusto.Language.Syntax.CommandWithValueClause | null): void;
        VisitCommandWithPropertyListClause(node: Kusto.Language.Syntax.CommandWithPropertyListClause | null): void;
        VisitUnknownCommand(node: Kusto.Language.Syntax.UnknownCommand | null): void;
        VisitCustomCommand(node: Kusto.Language.Syntax.CustomCommand | null): void;
        VisitBadCommand(node: Kusto.Language.Syntax.BadCommand | null): void;
        VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): void;
    }
    interface SyntaxVisitorFunc extends Function {
        prototype: SyntaxVisitor;
        new (): SyntaxVisitor;
    }
    var SyntaxVisitor: SyntaxVisitorFunc;

    interface SyntaxVisitor$1<TResult> {
        VisitDirectiveBlock(node: Kusto.Language.Syntax.DirectiveBlock | null): TResult;
        VisitSkippedTokens(node: Kusto.Language.Syntax.SkippedTokens | null): TResult;
        VisitQueryBlock(node: Kusto.Language.Syntax.QueryBlock | null): TResult;
        VisitTypeOfLiteralExpression(node: Kusto.Language.Syntax.TypeOfLiteralExpression | null): TResult;
        VisitBadQueryOperator(node: Kusto.Language.Syntax.BadQueryOperator | null): TResult;
        VisitCompoundStringLiteralExpression(node: Kusto.Language.Syntax.CompoundStringLiteralExpression | null): TResult;
        VisitTokenName(node: Kusto.Language.Syntax.TokenName | null): TResult;
        VisitBracketedName(node: Kusto.Language.Syntax.BracketedName | null): TResult;
        VisitBracedName(node: Kusto.Language.Syntax.BracedName | null): TResult;
        VisitWildcardedName(node: Kusto.Language.Syntax.WildcardedName | null): TResult;
        VisitBracketedWildcardedName(node: Kusto.Language.Syntax.BracketedWildcardedName | null): TResult;
        VisitNameDeclaration(node: Kusto.Language.Syntax.NameDeclaration | null): TResult;
        VisitNameReference(node: Kusto.Language.Syntax.NameReference | null): TResult;
        VisitLiteralExpression(node: Kusto.Language.Syntax.LiteralExpression | null): TResult;
        VisitStarExpression(node: Kusto.Language.Syntax.StarExpression | null): TResult;
        VisitAtExpression(node: Kusto.Language.Syntax.AtExpression | null): TResult;
        VisitJsonPair(node: Kusto.Language.Syntax.JsonPair | null): TResult;
        VisitJsonObjectExpression(node: Kusto.Language.Syntax.JsonObjectExpression | null): TResult;
        VisitJsonArrayExpression(node: Kusto.Language.Syntax.JsonArrayExpression | null): TResult;
        VisitDynamicExpression(node: Kusto.Language.Syntax.DynamicExpression | null): TResult;
        VisitParenthesizedExpression(node: Kusto.Language.Syntax.ParenthesizedExpression | null): TResult;
        VisitExpressionList(node: Kusto.Language.Syntax.ExpressionList | null): TResult;
        VisitExpressionCouple(node: Kusto.Language.Syntax.ExpressionCouple | null): TResult;
        VisitPrefixUnaryExpression(node: Kusto.Language.Syntax.PrefixUnaryExpression | null): TResult;
        VisitBinaryExpression(node: Kusto.Language.Syntax.BinaryExpression | null): TResult;
        VisitInExpression(node: Kusto.Language.Syntax.InExpression | null): TResult;
        VisitHasAnyExpression(node: Kusto.Language.Syntax.HasAnyExpression | null): TResult;
        VisitHasAllExpression(node: Kusto.Language.Syntax.HasAllExpression | null): TResult;
        VisitBetweenExpression(node: Kusto.Language.Syntax.BetweenExpression | null): TResult;
        VisitFunctionCallExpression(node: Kusto.Language.Syntax.FunctionCallExpression | null): TResult;
        VisitToScalarExpression(node: Kusto.Language.Syntax.ToScalarExpression | null): TResult;
        VisitToTableExpression(node: Kusto.Language.Syntax.ToTableExpression | null): TResult;
        VisitMaterializedViewCombineExpression(node: Kusto.Language.Syntax.MaterializedViewCombineExpression | null): TResult;
        VisitMaterializedViewCombineNameClause(node: Kusto.Language.Syntax.MaterializedViewCombineNameClause | null): TResult;
        VisitMaterializedViewCombineClause(node: Kusto.Language.Syntax.MaterializedViewCombineClause | null): TResult;
        VisitSimpleNamedExpression(node: Kusto.Language.Syntax.SimpleNamedExpression | null): TResult;
        VisitRenameList(node: Kusto.Language.Syntax.RenameList | null): TResult;
        VisitCompoundNamedExpression(node: Kusto.Language.Syntax.CompoundNamedExpression | null): TResult;
        VisitBracketedExpression(node: Kusto.Language.Syntax.BracketedExpression | null): TResult;
        VisitPathExpression(node: Kusto.Language.Syntax.PathExpression | null): TResult;
        VisitElementExpression(node: Kusto.Language.Syntax.ElementExpression | null): TResult;
        VisitPipeExpression(node: Kusto.Language.Syntax.PipeExpression | null): TResult;
        VisitRangeOperator(node: Kusto.Language.Syntax.RangeOperator | null): TResult;
        VisitNamedParameter(node: Kusto.Language.Syntax.NamedParameter | null): TResult;
        VisitConsumeOperator(node: Kusto.Language.Syntax.ConsumeOperator | null): TResult;
        VisitCountOperator(node: Kusto.Language.Syntax.CountOperator | null): TResult;
        VisitCountAsIdentifierClause(node: Kusto.Language.Syntax.CountAsIdentifierClause | null): TResult;
        VisitExecuteAndCacheOperator(node: Kusto.Language.Syntax.ExecuteAndCacheOperator | null): TResult;
        VisitExtendOperator(node: Kusto.Language.Syntax.ExtendOperator | null): TResult;
        VisitFacetOperator(node: Kusto.Language.Syntax.FacetOperator | null): TResult;
        VisitFacetWithOperatorClause(node: Kusto.Language.Syntax.FacetWithOperatorClause | null): TResult;
        VisitFacetWithExpressionClause(node: Kusto.Language.Syntax.FacetWithExpressionClause | null): TResult;
        VisitFilterOperator(node: Kusto.Language.Syntax.FilterOperator | null): TResult;
        VisitGetSchemaOperator(node: Kusto.Language.Syntax.GetSchemaOperator | null): TResult;
        VisitFindOperator(node: Kusto.Language.Syntax.FindOperator | null): TResult;
        VisitDataScopeClause(node: Kusto.Language.Syntax.DataScopeClause | null): TResult;
        VisitTypedColumnReference(node: Kusto.Language.Syntax.TypedColumnReference | null): TResult;
        VisitFindInClause(node: Kusto.Language.Syntax.FindInClause | null): TResult;
        VisitFindProjectClause(node: Kusto.Language.Syntax.FindProjectClause | null): TResult;
        VisitPackExpression(node: Kusto.Language.Syntax.PackExpression | null): TResult;
        VisitNameAndTypeDeclaration(node: Kusto.Language.Syntax.NameAndTypeDeclaration | null): TResult;
        VisitPrimitiveTypeExpression(node: Kusto.Language.Syntax.PrimitiveTypeExpression | null): TResult;
        VisitSearchOperator(node: Kusto.Language.Syntax.SearchOperator | null): TResult;
        VisitForkOperator(node: Kusto.Language.Syntax.ForkOperator | null): TResult;
        VisitNameEqualsClause(node: Kusto.Language.Syntax.NameEqualsClause | null): TResult;
        VisitForkExpression(node: Kusto.Language.Syntax.ForkExpression | null): TResult;
        VisitMakeSeriesOperator(node: Kusto.Language.Syntax.MakeSeriesOperator | null): TResult;
        VisitMakeSeriesExpression(node: Kusto.Language.Syntax.MakeSeriesExpression | null): TResult;
        VisitDefaultExpressionClause(node: Kusto.Language.Syntax.DefaultExpressionClause | null): TResult;
        VisitMakeSeriesOnClause(node: Kusto.Language.Syntax.MakeSeriesOnClause | null): TResult;
        VisitMakeSeriesFromClause(node: Kusto.Language.Syntax.MakeSeriesFromClause | null): TResult;
        VisitMakeSeriesToClause(node: Kusto.Language.Syntax.MakeSeriesToClause | null): TResult;
        VisitMakeSeriesStepClause(node: Kusto.Language.Syntax.MakeSeriesStepClause | null): TResult;
        VisitMakeSeriesInRangeClause(node: Kusto.Language.Syntax.MakeSeriesInRangeClause | null): TResult;
        VisitMakeSeriesFromToStepClause(node: Kusto.Language.Syntax.MakeSeriesFromToStepClause | null): TResult;
        VisitMakeSeriesByClause(node: Kusto.Language.Syntax.MakeSeriesByClause | null): TResult;
        VisitMvExpandOperator(node: Kusto.Language.Syntax.MvExpandOperator | null): TResult;
        VisitMvExpandExpression(node: Kusto.Language.Syntax.MvExpandExpression | null): TResult;
        VisitMvExpandRowLimitClause(node: Kusto.Language.Syntax.MvExpandRowLimitClause | null): TResult;
        VisitMvApplyOperator(node: Kusto.Language.Syntax.MvApplyOperator | null): TResult;
        VisitMvApplyExpression(node: Kusto.Language.Syntax.MvApplyExpression | null): TResult;
        VisitMvApplyRowLimitClause(node: Kusto.Language.Syntax.MvApplyRowLimitClause | null): TResult;
        VisitMvApplyContextIdClause(node: Kusto.Language.Syntax.MvApplyContextIdClause | null): TResult;
        VisitMvApplySubqueryExpression(node: Kusto.Language.Syntax.MvApplySubqueryExpression | null): TResult;
        VisitToTypeOfClause(node: Kusto.Language.Syntax.ToTypeOfClause | null): TResult;
        VisitEvaluateSchemaClause(node: Kusto.Language.Syntax.EvaluateSchemaClause | null): TResult;
        VisitEvaluateOperator(node: Kusto.Language.Syntax.EvaluateOperator | null): TResult;
        VisitParseOperator(node: Kusto.Language.Syntax.ParseOperator | null): TResult;
        VisitParseWhereOperator(node: Kusto.Language.Syntax.ParseWhereOperator | null): TResult;
        VisitPartitionOperator(node: Kusto.Language.Syntax.PartitionOperator | null): TResult;
        VisitPartitionQuery(node: Kusto.Language.Syntax.PartitionQuery | null): TResult;
        VisitPartitionScope(node: Kusto.Language.Syntax.PartitionScope | null): TResult;
        VisitPartitionSubquery(node: Kusto.Language.Syntax.PartitionSubquery | null): TResult;
        VisitProjectOperator(node: Kusto.Language.Syntax.ProjectOperator | null): TResult;
        VisitProjectAwayOperator(node: Kusto.Language.Syntax.ProjectAwayOperator | null): TResult;
        VisitProjectKeepOperator(node: Kusto.Language.Syntax.ProjectKeepOperator | null): TResult;
        VisitProjectRenameOperator(node: Kusto.Language.Syntax.ProjectRenameOperator | null): TResult;
        VisitProjectReorderOperator(node: Kusto.Language.Syntax.ProjectReorderOperator | null): TResult;
        VisitSampleOperator(node: Kusto.Language.Syntax.SampleOperator | null): TResult;
        VisitSampleDistinctOperator(node: Kusto.Language.Syntax.SampleDistinctOperator | null): TResult;
        VisitEntityGroup(node: Kusto.Language.Syntax.EntityGroup | null): TResult;
        VisitReduceByOperator(node: Kusto.Language.Syntax.ReduceByOperator | null): TResult;
        VisitReduceByWithClause(node: Kusto.Language.Syntax.ReduceByWithClause | null): TResult;
        VisitSummarizeOperator(node: Kusto.Language.Syntax.SummarizeOperator | null): TResult;
        VisitSummarizeByClause(node: Kusto.Language.Syntax.SummarizeByClause | null): TResult;
        VisitDistinctOperator(node: Kusto.Language.Syntax.DistinctOperator | null): TResult;
        VisitTakeOperator(node: Kusto.Language.Syntax.TakeOperator | null): TResult;
        VisitSortOperator(node: Kusto.Language.Syntax.SortOperator | null): TResult;
        VisitOrderedExpression(node: Kusto.Language.Syntax.OrderedExpression | null): TResult;
        VisitOrderingClause(node: Kusto.Language.Syntax.OrderingClause | null): TResult;
        VisitOrderingNullsClause(node: Kusto.Language.Syntax.OrderingNullsClause | null): TResult;
        VisitTopHittersOperator(node: Kusto.Language.Syntax.TopHittersOperator | null): TResult;
        VisitTopHittersByClause(node: Kusto.Language.Syntax.TopHittersByClause | null): TResult;
        VisitTopOperator(node: Kusto.Language.Syntax.TopOperator | null): TResult;
        VisitTopNestedOperator(node: Kusto.Language.Syntax.TopNestedOperator | null): TResult;
        VisitTopNestedClause(node: Kusto.Language.Syntax.TopNestedClause | null): TResult;
        VisitTopNestedWithOthersClause(node: Kusto.Language.Syntax.TopNestedWithOthersClause | null): TResult;
        VisitUnionOperator(node: Kusto.Language.Syntax.UnionOperator | null): TResult;
        VisitAsOperator(node: Kusto.Language.Syntax.AsOperator | null): TResult;
        VisitSerializeOperator(node: Kusto.Language.Syntax.SerializeOperator | null): TResult;
        VisitInvokeOperator(node: Kusto.Language.Syntax.InvokeOperator | null): TResult;
        VisitRenderOperator(node: Kusto.Language.Syntax.RenderOperator | null): TResult;
        VisitNameReferenceList(node: Kusto.Language.Syntax.NameReferenceList | null): TResult;
        VisitRenderWithClause(node: Kusto.Language.Syntax.RenderWithClause | null): TResult;
        VisitPrintOperator(node: Kusto.Language.Syntax.PrintOperator | null): TResult;
        VisitAliasStatement(node: Kusto.Language.Syntax.AliasStatement | null): TResult;
        VisitLetStatement(node: Kusto.Language.Syntax.LetStatement | null): TResult;
        VisitFunctionDeclaration(node: Kusto.Language.Syntax.FunctionDeclaration | null): TResult;
        VisitFunctionParameters(node: Kusto.Language.Syntax.FunctionParameters | null): TResult;
        VisitFunctionParameter(node: Kusto.Language.Syntax.FunctionParameter | null): TResult;
        VisitDefaultValueDeclaration(node: Kusto.Language.Syntax.DefaultValueDeclaration | null): TResult;
        VisitFunctionBody(node: Kusto.Language.Syntax.FunctionBody | null): TResult;
        VisitSchemaTypeExpression(node: Kusto.Language.Syntax.SchemaTypeExpression | null): TResult;
        VisitExpressionStatement(node: Kusto.Language.Syntax.ExpressionStatement | null): TResult;
        VisitMaterializeExpression(node: Kusto.Language.Syntax.MaterializeExpression | null): TResult;
        VisitSetOptionStatement(node: Kusto.Language.Syntax.SetOptionStatement | null): TResult;
        VisitOptionValueClause(node: Kusto.Language.Syntax.OptionValueClause | null): TResult;
        VisitQueryParametersStatement(node: Kusto.Language.Syntax.QueryParametersStatement | null): TResult;
        VisitRestrictStatement(node: Kusto.Language.Syntax.RestrictStatement | null): TResult;
        VisitPatternStatement(node: Kusto.Language.Syntax.PatternStatement | null): TResult;
        VisitPatternDeclaration(node: Kusto.Language.Syntax.PatternDeclaration | null): TResult;
        VisitPatternPathParameter(node: Kusto.Language.Syntax.PatternPathParameter | null): TResult;
        VisitPatternMatch(node: Kusto.Language.Syntax.PatternMatch | null): TResult;
        VisitPatternPathValue(node: Kusto.Language.Syntax.PatternPathValue | null): TResult;
        VisitDataScopeExpression(node: Kusto.Language.Syntax.DataScopeExpression | null): TResult;
        VisitDataTableExpression(node: Kusto.Language.Syntax.DataTableExpression | null): TResult;
        VisitExternalDataExpression(node: Kusto.Language.Syntax.ExternalDataExpression | null): TResult;
        VisitContextualDataTableExpression(node: Kusto.Language.Syntax.ContextualDataTableExpression | null): TResult;
        VisitExternalDataWithClause(node: Kusto.Language.Syntax.ExternalDataWithClause | null): TResult;
        VisitJoinOperator(node: Kusto.Language.Syntax.JoinOperator | null): TResult;
        VisitLookupOperator(node: Kusto.Language.Syntax.LookupOperator | null): TResult;
        VisitJoinOnClause(node: Kusto.Language.Syntax.JoinOnClause | null): TResult;
        VisitJoinWhereClause(node: Kusto.Language.Syntax.JoinWhereClause | null): TResult;
        VisitScanOperator(node: Kusto.Language.Syntax.ScanOperator | null): TResult;
        VisitScanDeclareClause(node: Kusto.Language.Syntax.ScanDeclareClause | null): TResult;
        VisitScanOrderByClause(node: Kusto.Language.Syntax.ScanOrderByClause | null): TResult;
        VisitScanPartitionByClause(node: Kusto.Language.Syntax.ScanPartitionByClause | null): TResult;
        VisitScanStepOutput(node: Kusto.Language.Syntax.ScanStepOutput | null): TResult;
        VisitScanStep(node: Kusto.Language.Syntax.ScanStep | null): TResult;
        VisitScanComputationClause(node: Kusto.Language.Syntax.ScanComputationClause | null): TResult;
        VisitScanAssignment(node: Kusto.Language.Syntax.ScanAssignment | null): TResult;
        VisitCommandWithValueClause(node: Kusto.Language.Syntax.CommandWithValueClause | null): TResult;
        VisitCommandWithPropertyListClause(node: Kusto.Language.Syntax.CommandWithPropertyListClause | null): TResult;
        VisitUnknownCommand(node: Kusto.Language.Syntax.UnknownCommand | null): TResult;
        VisitCustomCommand(node: Kusto.Language.Syntax.CustomCommand | null): TResult;
        VisitBadCommand(node: Kusto.Language.Syntax.BadCommand | null): TResult;
        VisitCommandBlock(node: Kusto.Language.Syntax.CommandBlock | null): TResult;
    }
    interface SyntaxVisitor$1Func extends Function {
        <TResult>($TResult: Bridge.TypeRef<TResult>): {
            prototype: SyntaxVisitor$1<TResult>;
            new (): SyntaxVisitor$1<TResult>;
        }
    }
    var SyntaxVisitor$1: SyntaxVisitor$1Func;

    interface SyntaxTree {
        /**
         * The root {@link } of the {@link }
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SyntaxTree
         * @function Root
         * @type Kusto.Language.Syntax.SyntaxNode
         */
        Root: Kusto.Language.Syntax.SyntaxNode | null;
        /**
         * The maximal depth of the nodes in the tree.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxTree
         * @function Depth
         * @type number
         */
        Depth: number;
        /**
         * True if the tree depth is shallow enough to allow stack recursion
         to walk the nodes of this tree.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxTree
         * @function IsSafeToRecurse
         * @type boolean
         */
        IsSafeToRecurse: boolean;
    }
    interface SyntaxTreeFunc extends Function {
        prototype: SyntaxTree;
        new (root: Kusto.Language.Syntax.SyntaxNode | null): SyntaxTree;
        /**
         * Walks the entire syntax tree and evaluates the maximum depth of all the nodes.
         *
         * @static
         * @private
         * @this Kusto.Language.Syntax.SyntaxTree
         * @memberof Kusto.Language.Syntax.SyntaxTree
         * @param   {Kusto.Language.Syntax.SyntaxNode}    root
         * @return  {number}
         */
    }
    var SyntaxTree: SyntaxTreeFunc;

    /**
     * A basic element of syntax.
     *
     * @abstract
     * @public
     * @class Kusto.Language.Syntax.SyntaxElement
     */
    interface SyntaxElement {
        /**
         * The parent node of this element, or extended data. Use property to access this value.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function Parent
         * @type Kusto.Language.Syntax.SyntaxNode
         */
        Parent: Kusto.Language.Syntax.SyntaxNode | null;
        /**
         * Kind of token
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function Kind
         * @type Kusto.Language.Syntax.SyntaxKind
         */
        Kind: Kusto.Language.Syntax.SyntaxKind;
        /**
         * True if this {@link } or any child element has syntax diagnostics.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function ContainsSyntaxDiagnostics
         * @type boolean
         */
        ContainsSyntaxDiagnostics: boolean;
        /**
         * True if this element has syntax diagnostics.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function HasSyntaxDiagnostics
         * @type boolean
         */
        HasSyntaxDiagnostics: boolean;
        /**
         * All syntax diagnostics located at this element.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function SyntaxDiagnostics
         * @type System.Collections.Generic.IReadOnlyList$1
         */
        SyntaxDiagnostics: System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * True if the {@link } is a {@link }.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function IsToken
         * @type boolean
         */
        IsToken: boolean;
        /**
         * True if the element is taking the place of a missing element.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function IsMissing
         * @type boolean
         */
        IsMissing: boolean;
        /**
         * The root element
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function Root
         * @type Kusto.Language.Syntax.SyntaxElement
         */
        Root: Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * Child Index in parent.
         *
         * @instance
         * @public
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function IndexInParent
         * @type number
         */
        IndexInParent: number;
        /**
         * The number of immediate child elements this element has.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function ChildCount
         * @type number
         */
        ChildCount: number;
        /**
         * The depth of this node below the root.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function Depth
         * @type number
         */
        Depth: number;
        /**
         * The name of the element given by the parent.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function NameInParent
         * @type string
         */
        NameInParent: string | null;
        /**
         * The position in the source of the start of the leading trivia.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function TriviaStart
         * @type number
         */
        TriviaStart: number;
        /**
         * The full width (in characters) of this element including leading trivia.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function FullWidth
         * @type number
         */
        FullWidth: number;
        /**
         * The width (in characters) of the leading trivia.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function TriviaWidth
         * @type number
         */
        TriviaWidth: number;
        /**
         * The position in the source where the element's first token text starts.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function TextStart
         * @type number
         */
        TextStart: number;
        /**
         * The position in the source immediately after this element.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function End
         * @type number
         */
        End: number;
        /**
         * The width (in characters) of this element, not including trivia.
         *
         * @instance
         * @public
         * @readonly
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @function Width
         * @type number
         */
        Width: number;
        /**
         * Initializes the element (does one-time computations)
         *
         * @instance
         * @protected
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @return  {void}
         */
        /**
         * Attaches the {@link } as a child of this {@link }.
         *
         * @instance
         * @protected
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {Function}    TElement    
         * @param   {TElement}    element     
         * @param   {boolean}     optional
         * @return  {TElement}
         */
        /**
         * Gets syntax diagnostics for this {@link } an all child elements.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @return  {System.Collections.Generic.IReadOnlyList$1}
         */
        GetContainedSyntaxDiagnostics(): System.Collections.Generic.IReadOnlyList$1<Kusto.Language.Diagnostic> | null;
        /**
         * Creates a copy of this {@link } with the specified diagnostics.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {System.Collections.Generic.IEnumerable$1}    diagnostics
         * @return  {Kusto.Language.Syntax.SyntaxElement}
         */
        WithDiagnostics(diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null): Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * Creates a copy of this {@link } with the specified diagnostics added.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {System.Collections.Generic.IEnumerable$1}    diagnostics
         * @return  {Kusto.Language.Syntax.SyntaxElement}
         */
        WithAdditionalDiagnostics$1(diagnostics: System.Collections.Generic.IEnumerable$1<Kusto.Language.Diagnostic> | null): Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * Creates a copy of this {@link } with the specified diagnostics added.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {Array.<Kusto.Language.Diagnostic>}      diagnostics
         * @return  {Kusto.Language.Syntax.SyntaxElement}
         */
        WithAdditionalDiagnostics(diagnostics: Kusto.Language.Diagnostic[] | null): Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * Get the child element of this node at the specified index.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {number}                                 index
         * @return  {Kusto.Language.Syntax.SyntaxElement}
         */
        GetChild(index: number): Kusto.Language.Syntax.SyntaxElement | null;
        /**
         * True if the child element at the specified index is optional and may contain a null value.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {number}     index
         * @return  {boolean}
         */
        IsOptional(index: number): boolean;
        /**
         * Gets the name of the child element at the specified index.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {number}    index
         * @return  {string}
         */
        GetName(index: number): string | null;
        /**
         * The {@link } to use for this child element index in the syntax tree.
         *
         * @instance
         * @public
         * @this Kusto.Language.Syntax.SyntaxElement
         * @memberof Kusto.Language.Syntax.SyntaxElement
         * @param   {number}                                  index
         * @return  {Kusto.Language.Editor.CompletionHint}
         */
        GetCompletionHint(index: number): Kusto.Language.Edi