<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# parse-url

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/parse-url.svg)](https://travis-ci.org/IonicaBizau/parse-url/) [![Version](https://img.shields.io/npm/v/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Downloads](https://img.shields.io/npm/dt/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> An advanced url parser supporting git urls too.






For low-level path parsing, check out [`parse-path`](https://github.com/IonicaBizau/parse-path). This very module is designed to parse urls. By default the urls are normalized.












## :cloud: Installation

```sh
# Using npm
npm install --save parse-url

# Using yarn
yarn add parse-url
```













## :clipboard: Example



```js
// Dependencies
const parseUrl = require("parse-url")

console.log(parseUrl("http://ionicabizau.net/blog"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'ionicabizau.net',
//   user: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog' }

console.log(parseUrl("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// { protocols: [ 'http' ],
//   protocol: 'http',
//   port: null,
//   resource: 'domain.com',
//   user: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash' }

// If you want to parse fancy Git urls, turn off the automatic url normalization
console.log(parseUrl("git+ssh://git@host.xz/path/name.git", false))
// { protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: null,
//   resource: 'host.xz',
//   user: 'git',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git' }

console.log(parseUrl("git@github.com:IonicaBizau/git-stats.git", false))
// { protocols: [],
//   protocol: 'ssh',
//   port: null,
//   resource: 'github.com',
//   user: 'git',
//   pathname: '/IonicaBizau/git-stats.git',
//   hash: '',
//   search: '',
//   href: 'git@github.com:IonicaBizau/git-stats.git' }
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `parseUrl(url, normalize)`
Parses the input url.

**Note**: This *throws* if invalid urls are provided.

#### Params

- **String** `url`: The input url.
- **Boolean|Object** `normalize`: Wheter to normalize the url or not.                         Default is `false`. If `true`, the url will
                        be normalized. If an object, it will be the
                        options object sent to [`normalize-url`](https://github.com/sindresorhus/normalize-url).

                        For SSH urls, normalize won't work.

#### Return
- **Object** An object containing the following fields:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `protocol` (String): The first protocol, `"ssh"` (if the url is a ssh url) or `"file"`.
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `query` (Object): The url querystring, parsed as object.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `git-up`
 - `lien`
 - `stun`
 - `kakapo`
 - `@open-wa/wa-automate`
 - `fuge-runner`
 - `url-local`
 - `parse-db-uri`
 - `warp-api`
 - `warp-server`
 - `robots-agent`
 - `normalize-ssh`
 - `xl-git-up`
 - `normalize-id`
 - `egg-muc-custom-loader`
 - `hologit`
 - `vrt-cli`
 - `native-zip`
 - `normalize-ssh-url`
 - `eval-spider`
 - `ts-scraper`
 - `microbe.js`
 - `hubot-will-it-connect`
 - `deploy-versioning`
 - `xbuilder-forms`
 - `tumblr-text`
 - `ssh-host-manager`
 - `blitzzz`
 - `wander-cli`
 - `graphmilker`
 - `api-reach-react-native-fix`
 - `@roshub/api`
 - `verify-aws-sns-signature`
 - `@apardellass/react-native-audio-stream`
 - `l2forlerna`
 - `react-native-plugpag-wrapper`
 - `react-native-pulsator-native`
 - `@hstech/utils`
 - `react-native-kakao-maps`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `native-apple-login`
 - `native-google-login`
 - `@jprustv/sulla-hotfix`
 - `vue-cli-plugin-ice-builder`
 - `@hemith/react-native-tnk`
 - `workpad`
 - `react-native-contact-list`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@dataparty/api`
 - `heroku-wp-environment-sync`
 - `react-native-responsive-size`
 - `delta-screen`
 - `react-native-test-module-hhh`
 - `react-native-is7`
 - `@kriblet/wa-automate`
 - `@mergulhao/wa-automate`
 - `@jimengio/mocked-proxy`
 - `cli-live-tutorial`
 - `@buganto/client`
 - `@datalogic/react-native-datalogic-module`
 - `birken-react-native-community-image-editor`
 - `native-kakao-login`
 - `react-native-modal-progress-bar`
 - `@hawkingnetwork/react-native-tab-view`
 - `miguelcostero-ng2-toasty`
 - `vue-cli-plugin-ut-builder`
 - `cv-app-payment-adyen`
 - `react-native-flyy`
 - `drowl-base-theme-iconset`
 - `gitlab-backup-util-harduino`
 - `loast`
 - `rn-custom-tabview`
 - `homebridge-pushcutter`
 - `soajs.repositories`
 - `@ntt_app/react-native-custom-notification`
 - `@ndla/source-map-resolver`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
